#include "stdio.h"
#include "stdlib.h"
#include "string.h"

#include "constants.h"
#include "game_context.h"
#include "common.h"
#include "collision.h"
#include "eneshot.h"
#include "esp.h"

#include "ene_ghost.h"

// vg^Cv錾
void move_ghost_normal(void* pEnemy);		// ړiʏj
void move_ghost_simple(void* pEnemy);		// ړiȑfj
void eneshot_ghost(void* pEnemy);		// Geˏ

// 萔`
int ghost_sptop[6] = { 0x00, 0x00 , 0xA8 , 0x98 , 0x90 , 0x9C };

//=============================================================================
// o
//=============================================================================
void init_ghost(int ene_index)
{
	ENEMY* pEnemy;
	OBJPOS* pEnePos;
	int ene_width	= 14;
	int ene_top = -14;
	int ene_bottom = 15;

	// o̍\̂𓾂
	pEnemy = &(p_stage_objects->enemy[ene_index]);
	pEnePos = &(pEnemy->obj.pos);

	// ʒuݒ
	enemy_appear_positioning(pEnemy, ene_width, ene_top, ene_bottom);
	if (vrand() & 1) { pEnemy->obj.direction = dir_right; }
	else { pEnemy->obj.direction = dir_left; }

	// ݒ
	pEnemy->obj.move = move_ghost;			// ړ֐
	pEnemy->obj.draw = draw_ghost;			// `֐
	pEnemy->do_eneshot = eneshot_ghost;	// Geˏ
	pEnemy->obj.on_hit = on_hit_enemy;	// Gj󎞂̋ʏ

	return;
}


//=============================================================================
// ړ
//=============================================================================
void move_ghost(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);

	// ʊOȂȈՈړ
	if (pObj->out_of_screen==0) {
		move_ghost_normal(pTarget);
	}
	else {
		move_ghost_simple(pTarget);
	}

	// BGMESHɃvbgʊO肷
	collision_put_bgmesh_enemy(pObj);
}

//=============================================================================
// ړiʏj
//=============================================================================
void move_ghost_normal(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);

	// 
	move_ghost_simple(pTarget);

	// Ge
	//if ((vrand() & 255) < 3) {
	if ((vrand() & eneshot_rate[p_game_properties->game_level][enetype_ghost]) < 3) {
		regist_eneshot_delay(pEnemy, 0, 0);
	}
}

//=============================================================================
// ړiȑfj
//=============================================================================
void move_ghost_simple(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	int clip_x0 = p_stage_context->stage_clipping_area.x0;
	int clip_x1 = p_stage_context->stage_clipping_area.x1;
	int clip_y0 = p_stage_context->stage_clipping_area.y0;
	int clip_y1 = p_stage_context->stage_clipping_area.y1;

	// cړFonChange = t[Ƃ 0, 1, 2, 3 ̌JԂ
	int onChange = (pObj->frame_count >> 6) & 3;
	int onChangeTiming = pObj->frame_count & 0b00111111;
	if (onChangeTiming == 0) {
		// x𑀍삷
		int updown = (vrand() & 15) + 1;
		switch (onChange) {
		case 0:
			pPos->ay = updown;
			break;
		case 1:
			pPos->ay = -updown;
			break;
		case 2:
			pPos->ay = -updown;
			break;
		case 3:
			pPos->ay = updown;
			break;
		}

		// Eړx؂ւ
		if (vrand() & 1) {
			pObj->direction = (pObj->direction == dir_left ? dir_right : dir_left);
		}
	}

	// ㉺ړx̌
	if (pPos->vy > 0) { pPos->vy -= 8; }
	if (pPos->vy < 0) { pPos->vy += 8; }

	// ړxݒ
	pPos->vx = (pObj->direction == dir_left ? -256 : 256);

	// ʒ[̃NbsO
	if (	//
		   ((((pPos->hx + pPos->vx) >> 8) < (clip_x0 + 32)) && (pObj->direction == dir_left))	//
		|| ((((pPos->hx + pPos->vx) >> 8) > (clip_x1 - 32)) && (pObj->direction == dir_right))	//
		) {
		pObj->direction = (pObj->direction == dir_left ? dir_right : dir_left);
		pPos->vx *= -1;
	}
	if (	//
		   (((pPos->hy + pPos->vy) >> 8) < (clip_y0 + 32))	//
		|| (((pPos->hy + pPos->vy) >> 8) > (clip_y1 - 32))	//
		) {
		pPos->vy *= -1;
	}

	// ړʏ
	//
	move_common(pObj, 0, 0);

	// BGMESHɃvbgʊO肷
	collision_put_bgmesh_enemy(pObj);
}

//=============================================================================
// Geˏ
//=============================================================================
void eneshot_ghost(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);

	if (pObj->direction == dir_left) {
		appear_eneshot(eneshottype_fire, pPos->hx, pPos->hy, -1024, 0);
	}
	else {
		appear_eneshot(eneshottype_fire, pPos->hx, pPos->hy, 1024, 0);
	}
}

//=============================================================================
// `揈
//=============================================================================
void draw_ghost(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int hx, hy;
	int px, py;
	int anim = 0;
	int allocsp = 0;
	int pal = pEnemy->on_damage==0 ? 12 : 15;
	int sptop = ghost_sptop[p_stage_context->stage - 1];

	// Aj[ṼCfbNXԍ
	anim = (pObj->frame_count >> 4) & 1;

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(4);	// SP2g
	if (allocsp < 4) {
		// mۂłȂ`߂
		return;
	}

	// }bvobt@Ƀf[^i[
	if (pObj->direction == dir_left) {
		SP_SET(sp, px, py, sptop + (anim << 2), pal, 0, 0, 3);
		sp++;
		SP_SET(sp, px + 16, py, sptop + 1 + (anim << 2), pal, 0, 0, 3);
		sp++;
		SP_SET(sp, px, py + 16, sptop + 2 + (anim << 2), pal, 0, 0, 3);
		sp++;
		SP_SET(sp, px + 16, py + 16, sptop + 3 + (anim << 2), pal, 0, 0, 3);
		sp++;
	}
	else {
		SP_SET(sp, px + 16, py, sptop + (anim << 2), pal, 1, 0, 3);
		sp++;
		SP_SET(sp, px, py, sptop + 1 + (anim << 2), pal, 1, 0, 3);
		sp++;
		SP_SET(sp, px + 16, py + 16, sptop + 2 + (anim << 2), pal, 1, 0, 3);
		sp++;
		SP_SET(sp, px, py + 16, sptop + 3 + (anim << 2), pal, 1, 0, 3);
		sp++;
	}

	return;
}
