#include "stdio.h"
#include "stdlib.h"
#include "string.h"

#include "constants.h"
#include "game_context.h"
#include "common.h"
#include "collision.h"
#include "eneshot.h"
#include "esp.h"

#include "ene_eye.h"

// vg^Cv錾
void move_eye_normal(void* pEnemy);
void move_eye_simple(void* pEnemy);
void eneshot_eye(void* pEnemy);

// 萔`
int eye_sptop[6] = { 0x00, 0x00 , 0xBC , 0x80 , 0x90 , 0x90 };

//=============================================================================
// o
//=============================================================================
void init_eye(int ene_index)
{
	ENEMY* pEnemy;
	OBJPOS* pEnePos;
	int ene_width	= 14;
	int ene_top = -14;
	int ene_bottom = 15;

	// o̍\̂𓾂
	pEnemy = &(p_stage_objects->enemy[ene_index]);
	pEnePos = &(pEnemy->obj.pos);

	// ʒuݒ
	enemy_appear_positioning(pEnemy, ene_width, ene_top, ene_bottom);
	if (vrand() & 1) { pEnemy->obj.direction = dir_right; }
	else { pEnemy->obj.direction = dir_left; }

	// ݒ
	pEnemy->obj.move = move_eye;			// ړ֐
	pEnemy->obj.draw = draw_eye;			// `֐
	pEnemy->obj.grounding = move_grounding_flying_simple;	// ڒn֐
	pEnemy->do_eneshot = eneshot_eye;	// Geˏ
	pEnemy->obj.on_hit = on_hit_enemy;	// Gj󎞂̋ʏ

	return;
}


//=============================================================================
// ړ
//=============================================================================
void move_eye(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);

	// ʊOȂȈՈړ
	if (pObj->out_of_screen==0) {
		move_eye_normal(pTarget);
	}
	else {
		move_eye_simple(pTarget);
	}

	// BGMESHɃvbgʊO肷
	collision_put_bgmesh_enemy(pObj);
}

//=============================================================================
// ړiʏj
//=============================================================================
void move_eye_normal(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	int timing;
	int timing_type;

	// ^C~O
	if (p_game_properties->game_level < game_level_hard) {
		timing = ((pObj->frame_count & 0xF) == 0);
		timing_type = (pObj->frame_count >> 4) & 1;
	}
	else {
		timing = ((pObj->frame_count & 0x7) == 0);
		timing_type = (pObj->frame_count >> 3) & 1;
	}

	// ߂
	if (timing == 1) {
		int diff_x, diff_y;

		// @ɊĂ
		diff_x = p_stage_objects->jiki.obj.pos.hx - pPos->hx;
		diff_y = p_stage_objects->jiki.obj.pos.hy - pPos->hy;

		// Еړ
		switch (vrand() & 1) {
		case 0:
			if (diff_x < 0) {
				pObj->direction = dir_left;
			}
			else {
				pObj->direction = dir_right;
			}
			break;
		case 1:
			if (diff_y < 0) {
				// ւ̈ړ
				if ((pObj->direction == dir_left) || (pObj->direction == dir_lu) || (pObj->direction == dir_ld)) {
					// G͍ňړ͏
					pObj->direction = dir_lu;
				}
				else {
					// G͉Eňړ͏
					pObj->direction = dir_up;
				}
			}
			else {
				if ((pObj->direction == dir_left) || (pObj->direction == dir_lu) || (pObj->direction == dir_ld)) {
					// G͍ňړ͉
					pObj->direction = dir_ld;
				}
				else {
					// G͉Eňړ͉
					pObj->direction = dir_rd;
				}
			}
			break;
		}
	}

	// ړ
	if (timing == 1) {
		if (timing_type == 0) {
			// ~
			pPos->vx = 0;
			pPos->vy = 0;
		}
		else {
			int speed = 512 + (p_game_properties->game_level>=game_level_hard ? 512 : 0);
			// ړ
			switch (pObj->direction) {
			case dir_left:
				pPos->vx = -speed;
				pPos->vy = 0;
				break;
			case dir_right:
				pPos->vx = speed;
				pPos->vy = 0;
				break;
			case dir_up:
			case dir_lu:
			case dir_ru:
				pPos->vx = 0;
				pPos->vy = -speed;
				break;
			case dir_down:
			case dir_ld:
			case dir_rd:
				pPos->vx = 0;
				pPos->vy = speed;
				break;
			default:
				pPos->vx = 0;
				pPos->vy = 0;
				break;
			}
		}
	}

	// ړʏ
	//
	move_common(pObj, 0, 0);

	// Geˁi64t[1j
	//if ((pObj->frame_count & 63) == 0) {
	if ((pObj->frame_count & eneshot_rate[p_game_properties->game_level][enetype_eye]) == 0) {
		regist_eneshot_delay(pEnemy, 0, 0);
	}

	// I
	return;
}

//=============================================================================
// ړiʊOj
//=============================================================================
void move_eye_simple(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);

	// ړȂ
	pPos->ax = 0;
	pPos->ay = 0;
	pPos->vx = 0;
	pPos->vy = 0;

	// ړʏ
	//
	move_common(pObj, 0, 0);

	// I
	return;
}

//=============================================================================
// Geˏ
//=============================================================================
void eneshot_eye(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	ENESHOT* pEneShot;

	switch (pObj->direction) {
	case dir_left:
		pEneShot = appear_eneshot(eneshottype_laser, pPos->hx, pPos->hy, -1024, 0);
		if (pEneShot != NULL) { pEneShot->obj.direction = dir_left; }
		break;
	case dir_right:
		pEneShot = appear_eneshot(eneshottype_laser, pPos->hx, pPos->hy, 1024, 0);
		if (pEneShot != NULL) { pEneShot->obj.direction = dir_right; }
		break;
	case dir_up:
	case dir_lu:
	case dir_ru:
		pEneShot = appear_eneshot(eneshottype_laser, pPos->hx, pPos->hy, 0, -1024);
		if (pEneShot != NULL) { pEneShot->obj.direction = dir_up; }
		break;
	case dir_down:
	case dir_ld:
	case dir_rd:
		pEneShot = appear_eneshot(eneshottype_laser, pPos->hx, pPos->hy, 0, 1024);
		if (pEneShot != NULL) {pEneShot->obj.direction = dir_down;}
		break;
	default:
		pEneShot = appear_eneshot(eneshottype_laser, pPos->hx, pPos->hy, 1024, 0);
		if (pEneShot != NULL) { pEneShot->obj.direction = dir_left; }
		break;
	}

	// I
	return;
}

//=============================================================================
// `揈
//=============================================================================
void draw_eye(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int hx, hy;
	int px, py;
	int anim = 0;
	int allocsp = 0;
	int pal = pEnemy->on_damage==0 ? 12 : 15;
	int sptop = eye_sptop[p_stage_context->stage - 1];
	int xoffset[4] = { 0, 0, 2, 2 };
	int yoffset[4] = { 0, 1, 1, 0 };

	// Aj[ṼCfbNXԍ
	anim = (pObj->frame_count >> 3) & 3;

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(4);	// SP2g
	if (allocsp < 4) {
		// mۂłȂ`߂
		return;
	}

	// }bvobt@Ƀf[^i[
	if ((pObj->direction == dir_left) || (pObj->direction == dir_lu) || (pObj->direction == dir_ld)) {
		SP_SET(sp, px + xoffset[anim] + 0, py + yoffset[anim], sptop, pal, 0, 0, 3);
		sp++;
		SP_SET(sp, px - xoffset[anim] + 16, py + yoffset[anim], sptop + 1, pal, 0, 0, 3);
		sp++;
		SP_SET(sp, px + xoffset[anim] + 0, py - yoffset[anim] + 16, sptop + 2, pal, 0, 0, 3);
		sp++;
		SP_SET(sp, px - xoffset[anim] + 16, py - yoffset[anim] + 16, sptop + 3, pal, 0, 0, 3);
		sp++;
	}
	else {
		SP_SET(sp, px - xoffset[anim] + 16, py + yoffset[anim], sptop, pal, 1, 0, 3);
		sp++;
		SP_SET(sp, px + xoffset[anim] + 0, py + yoffset[anim], sptop + 1, pal, 1, 0, 3);
		sp++;
		SP_SET(sp, px - xoffset[anim] + 16, py - yoffset[anim] + 16, sptop + 2, pal, 1, 0, 3);
		sp++;
		SP_SET(sp, px + xoffset[anim] + 0, py - yoffset[anim] + 16, sptop + 3, pal, 1, 0, 3);
		sp++;
	}

	return;
}
