#include "stdio.h"
#include "stdlib.h"
#include "string.h"

#include "../devs/devs.h"
#include "game_context.h"
#include "common.h"
#include "stage.h"
#include "collision.h"
#include "enemy.h"
#include "kon_util.h"
#include "explode.h"
#include "eneshot.h"
#include "item.h"
#include "esp.h"
#include "explode.h"
#include "ene_boss6.h"

// -----< vg^Cv錾 >-----
//
void move_boss6_normal(void* pEnemy);		// BOSS6̈ړiʏԁj
void move_boss6_on_down(void* pEnemy);		// BOSS6̈ړi_Ej
void transition_boss6(ENEMY* pEnemy);

//=============================================================================
// o
//=============================================================================
void init_boss6(int ene_index)
{
	ENEMY* pEnemy;
	OBJPOS* pEnePos;
	int ene_width = 22;
	int ene_height = 48;
	JIKI* pJiki;
	OBJPOS* pJikiPos;
	int i;

	// o̍\̂𓾂
	pEnemy = &(p_stage_objects->enemy[ene_index]);
	pEnePos = &(pEnemy->obj.pos);

	// L̏𓾂
	pJiki = &(p_stage_objects->jiki);
	pJikiPos = &(pJiki->obj.pos);

	// ʒuݒ
	enemy_appear_positioning_center(pEnemy, ene_width, ene_height);

	// _ʒuύX
	memset(pEnePos, 0, sizeof(OBJPOS));
	pEnePos->px = 5380+512+128+32+16;
	pEnePos->py = 470;
	pEnePos->hx = pEnePos->px << 8;
	pEnePos->hy = pEnePos->py << 8;
	pEnemy->obj.prev_pos = *pEnePos;

	// ݒ
	pEnemy->obj.move = move_boss6;			// ړ֐
	pEnemy->obj.draw = draw_boss6;			// `֐
	pEnemy->obj.grounding = move_grounding_bottom_simple;	// ڒn֐
	pEnemy->obj.on_hit = on_hit_boss;	// Gj󎞂̋ʏ

	// SP
	stack_transfer_sp(p_stage_context->boss_sp_slot, 0x78, 0xB0, 4);	// j

	// pbg]
	stack_transfer_pal(p_stage_context->boss_pal_stot, 0, 12, 3);

	// Ȃo
	for (i = 0; i < 8; i++) {
		//ESP* pESP;
		int dx, dir;
		// 
		dir = (vrand() & 1 ? dir_left : dir_right);

		// zu
		dx = 20 + (vrand() & 31);
		if (dir == dir_right) {
			dx *= -1;
		}
		dx = dx << 8;

		// o
		/*
		pESP = appear_esp_vec(esptype_lastoinari, pEnePos->hx + dx, pEnePos->hy, 0, 0);
		if (pESP != NULL) {
			pESP->obj.direction = dir;
		}
		*/
		{
			ENESHOT* pEneShot;
			pEneShot = appear_eneshot(eneshottype_lastoinari, pEnePos->hx + dx, pEnePos->hy, 0, 0);
			if (pEneShot != NULL) {
				pEneShot->obj.direction = dir;
			}
		}
	}

	// BGM؂ւ
	if (p_game_properties->disable_sound == 0) {
		// BGM̎w肠̏ꍇɐ؂ւBw肪Ȃꍇ͍ĐpB
		if (p_sound_context->bgm_index[bgmtype_boss] != SOUND_NULL) {
			sound_stop_bgm();
			sound_play_bgm(p_sound_context->bgm_index[bgmtype_boss]);
		}
	}

	return;
}


//=============================================================================
// ړ
//=============================================================================
void move_boss6(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);

	// ԑJ
	transition_boss6(pEnemy);

	// ړ
	switch (pObj->status) {
	case status_on_down:
		// _E
		move_boss6_on_down(pTarget);
		break;
	default:
		// ʏ
		move_boss6_normal(pTarget);
		// BGMESHɃvbgʊO肷
		collision_put_bgmesh_enemy(pObj);
		break;
	}
}


//=============================================================================
// ԑJڐ
//=============================================================================
void transition_boss6(ENEMY* pEnemy)
{
	//CHROBJ* pObj = &(pEnemy->obj);
}


//=============================================================================
// ړiʏj
//=============================================================================
void move_boss6_normal(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	int anim_frame,  anim_index;

	// ړ

	// ړʏ
	//
	move_common(pObj, 0, MOVE_GRAVITY >> 2);

	// SP`iLN^j
	pObj->anim_index = (pObj->frame_count >> 4) & 1;
	stack_transfer_sp(p_stage_context->boss_sp_slot, pObj->anim_index * 12, 0x90, 12);

	// SP`iBj
 	anim_frame = pObj->frame_count & 127;
	anim_index = (anim_frame - (127 - 20 - 1));
	if (anim_index < 0) { anim_index = 0; }
	else { anim_index = anim_index >> 2; }
	stack_transfer_sp(p_stage_context->boss_sp_slot, 0x30 + (anim_index * 12), 0x90 + 12, 12);

	// SP`iQ[Wj
	enemy_transsp_boss_gauge(pEnemy, 0x80, 0xBC);

	// I
	return;
}

//=============================================================================
// ړi_Ej
//=============================================================================
void move_boss6_on_down(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	int i;

	// 0t[̂ƂESPo
	if (pObj->frame_count == 0) {
		int vx, vy;
		// {ESP
		appear_esp_vec(esptype_last, pPos->hx, pPos->hy, 0, 0);

		// jESP
		for (i = 0; i < 16; i++) {
			vx = -2 + (vrand() & 3);
			if (vx == 0) { vx = 2; }
			vy = -(vrand() & 7);
			appear_esp_vec(esptype_glass, pPos->hx, pPos->hy, vx << 8, vy << 8);
		}

		// ʉ
		play_se(&(p_sound_context->se_item[setype_stageclear]));

		// X[ɂ
		p_stage_objects->slow_mode = 1;
	}

	// L𖳓GԂɂ
	p_stage_objects->jiki.invincible = JIKI_BOSS_DOWN_INVINCIBLE;
	p_stage_objects->jiki.invincible_no_blink = 1;

	// Ƃ肠~߂
	pPos->ax = 0;
	pPos->ay = 0;
	pPos->vx = 0;
	pPos->vy = 0;

	// ړʏ
	//
	move_common(pObj, 0, 0);

	// SP`iLN^j
	pObj->anim_index = (pObj->frame_count >> 4) & 1;
	stack_transfer_sp(p_stage_context->boss_sp_slot, 24 + (pObj->anim_index * 12), 0x90, 12);

	// SP`iQ[Wj
	enemy_transsp_boss_gauge(pEnemy, 0x80, 0xBC);

//	// 3bԔGtFNgo
//	if (pEnemy->obj.frame_count <= 180) {
//		if ((pEnemy->obj.frame_count & 7) == 0) {
//			exposx = ((vrand() & 63) - 32) << 8;
//			exposy = ((vrand() & 63) - 32) << 8;
//			appear_exp(exptype_big, pPos->hx + exposx, pPos->hy + exposy, 2 << 8);	// 
//		}
//	}

	// ST6ɌACxg^C~OقȂ
	//if (pEnemy->obj.frame_count == BOSS_EXP_DUDATION) {
	if (pEnemy->obj.frame_count == 160) {
		stage_play_clear_jingle(p_stage_context->stage - 1);
	}

	// 4bŏ
	if (pEnemy->obj.frame_count == 160) {
		dispose_enemy(pEnemy);
	}

	// I
	return;
}


//=============================================================================
// `揈
//=============================================================================
void draw_boss6(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int hx, hy;
	int px, py;
	int y, x;
	int ox, oy, oi;
	int allocsp = 0;
	int pal = pEnemy->on_damage == 0 ? 12 : 15;

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	// -----< B` >-----
	//
	if ((pObj->status != status_on_down) || ((pObj->status == status_on_down) && (pObj->frame_count==0))) {
		sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
		allocsp = sp_alloc_index(12);	// SP12g
		if (allocsp < 12) {
			// mۂłȂ`߂
			return;
		}

		ox = 0;
		oy = 0;
		oi = 0;
		for (y = 0; y < 4; y++) {
			for (x = 0; x < 3; x++) {
				// }bvobt@Ƀf[^i[
				SP_SET(sp, px - 8 + ox, py - 24 + oy, 0x90 + 12 + oi, pal, 0, 0, 3);
				// 
				sp++;
				ox += 16;
				oi++;
			}
			ox = 0;
			oy += 16;
		}

		// -----< {̂` >-----
		//
		sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
		allocsp = sp_alloc_index(12);	// SP12g
		if (allocsp < 12) {
			// mۂłȂ`߂
			return;
		}

		ox = 0;
		oy = 0;
		oi = 0;
		for (y = 0; y < 4; y++) {
			for (x = 0; x < 3; x++) {
				// }bvobt@Ƀf[^i[
				SP_SET(sp, px - 8 + ox, py - 24 + oy + 4, 0x90 + oi, 12, 0, 0, 3);
				// 
				sp++;
				ox += 16;
				oi++;
			}
			ox = 0;
			oy += 16;
		}
	}

	// -----< Q[W\ >-----
	//
	enemy_draw_boss_gauge(pEnemy, -16, -48, 0xBC);

	return;
}
