#include "stdio.h"
#include "stdlib.h"
#include "string.h"

#include "constants.h"
#include "game_context.h"
#include "common.h"
#include "collision.h"
#include "eneshot.h"
#include "esp.h"

#include "enemy.h"
#include "ene_boss5opt.h"

// vg^Cv錾
void move_boss5opt(void* pEnemy);			// ړ
void draw_boss5opt(void* pEnemy);			// `揈
void eneshot_boss5opt(void* pEnemy);			// Geˏ

//============================================================
// option_param[0] : eIuWFNgiBOSS5j̃CfbNX
// option_param[1] : ړItZbgʒuX
// option_param[2] : ړItZbgʒuY
// option_param[3] : ړ[h 0:WJ 1:N[Y
// option_param[4] : U[h
//============================================================

//=============================================================================
// o
//=============================================================================
void init_boss5opt(int ene_index)
{
	ENEMY* pEnemy;
	OBJPOS* pEnePos;
	int ene_width = 1;
	int ene_height = 1;

	// o̍\̂𓾂
	pEnemy = &(p_stage_objects->enemy[ene_index]);
	pEnePos = &(pEnemy->obj.pos);

	// ʒuݒ
	enemy_appear_positioning_center(pEnemy, ene_width, ene_height);

	// ݒ
	pEnemy->obj.move = move_boss5opt;	// ړ֐
	pEnemy->obj.draw = draw_boss5opt;	// `֐
	pEnemy->obj.grounding = NULL;	// ڒn֐
	pEnemy->do_eneshot = NULL;	// Geˏ
	pEnemy->obj.on_hit = NULL;	// Gj󎞂̋ʏ

	// I
	return;
}


//=============================================================================
// ړ
//============================================================================
void move_boss5opt(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	ENEMY* pParent;
	int offset_hx, offset_hy, target_hx, target_hy;
	int parent, diff_hx, diff_hy;
	int mode;

	// eIuWFNg𓾂
	parent = pEnemy->option_param[0];
	pParent = &(p_stage_objects->enemy[parent]);

	// ItZbg𓾂
	offset_hx = pEnemy->option_param[1];
	offset_hy = pEnemy->option_param[2];

	// [h𓾂 0:WJ 1:N[Y
	mode = pEnemy->option_param[3];

	// ړxݒ
	if (mode == 0) {
		// I[v
		target_hx = pParent->obj.pos.hx + offset_hx;
		target_hy = pParent->obj.pos.hy + offset_hy;
	}
	else {
		// N[Y
		target_hx = pParent->obj.pos.hx;
		target_hy = pParent->obj.pos.hy;
	}

	// vZ
	diff_hx = target_hx - pPos->hx;
	diff_hy = target_hy - pPos->hy;

	// xݒ肷F΋1/2^nړvZ
	pPos->vx = diff_hx >> 3;
	pPos->vy = diff_hy >> 3;

	// ړʏ
	//
	move_common(pObj, 0, 0);

	// BGMESHɃvbgʊO肷
	//collision_put_bgmesh_enemy(pObj);

	// Ge
	eneshot_boss5opt(pTarget);

	// 
	if (mode == 1) {
		if ((abs(diff_hx) < (24<<8)) && (abs(diff_hy) < (24 << 8))) {
			// ߂؂
			dispose_enemy(pEnemy);
		}
	}
}

//=============================================================================
// Geˏ
//============================================================================
void eneshot_boss5opt(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	int mode = pEnemy->option_param[4];
	int wait = 45;
	int duration = 80;

	// ҂
	if (pObj->frame_count < 45) {
		mode = 99999;
	}
	if (pObj->frame_count > (wait + duration)) {
		mode = 99999;
	}

	switch (mode) {
	case 0:
		// 
		if ((pObj->frame_count & 3) == 0) {
			ENESHOT* pEneShot = appear_eneshot(eneshottype_laser, pPos->hx, pPos->hy, 0, 16 << 8);
			if (pEneShot != NULL) {
				pEneShot->obj.direction = vdir[128];
			}
		}
		break;

	case 1:
		// _
		if ((pObj->frame_count & 3) == 0) {
			int dir = vrand() & 0x1FF;
			ENESHOT* pEneShot = appear_eneshot(
				eneshottype_big
				, pPos->hx
				, pPos->hy
				, vcos[dir] << 3
				, vsin[dir] << 3
			);
		}
		break;

	case 2:
		// gł
		if ((pObj->frame_count & 3) == 0) {
			int vx, vy;
			ENESHOT* pEneShot;
			int dir = (pObj->frame_count << 2) & 0x1FF;
			if (dir > 255) {
				dir = 256 - (dir - 255);
			}
			vx = vcos[dir] << 4;
			vy = vsin[dir] << 4;
			pEneShot = appear_eneshot(eneshottype_laser, pPos->hx, pPos->hy, vx, vy);
			if (pEneShot != NULL) {
				pEneShot->obj.direction = vdir[dir];
			}
		}
		break;

	case 3:
		// L
		if ((pObj->frame_count & 3) == 0) {
			int vx, vy;
			ENESHOT* pEneShot;
			OBJPOS* pJikiPos = &(p_stage_objects->jiki.obj.pos);
			int diff_x, diff_y;
			diff_x = pJikiPos->hx - pPos->hx;
			diff_y = pJikiPos->hy - pPos->hy;
			vx = diff_x >> 4;
			vy = diff_y >> 4;
			pEneShot = appear_eneshot(eneshottype_big, pPos->hx, pPos->hy, vx, vy);
		}
		break;

	default:
		// ̑̏ꍇ͉Ȃ
		break;
	}

	// UI
	if (pObj->frame_count == 200) {
		// [hN[Yɂ
		pEnemy->option_param[3] = 1;
	}
}


//=============================================================================
// `揈
//=============================================================================
void draw_boss5opt(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int hx, hy;
	int px, py;
	int allocsp = 0;
	int pal = 13;

	// SPR[h̐擪I
	int sp_code_top = 0xB0;

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(4);	// SP9g
	if (allocsp < 4) {
		// mۂłȂ`߂
		return;
	}

	// SPzu
	SP_SET(sp, px   , py   , sp_code_top + 0, pal, 0, 0, 3);
	sp++;
	SP_SET(sp, px+16, py   , sp_code_top + 1, pal, 0, 0, 3);
	sp++;
	SP_SET(sp, px   , py+16, sp_code_top + 2, pal, 0, 0, 3);
	sp++;
	SP_SET(sp, px+16, py+16, sp_code_top + 3, pal, 0, 0, 3);
	sp++;

	return;
}
