#include "stdio.h"
#include "stdlib.h"
#include "string.h"

#include "../devs/devs.h"
#include "game_context.h"
#include "common.h"
#include "stage.h"
#include "collision.h"
#include "enemy.h"
#include "kon_util.h"
#include "explode.h"
#include "eneshot.h"
#include "bossshot.h"
#include "item.h"
#include "esp.h"
#include "explode.h"
#include "ene_boss5.h"

#define BOSS5_Y_OFFSET (120)

// -----< vg^Cv錾 >-----
//
void transition_boss5(ENEMY* pEnemy);
void do_move_boss5(ENEMY* pEnemy);
void draw_boss5_core(ENEMY* pEnemy);
void draw_boss5_anim(ENEMY* pEnemy);
void appear_option(ENEMY* pEnemy, int offset_hx, int offset_hy, int mode);

// 1 : o
int transition_boss5_open(ENEMY* pEnemy);
void move_boss5_open(ENEMY* pEnemy);
void draw_boss5_open(ENEMY* pEnemy);
//
// 2 : U
int transition_boss5_attack(ENEMY* pEnemy);
void move_boss5_attack(ENEMY* pEnemy);
void draw_boss5_attack(ENEMY* pEnemy);
//
// 3 : [v
int transition_boss5_close(ENEMY* pEnemy);
void move_boss5_close(ENEMY* pEnemy);
void draw_boss5_close(ENEMY* pEnemy);

// status_on_down : _E
int transition_boss5_on_down(ENEMY* pEnemy);
void move_boss5_on_down(ENEMY* Enemy);
void draw_boss5_on_down(ENEMY* pEnemy);

//=============================================================================
// o
//=============================================================================
void init_boss5(int ene_index)
{
	ENEMY* pEnemy;
	OBJPOS* pEnePos;
	int ene_width = 64;
	int ene_height = 96;
	JIKI* pJiki;
	OBJPOS* pJikiPos;

	// o̍\̂𓾂
	pEnemy = &(p_stage_objects->enemy[ene_index]);
	pEnePos = &(pEnemy->obj.pos);

	// L̏𓾂
	pJiki = &(p_stage_objects->jiki);
	pJikiPos = &(pJiki->obj.pos);

	// ʒuݒ
	enemy_appear_positioning_center(pEnemy, ene_width, ene_height);

	// _ʒuύX
	memset(pEnePos, 0, sizeof(OBJPOS));
	pEnePos->px = 1105 + 100;
	pEnePos->py = 984 - 140;
	pEnePos->hx = pEnePos->px << 8;
	pEnePos->hy = pEnePos->py << 8;
	pEnemy->obj.prev_pos = *pEnePos;

	// ݒ
	pEnemy->obj.move = move_boss5;			// ړ֐
	pEnemy->obj.draw = draw_boss5;			// `֐
	pEnemy->obj.grounding = NULL;	// ڒn֐
	pEnemy->obj.on_hit = on_hit_boss;	// Gj󎞂̋ʏ
	pEnemy->option_param[0] = 1;	// \ȂƂ1
	pEnemy->option_param[1] = 0;	// Up^[
	pEnemy->obj.status = status_normal;

	// SP
	stack_transfer_sp(p_stage_context->boss_sp_slot, 0x60, 0xA8, 3);	// 
	stack_transfer_sp(p_stage_context->boss_sp_slot, 0x63, 0x10, 6);	// 

	// pbg]
	stack_transfer_pal(p_stage_context->boss_pal_stot, 0, 12, 3);

	// BGM؂ւ
	if (p_game_properties->disable_sound == 0) {
		// BGM̎w肠̏ꍇɐ؂ւBw肪Ȃꍇ͍ĐpB
		if (p_sound_context->bgm_index[bgmtype_boss] != SOUND_NULL) {
			sound_stop_bgm();
			sound_play_bgm(p_sound_context->bgm_index[bgmtype_boss]);
		}
	}

	return;
}


//=============================================================================
// ړ
//=============================================================================
void move_boss5(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	int anim_index;
	int pattern;

	// ԑJ
	transition_boss5(pEnemy);

	// ړ
	do_move_boss5(pEnemy);

	// IvV̉摜]
	anim_index = (pEnemy->obj.frame_count >> 3) & 3;
	pattern = pEnemy->option_param[1] & 3;
	stack_transfer_sp(p_stage_context->boss_sp_slot, 0x80 + (pattern<<4) + (anim_index << 2), 0xB0, 4);
}


//=============================================================================
// ԑJڐ
//=============================================================================
void transition_boss5(ENEMY* pEnemy)
{
	CHROBJ* pObj = &(pEnemy->obj);
	int next_status = pObj->status;

	// ԑJڐ
	switch (pObj->status) {
	case status_normal:
		// fItg̏Ԃڋߑ҂ɑJ
		if (pObj->frame_count >= 60) {
			// n邭炢܂ŏ҂
			next_status = status_boss_1;
		}
		break;

	case status_boss_1:
		// oԂ̏ԑJڐ
		next_status = transition_boss5_open(pEnemy);
		break;

	case status_boss_2:
		// ȔԑJڐ
		next_status = transition_boss5_attack(pEnemy);
		break;

	case status_boss_3:
		// [vԂ̏ԑJڐ
		next_status = transition_boss5_close(pEnemy);
		break;

	case status_on_down:
		// _E
		next_status = transition_boss5_on_down(pEnemy);
		break;
	}

	// Ԃωꍇ
	if (next_status != pObj->status) {
		pObj->status = next_status;
		pEnemy->obj.frame_count = 0;
	}
}


//=============================================================================
// ړ
//=============================================================================
void do_move_boss5(ENEMY* pEnemy)
{
	CHROBJ* pObj = &(pEnemy->obj);

	// ړ
	switch (pObj->status) {
	case status_normal:
		// ftHgԁiȂj
		pEnemy->obj.frame_count += 1;
		break;

	case status_boss_1:
		// o
		move_boss5_open(pEnemy);
		break;

	case status_boss_2:
		// U
		move_boss5_attack(pEnemy);
		break;

	case status_boss_3:
		// [v
		move_boss5_close(pEnemy);
		break;

	case status_on_down:
		// _E
		move_boss5_on_down(pEnemy);
		break;

	default:
		// zȌԂȂ牽Ȃ
		break;
	}

	// 蔻
	switch (pObj->status) {
	case status_on_down:
		// _E͏Ȃ
		break;

	default:
		// BGMESHɃvbgʊO肷
		collision_put_bgmesh_enemy(pObj);
		break;
	}
}


//=============================================================================
// `揈
//=============================================================================
void draw_boss5(void* pTarget)
{
	ENEMY* pEnemy = pTarget;
	CHROBJ* pObj = &(pEnemy->obj);

	// ړ
	switch (pObj->status) {
	case status_normal:
		// ftHgԁiȂj
		break;

	case status_boss_1:
		// o
		draw_boss5_open(pEnemy);
		break;

	case status_boss_2:
		// U
		draw_boss5_attack(pEnemy);
		break;

	case status_boss_3:
		// [v
		draw_boss5_close(pEnemy);
		break;

	case status_on_down:
		// _E
		draw_boss5_on_down(pEnemy);
		break;

	default:
		// zȌԂȂ牽Ȃ
		break;
	}
}


//=============================================================================
// 1 : o
//=============================================================================
//-----------------------------------------------------------------------------
// ԑJڐ
//-----------------------------------------------------------------------------
int transition_boss5_open(ENEMY* pEnemy)
{
	int next_status = pEnemy->obj.status;

	// L̏𓾂
	JIKI* pJiki = &(p_stage_objects->jiki);
	OBJPOS* pJikiPos = &(pJiki->obj.pos);

	// oIUJn
	if (pEnemy->obj.frame_count >= 90) {
		// U
		next_status = status_boss_2;
	}

	// ̃Xe[gԂ
	return next_status;
}


//-----------------------------------------------------------------------------
// ړ
//-----------------------------------------------------------------------------
void move_boss5_open(ENEMY* pEnemy)
{
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	int anim_index;
	int frame;
	int wait_frame = 30;
	OBJPOS* pJikiPos = &(p_stage_objects->jiki.obj.pos);

	// ړ
	if (pObj->frame_count == 0) {
		// ŏɈʒu߂B@ɂ܂ƂĂB
		pPos->hx = pJikiPos->hx;
		pPos->hy = pJikiPos->hy - (BOSS5_Y_OFFSET << 8);
		pPos->px = pPos->hx >> 8;
		pPos->py = pPos->hy >> 8;
		pObj->prev_pos = *pPos;
	}

	// ړʏ
	//
	move_common(pObj, 0, 0);

	// SP`iLN^j
	if (pObj->frame_count < wait_frame) {
		// 1b҂
		pEnemy->option_param[0] = 1;
	}
	else {
		pEnemy->option_param[0] = 0;
	}

	// Aj[Ṽp^[߂
	// t[͂҂
	frame = pObj->frame_count - wait_frame;
	if (frame < 0) { frame = 0; }
	// p^[߂
	anim_index = 3 - (frame >> 0);
	if (anim_index < 0) { anim_index = 0; }

	// {̂SP]
	stack_transfer_sp(p_stage_context->boss_sp_slot, anim_index * 24, 0x90, 24);

	// SP`iQ[Wj
	enemy_transsp_boss_gauge(pEnemy, 0xC0, 0xBC);

	// I
	return;
}


//-----------------------------------------------------------------------------
// `揈
//-----------------------------------------------------------------------------
void draw_boss5_open(ENEMY* pEnemy)
{
	// ʏɉ
	draw_boss5_anim(pEnemy);
}


//=============================================================================
// 2 : U
//=============================================================================
//-----------------------------------------------------------------------------
// ԑJڐ
//-----------------------------------------------------------------------------
int transition_boss5_attack(ENEMY* pEnemy)
{
	int next_status = pEnemy->obj.status;

	// L̏𓾂
	JIKI* pJiki = &(p_stage_objects->jiki);
	OBJPOS* pJikiPos = &(pJiki->obj.pos);

	// N[Y
	if (pEnemy->obj.frame_count >= 420) {
		// N[Y
		next_status = status_boss_3;
	}

	// ̃Xe[gԂ
	return next_status;
}


//-----------------------------------------------------------------------------
// ړ
//-----------------------------------------------------------------------------
void move_boss5_attack(ENEMY* pEnemy)
{
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	OBJPOS* pJikiPos = &(p_stage_objects->jiki.obj.pos);
	int diff_x, diff_y, speed_x, speed_y;

	// ܂Ƃ
	speed_x = 384;
	speed_y = 128;
	diff_x = pJikiPos->hx - pPos->hx;
	diff_y = (pJikiPos->hy - (BOSS5_Y_OFFSET << 8)) - pPos->hy;
	if (abs(diff_x) > (16 << 8)) {
		pPos->vx = (diff_x < 0 ? -speed_x : speed_x);
	}
	else {
		pPos->vx = 0;
	}
	if (abs(diff_y) > (16 << 8)) {
		pPos->vy = (diff_y < 0 ? -speed_y : speed_y);
	}
	else {
		pPos->vy = 0;
	}

	// IvVo
	if (pObj->frame_count == 120) {
		int pattern = vrand() & 3;
		pEnemy->option_param[1] = pattern;	// U

		// 
		appear_option(pEnemy,  (100 << 8), -(32 << 8), pattern);
		appear_option(pEnemy, -(100 << 8), -(32 << 8), pattern);
		appear_option(pEnemy,  ( 60 << 8),  (12 << 8), pattern);
		appear_option(pEnemy, -( 60 << 8),  (12 << 8), pattern);
	}

	// ړʏ
	//
	move_common(pObj, 0, 0);

	// SP`iLN^j
	pObj->anim_index = (pObj->frame_count >> 5) & 1;
	stack_transfer_sp(p_stage_context->boss_sp_slot, 0x00, 0x90, 24);

	// SP`iQ[Wj
	enemy_transsp_boss_gauge(pEnemy, 0xC0, 0xBC);

	// I
	return;
}


//-----------------------------------------------------------------------------
// IvVo
//-----------------------------------------------------------------------------
void appear_option(ENEMY* pEnemy, int offset_hx, int offset_hy, int mode)
{
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	int absent_index;
	ENEMY* pNewEnemy;
	CHROBJ* pNewObj;
	OBJPOS* pNewPos;

	// X^bN^[Qbg̃CfbNX𓾂
	absent_index = POP_IDSTACK_ENEMY;
	if (absent_index < 0) {
		return;
	}
	// IuWFNg\z
	build_enemy(absent_index, enetype_boss5opt, 0, -1);
	pNewEnemy = &(p_stage_objects->enemy[absent_index]);
	pNewObj = &(pNewEnemy->obj);
	pNewPos = &(pNewObj->pos);

	// ʒuXV
	*pNewPos = *pPos;
	pNewEnemy->obj.prev_pos = *pPos;

	// IvVlXV
	// option_param[0] : eIuWFNgiBOSS5j̃CfbNX
	// option_param[1] : ړItZbgʒuX
	// option_param[2] : ړItZbgʒuY
	// option_param[3] : ړ[h 0:WJ 1:N[Y
	// option_param[4] : U[h
	pNewEnemy->option_param[0] = pEnemy->obj.array_index;
	pNewEnemy->option_param[1] = offset_hx;
	pNewEnemy->option_param[2] = offset_hy;
	pNewEnemy->option_param[3] = 0;
	pNewEnemy->option_param[4] = mode;
}


//-----------------------------------------------------------------------------
// `揈
//-----------------------------------------------------------------------------
void draw_boss5_attack(ENEMY* pEnemy)
{
	// ʏɉ
	draw_boss5_core(pEnemy);
}


//=============================================================================
// 3 : [v
//=============================================================================
//-----------------------------------------------------------------------------
// ԑJڐ
//-----------------------------------------------------------------------------
int transition_boss5_close(ENEMY* pEnemy)
{
	int next_status = pEnemy->obj.status;

	// L̏𓾂
	JIKI* pJiki = &(p_stage_objects->jiki);
	OBJPOS* pJikiPos = &(pJiki->obj.pos);

	// I烏[v
	if (pEnemy->obj.frame_count >= 30) {
		// U
		next_status = status_boss_1;
	}

	// ̃Xe[gԂ
	return next_status;
}


//-----------------------------------------------------------------------------
// ړ
//-----------------------------------------------------------------------------
void move_boss5_close(ENEMY* pEnemy)
{
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	int anim_index;
	int anim_index_raw;

	// ړ

	// ړʏ
	//
	move_common(pObj, 0, 0);

	// Aj[Ṽp^[߂
	anim_index_raw = (pObj->frame_count >> 0);
	anim_index = anim_index_raw;
	if (anim_index > 3) { anim_index = 3; }

	// SP`iLN^j
	if (anim_index_raw>3) {
		// `Ȃ
		pEnemy->option_param[0] = 1;
	}
	else {
		pEnemy->option_param[0] = 0;
	}

	// {̂SP]
	stack_transfer_sp(p_stage_context->boss_sp_slot, anim_index * 24, 0x90, 24);

	// SP`iQ[Wj
	enemy_transsp_boss_gauge(pEnemy, 0xC0, 0xBC);

	// I
	return;
}


//-----------------------------------------------------------------------------
// `揈
//-----------------------------------------------------------------------------
void draw_boss5_close(ENEMY* pEnemy)
{
	// ʏɉ
	draw_boss5_anim(pEnemy);
}


//=============================================================================
// on_down : _E
//=============================================================================
//-----------------------------------------------------------------------------
// ԑJڐ
//-----------------------------------------------------------------------------
int transition_boss5_on_down(ENEMY* pEnemy)
{
	// ԑJڐȂ
	return pEnemy->obj.status;
}


//-----------------------------------------------------------------------------
// ړ
//-----------------------------------------------------------------------------
void move_boss5_on_down(ENEMY* pEnemy)
{
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	int exposx, exposy;

	// L𖳓GԂɂ
	p_stage_objects->jiki.invincible = JIKI_BOSS_DOWN_INVINCIBLE;
	p_stage_objects->jiki.invincible_no_blink = 1;

	// Ƃ肠~߂
	pPos->ax = 0;
	pPos->ay = 0;
	pPos->vx = 0;
	pPos->vy = 0;

	// ړʏ
	//
	move_common(pObj, 0, 0);

	// SP`iLN^j
	pObj->anim_index = (pObj->frame_count >> 5) & 1;
	stack_transfer_sp(p_stage_context->boss_sp_slot, 0x00, 0x90, 24);

	// SP`iQ[Wj
	enemy_transsp_boss_gauge(pEnemy, 0xC0, 0xBC);

	// 3bԔGtFNgo
	if (pEnemy->obj.frame_count <= BOSS_EXP_DUDATION) {
		if ((pEnemy->obj.frame_count & 7) == 0) {
			exposx = ((vrand() & 63) - 32) << 8;
			exposy = ((vrand() & 63) - 32) << 8;
			appear_exp(exptype_big, pPos->hx + exposx, pPos->hy + exposy, 2 << 8);	// 
			// ʉ
			play_se(&(p_sound_context->se_item[setype_enemy_down]));
		}
	}

	// WO炷
	//if (pEnemy->obj.frame_count == BOSS_EXP_DUDATION) {
	if (pEnemy->obj.frame_count == BOSS_DOWN_DURATION) {
		stage_play_clear_jingle(p_stage_context->stage - 1);
	}

	// ΂炭Ă
	if (pEnemy->obj.frame_count == BOSS_DOWN_DURATION) {
		dispose_enemy(pEnemy);
	}

	// I
	return;
}


//-----------------------------------------------------------------------------
// `揈
//-----------------------------------------------------------------------------
void draw_boss5_on_down(ENEMY* pEnemy)
{
	// ʏɉ
	draw_boss5_core(pEnemy);
}


//=============================================================================
// `揈
//=============================================================================
//-----------------------------------------------------------------------------
// ʏ`
//-----------------------------------------------------------------------------
void draw_boss5_core(ENEMY* pEnemy)
{
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int hx, hy;
	int px, py;
	int y, x;
	int ox, oy, oi;
	int allocsp = 0;
	int pal = pEnemy->on_damage == 0 ? 12 : 15;
	int offset_y = (pObj->anim_index == 1 ? 4 : 0);

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	// _Eň莞Ԃ߂\Ȃ
	if ((pEnemy->obj.status==status_on_down)
		&& (pEnemy->obj.frame_count >= 180)) {
		return;
	}

	// -----< ` >-----
	//
	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(6);	// SP6g
	if (allocsp < 6) {
		// mۂłȂ`߂
		return;
	}
	oi = 0;
	oy = 0;
	for (y = 0; y < 6; y++) {
		// 
		SP_SET(sp, px - 32, py -48 + oy - offset_y, 0x10 + oi, pal, 0, 0, 3);
		sp++;
		// 
		oy += 16;
		oi++;
	}

	// -----< {̂` >-----
	//
	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(48);	// SP48g
	if (allocsp < 48) {
		// mۂłȂ`߂
		return;
	}

	ox = 0;
	oy = 0;
	oi = 0;
	// ȊO
	for (y = 0; y < 7; y++) {
		for (x = 0; x < 3; x++) {
			// }bvobt@Ƀf[^i[
			// 
			SP_SET(sp, px - 32 + ox, py - 48 + oy + offset_y, 0x90 + oi, pal, 0, 0, 3);
			sp++;
			// E
			SP_SET(sp, px + 48 - ox, py - 48 + oy + offset_y, 0x90 + oi, pal, 1, 0, 3);
			sp++;
			// 
			ox += 16;
			oi++;
		}
		ox = 0;
		oy += 16;
	}
	// 
	oi = 0;
	for (x = 0; x < 3; x++) {
		int left = (pObj->anim_index==1 ? 21 : 24);
		int right = (pObj->anim_index == 1 ? 24 : 21);
		// }bvobt@Ƀf[^i[
		// 
		SP_SET(sp, px - 32 + ox, py - 48 + oy + offset_y, 0x90 + left + oi, pal, 0, 0, 3);
		sp++;
		// E
		SP_SET(sp, px + 48 - ox, py - 48 + oy + offset_y, 0x90 + right + oi, pal, 1, 0, 3);
		sp++;
		// 
		ox += 16;
		oi++;
	}

	// -----< Q[W\ >-----
	//
	enemy_draw_boss_gauge(pEnemy, -16, -72, 0xBC);

	return;
}


//-----------------------------------------------------------------------------
// Aj
//-----------------------------------------------------------------------------
void draw_boss5_anim(ENEMY* pEnemy)
{
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int hx, hy;
	int px, py;
	int y, x;
	int ox, oy, oi;
	int allocsp = 0;
	int pal = pEnemy->on_damage == 0 ? 12 : 15;

	// \Ȃwꍇ̓XLbv
	if (pEnemy->option_param[0] == 1) {
		return;
	}

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	// -----< ` >-----
	//
	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(6);	// SP6g
	if (allocsp < 6) {
		// mۂłȂ`߂
		return;
	}
	oi = 0;
	oy = 0;
	for (y = 0; y < 6; y++) {
		// 
		SP_SET(sp, px - 32, py - 48 + oy, 0x10 + oi, pal, 0, 0, 3);
		sp++;
		// 
		oy += 16;
		oi++;
	}

	// -----< {̂` >-----
	//
	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(48);	// SP48g
	if (allocsp < 48) {
		// mۂłȂ`߂
		return;
	}

	ox = 0;
	oy = 0;
	oi = 0;
	// ȊO
	for (y = 0; y < 8; y++) {
		for (x = 0; x < 3; x++) {
			// }bvobt@Ƀf[^i[
			// 
			SP_SET(sp, px - 32 + ox, py - 48 + oy, 0x90 + oi, pal, 0, 0, 3);
			sp++;
			// E
			SP_SET(sp, px + 48 - ox, py - 48 + oy, 0x90 + oi, pal, 1, 0, 3);
			sp++;
			// 
			ox += 16;
			oi++;
		}
		ox = 0;
		oy += 16;
	}

	// -----< Q[W\ >-----
	//
	enemy_draw_boss_gauge(pEnemy, -16, -72, 0xBC);

	return;
}
