#include "stdio.h"
#include "stdlib.h"
#include "string.h"

#include "../devs/devs.h"
#include "game_context.h"
#include "common.h"
#include "stage.h"
#include "collision.h"
#include "enemy.h"
#include "kon_util.h"
#include "explode.h"
#include "eneshot.h"
#include "bossshot.h"
#include "item.h"
#include "esp.h"
#include "explode.h"
#include "ene_boss4.h"

// -----< vg^Cv錾 >-----
//
void move_boss4_normal(void* pEnemy);		// BOSS4̈ړiʏԁj
void move_boss4_on_down(void* pEnemy);		// BOSS4̈ړi_Ej
void transition_boss4(ENEMY* pEnemy);

//=============================================================================
// o
//=============================================================================
void init_boss4(int ene_index)
{
	ENEMY* pEnemy;
	OBJPOS* pEnePos;
	int ene_width = 64;
	int ene_height = 96;
	JIKI* pJiki;
	OBJPOS* pJikiPos;

	// o̍\̂𓾂
	pEnemy = &(p_stage_objects->enemy[ene_index]);
	pEnePos = &(pEnemy->obj.pos);

	// L̏𓾂
	pJiki = &(p_stage_objects->jiki);
	pJikiPos = &(pJiki->obj.pos);

	// ʒuݒ
	enemy_appear_positioning_center(pEnemy, ene_width, ene_height);

	// _ʒuύX
	memset(pEnePos, 0, sizeof(OBJPOS));
	pEnePos->px = 256;
	pEnePos->py = pJikiPos->py - 256;
	pEnePos->hx = pEnePos->px << 8;
	pEnePos->hy = pEnePos->py << 8;
	pEnemy->obj.prev_pos = *pEnePos;

	// ݒ
	pEnemy->obj.move = move_boss4;			// ړ֐
	pEnemy->obj.draw = draw_boss4;			// `֐
	pEnemy->obj.grounding = move_grounding_flying_simple;	// ڒn֐
	pEnemy->obj.on_hit = on_hit_boss;	// Gj󎞂̋ʏ

	// SP`
	// zu
	stack_transfer_sp(p_stage_context->boss_sp_slot, 0x90, 0xB0, 4);

	// pbg]
	stack_transfer_pal(p_stage_context->boss_pal_stot, 0, 12, 3);

	// BGM؂ւ
	if (p_game_properties->disable_sound == 0) {
		// BGM̎w肠̏ꍇɐ؂ւBw肪Ȃꍇ͍ĐpB
		if (p_sound_context->bgm_index[bgmtype_boss] != SOUND_NULL) {
			sound_stop_bgm();
			sound_play_bgm(p_sound_context->bgm_index[bgmtype_boss]);
		}
	}

	return;
}


//=============================================================================
// ړ
//=============================================================================
void move_boss4(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);

	switch (pObj->status) {
	case status_on_down:
		// _E
		move_boss4_on_down(pTarget);
		break;
	default:
		// ʏ
		move_boss4_normal(pTarget);
		// BGMESHɃvbgʊO肷
		collision_put_bgmesh_enemy(pObj);
		break;
	}
}


//=============================================================================
// ԑJڐ
//=============================================================================
void transition_boss4(ENEMY* pEnemy)
{
	//CHROBJ* pObj = &(pEnemy->obj);
}


//=============================================================================
// ړiʏj
//=============================================================================
void move_boss4_normal(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	int pattern[4] = { 0,1,2,1 };
	int acc = 8;
	int acc_cycle = 64;
	int clip_center_y;
	int i;
	int on_eneshot;

	clip_center_y = (p_stage_context->stage_clipping_area.y1 + p_stage_context->stage_clipping_area.y0) >> 1;

	// ړ
	pPos->vx = vcos[(pObj->frame_count) & 0x1FF] >> 2;
	if (pPos->vx < 0) {
		pObj->direction = dir_left;
	}
	else {
		pObj->direction = dir_right;
	}

	// ㉺ړ̕I
	if (pEnemy->option_param[0] == 0) {
		// Ԓuɏ
		if ((pObj->frame_count & 0x31) == 0) {
			// _0-3̒l
			int sw = vrand() & 3;
			// _̒l2Ƃ̕ʒu狭
			// ɂꍇɂ͉ցAɂꍇɂ͏Ɉړ₷
			if (sw == 2) {
				if (pPos->py < clip_center_y) {
					sw = 1;
				}
				else {
					sw = 0;
				}
			}
			// Ɖ̕߂ĉx
			if (sw == 0) {
				// 
				pEnemy->option_param[0] = dir_up;
				pEnemy->option_param[1] = 0;
			}
			if (sw == 1) {
				// 
				pEnemy->option_param[0] = dir_down;
				pEnemy->option_param[1] = 0;
			}
		}
	}

	// ㉺ړ
	if (pEnemy->option_param[0] == dir_up) {
		// 
		if (pEnemy->option_param[1] < acc_cycle) {
			pPos->ay = -acc;
		}
		else if (pEnemy->option_param[1] < (acc_cycle<<1)) {
			pPos->ay = acc;
		}
		else {
			pPos->ay = 0;
			pEnemy->option_param[0] = 0;
		}
		pEnemy->option_param[1] += 1;
	}
	else if (pEnemy->option_param[0] == dir_down) {
		// 
		if (pEnemy->option_param[1] < acc_cycle) {
			pPos->ay = acc;
		}
		else if (pEnemy->option_param[1] < (acc_cycle<<1)) {
			pPos->ay = -acc;
		}
		else {
			pPos->ay = 0;
			pEnemy->option_param[0] = 0;
		}
		pEnemy->option_param[1] += 1;
	}

	// ړʏ
	move_common(pObj, 0, 0);

	// ԂɓGe
	on_eneshot = 0;
	switch (p_game_properties->game_level) {
	case game_level_easy:
		on_eneshot = ((pObj->frame_count & 511) == 0);
		break;
	case game_level_hard:
		on_eneshot = ((pObj->frame_count & 127) == 0);
		break;
	case game_level_novice:
	case game_level_normal:
	default:
		on_eneshot = ((pObj->frame_count & 255) == 0);
		break;
	}
	if (on_eneshot) {
		for (i = 0; i < 512; i += 64) {
			appear_bossshot(eneshottype_boss4rock, pPos->hx, pPos->hy, vcos[i]<<2, vsin[i]<<2);
		}
	}

	// SP`iLN^j
	pObj->anim_index = (pObj->frame_count >> 4) & 3;
	stack_transfer_sp(p_stage_context->boss_sp_slot, pattern[pObj->anim_index] * 48 , 0x80, 48);

	// SP`iQ[Wj
	enemy_transsp_boss_gauge(pEnemy, 0x98, 0xBD);

	// I
	return;
}

//=============================================================================
// ړi_Ej
//=============================================================================
void move_boss4_on_down(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	int exposx, exposy;

	// L𖳓GԂɂ
	p_stage_objects->jiki.invincible = JIKI_BOSS_DOWN_INVINCIBLE;
	p_stage_objects->jiki.invincible_no_blink = 1;

	// Ƃ肠~߂
	pPos->ax = 0;
	pPos->ay = 0;
	pPos->vx = 0;
	pPos->vy = 0;

	// ړʏ
	//
	move_common(pObj, 0, 0);

	// SP`iLN^j
	pObj->anim_index = (pObj->frame_count >> 4) & 1;
	stack_transfer_sp(p_stage_context->boss_sp_slot, pObj->anim_index * 48, 0x80, 48);

	// SP`iQ[Wj
	enemy_transsp_boss_gauge(pEnemy, 0x98, 0xBD);

	// 3bԔGtFNgo
	if (pEnemy->obj.frame_count <= BOSS_EXP_DUDATION) {
		if ((pEnemy->obj.frame_count & 7) == 0) {
			exposx = ((vrand() & 63) - 32) << 8;
			exposy = ((vrand() & 63) - 32) << 8;
			appear_exp(exptype_big, pPos->hx + exposx, pPos->hy + exposy, 2 << 8);	// 
			// ʉ
			play_se(&(p_sound_context->se_item[setype_enemy_down]));
		}
	}

	// WO炷
	//if (pEnemy->obj.frame_count == BOSS_EXP_DUDATION) {
	if (pEnemy->obj.frame_count == BOSS_DOWN_DURATION) {
		stage_play_clear_jingle(p_stage_context->stage - 1);
	}

	// ΂炭Ă
	if (pEnemy->obj.frame_count == BOSS_DOWN_DURATION) {
		dispose_enemy(pEnemy);
	}

	// I
	return;
}


//=============================================================================
// `揈
//=============================================================================
void draw_boss4(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int hx, hy;
	int px, py;
	int y, x;
	int ox, oy, oi;
	int allocsp = 0;
	int pal = pEnemy->on_damage == 0 ? 12 : 15;

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	// _Eň莞Ԃ߂\Ȃ
	if ((pEnemy->obj.status==status_on_down)
		&& (pEnemy->obj.frame_count >= 180)) {
		return;
	}

	// -----< {̂` >-----
	//
	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(48);	// SP48g
	if (allocsp < 48) {
		// mۂłȂ`߂
		return;
	}

	ox = 0;
	oy = 0;
	oi = 0;
	for (y = 0; y < 8; y++) {
		for (x = 0; x < 6; x++) {
			// }bvobt@Ƀf[^i[
			if (pObj->direction == dir_left) {
				SP_SET(sp, px - 32 + ox, py - 48 + oy, 0x80 + oi, pal, 0, 0, 3);
			}
			else {
				SP_SET(sp, px + 48 - ox, py - 48 + oy, 0x80 + oi, pal, 1, 0, 3);
			}
			// 
			sp++;
			ox += 16;
			oi++;
		}
		ox = 0;
		oy += 16;
	}

	// -----< Q[W\ >-----
	//
	enemy_draw_boss_gauge(pEnemy, -16, -72, 0xBD);

	return;
}
