#include "stdio.h"
#include "stdlib.h"
#include "string.h"

#include "../devs/devs.h"
#include "game_context.h"
#include "common.h"
#include "stage.h"
#include "collision.h"
#include "enemy.h"
#include "kon_util.h"
#include "explode.h"
#include "eneshot.h"
#include "bossshot.h"
#include "item.h"
#include "esp.h"
#include "explode.h"
#include "ene_boss3.h"

// -----< vg^Cv錾 >-----
//
void transition_boss3(ENEMY* pEnemy);
void do_move_boss3(ENEMY* pEnemy);
void draw_boss3_core(ENEMY* pEnemy);
void handle_direction(ENEMY* pEnemy);

// 1 : ڋߑ҂
int transition_boss3_wait(ENEMY* pEnemy);
void move_boss3_wait(ENEMY* pEnemy);
void draw_boss3_wait(ENEMY* pEnemy);
//
// 2 : o[\
int transition_boss3_baloon(ENEMY* pEnemy);
void move_boss3_baloon(ENEMY* pEnemy);
void draw_boss3_baloon(ENEMY* pEnemy);
//
// 3 : 
int transition_boss3_stand(ENEMY* pEnemy);
void move_boss3_stand(ENEMY* pEnemy);
void draw_boss3_stand(ENEMY* pEnemy);
//
// 4 : 
int transition_boss3_throw(ENEMY* pEnemy);
void move_boss3_throw(ENEMY* pEnemy);
void draw_boss3_throw(ENEMY* pEnemy);
//
// 5 : _bV
int transition_boss3_dash(ENEMY* pEnemy);
void move_boss3_dash(ENEMY* pEnemy);
void draw_boss3_dash(ENEMY* pEnemy);
//
// 6 : Wv
int transition_boss3_jump(ENEMY* pEnemy);
void move_boss3_jump(ENEMY* pEnemy);
void draw_boss3_jump(ENEMY* pEnemy);
void eneshot_boss3_jump(ENEMY* pEnemy);

// status_on_down : _E
int transition_boss3_on_down(ENEMY* pEnemy);
void move_boss3_on_down(ENEMY* Enemy);
void draw_boss3_on_down(ENEMY* pEnemy);

//=============================================================================
// o
//=============================================================================
void init_boss3(int ene_index)
{
	ENEMY* pEnemy;
	OBJPOS* pEnePos;
	int ene_width = 22;
	int ene_height = 48;
	JIKI* pJiki;
	OBJPOS* pJikiPos;

	// L̏𓾂
	pJiki = &(p_stage_objects->jiki);
	pJikiPos = &(pJiki->obj.pos);

	// o̍\̂𓾂
	pEnemy = &(p_stage_objects->enemy[ene_index]);
	pEnePos = &(pEnemy->obj.pos);

	// ʒuݒ
	enemy_appear_positioning_center(pEnemy, ene_width, ene_height);

	// _ʒuύX
	memset(pEnePos, 0, sizeof(OBJPOS));
	pEnePos->px = pJikiPos->px - 140 - 400;
	pEnePos->py = 768 - 128;
	pEnePos->hx = pEnePos->px << 8;
	pEnePos->hy = pEnePos->py << 8;
	pEnemy->obj.prev_pos = *pEnePos;
	pEnemy->obj.direction = dir_right;

	// ݒ
	pEnemy->obj.move = move_boss3;			// ړ֐
	pEnemy->obj.draw = draw_boss3;			// `֐
	pEnemy->obj.grounding = move_grounding_bottom_simple;	// ڒn֐
	pEnemy->obj.on_hit = on_hit_boss;	// Gj󎞂̋ʏ
	pEnemy->obj.status = status_boss_1;	// ڋߑ҂ԂJn

	// SP`
	// XCzu
	stack_transfer_sp(p_stage_context->boss_sp_slot, 0x98, 0xA0, 4);

	// pbg]
	stack_transfer_pal(p_stage_context->boss_pal_stot, 0, 12, 3);

	// BGM؂ւ
	if (p_game_properties->disable_sound == 0) {
		// BGM̎w肠̏ꍇɐ؂ւBw肪Ȃꍇ͍ĐpB
		if (p_sound_context->bgm_index[bgmtype_boss] != SOUND_NULL) {
			sound_stop_bgm();
			sound_play_bgm(p_sound_context->bgm_index[bgmtype_boss]);
		}
	}

	return;
}


//=============================================================================
// ړ
//=============================================================================
void move_boss3(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;

	// ԑJ
	transition_boss3(pEnemy);

	// ړ
	do_move_boss3(pEnemy);
}


//=============================================================================
// L̕
//=============================================================================
void handle_direction(ENEMY* pEnemy)
{
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	OBJPOS* pJikiPos = &(p_stage_objects->jiki.obj.pos);

	int diff;
	diff = pJikiPos->hx - pPos->hx;
	pObj->direction = (diff > 0 ? dir_right : dir_left);
}


//=============================================================================
// ԑJڐ
//=============================================================================
void transition_boss3(ENEMY * pEnemy)
{
	CHROBJ* pObj = &(pEnemy->obj);
	int next_status = pObj->status;

	// ԑJڐ
	switch (pObj->status) {
	case status_normal:
		// fItg̏Ԃڋߑ҂ɑJ
		next_status = status_boss_1;
		break;

	case status_boss_1:
		// ҂Ԃ̏ԑJڐ
		next_status = transition_boss3_wait(pEnemy);
		break;

	case status_boss_2:
		// o[\̏ԑJڐ
		next_status = transition_boss3_baloon(pEnemy);
		break;

	case status_boss_3:
		// Ԃ̏ԑJڐ
		next_status = transition_boss3_stand(pEnemy);
		break;

	case status_boss_4:
		// ̏ԑJڐ
		next_status = transition_boss3_throw(pEnemy);
		break;

	case status_boss_5:
		// _bV̏ԑJڐ
		next_status = transition_boss3_dash(pEnemy);
		break;

	case status_boss_6:
		// _bV̏ԑJڐ
		next_status = transition_boss3_jump(pEnemy);
		break;

	case status_on_down:
		// _E
		next_status = transition_boss3_on_down(pEnemy);
		break;
	}

	// Ԃωꍇ
	if (next_status != pObj->status) {
		pObj->status = next_status;
		pEnemy->obj.frame_count = 0;
	}
}

//=============================================================================
// ړ
//=============================================================================
void do_move_boss3(ENEMY* pEnemy)
{
	CHROBJ* pObj = &(pEnemy->obj);

	// ړ
	switch (pObj->status) {
	case status_normal:
		// ftHgԁiȂj
		break;

	case status_boss_1:
		// ڋߑ҂
		move_boss3_wait(pEnemy);
		break;

	case status_boss_2:
		// o[
		move_boss3_baloon(pEnemy);
		break;

	case status_boss_3:
		// 
		move_boss3_stand(pEnemy);
		break;

	case status_boss_4:
		// 
		move_boss3_throw(pEnemy);
		break;

	case status_boss_5:
		// 
		move_boss3_dash(pEnemy);
		break;

	case status_boss_6:
		// 
		move_boss3_jump(pEnemy);
		break;

	case status_on_down:
		// _E
		move_boss3_on_down(pEnemy);
		break;

	default:
		// zȌԂȂ牽Ȃ
		break;
	}

	// 蔻
	switch (pObj->status) {
	case status_boss_3:
	case status_boss_4:
	case status_boss_5:
	case status_boss_6:
		// BGMESHɃvbgʊO肷
		collision_put_bgmesh_enemy(pObj);
		break;

	default:
		// ̃Xe[gȊO͓蔻菈Ȃ
		break;
	}
}


//=============================================================================
// `揈
//=============================================================================
void draw_boss3(void* pTarget)
{
	ENEMY* pEnemy = pTarget;
	CHROBJ* pObj = &(pEnemy->obj);

	// ړ
	switch (pObj->status) {
	case status_normal:
		// ftHgԁiȂj
		break;

	case status_boss_1:
		// ڋߑ҂
		draw_boss3_wait(pEnemy);
		break;

	case status_boss_2:
		// o[
		draw_boss3_baloon(pEnemy);
		break;

	case status_boss_3:
		// 
		draw_boss3_stand(pEnemy);
		break;

	case status_boss_4:
		// 
		draw_boss3_throw(pEnemy);
		break;

	case status_boss_5:
		// 
		draw_boss3_dash(pEnemy);
		break;

	case status_boss_6:
		// 
		draw_boss3_jump(pEnemy);
		break;

	case status_on_down:
		// _E
		draw_boss3_on_down(pEnemy);
		break;

	default:
		// zȌԂȂ牽Ȃ
		break;
	}
}


//=============================================================================
// 1 : ڋߑ҂
//=============================================================================
//-----------------------------------------------------------------------------
// ԑJڐ
//-----------------------------------------------------------------------------
int transition_boss3_wait(ENEMY* pEnemy)
{
	int diff;
	int next_status = pEnemy->obj.status;

	// L̏𓾂
	JIKI* pJiki = &(p_stage_objects->jiki);
	OBJPOS* pJikiPos = &(pJiki->obj.pos);

	// 𑪂
	diff = pJikiPos->px - pEnemy->obj.pos.px;
	if (abs(diff) < 165) {
		// ߕt
		next_status = status_boss_2;
	}
	
	// ڋ߂玟ɐi
	return next_status;
}


//-----------------------------------------------------------------------------
// ړ
//-----------------------------------------------------------------------------
void move_boss3_wait(ENEMY* pEnemy)
{
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);

	// ړȂ
	pPos->vx = 0;
	pPos->vy = 0;
	pPos->ax = 0;
	pPos->ay = 0;

	// ړʏ
	//
	move_common(pObj, 0, MOVE_GRAVITY);

	// SP`iLN^j
	pObj->anim_index = (pObj->frame_count >> 4) & 1;
	stack_transfer_sp(p_stage_context->boss_sp_slot, pObj->anim_index * 12, 0x90, 12);

	// SP`iQ[Wj
	enemy_transsp_boss_gauge(pEnemy, 0xA0, 0x9D);

	// I
	return;
}


//-----------------------------------------------------------------------------
// `揈
//-----------------------------------------------------------------------------
void draw_boss3_wait(ENEMY* pEnemy)
{
	// ʏɉ
	draw_boss3_core(pEnemy);
}


//=============================================================================
// 2 : o[\
//=============================================================================
//-----------------------------------------------------------------------------
// ԑJڐ
//-----------------------------------------------------------------------------
int transition_boss3_baloon(ENEMY* pEnemy)
{
	int next_status = pEnemy->obj.status;

	// ̎Ԃo߂玟
	if (pEnemy->obj.frame_count > 300) {
		// Ԃ
		next_status = status_boss_3;
	}

	// ڋ߂玟ɐi
	return next_status;
}


//-----------------------------------------------------------------------------
// ړ
//-----------------------------------------------------------------------------
void move_boss3_baloon(ENEMY* pEnemy)
{
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);

	// ړȂ
	pPos->vx = 0;
	pPos->vy = 0;
	pPos->ax = 0;
	pPos->ay = 0;

	// ړʏ
	//
	move_common(pObj, 0, MOVE_GRAVITY >> 2);

	// SP`iLN^j
	pObj->anim_index = (pObj->frame_count >> 4) & 1;
	stack_transfer_sp(p_stage_context->boss_sp_slot, pObj->anim_index * 12 * 7, 0x90, 12);

	// SP`io[j
	stack_transfer_sp(p_stage_context->boss_sp_slot, 0x90, 0xB0, 7);

	// SP`iQ[Wj
	enemy_transsp_boss_gauge(pEnemy, 0xA0, 0x9D);

	// I
	return;
}


//-----------------------------------------------------------------------------
// `揈
//-----------------------------------------------------------------------------
void draw_boss3_baloon(ENEMY* pEnemy)
{
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
//	int hx, hy;
	int px, py;
	int x;
	int ox, oi;
	int allocsp = 0;
	int pal = 12;

	// ʏɉ
	draw_boss3_core(pEnemy);

	// o[`
	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(7);	// SP7g
	if (allocsp < 7) {
		// mۂłȂ`߂
		return;
	}

	ox = 0;
	oi = 0;
	px = ((pPos->hx - p_stage_context->bgview_hx) >> 8) + 28 + (pObj->anim_index & 1);
	py = ((pPos->hy - p_stage_context->bgview_hy) >> 8) - 36 - (pObj->anim_index & 1);
	for (x = 0; x < 6; x++) {
		// }bvobt@Ƀf[^i[
		SP_SET(sp, px + ox, py, 0xB0 + oi, pal, 0, 0, 3);
		sp++;
		// 
		ox += 16;
		oi++;
	}
	// o`
	SP_SET(sp, px, py+16, 0xB0 + 6, pal, 0, 0, 3);
	sp++;
}

//=============================================================================
// 3 : 
//=============================================================================
//-----------------------------------------------------------------------------
// ԑJڐ
//-----------------------------------------------------------------------------
int transition_boss3_stand(ENEMY* pEnemy)
{
	int next_status = pEnemy->obj.status;
	int pattern[16] = { 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0 };

	// ̎Ԃo߂玟ցH
	if (pEnemy->obj.frame_count > 90) {
		// _œς
		next_status = status_boss_4 + pattern[vrand() & 15];
	}

	// ڋ߂玟ɐi
	return next_status;
}


//-----------------------------------------------------------------------------
// ړ
//-----------------------------------------------------------------------------
void move_boss3_stand(ENEMY* pEnemy)
{
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);

	// ړȂ
	pPos->vx = 0;
	pPos->vy = 0;
	pPos->ax = 0;
	pPos->ay = 0;

	// 
	handle_direction(pEnemy);

	// ړʏ
	//
	move_common(pObj, 0, MOVE_GRAVITY >> 2);

	// SP`iLN^j
	pObj->anim_index = (pObj->frame_count >> 3) & 1;
	stack_transfer_sp(p_stage_context->boss_sp_slot, pObj->anim_index * 12, 0x90, 12);

	// SP`iQ[Wj
	enemy_transsp_boss_gauge(pEnemy, 0xA0, 0x9D);

	// I
	return;
}


//-----------------------------------------------------------------------------
// `揈
//-----------------------------------------------------------------------------
void draw_boss3_stand(ENEMY* pEnemy)
{
	// ʏɉ
	draw_boss3_core(pEnemy);
}

//=============================================================================
// 4 : S~Ȃ
//=============================================================================
//-----------------------------------------------------------------------------
// ԑJڐ
//-----------------------------------------------------------------------------
int transition_boss3_throw(ENEMY* pEnemy)
{
	int next_status = pEnemy->obj.status;

	// ̎Ԃo߂玟ցH
	if (pEnemy->obj.frame_count > 300) {
		// Ԃ
		next_status = status_boss_3;
	}

	// ڋ߂玟ɐi
	return next_status;
}


//-----------------------------------------------------------------------------
// ړ
//-----------------------------------------------------------------------------
void move_boss3_throw(ENEMY* pEnemy)
{
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	int shotdir;

	// ړȂ
	pPos->vx = 0;
	pPos->vy = 0;
	pPos->ax = 0;
	pPos->ay = 0;

	// 
	handle_direction(pEnemy);

	// ړʏ
	//
	move_common(pObj, 0, MOVE_GRAVITY >> 3);

	// U
	if ((pObj->frame_count & 0xF) == 0) {
		if (pObj->direction == dir_right) {
			shotdir = 384 + 4 + (vrand() & 0x1F);
		}
		else {
			shotdir = 384 - 4 - (vrand() & 0x1F);
		}
		appear_bossshot(
			eneshottype_boss3dust
			, pPos->hx
			, pPos->hy
			, (vcos[shotdir] << 1) + (vcos[shotdir])
			, (vsin[shotdir] << 1) + (vsin[shotdir])
		);
	}

	// SP`iLN^j
	pObj->anim_index = 7 + ((pObj->frame_count >> 4) & 1);
	stack_transfer_sp(p_stage_context->boss_sp_slot, pObj->anim_index * 12, 0x90, 12);

	// SP`iQ[Wj
	enemy_transsp_boss_gauge(pEnemy, 0xA0, 0x9D);

	// I
	return;
}


//-----------------------------------------------------------------------------
// `揈
//-----------------------------------------------------------------------------
void draw_boss3_throw(ENEMY* pEnemy)
{
	// ʏɉ
	draw_boss3_core(pEnemy);
}


//=============================================================================
// 5 : _bV
//=============================================================================
//-----------------------------------------------------------------------------
// ԑJڐ
//-----------------------------------------------------------------------------
int transition_boss3_dash(ENEMY* pEnemy)
{
	int next_status = pEnemy->obj.status;

	// ̎Ԃo߂玟ցH
	if (pEnemy->obj.frame_count > 140) {
		// Ԃ
		next_status = status_boss_3;
	}

	// ڋ߂玟ɐi
	return next_status;
}


//-----------------------------------------------------------------------------
// ړ
//-----------------------------------------------------------------------------
void move_boss3_dash(ENEMY* pEnemy)
{
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	int mode = 0;

	// ړ
	if (pObj->frame_count < 90) {
		// ΂炭
		mode = 0;
		pPos->vx = 0;
		pPos->vy = 0;

		// 
		handle_direction(pEnemy);
	}
	else if (pObj->frame_count < 120) {
		// ړ
		mode = 1;
		if (pObj->direction == dir_left) {
			pPos->vx = -(8 << 8);
		}
		else {
			pPos->vx = (8 << 8);
		}
		pPos->vy = 0;
	}
	else {
		// ~
		mode = 2;
		pPos->vx = 0;
		pPos->vy = 0;

		// 
		handle_direction(pEnemy);
	}

	// ړʏ
	//
	move_common(pObj, 0, MOVE_GRAVITY >> 3);

	// SP`iLN^j
	switch (mode) {
	case 0:
		// 
		pObj->anim_index = 2;
		break;
	case 1:
		// 
		pObj->anim_index = 3 + ((pObj->frame_count >> 2) & 1);
		break;
	case 2:
		// ~
		pObj->anim_index = (pObj->frame_count >> 3) & 1;
		break;
	}
	stack_transfer_sp(p_stage_context->boss_sp_slot, pObj->anim_index * 12, 0x90, 12);

	// SP`iQ[Wj
	enemy_transsp_boss_gauge(pEnemy, 0xA0, 0x9D);

	// I
	return;
}


//-----------------------------------------------------------------------------
// `揈
//-----------------------------------------------------------------------------
void draw_boss3_dash(ENEMY* pEnemy)
{
	// ʏɉ
	draw_boss3_core(pEnemy);
}


//=============================================================================
// 6 : Wv
//=============================================================================
//-----------------------------------------------------------------------------
// ԑJڐ
//-----------------------------------------------------------------------------
int transition_boss3_jump(ENEMY* pEnemy)
{
	int next_status = pEnemy->obj.status;

	// ̎Ԃo߂玟ցH
	if (pEnemy->obj.frame_count > 260) {
		// Ԃ
		next_status = status_boss_3;
	}

	// ڋ߂玟ɐi
	return next_status;
}


//-----------------------------------------------------------------------------
// ړ
//-----------------------------------------------------------------------------
void move_boss3_jump(ENEMY* pEnemy)
{
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	int mode = 0;
	int walk_anim[4] = { 0,1,2,1 };

	// ړ
	if (pObj->frame_count < 90) {
		// ΂炭
		mode = 0;

		// 
		handle_direction(pEnemy);

		// ړ
		if (pObj->direction == dir_left) {
			pPos->vx = -(256 + 128);
		}
		else {
			pPos->vx = (256 + 128);
		}
		pPos->vy = 0;
	}
	else if (pObj->frame_count == 90) {
		// Wv
		mode = 1;
		if (pObj->direction == dir_left) {
			pPos->vx = (256);
		}
		else {
			pPos->vx = -(256);
		}
		pPos->vy = -1900;
	} else if (pObj->frame_count > 90) {
		if (pObj->gcol.bottom == 0) {
			mode = 1;
		}
		else {
			mode = 2;
			// ~߂
			pPos->vx = 0;
			pPos->vy = 0;
			// 
			handle_direction(pEnemy);
		}
	}

	// ړʏ
	//
	if (pPos->vy < 0) {
		// ㏸
		move_common(pObj, 0, MOVE_GRAVITY >> 1);
	}
	else {
		// ~͂藎
		move_common(pObj, 0, MOVE_GRAVITY >> 2);
	}

	// SP`iLN^j
	switch (mode) {
	case 0:
		// 
		pObj->anim_index = 9 + walk_anim[((pObj->frame_count >> 4) & 3)];
		break;
	case 1:
		// Wv
		pObj->anim_index = 5 + ((pObj->frame_count >> 2) & 1);
		break;
	case 2:
		// ~
		pObj->anim_index = (pObj->frame_count >> 3) & 1;
		break;
	}
	stack_transfer_sp(p_stage_context->boss_sp_slot, pObj->anim_index * 12, 0x90, 12);

	// SP`iQ[Wj
	enemy_transsp_boss_gauge(pEnemy, 0xA0, 0x9D);

	// U
	eneshot_boss3_jump(pEnemy);

	// I
	return;
}

void eneshot_boss3_jump(ENEMY* pEnemy)
{
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	int frame = pObj->frame_count;
	int frame_start = 115;
	int sequence;
	int arg;

	if (frame < frame_start) {
		// ^C~OOȂ牽Ȃ
		return;
	}
	if (((frame - frame_start) & 3) != 0) {
		// 4t[1񂾂s
		return;
	}

	// V[PXԍ𓱏oB萔葽疳B
	sequence = (frame - frame_start) >> 2;
	if (sequence > 8) {
		return;
	}

	// o
	if (pObj->direction == dir_right) {
		arg = (128 - (sequence << 5)) & 0x1FF;
	}
	else {
		arg = (128 + (sequence << 5)) & 0x1FF;
	}
	appear_bossshot(
		eneshottype_boss3dust
		, pPos->hx
		, pPos->hy
		, (vcos[arg] << 1)
		, (vsin[arg] << 1)
	);
}


//-----------------------------------------------------------------------------
// `揈
//-----------------------------------------------------------------------------
void draw_boss3_jump(ENEMY* pEnemy)
{
	// ʏɉ
	draw_boss3_core(pEnemy);
}


//=============================================================================
// on_down : _E
//=============================================================================
//-----------------------------------------------------------------------------
// ԑJڐ
//-----------------------------------------------------------------------------
int transition_boss3_on_down(ENEMY* pEnemy)
{
	// ԑJڐȂ
	return pEnemy->obj.status;
}


//-----------------------------------------------------------------------------
// ړ
//-----------------------------------------------------------------------------
void move_boss3_on_down(ENEMY* pEnemy)
{
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	int exposx, exposy;

	// L𖳓GԂɂ
	p_stage_objects->jiki.invincible = JIKI_BOSS_DOWN_INVINCIBLE;
	p_stage_objects->jiki.invincible_no_blink = 1;

	// Ă̋tɈړ
	pPos->ax = 0;
	pPos->ay = 0;
	pPos->vy = 0;
	pPos->vx = 0;

	// o瓦
	if (pEnemy->obj.frame_count > BOSS_EXP_DUDATION) {
		if (pObj->direction == dir_left) {
			pPos->vx = (4 << 8);
		}
		else {
			pPos->vx = -(4 << 8);
		}
	}

	// ړʏ
	//
	move_common(pObj, 0, 0);

	// 
	handle_direction(pEnemy);

	// SP`iLN^j
	if (pEnemy->obj.frame_count <= BOSS_EXP_DUDATION) {
		// ̂܂ܑ҂
		pObj->anim_index = (pObj->frame_count >> 4) & 1;
		stack_transfer_sp(p_stage_context->boss_sp_slot, pObj->anim_index * 12, 0x90, 12);
	}
	else {
		// Wv̊GœĂ
		pObj->anim_index = 5 + ((pObj->frame_count >> 2) & 1);
		stack_transfer_sp(p_stage_context->boss_sp_slot, pObj->anim_index * 12, 0x90, 12);
	}

	// SP`iQ[Wj
	enemy_transsp_boss_gauge(pEnemy, 0xA0, 0x9D);

	// GtFNgo
	if (pEnemy->obj.frame_count <= BOSS_EXP_DUDATION) {
		if ((pEnemy->obj.frame_count & 7) == 0) {
			exposx = ((vrand() & 63) - 32) << 8;
			exposy = ((vrand() & 63) - 32) << 8;
			appear_esp_rnd(esptype_bigsmoke, pPos->hx + exposx, pPos->hy + exposy, 2 << 8);	// 
			// ʉ
			play_se(&(p_sound_context->se_item[setype_enedamage]));
		}
	}

	// WO炷
	//if (pEnemy->obj.frame_count == BOSS_EXP_DUDATION) {
	if (pEnemy->obj.frame_count == BOSS_DOWN_DURATION) {
		stage_play_clear_jingle(p_stage_context->stage - 1);
	}

	// ΂炭Ă
	if (pEnemy->obj.frame_count == BOSS_DOWN_DURATION) {
		dispose_enemy(pEnemy);
	}

	// I
	return;
}


//-----------------------------------------------------------------------------
// `揈
//-----------------------------------------------------------------------------
void draw_boss3_on_down(ENEMY* pEnemy)
{
	// ʏɉ
	draw_boss3_core(pEnemy);
}


//=============================================================================
// `揈
//=============================================================================
void draw_boss3_core(ENEMY* pEnemy)
{
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int hx, hy;
	int px, py;
	int y, x;
	int ox, oy, oi;
	int allocsp = 0;
	int pal = pEnemy->on_damage == 0 ? 12 : 15;

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	// _Eŉʒ[܂ōs\Ȃ
	if ((pEnemy->obj.status==status_on_down)
		&& ((pEnemy->obj.pos.px < 182) || (pEnemy->obj.pos.px > 1017))
		) {
		return;
	}

	// -----< {̂` >-----
	//
	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(12);	// SP12g
	if (allocsp < 12) {
		// mۂłȂ`߂
		return;
	}

	ox = 0;
	oy = 0;
	oi = 0;
	for (y = 0; y < 4; y++) {
		for (x = 0; x < 3; x++) {
			// }bvobt@Ƀf[^i[
			if (pObj->direction==dir_right) {
				// E
				SP_SET(sp, px - 8 + ox, py - 24 + oy, 0x90 + oi, pal, 0, 0, 3);
			}
			else {
				// 
				SP_SET(sp, px + 24 - ox, py - 24 + oy, 0x90 + oi, pal, 1, 0, 3);
			}
			// 
			sp++;
			ox += 16;
			oi++;
		}
		ox = 0;
		oy += 16;
	}

	// -----< Q[W\ >-----
	//
	enemy_draw_boss_gauge(pEnemy, -16, -35, 0x9D);

	return;
}
