#include "stdio.h"
#include "stdlib.h"
#include "string.h"

#include "../devs/devs.h"
#include "game_context.h"
#include "common.h"
#include "stage.h"
#include "collision.h"
#include "enemy.h"
#include "kon_util.h"
#include "explode.h"
#include "eneshot.h"
#include "bossshot.h"
#include "item.h"
#include "esp.h"
#include "explode.h"
#include "ene_boss2.h"

// -----< vg^Cv錾 >-----
//
void move_boss2_normal(void* pEnemy);		// j[g
void move_boss2_takeoff(void* pEnemy);		// ㏸
void move_boss2_main(void* pEnemy);			// C
void move_boss2_shot(void* pEnemy);			// U
void move_boss2_on_down(void* pEnemy);		// _E
void transition_boss2(ENEMY* pEnemy);
void boss3_eneshot(void* pEnemy);			// ʏe
void do_boss2_bat(ENEMY* pEnemy);			// qobgo

// -----< 萔` >-----
//
int boss2_sptrans_frame[4] = { 0,1,2,1 };

//=============================================================================
// o
//=============================================================================
void init_boss2(int ene_index)
{
	ENEMY* pEnemy;
	OBJPOS* pEnePos;
	int ene_width = 80;
	int ene_height = 100;
	JIKI* pJiki;
	OBJPOS* pJikiPos;

	// o̍\̂𓾂
	pEnemy = &(p_stage_objects->enemy[ene_index]);
	pEnePos = &(pEnemy->obj.pos);

	// L̏𓾂
	pJiki = &(p_stage_objects->jiki);
	pJikiPos = &(pJiki->obj.pos);

	// ʒuݒ
	enemy_appear_positioning_center(pEnemy, ene_width, ene_height);

	// _ʒuύX
	memset(pEnePos, 0, sizeof(OBJPOS));
	pEnePos->px = pJikiPos->px + 128;
	pEnePos->py = 768 - 160;
	pEnePos->hx = pEnePos->px << 8;
	pEnePos->hy = pEnePos->py << 8;
	pEnemy->obj.prev_pos = *pEnePos;
	pEnemy->obj.direction = dir_left;

	// ݒ
	pEnemy->obj.move = move_boss2;			// ړ֐
	pEnemy->obj.draw = draw_boss2;			// `֐
	pEnemy->obj.grounding = move_grounding_flying_simple;	// ڒn֐
	pEnemy->do_eneshot = boss3_eneshot;		// ʏ̓Ge˂
	pEnemy->obj.on_hit = on_hit_boss;	// Gj󎞂̋ʏ

	// SP`
	// qobgBGp^[`̈̒[ɔzu
	stack_transfer_sp(p_stage_context->boss_sp_slot, 0xE0, 0x3E, 2);

	// BGM؂ւ
	if (p_game_properties->disable_sound == 0) {
		// BGM̎w肠̏ꍇɐ؂ւBw肪Ȃꍇ͍ĐpB
		if (p_sound_context->bgm_index[bgmtype_boss] != SOUND_NULL) {
			sound_stop_bgm();
			sound_play_bgm(p_sound_context->bgm_index[bgmtype_boss]);
		}
	}

	return;
}


//=============================================================================
// ړ
//=============================================================================
void move_boss2(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);

	// ԑJ
	transition_boss2(pEnemy);

	// ړ
	switch (pObj->status) {
	case status_boss_1:
		// ㏸
		move_boss2_takeoff(pTarget);
		break;
	case status_boss_2:
		// C
		move_boss2_main(pTarget);
		break;
	case status_boss_3:
		// U
		move_boss2_shot(pTarget);
		break;
	case status_on_down:
		// _E
		move_boss2_on_down(pTarget);
		break;
	default:
		// ʏ
		move_boss2_normal(pTarget);
		break;
	}

	// 蔻
	if (pObj->status != status_on_down) {
		// BGMESHɃvbgʊO肷
		collision_put_bgmesh_enemy(pObj);
	}
}


//=============================================================================
// ԑJڐ
//=============================================================================
void transition_boss2(ENEMY* pEnemy)
{
	CHROBJ* pObj = &(pEnemy->obj);

	// ԑJڐ
	int next_status = pObj->status;
	switch (pObj->status) {
	case status_normal:
		// o꒼ ҂Ă㏸
		if (pObj->frame_count > 90) {
			next_status = status_boss_1;
		}
		break;

	case status_boss_1:
		// ㏸  C
		if (pObj->frame_count > 180) {
			next_status = status_boss_2;
		}
		break;

	case status_boss_2:
		// C  U
		if (pObj->frame_count == 200) {
			next_status = status_boss_3;
		}
		break;

	case status_boss_3:
		// U  C
		if (pObj->frame_count == 200) {
			next_status = status_boss_2;
			// xȌԂɖ߂
			pObj->pos.vx =  pEnemy->option_param[0];
		}
		break;
	}

	// Ԃωꍇnh
	if (next_status != pObj->status) {
		pObj->status = next_status;
		pEnemy->obj.frame_count = 0;
	}
}


//=============================================================================
// ړiʏj
//=============================================================================
void move_boss2_normal(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);

	// ړ

	// ړʏ
	//
	move_common(pObj, 0, 0);

	// Ge
	//do_boss2_bat(pEnemy);

	// SP`iLN^j
	pObj->anim_index = boss2_sptrans_frame[ (pObj->frame_count >> 4) & 3 ];
	stack_transfer_sp(p_stage_context->boss_sp_slot, pObj->anim_index * 48, 0x90, 48);

	// SP`iQ[Wj
	enemy_transsp_boss_gauge(pEnemy, 0xE8, 0x85);

	// I
	return;
}


//=============================================================================
// ړi㏸j
//=============================================================================
void move_boss2_takeoff(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);

	// ړ
	if (pObj->frame_count < 90) {
		pPos->ay = -8;
		pPos->ax = -3;
	}
	else if (pObj->frame_count < 180) {
		pPos->ay = +8;
		pPos->ax = 0;
	}
	else {
		pPos->ay = 0;
		pPos->ax = 0;
	}

	// E]
	if (pPos->px < (p_stage_context->stage_clipping_area.x0 + 48)) {
		pPos->vx *= -1;
		pObj->direction = dir_right;
	}
	if (pPos->px > (p_stage_context->stage_clipping_area.x1 - 48)) {
		pPos->vx *= -1;
		pObj->direction = dir_left;
	}

	// IvVlƂčEړxۑBԕApB
	pEnemy->option_param[0] = pPos->vx;

	// ړʏ
	//
	move_common(pObj, 0, 0);

	// Ge

	// SP`iLN^j
	pObj->anim_index = boss2_sptrans_frame[(pObj->frame_count >> 4) & 3];
	stack_transfer_sp(p_stage_context->boss_sp_slot, pObj->anim_index * 48, 0x90, 48);

	// SP`iQ[Wj
	enemy_transsp_boss_gauge(pEnemy, 0xE8, 0x85);

	// I
	return;
}


//=============================================================================
// ړiCj
//=============================================================================
void move_boss2_main(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);

	// ړ
	pPos->vy = vsin[(pEnemy->option_param[1]++) & 0x1FF] >> 1;

	// E]
	if (pPos->px < (p_stage_context->stage_clipping_area.x0 + 48)) {
		pPos->vx *= -1;
		pObj->direction = dir_right;
	}
	if (pPos->px > (p_stage_context->stage_clipping_area.x1 - 48)) {
		pPos->vx *= -1;
		pObj->direction = dir_left;
	}

	// IvVlƂčEړxۑBԕApB
	pEnemy->option_param[0] = pPos->vx;

	// ړʏ
	//
	move_common(pObj, 0, 0);

	// Ge
	//if ((vrand() & 255) < 3) {
	if ((vrand() & 63) < 3) {
		int offset_hx = 0;
		if (pObj->direction == dir_left) {
			offset_hx = -(32 << 8);
		}
		else {
			offset_hx = (32 << 8);
		}
		regist_eneshot_delay(pEnemy, offset_hx, 1024);
	}

	// SP`iLN^j
	pObj->anim_index = boss2_sptrans_frame[(pObj->frame_count >> 4) & 3];
	stack_transfer_sp(p_stage_context->boss_sp_slot, pObj->anim_index * 48, 0x90, 48);

	// SP`iQ[Wj
	enemy_transsp_boss_gauge(pEnemy, 0xE8, 0x85);

	// I
	return;
}


//=============================================================================
// ړiUj
//=============================================================================
void move_boss2_shot(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);

	// ړ
	pPos->vy = vsin[(pEnemy->option_param[1]++) & 0x1FF] >> 1;

	// E]
	pPos->vx = 0;

	// ړʏ
	//
	move_common(pObj, 0, 0);

	// Ge
	do_boss2_bat(pEnemy);

	// SP`iLN^j
	pObj->anim_index = boss2_sptrans_frame[(pObj->frame_count >> 4) & 3];
	stack_transfer_sp(p_stage_context->boss_sp_slot, 0x90 + (pObj->anim_index * 24), 0x90, 24);

	// SP`iQ[Wj
	enemy_transsp_boss_gauge(pEnemy, 0xE8, 0x85);

	// I
	return;
}

//=============================================================================
// ړi_Ej
//=============================================================================
void move_boss2_on_down(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	int exposx, exposy;

	// L𖳓GԂɂ
	p_stage_objects->jiki.invincible = JIKI_BOSS_DOWN_INVINCIBLE;
	p_stage_objects->jiki.invincible_no_blink = 1;

	// Ƃ肠~߂
	pPos->ax = 0;
	pPos->ay = 0;
	pPos->vx = 0;
	pPos->vy = 0;

	// ړʏ
	//
	move_common(pObj, 0, 0);

	// SP`iLN^j
	pObj->anim_index = boss2_sptrans_frame[ (pObj->frame_count >> 4) & 3 ];
	stack_transfer_sp(p_stage_context->boss_sp_slot, pObj->anim_index * 48, 0x90, 48);

	// SP`iQ[Wj
	enemy_transsp_boss_gauge(pEnemy, 0xE8, 0x85);

	// 3bԔGtFNgo
	if (pEnemy->obj.frame_count <= BOSS_EXP_DUDATION) {
		if ((pEnemy->obj.frame_count & 7) == 0) {
			exposx = ((vrand() & 63) - 32) << 8;
			exposy = ((vrand() & 63) - 32) << 8;
			appear_exp(exptype_big, pPos->hx + exposx, pPos->hy + exposy, 2 << 8);	// 
			// ʉ
			play_se(&(p_sound_context->se_item[setype_enemy_down]));
		}
	}

	// WO炷
	//if (pEnemy->obj.frame_count == BOSS_EXP_DUDATION) {
	if (pEnemy->obj.frame_count == BOSS_DOWN_DURATION) {
		stage_play_clear_jingle(p_stage_context->stage - 1);
	}

	// ΂炭Ă
	if (pEnemy->obj.frame_count == BOSS_DOWN_DURATION) {
		dispose_enemy(pEnemy);
	}

	// I
	return;
}


//=============================================================================
// Geˏ
//============================================================================
void boss3_eneshot(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	int speed = (6 << 8);

	//if (pObj->direction == dir_left) {
		appear_eneshot(eneshottype_wave, pPos->hx - (32 << 8), pPos->hy + 1024, -speed, -256);
		appear_eneshot(eneshottype_wave, pPos->hx - (32 << 8), pPos->hy + 1024, -speed, 0);
		appear_eneshot(eneshottype_wave, pPos->hx - (32 << 8), pPos->hy + 1024, -speed, +256);
	//}
	//else {
		appear_eneshot(eneshottype_wave, pPos->hx + (32 << 8), pPos->hy + 1024, speed, -256);
		appear_eneshot(eneshottype_wave, pPos->hx + (32 << 8), pPos->hy + 1024, speed, 0);
		appear_eneshot(eneshottype_wave, pPos->hx + (32 << 8), pPos->hy + 1024, speed, +256);
	//}
}


//=============================================================================
// qobgo
//============================================================================
void do_boss2_bat(ENEMY* pEnemy)
{
	OBJPOS* pPos = &(pEnemy->obj.pos);
	int frame = pEnemy->obj.frame_count;
	int sequence;
	int arg;

	if (frame < 60) {
		// ^C~OȑOȂ牽Ȃ
		return;
	}
	if (((frame - 60) & 3) != 0) {
		// 4t[1񂾂s
		return;
	}

	// V[PXԍ𓱏oB萔葽疳B
	sequence = (frame - 60) >> 2;
	if (sequence > 8) {
		return;
	}

	// o
	arg = 0 + (sequence<<5);
	appear_bossshot(
		eneshottype_boss2bat
		, pPos->hx
		, pPos->hy
		//, (vcos[arg] << 2) + (vcos[arg] << 1)
		//, (vsin[arg] << 2) + (vsin[arg] << 1)
		, (vcos[arg] << 2)
		, (vsin[arg] << 2)
	);
}

//=============================================================================
// `揈
//=============================================================================
void draw_boss2(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int hx, hy;
	int px, py;
	int y, x;
	int ox, oy, oi;
	int allocsp = 0;
	int pal = pEnemy->on_damage == 0 ? 12 : 15;

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	// _Eň莞Ԃ߂\Ȃ
	if ((pEnemy->obj.status==status_on_down)
		&& (pEnemy->obj.frame_count >= 180)) {
		return;
	}

	// -----< {̂` >-----
	//
	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(48);	// SP32g
	if (allocsp < 48) {
		// mۂłȂ`߂
		return;
	}

	ox = 0;
	oy = 0;
	oi = 0;
	if (pObj->status != status_boss_3) {
		// Ě̕`
		for (y = 0; y < 8; y++) {
			for (x = 0; x < 6; x++) {
				// }bvobt@Ƀf[^i[
				if (pObj->direction == dir_left) {
					SP_SET(sp, px - 32 + ox, py - 48 + oy, 0x90 + oi, pal, 0, 0, 3);
				}
				else {
					SP_SET(sp, px + 48 - ox, py - 48 + oy, 0x90 + oi, pal, 1, 0, 3);
				}
				// 
				sp++;
				ox += 16;
				oi++;
			}
			ox = 0;
			oy += 16;
		}
	}
	else {
		// U̕`
		for (y = 0; y < 8; y++) {
			for (x = 0; x < 3; x++) {
				// }bvobt@Ƀf[^i[
				SP_SET(sp, px - 32 + ox, py - 48 + oy, 0x90 + oi, pal, 0, 0, 3);
				sp++;
				SP_SET(sp, px + 48 - ox, py - 48 + oy, 0x90 + oi, pal, 1, 0, 3);
				sp++;
				// 
				ox += 16;
				oi++;
			}
			ox = 0;
			oy += 16;
		}
	}

	// -----< Q[W\ >-----
	//
	enemy_draw_boss_gauge(pEnemy, -16, -68, 0x85);

	return;
}
