#include "stdio.h"
#include "stdlib.h"
#include "string.h"

#include "../devs/devs.h"
#include "game_context.h"
#include "common.h"
#include "stage.h"
#include "collision.h"
#include "enemy.h"
#include "kon_util.h"
#include "explode.h"
#include "eneshot.h"
#include "bossshot.h"
#include "item.h"
#include "esp.h"
#include "explode.h"
#include "ene_boss1.h"

// -----< vg^Cv錾 >-----
//
void move_boss1_normal(void* pEnemy);		// BOSS1̈ړiʏԁj
void move_boss1_on_down(void* pEnemy);		// BOSS1̈ړi_Ej
void transition_boss1(ENEMY* pEnemy);

//=============================================================================
// o
//=============================================================================
void init_boss1(int ene_index)
{
	ENEMY* pEnemy;
	OBJPOS* pEnePos;
	int ene_width = 64;
	int ene_height = 96;
	JIKI* pJiki;
	OBJPOS* pJikiPos;

	// L̏𓾂
	pJiki = &(p_stage_objects->jiki);
	pJikiPos = &(pJiki->obj.pos);

	// o̍\̂𓾂
	pEnemy = &(p_stage_objects->enemy[ene_index]);
	pEnePos = &(pEnemy->obj.pos);

	// ʒuݒ
	enemy_appear_positioning_center(pEnemy, ene_width, ene_height);

	// _ʒuύX
	memset(pEnePos, 0, sizeof(OBJPOS));
	pEnePos->px = 4862;
	pEnePos->py = 512 - 160;
	pEnePos->hx = pEnePos->px << 8;
	pEnePos->hy = pEnePos->py << 8;
	pEnemy->obj.prev_pos = *pEnePos;

	// ݒ
	pEnemy->obj.move = move_boss1;			// ړ֐
	pEnemy->obj.draw = draw_boss1;			// `֐
	pEnemy->obj.grounding = move_grounding_bottom_single;	// ڒn֐
	pEnemy->obj.on_hit = on_hit_boss;	// Gj󎞂̋ʏ

	// BGM؂ւ
	if (p_game_properties->disable_sound == 0) {
		// BGM̎w肠̏ꍇɐ؂ւBw肪Ȃꍇ͍ĐpB
		if (p_sound_context->bgm_index[bgmtype_boss] != SOUND_NULL) {
			sound_stop_bgm();
			sound_play_bgm(p_sound_context->bgm_index[bgmtype_boss]);
		}
	}

	return;
}


//=============================================================================
// ړ
//=============================================================================
void move_boss1(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);

	// ԑJ
	transition_boss1(pEnemy);

	// ړ
	switch (pObj->status) {
	case status_on_down:
		// _E
		move_boss1_on_down(pTarget);
		break;
	default:
		// ʏ
		move_boss1_normal(pTarget);
		// BGMESHɃvbgʊO肷
		collision_put_bgmesh_enemy(pObj);
		break;
	}
}


//=============================================================================
// ԑJڐ
//=============================================================================
void transition_boss1(ENEMY* pEnemy)
{
	CHROBJ* pObj = &(pEnemy->obj);
}


//=============================================================================
// ړiʏj
//=============================================================================
void move_boss1_normal(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);

	int cmn_sp_top = p_stage_context->cmn_sp_top;
	int ene_sp_top = p_stage_context->ene_sp_top;

	// nĂWv
	if (pObj->gcol.bottom != 0) {
		pPos->vy = -(2 << 8);
	}

	// Eړ
	if( (pObj->frame_count&63)==0 ) {
		int rnd = vrand();
		pPos->vx = 0;
		if ((rnd & 0xFF) < 64) {
			if (rnd & 1) {
				pPos->vx = 256;
			}
			else {
				pPos->vx = -256;
			}
		}
	}

	// ړʏ
	//
	move_common(pObj, 0, MOVE_GRAVITY >> 2);

	// Ge
	if ((pObj->frame_count & 0xF) == 0) {
		int offdir = (vrand() & 0x7F);
		appear_bossshot(eneshottype_bubble, pPos->hx, pPos->hy - (48<<8), vcos[384 - 64 + offdir] << 1, vsin[384 - 64 + offdir] << 1);
	}

	// SP`iLN^j
	pObj->anim_index = (pObj->frame_count >> 4) & 1;
	stack_transfer_sp(p_stage_context->boss_sp_slot, pObj->anim_index << 5, ene_sp_top, 32);

	// SP`iQ[Wj
	enemy_transsp_boss_gauge(pEnemy, 0x40, ene_sp_top + 0x20);

	// I
	return;
}

//=============================================================================
// ړi_Ej
//=============================================================================
void move_boss1_on_down(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	int exposx, exposy;

	int cmn_sp_top = p_stage_context->cmn_sp_top;
	int ene_sp_top = p_stage_context->ene_sp_top;

	// L𖳓GԂɂ
	p_stage_objects->jiki.invincible = JIKI_BOSS_DOWN_INVINCIBLE;
	p_stage_objects->jiki.invincible_no_blink = 1;

	// Ƃ肠~߂
	pPos->ax = 0;
	pPos->ay = 0;
	pPos->vx = 0;
	pPos->vy = 0;

	// ړʏ
	//
	move_common(pObj, 0, 0);

	// SP`iLN^j
	pObj->anim_index = (pObj->frame_count >> 4) & 1;
	stack_transfer_sp(p_stage_context->boss_sp_slot, pObj->anim_index << 5, ene_sp_top, 32);

	// SP`iQ[Wj
	enemy_transsp_boss_gauge(pEnemy, 0x40, ene_sp_top + 0x20);

	// 3bԔGtFNgo
	if (pEnemy->obj.frame_count <= BOSS_EXP_DUDATION) {
		if ((pEnemy->obj.frame_count & 7) == 0) {
			exposx = ((vrand() & 63) - 32) << 8;
			exposy = ((vrand() & 63) - 32) << 8;
			appear_exp(exptype_big, pPos->hx + exposx, pPos->hy + exposy, 2 << 8);	// 
			// ʉ
			play_se(&(p_sound_context->se_item[setype_enemy_down]));
		}
	}

	// WO炷
	//if (pEnemy->obj.frame_count == BOSS_EXP_DUDATION) {
	if (pEnemy->obj.frame_count == BOSS_DOWN_DURATION) {
			stage_play_clear_jingle(p_stage_context->stage - 1);
	}

	// ΂炭Ă
	if (pEnemy->obj.frame_count == BOSS_DOWN_DURATION) {
		dispose_enemy(pEnemy);
	}

	// I
	return;
}


//=============================================================================
// `揈
//=============================================================================
void draw_boss1(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int hx, hy;
	int px, py;
	int y, x;
	int ox, oy, oi;
	int allocsp = 0;
	int pal = pEnemy->on_damage == 0 ? 12 : 15;

	int sp_top = p_stage_context->ene_sp_top;

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	// _Eň莞Ԃ߂\Ȃ
	if ((pEnemy->obj.status==status_on_down)
		&& (pEnemy->obj.frame_count >= 180)) {
		return;
	}

	// -----< {̂` >-----
	//
	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(32);	// SP32g
	if (allocsp < 32) {
		// mۂłȂ`߂
		return;
	}

	ox = 0;
	oy = 0;
	oi = 0;
	for (y = 0; y < 8; y++) {
		for (x = 0; x < 4; x++) {
			// }bvobt@Ƀf[^i[
			SP_SET(sp, px - 16 + ox, py - 64 + oy, sp_top + oi, pal, 0, 0, 3);
			// 
			sp++;
			ox += 16;
			oi++;
		}
		ox = 0;
		oy += 16;
	}

	// -----< Q[W\ >-----
	//
	enemy_draw_boss_gauge(pEnemy, -16, -72, sp_top + 0x20);

	return;
}
