#include "stdio.h"
#include "stdlib.h"
#include "string.h"

#include "constants.h"
#include "game_context.h"
#include "common.h"
#include "collision.h"
#include "eneshot.h"
#include "esp.h"

#include "enemy.h"
#include "ene_bat.h"

// vg^Cv錾
void move_bat(void* pEnemy);			// ړ
void draw_bat(void* pEnemy);			// `揈
void eneshot_bat(void* pEnemy);			// Geˏ

//=============================================================================
// o
//=============================================================================
void init_bat(int ene_index)
{
	ENEMY* pEnemy;
	OBJPOS* pEnePos;
	int ene_width = 26;
	int ene_height = 26;

	// o̍\̂𓾂
	pEnemy = &(p_stage_objects->enemy[ene_index]);
	pEnePos = &(pEnemy->obj.pos);

	// ʒuݒ
	enemy_appear_positioning_center(pEnemy, ene_width, ene_height);

	// ݒ
	pEnemy->obj.move = move_bat;	// ړ֐
	pEnemy->obj.draw = draw_bat;	// `֐
	pEnemy->obj.grounding = NULL;	// ڒn֐
	pEnemy->do_eneshot = eneshot_bat;	// Geˏ
	pEnemy->obj.on_hit = on_hit_enemy;	// Gj󎞂̋ʏ

	// I
	return;
}


//=============================================================================
// ړ
//============================================================================
void move_bat(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	int clip_x0 = p_stage_context->stage_clipping_area.x0;
	int clip_x1 = p_stage_context->stage_clipping_area.x1;
	int ay[game_level_count][4] =		// t[Yx
	{
		{ 16, -16, -16, 16 }	// EASY
		, { 16, -16, -16, 16 }	// NOVICE
		, { 16, -16, -16, 16 }	// NORMAL
		, { 64, -64, -64, 64 }	// HARD
	};

	// ړxݒ
	pPos->ay = ay[p_game_properties->game_level][((pObj->frame_count >> 4) & 3)];
	pPos->vx = (pObj->direction == dir_left ? -256 : 256);
	// ʒ[̃NbsO
	if (((pPos->hx + pPos->vx) >> 8) < clip_x0 ) {
		pObj->direction = dir_right;
		pPos->vx = 256;
	}
	if (((pPos->hx + pPos->vx) >> 8) > clip_x1) {
		pObj->direction = dir_left;
		pPos->vx = -256;
	}

	// ړʏ
	//
	move_common(pObj, 0, 0);

	// BGMESHɃvbgʊO肷
	collision_put_bgmesh_enemy(pObj);

	// Ge
	//if ((vrand() & 255) < 3) {
	if ((vrand() & eneshot_rate[p_game_properties->game_level][enetype_bat]) < 3) {
		regist_eneshot_delay(pEnemy, 0, 0);
	}
}

//=============================================================================
// Geˏ
//============================================================================
void eneshot_bat(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);

	if (pObj->direction == dir_left) {
		appear_eneshot(eneshottype_wave, pPos->hx, pPos->hy, -640, 0);
	}
	else {
		appear_eneshot(eneshottype_wave, pPos->hx, pPos->hy, 640, 0);
	}
}


//=============================================================================
// `揈
//=============================================================================
void draw_bat(void* pTarget)
{
	ENEMY* pEnemy = (ENEMY*)pTarget;
	CHROBJ* pObj = &(pEnemy->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int hx, hy;
	int px, py;
	int anim = 0;
	int allocsp = 0;
	int pal = pEnemy->on_damage==0 ? 12 : 15;
	int anim_pattern[4] = { 0, 1, 2, 1 };

	// SPR[h̐擪I
	int sp_code_top = p_stage_context->ene_sp_top + 4;

	// Aj[ṼCfbNXԍ
	anim = anim_pattern[(pObj->frame_count >> 4) & 3];

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(4);	// SP2g
	if (allocsp < 4) {
		// mۂłȂ`߂
		return;
	}

	// }bvobt@Ƀf[^i[
	if (pObj->direction == dir_left) {
		SP_SET(sp, px, py, sp_code_top + (anim << 2), pal, 0, 0, 3);
		sp++;
		SP_SET(sp, px + 16, py, sp_code_top + 1 + (anim << 2), pal, 0, 0, 3);
		sp++;
		SP_SET(sp, px, py + 16, sp_code_top + 2 + (anim << 2), pal, 0, 0, 3);
		sp++;
		SP_SET(sp, px + 16, py + 16, sp_code_top + 3 + (anim << 2), pal, 0, 0, 3);
		sp++;
	}
	else {
		SP_SET(sp, px + 16, py, sp_code_top + (anim << 2), pal, 1, 0, 3);
		sp++;
		SP_SET(sp, px, py, sp_code_top + 1 + (anim << 2), pal, 1, 0, 3);
		sp++;
		SP_SET(sp, px + 16, py + 16, sp_code_top + 2 + (anim << 2), pal, 1, 0, 3);
		sp++;
		SP_SET(sp, px, py + 16, sp_code_top + 3 + (anim << 2), pal, 1, 0, 3);
		sp++;
	}

	return;
}
