#define __ENDING_C__
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "kon_util.h"
#include "constants.h"
#include "structs.h"
#include "common.h"
#include "game_context.h"
#include "../devs/devs.h"
#include "stage.h"

// -----< vg^Cv錾 >-----
//
int ending_init();		// ^Cgʂ̏
int ending_main();		// ^Cgʂ̃C
int ending_dispose();	// ^Cgʂ̌㏈
int ending_move();		// ^Cgʂ̉Z
int ending_move_1();
int ending_move_2();
int ending_move_3();
int ending_draw();		// ^Cgʂ̕`揈

// gWV
int transition_x[17] = { 0
						,256,512,768,0,256,512,768, 0
						, 768, 512, 256, 0, 768, 512, 256, 0};
int transition_y[17] = { 0
						, 0, 0, 0, 256, 256, 256, 256, 512
						, 256, 256, 256, 256, 0, 0, 0, 0 };

// 
int scene_x[13] = { 0
				,   0,   0,   0,   0
				, 256,  256, 256, 256
				, 512, 512
				, 512, 768};
int scene_y[13] = { 0
				,   0, 256, 512, 768
				,   0, 256, 512, 768
				,   0, 256
				, 512,   0};

// ItO
int ending_exit = 0;
int ending_on_save_all_clear_log = 0;
struct tm* tm;
time_t t;

//--------------------------------------------------------------------
//	[  ]
//		
//
//	[  ]
//		
//
//	[ ߂l ]
//		
//
//	[  ]
//		
//--------------------------------------------------------------------
int ending()
{
	int result = 0;

	// 
	ending_init();

	// ^Cgʂ̏
	result = ending_main();

	// ^Cg㏈
	ending_dispose();

	// I
	return result;
}


//--------------------------------------------------------------------
//	[  ]
//		
//
//	[  ]
//		
//
//	[ ߂l ]
//		
//
//	[  ]
//		
//--------------------------------------------------------------------
int ending_init()
{
	int result;
	int i;
	SP_UNIT* sp;

	// Xe[W̃ReLXg0ŏ
	memset(p_stage_context, 0, sizeof(STAGE_CONTEXT));

	// ʂ
	screen_init();

	// SP̈ʒuɏW߂
	sp = p_memory_map_buffer->sp_unit;
	for(i=0;i<128;i++) {
		SP_SET(sp, 0, 0, 0x00, 0, 0, 0, 3);
		sp++;
	}

	p_stage_context->cmn_sp_top = 0x40;
	
	// ZNVԍʔԍƂ
	p_stage_context->section = 0;
	p_stage_context->status = 0;
	p_stage_context->status_count = 8;

	// xʂB
	p_memory_map_buffer->vc_onoff.bit.gs0 = 0;
	p_memory_map_buffer->vc_onoff.bit.gs1 = 0;
	p_memory_map_buffer->vc_onoff.bit.gs2 = 0;
	p_memory_map_buffer->vc_onoff.bit.gs3 = 0;
	p_memory_map_buffer->vc_onoff.bit.gs4 = 0;
	p_memory_map_buffer->vc_onoff.bit.son = 0;
	p_memory_map_buffer->vc_onoff.bit.ton = 0;
	//
	p_memory_map_buffer->grp_scroll_unit.sc0_x = 0;
	p_memory_map_buffer->grp_scroll_unit.sc0_y = 256;
	//
	p_memory_map_buffer->bg_scroll_unit.ctrl.bit.bg0onoff = 0;
	p_memory_map_buffer->bg_scroll_unit.ctrl.bit.bg1onoff = 0;
	p_memory_map_buffer->bg_scroll_unit.ctrl.bit.disp_cpu = 1;
	do_wait_vsync(1);

	// \[Xǂݍ
	result = resource_load_ending();
	if (result != 0) {
		// s
		kon_log("ending_init : \[X̓ǂݍݒɃG[܂B\n");
		return -1;
	}

	// pbg]
	stack_transfer_pal(p_stage_context->text_pal_slot, 2, 0, 1);

	// ʃ[h֘A̐ݒs
	p_memory_map_buffer->vc_onoff.bit.gs0 = 1;
	p_memory_map_buffer->vc_onoff.bit.gs1 = 1;
	p_memory_map_buffer->vc_onoff.bit.gs2 = 1;
	p_memory_map_buffer->vc_onoff.bit.gs3 = 1;
	p_memory_map_buffer->vc_onoff.bit.gs4 = 1;
	p_memory_map_buffer->vc_onoff.bit.son = 1;
	p_memory_map_buffer->vc_onoff.bit.ton = 1;

	// ʂ̃vCIeBݒ肷
	p_memory_map_buffer->vc_priority.bit.sp = 1;      // XvCg̓eLXgƃOtBbN̊
	p_memory_map_buffer->vc_priority.bit.txt = 2;     // eLXg
	p_memory_map_buffer->vc_priority.bit.grp = 0;     // OtBbNO
	p_memory_map_buffer->vc_priority.bit.grp_p4 = 3;  // page4
	p_memory_map_buffer->vc_priority.bit.grp_p3 = 2;  // page3
	p_memory_map_buffer->vc_priority.bit.grp_p2 = 1;  // page2
	p_memory_map_buffer->vc_priority.bit.grp_p1 = 0;  // page1

	// Ԓlݒ
	p_stage_objects->frame_count = 0;
	ending_exit = 0;
	tm = NULL;	// l
	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int ending_main()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		0 : ̃Xe[W
//		1 : exit
//		ȊO : G[
//
//	[  ]
//		^Cg
//--------------------------------------------------------------------
int ending_main()
{
	int i;
	int result = 0;

	// BGMĐ
	if (p_game_properties->disable_sound == 0) {
		sound_play_bgm(p_sound_context->bgm_index[bgmtype_main]);
	}

	// Q[[v
	while ( 1 ) {
		// <<< SP`eSɏ >>>
		p_stage_objects->sp_index_seq = 0; // SP`̃R[hԍ

		// ړ
		ending_move();

		// `揈
		ending_draw();

		// NAOۑ
		if (ending_on_save_all_clear_log == 1) {
			draw_memory_map_buffer();
			save_all_clear_log(&t);
		}

		// VSYNC҂т̑O
		do_wait_vsync(1);

		// t[JE^XV
		p_stage_objects->frame_count += 1;
		p_application_context->frame_count += 1;

		// Xe[WNA甲
		if (ending_exit != 0) {
			break;
		}

		// vȌINGXgꂽI
//		if(p_input_parser->pause_clicked) {
//			p_application_context->quit_requested = 1;
//		}
		if (p_application_context->quit_requested) {
			break;
		}
	}

	// NbNI邭炢܂ő҂
	for (i = 0; i < 90; i++) {
		do_wait_vsync(1);
	}

	// BGM~߂
	sound_stop_bgm();
	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int ending_dispose()
//
//	[  ]
//		
//
//	[ ߂l ]
//		
//
//	[  ]
//		
//--------------------------------------------------------------------
int ending_dispose()
{
	resource_release_stage();
	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int ending_move()
//
//	[  ]
//		
//
//	[ ߂l ]
//		
//
//	[  ]
//		^Cgʂ̉Z
//--------------------------------------------------------------------
int ending_move()
{
	int result;

	// ^C~OƂ邽߂̃tO
	ending_on_save_all_clear_log = 0;

	// 
	if (p_stage_context->section <= 10) {
		result = ending_move_1();
	}
	else if (p_stage_context->section == 11) {
		// XN[
		result = ending_move_2();
	}
	else {
		// NWbg
		result = ending_move_3();
	}

	return result;
}

int ending_move_1()
{
	// ZNVԍʔԍƂ
	// clear_movegWVJE^Ƃ

	// gWV
	if (p_stage_context->status_count != 0) {
		// XN[ʒu𐧌䂷
		p_memory_map_buffer->grp_scroll_unit.sc0_x = transition_x[p_stage_context->status_count];
		p_memory_map_buffer->grp_scroll_unit.sc0_y = transition_y[p_stage_context->status_count];

		// Ԓli߂
		p_stage_context->status_count += 1;
		if (p_stage_context->status_count >= 18) {
			p_stage_context->status_count = 0;
			return 0;
		}
	}

	// gWVuԂɊG؂ւ
	if ((p_stage_context->status_count == (8+1)) && (p_stage_context->section<=10)) {
		p_stage_context->section += 1;
		p_memory_map_buffer->txt_scroll_unit.tx_x = scene_x[p_stage_context->section];
		p_memory_map_buffer->txt_scroll_unit.tx_y = scene_y[p_stage_context->section];
		p_stage_objects->frame_count = 0;
	}

	// {^NbNꂽgWV
	if ((p_input_parser->trg_main_clicked) && (p_stage_context->status_count==0)) {
		p_stage_context->status_count = 1;

		// ʉ
		play_se(&(p_sound_context->se_item[setype_cursor]));
	}

	return 0;
}

int ending_move_2()
{
	// pbg]
	stack_transfer_pal(p_stage_context->text_pal_slot, 3, 0, 1);

	// gWV
	if (p_stage_context->status_count != 0) {
		// XN[ʒu𐧌䂷
		p_memory_map_buffer->grp_scroll_unit.sc0_x = transition_x[p_stage_context->status_count];
		p_memory_map_buffer->grp_scroll_unit.sc0_y = transition_y[p_stage_context->status_count];

		// Ԓli߂
		p_stage_context->status_count += 1;
		if (p_stage_context->status_count >= 18) {
			p_stage_context->status_count = 0;
			return 0;
		}
	}

	// ҂
	if (p_stage_objects->frame_count < 120) {
		// 1bxȂBTu{^ŃXLbv
		if (p_input_parser->trg_sub_on_count > 0) {
			p_stage_objects->frame_count += 120;
		}
		return 0;
	}

	// XN[
	if (p_memory_map_buffer->txt_scroll_unit.tx_y < 768) {
		if ((p_application_context->frame_count & 1) == 0) {
			p_memory_map_buffer->txt_scroll_unit.tx_y += 1;
			if (p_input_parser->trg_sub_on_count > 0) {
				// Tu{^ŃXs[hAbv
				p_memory_map_buffer->txt_scroll_unit.tx_y += 15;
			}
		}
	}
	if (p_memory_map_buffer->txt_scroll_unit.tx_y >= 768) {
		p_memory_map_buffer->txt_scroll_unit.tx_y = 768;
	}

	// XN[Ƀ{^NbNꂽgWV
	if ((p_memory_map_buffer->txt_scroll_unit.tx_y >= 768)
		&& (p_stage_context->status_count == 0)) {
		if (p_input_parser->trg_main_clicked) {
			p_stage_context->status_count = 1;

			// ʉ
			play_se(&(p_sound_context->se_item[setype_cursor]));
		}
	}

	if ((p_memory_map_buffer->txt_scroll_unit.tx_y >= 768)
		&& (p_stage_context->status_count == 9)) {
		// gWVŉʂBꂽuԂɏIw
		p_stage_context->section += 1;
		p_memory_map_buffer->txt_scroll_unit.tx_x = scene_x[p_stage_context->section];
		p_memory_map_buffer->txt_scroll_unit.tx_y = scene_y[p_stage_context->section];
		p_stage_objects->frame_count = 0;

		// X^bt[BGM̓o^ꍇ͍Đ؂ւ
		if (resource_conf.bgm[bgmindex_ending][bgmtype_intermission] != NULL) {
			int bgm_index = p_sound_context->bgm_index[bgmtype_intermission];
			sound_stop_bgm();
			sound_play_bgm(bgm_index);
		}
	}

	return 0;
}

int ending_move_3()
{
	// pbg]
	stack_transfer_pal(p_stage_context->text_pal_slot, 4, 0, 1);

	// gWV
	if (p_stage_context->status_count != 0) {
		// XN[ʒu𐧌䂷
		p_memory_map_buffer->grp_scroll_unit.sc0_x = transition_x[p_stage_context->status_count];
		p_memory_map_buffer->grp_scroll_unit.sc0_y = transition_y[p_stage_context->status_count];

		// Ԓli߂
		p_stage_context->status_count += 1;
		if (p_stage_context->status_count >= 18) {
			p_stage_context->status_count = 0;
			return 0;
		}
	}

	// XN[
	if (p_memory_map_buffer->txt_scroll_unit.tx_y < 768) {
		if ((p_application_context->frame_count & 1) == 0) {
			p_memory_map_buffer->txt_scroll_unit.tx_y += 1;
			if (p_input_parser->trg_sub_on_count > 0) {
				// Tu{^ŃXs[hAbv
				p_memory_map_buffer->txt_scroll_unit.tx_y += 15;
			}
		}
	}
	if (p_memory_map_buffer->txt_scroll_unit.tx_y >= 768) {
		p_memory_map_buffer->txt_scroll_unit.tx_y = 768;
	}

	// XN[~܂玞
	if ((p_memory_map_buffer->txt_scroll_unit.tx_y == 768) && (tm == NULL))
	{
		t = time(NULL);
		tm = localtime(&t);
	}

	// XN[Ƀ{^NbNꂽgWV
	if ((p_memory_map_buffer->txt_scroll_unit.tx_y >= 768)
		&& (p_stage_context->status_count == 0)) {
		if (p_input_parser->trg_main_clicked) {
			// ԂɊ߂
			p_stage_context->status_count = 1;

			// I[NAOL^
			ending_on_save_all_clear_log = 1;

			// ʉ
			play_se(&(p_sound_context->se_item[setype_cursorok]));
		}
	}

	if ((p_memory_map_buffer->txt_scroll_unit.tx_y >= 768)
		&& (p_stage_context->status_count == 9)) {
		// gWVŉʂBꂽuԂɏIw
		ending_exit = 1;
	}

	return 0;
}


//--------------------------------------------------------------------
//	[  ]
//		int ending_draw()
//
//	[  ]
//		
//
//	[ ߂l ]
//		
//
//	[  ]
//		^Cgʂ̕`揈
//--------------------------------------------------------------------
int ending_draw()
{
	int i;
	SP_UNIT* sp;
	int x, y;
	int allocsp = 0;

	// XRA\
	x = 768 - p_memory_map_buffer->txt_scroll_unit.tx_x + 190;
	y = 768 - p_memory_map_buffer->txt_scroll_unit.tx_y + 128;
	if (force_zero_all_clear_score()) {
		// fobOIvVw肳ꂽꍇ͋0
		draw_digits(0, x, y);
	}
	else {
		// ʏ̓XRA\
		draw_digits_bigint(
			p_application_context->score
			, SCORE_DIGITS
			, x
			, y
			, 0x46
			, 5
			, 9
			, 0
		);
	}

	// ReBj[
	x = 768 - p_memory_map_buffer->txt_scroll_unit.tx_x + 137;
	y = 768 - p_memory_map_buffer->txt_scroll_unit.tx_y + 155;
	draw_digits(p_application_context->cont, x, y);

	// LEVEL\
	{
		x = 768 - p_memory_map_buffer->txt_scroll_unit.tx_x + 140;
		y = 768 - p_memory_map_buffer->txt_scroll_unit.tx_y + 155 + 16;

		// ^[QbgSP_UNITւ̃|C^
		sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;
		allocsp = sp_alloc_index(4);	// SP4g
		if (allocsp < 4) {
			// mۂłȂ`߂
			return 0;
		}

		// SPzu
		for (i = 0; i < 4; i++) {
			int spTop = 0x50 + (p_game_properties->game_level << 2);
			SP_SET(sp, x + (i << 4), y, spTop + i, 5, 0, 0, 3);
			sp++;
		}
	}

	// Ctݒ
	x = 768 - p_memory_map_buffer->txt_scroll_unit.tx_x + 137;
	y = 768 - p_memory_map_buffer->txt_scroll_unit.tx_y + 155 + 32;
	draw_digits(p_game_properties->life, x, y);

	// m肵Aƃx\
	if (tm != NULL)
	{
		// <<<  >>>
		x = 768 - p_memory_map_buffer->txt_scroll_unit.tx_x + 256 - 100;
		y = 768 - p_memory_map_buffer->txt_scroll_unit.tx_y + 16;
		// Year
		draw_digits(tm->tm_year+1900, x, y);
		// Month
		x += 16;
		sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;
		allocsp = sp_alloc_index(1);
		SP_SET(sp, x - 10, y, 0x61, 5, 0, 0, 3);
		sp++;
		x += 4;
		draw_digits(tm->tm_mon+1, x, y);
		if (tm->tm_mon + 1 < 10) {
			draw_digits(0, x-8, y);
		}
		// Day
		x += 16;
		sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;
		allocsp = sp_alloc_index(1);
		SP_SET(sp, x - 10, y, 0x61, 5, 0, 0, 3);
		sp++;
		x += 4;
		draw_digits(tm->tm_mday, x, y);
		if (tm->tm_mday < 10) {
			draw_digits(0, x - 8, y);
		}
		// Hour
		x += 16;
		x += 4;
		draw_digits(tm->tm_hour, x, y);
		if (tm->tm_hour < 10) {
			draw_digits(0, x - 8, y);
		}
		// Minute
		x += 16;
		sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;
		allocsp = sp_alloc_index(1);
		SP_SET(sp, x - 10, y, 0x64, 5, 0, 0, 3);
		sp++;
		x += 4;
		draw_digits(tm->tm_min, x, y);
		if (tm->tm_min < 10) {
			draw_digits(0, x - 8, y);
		}
		// Second
		x += 16;
		sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;
		allocsp = sp_alloc_index(1);
		SP_SET(sp, x - 10, y, 0x64, 5, 0, 0, 3);
		sp++;
		x += 4;
		draw_digits(tm->tm_sec, x, y);
		if (tm->tm_sec < 10) {
			draw_digits(0, x - 8, y);
		}

		// <<< o[W\ >>>
		x = 768 - p_memory_map_buffer->txt_scroll_unit.tx_x + 256 - 24;
		y = 768 - p_memory_map_buffer->txt_scroll_unit.tx_y + 16 + 14;
		// V
		sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;
		allocsp = sp_alloc_index(1);
		SP_SET(sp, x - 6, y, 0x60, 5, 0, 0, 3);
		sp++;
		//
		x += 8;
		draw_digits(VERSION_0, x - 8, y);
		{
			sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;
			allocsp = sp_alloc_index(1);
			SP_SET(sp, x, y, 0x61, 5, 0, 0, 3);
			sp++;
			x += 8;
		}
		x += 8;
		draw_digits(VERSION_1, x - 8, y);
		x += 8;
		draw_digits(VERSION_2, x - 8, y);
	}

	// <<< SP̎c̈ >>>
	//
	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;
	for (i = p_stage_objects->sp_index_seq; i <= 127; i++) {
		// Wړ
		sp->x = 0;
		sp->y = 0;
		// ̃jbgɐi
		sp++;
	}

	return 0;
}
