#ifndef __COMMON_H__
#define __COMMON_H__

#include "structs.h"

#ifdef __COMMON_C__
#define EXTERN 
#else
#define EXTERN extern
#endif

// <<<<< 萔` >>>>>
#define BG_ATTRIBUTE_NOP		(0)		// BG蔻Ȃ
#define BG_ATTRIBUTE_GROUND		(1)		// 
#define BG_ATTRIBUTE_BOARD		(2)		// 
#define BG_ATTRIBUTE_OUTER_WALL	(3)		// O
#define BG_ATTRIBUTE_SHOPDOOR	(4)		// Vbv
#define BG_ATTRIBUTE_SLIP		(5)		// 鏰
#define BG_ATTRIBUTE_DAMAGE		(6)		// _[W
#define BG_ATTRIBUTE_HOOK		(7)		// Ԃ牺
#define BG_ATTRIBUTE_SLOWBOARD	(8)		// ꂪ
#define BG_ATTRIBUTE_SLOW		(9)		// ꂪ
#define BG_ATTRIBUTE_FLOW_LEFT	(10)	// ɗ鏰
#define BG_ATTRIBUTE_FLOW_RIGHT	(11)	// Eɗ鏰

// <<< }N >>>
// nʂƊO
#define BG_WALL_CONDITION( VALUE )			\
		   ((VALUE==BG_ATTRIBUTE_GROUND)	\
		|| (VALUE==BG_ATTRIBUTE_OUTER_WALL)	\
		|| (VALUE==BG_ATTRIBUTE_SLIP)		\
		|| (VALUE==BG_ATTRIBUTE_DAMAGE)		\
		|| (VALUE==BG_ATTRIBUTE_SLOW)		\
		|| (VALUE==BG_ATTRIBUTE_FLOW_LEFT)	\
		|| (VALUE==BG_ATTRIBUTE_FLOW_RIGHT)	\
)

// 
#define BG_BOARD_CONDITION( VALUE )				\
		   ((VALUE==BG_ATTRIBUTE_BOARD)			\
		|| (VALUE == BG_ATTRIBUTE_SLOWBOARD)	\
)

// Ԃ牺\
#define BG_HOOK_CONDITION( VALUE )	(VALUE==BG_ATTRIBUTE_HOOK)

// n\
#define BG_STEP_CONDITION( VALUE )			\
		   ((VALUE==BG_ATTRIBUTE_GROUND)	\
		|| (VALUE==BG_ATTRIBUTE_BOARD)		\
		|| (VALUE==BG_ATTRIBUTE_OUTER_WALL)	\
		|| (VALUE==BG_ATTRIBUTE_SLIP)		\
		|| (VALUE==BG_ATTRIBUTE_DAMAGE)		\
		|| (VALUE==BG_ATTRIBUTE_SLOW)		\
		|| (VALUE==BG_ATTRIBUTE_FLOW_LEFT)	\
		|| (VALUE==BG_ATTRIBUTE_FLOW_RIGHT)	\
)

// <<<<< }N >>>>>
// IDX^bNɂ擾iTuEF|j
#define POP_IDSTACK_SUBWEAPON stack_pop(	\
	  p_stage_objects->subweapon_id_stack	\
	, &(p_stage_objects->subweapon_id_stack_ptr))

// IDX^bNɕԋpiTuEF|j
#define PUSH_IDSTACK_SUBWEAPON( ID_TO_PUSH ) stack_push(	\
	  (ID_TO_PUSH)	\
	, p_stage_objects->subweapon_id_stack	\
	, &(p_stage_objects->subweapon_id_stack_ptr)	\
	, MAX_SUBWEAPON )

// IDX^bNɂ擾iGj
#define POP_IDSTACK_ENEMY stack_pop(	\
	  p_stage_objects->enemy_id_stack	\
	, &(p_stage_objects->enemy_id_stack_ptr))

// IDX^bNɕԋpiGj
#define PUSH_IDSTACK_ENEMY( ID_TO_PUSH ) stack_push(	\
	  (ID_TO_PUSH)	\
	, p_stage_objects->enemy_id_stack	\
	, &(p_stage_objects->enemy_id_stack_ptr)	\
	, MAX_ENEMY )

// IDX^bNɂ擾iGej
#define POP_IDSTACK_ENESHOT stack_pop(	\
	  p_stage_objects->eneshot_id_stack	\
	, &(p_stage_objects->eneshot_id_stack_ptr))

// IDX^bNɕԋpiGej
#define PUSH_IDSTACK_ENESHOT( ID_TO_PUSH ) stack_push(	\
	  (ID_TO_PUSH)	\
	, p_stage_objects->eneshot_id_stack	\
	, &(p_stage_objects->eneshot_id_stack_ptr)	\
	, MAX_ENESHOT )

// IDX^bNɂ擾ij
#define POP_IDSTACK_EXPLODE stack_pop(	\
	  p_stage_objects->explode_id_stack	\
	, &(p_stage_objects->explode_id_stack_ptr))

// IDX^bNɕԋpij
#define PUSH_IDSTACK_EXPLODE( ID_TO_PUSH ) stack_push(	\
	  (ID_TO_PUSH)	\
	, p_stage_objects->explode_id_stack	\
	, &(p_stage_objects->explode_id_stack_ptr)	\
	, MAX_EXPLODE )

// IDX^bNɂ擾iACej
#define POP_IDSTACK_ITEM stack_pop(	\
	  p_stage_objects->item_id_stack	\
	, &(p_stage_objects->item_id_stack_ptr))

// IDX^bNɕԋpiACej
#define PUSH_IDSTACK_ITEM( ID_TO_PUSH ) stack_push(	\
	  (ID_TO_PUSH)	\
	, p_stage_objects->item_id_stack	\
	, &(p_stage_objects->item_id_stack_ptr)	\
	, MAX_ITEM )

// IDX^bNɂ擾iESPj
#define POP_IDSTACK_ESP stack_pop(	\
	  p_stage_objects->esp_id_stack	\
	, &(p_stage_objects->esp_id_stack_ptr))

// IDX^bNɕԋpiESPj
#define PUSH_IDSTACK_ESP( ID_TO_PUSH ) stack_push(	\
	  (ID_TO_PUSH)	\
	, p_stage_objects->esp_id_stack	\
	, &(p_stage_objects->esp_id_stack_ptr)	\
	, MAX_ESP )

// IuWFNg폜ɃNqȂ
#define DISCONNECT_STAGE_OBJECT_LINK( P_OBJ, P_TOP )	\
	{	\
		if (P_OBJ->p_prev != NULL) {	\
			P_OBJ->p_prev->p_next = P_OBJ->p_next;	\
		}	\
		if (P_OBJ->p_next != NULL) {	\
			P_OBJ->p_next->p_prev = P_OBJ->p_prev;	\
		}	\
		if (P_OBJ->p_prev == NULL) {	\
			p_stage_objects->P_TOP = P_OBJ->p_next;	\
		}	\
	}

// <<<<< ֐錾 >>>>>
//
// ^
EXTERN int vrand_index;	// ^CfbNX
EXTERN int vrand();

// SP֘A
EXTERN int sp_alloc_index(int count);

// IuWFNgX^bNɕԂ
void dispose_enemy(ENEMY* pEnemy);
void dispose_eneshot(ENESHOT* pEneShot);
void dispose_subweapon(SUBWEAPON* pSub);
void dispose_item(ITEM* pItem);
void dispose_explode(EXPLODE* pExplode);
void dispose_esp(ESP* pItem);

// BG֘A
void get_collision_bgs(OBJPOS* pPos, BBOX* bbox, BBOX* pTarget);	// ڐGĂBG͈̔͂𓾂

// R{Jn
void start_combo(OBJPOS* pPos);

// ړ
EXTERN void move_common(CHROBJ* pObj, int downstair, int gravity);	// ړʏ
//
EXTERN void move_obj(OBJPOS* pPos);	// ړ̋ʏ
EXTERN void move_grounding(struct _CHROBJ* pObj, int downstair, GROUNDING_COLLISION* collision);	// EǁEV̐ڒn

// ڒni@pFʏɉHOOK肪j
EXTERN void move_grounding_jiki(struct _CHROBJ* pObj, int downstair, GROUNDING_COLLISION* collision);	// EǁEV̐ڒn
// ڒniŉP_̂ݔj
EXTERN void move_grounding_bottom_single(struct _CHROBJ* pObj, int downstair, GROUNDING_COLLISION* collision);	// EǁEV̐ڒn
// ڒniŉP_̂ݔ{Eړ̊ȑfǔ{ZNVV䔻j
EXTERN void move_grounding_bottom_simple(struct _CHROBJ* pObj, int downstair, GROUNDING_COLLISION* collision);	// EǁEV̐ڒn
// ڐGi㉺E1_̂ݔ{NbsOGAړj
EXTERN void move_grounding_flying_simple(struct _CHROBJ* pObj, int downstair, GROUNDING_COLLISION* collision);	// EǁEV̐ڒn

// {֘A֐
EXTERN void add_digit(int* target, int target_digits, int digit, int value);
EXTERN void add_digit_def(int* target, int target_digits, int* score_def);
EXTERN int sub_digit(int* target, int target_digits, int digit, int value);
EXTERN int digits_get_int(int* target, int target_digits);
EXTERN void digits_set_int(int value, int* target, int target_digits);

// ̕`
EXTERN void draw_digits(int value, int px, int py);
EXTERN void draw_digits_bigint(int* value, int max_digits, int px, int py, int sp_code_zero, int pal, int width, int force_full);

// SE֘A
EXTERN void play_se(SE_ITEM* pItem);	// SEĐ

// ̑
void save_all_clear_log_file(char* path, void* pTim);
int force_zero_all_clear_score();	// SNAOɎcXRA0ɂƂ1Ԃ

#undef EXTERN
#endif
