#define __COMMON_C__
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "../devs/devs.h"

#include "constants.h"
#include "kon_util.h"
#include "game_context.h"
#include "structs.h"
#include "common.h"
#include "stage.h"
#include "explode.h"
#include "enemy.h"

// -----< vg^Cv錾 >-----
//
// ڐG֘A
void move_grounding_xpos(OBJPOS* pFrom, OBJPOS* pTo, BBOX* grd_bbox, GROUNDING_COLLISION* collision);	// ڒn Xړ
void move_grounding_xneg(OBJPOS* pFrom, OBJPOS* pTo, BBOX* grd_bbox, GROUNDING_COLLISION* collision);	// ڒn Xړ
void move_grounding_ypos(OBJPOS* pFrom, OBJPOS* pTo, BBOX* grd_bbox, int downstair, GROUNDING_COLLISION* collision);	// ڒn Yړ
void move_grounding_yneg(OBJPOS* pFrom, OBJPOS* pTo, BBOX* grd_bbox, GROUNDING_COLLISION* collision);	// ڒn Yړ
void move_grounding_stage_area(OBJPOS* pTo, BBOX* grd_bbox, GROUNDING_COLLISION* collision);	// Xe[WS͈̔͂̃NbsO
//
void move_grounding_ypos_single(OBJPOS* pFrom, OBJPOS* pTo, BBOX* grd_bbox, int downstair, GROUNDING_COLLISION* collision);	// ڒn Yړ
// Ԃ牺蔻菈
void move_grounding_ypos_hook(OBJPOS* pFrom, OBJPOS* pTo, BBOX* grd_bbox, int downstair, GROUNDING_COLLISION* collision);	// ڒn Yړ

// ԑJڊ֘A

// -----< ϐ` >-----
//
int vrand_index = 0;

//--------------------------------------------------------------------
//	[  ]
//		int vrand()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		^i0`255j
//
//	[  ]
//		^Ԃ܂
//--------------------------------------------------------------------
int vrand()
{
	int result = vrandom[vrand_index++];
	vrand_index &= VARY_TABLE_MASK;
	return result;
}

//--------------------------------------------------------------------
//	[  ]
//		sp_alloc_index(int count)
//
//	[  ]
//		int count	mۂSP̌
//
//	[ ߂l ]
//		mۂłSP̌
//
//	[  ]
//		StageContextŃJEgĂSP̃V[PXgāA
//		countSP̃CfbNXmۂAmۂʂ
//		V[PXlXV܂B
//		128ȏɂȂƊmۂłȂ̂ŁȀꍇ0Ԃ܂B
//--------------------------------------------------------------------
int sp_alloc_index(int count)
{
	int sp_index;
	int allocsp;
	sp_index = p_stage_objects->sp_index_seq;		// SPindex𓾂
	allocsp = min(count, SP_UNIT_ARRAY_LENGTH - sp_index);			// mۂłSP
	p_stage_objects->sp_index_seq += allocsp;		// CfbNXi߂

	return allocsp;
}

//--------------------------------------------------------------------
//	[  ]
//		void dispose_enemy(ENEMY* pEnemy)
//
//	[  ]
//		ENEMY* pEnemy     폜IuWFNgւ̃|C^
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		G폜X^bNɕԂ܂B
//--------------------------------------------------------------------
void dispose_enemy(ENEMY* pEnemy)
{
	pEnemy->obj.status = status_absent;

	// Xe[W̏o炷
	if (pEnemy->desc_line >= 0) {
		p_stage_objects->enemy_existing[pEnemy->desc_line] -= 1;
	}

	// IuWFNgԂ
	PUSH_IDSTACK_ENEMY(pEnemy->obj.array_index);

	// NqȂ
	DISCONNECT_STAGE_OBJECT_LINK(pEnemy, enemy_top);
}

//--------------------------------------------------------------------
//	[  ]
//		void dispose_eneshot(ENESHOT* pEneShot)
//
//	[  ]
//		ENESHOT* pEneShot     폜IuWFNgւ̃|C^
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		Ge폜X^bNɕԂ܂B
//--------------------------------------------------------------------
void dispose_eneshot(ENESHOT* pEneShot)
{
	pEneShot->obj.status = status_absent;

	// IuWFNgԂ
	PUSH_IDSTACK_ENESHOT(pEneShot->obj.array_index);

	// NqȂ
	DISCONNECT_STAGE_OBJECT_LINK(pEneShot, eneshot_top);
}

//--------------------------------------------------------------------
//	[  ]
//		void dispose_subweapon(SUBWEAPON* pSub)
//
//	[  ]
//		SUBWEAPON* pSub     폜TuEF|ւ̃|C^
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		TuEF|폜X^bNɕԂ܂B
//--------------------------------------------------------------------
void dispose_subweapon(SUBWEAPON* pSub)
{
	pSub->obj.status = status_absent;

	// IuWFNgԂ
	PUSH_IDSTACK_SUBWEAPON(pSub->obj.array_index);

	// NqȂ
	DISCONNECT_STAGE_OBJECT_LINK(pSub, subweapon_top);
}

//--------------------------------------------------------------------
//	[  ]
//		void dispose_item(ITEM* pItem)
//
//	[  ]
//		ITEM* pItem     폜IuWFNgւ̃|C^
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		ACe폜X^bNɕԂ܂B
//--------------------------------------------------------------------
void dispose_item(ITEM* pItem)
{
	pItem->obj.status = status_absent;

	// IuWFNgԂ
	PUSH_IDSTACK_ITEM(pItem->obj.array_index);

	// NqȂ
	DISCONNECT_STAGE_OBJECT_LINK(pItem, item_top);
}

//--------------------------------------------------------------------
//	[  ]
//		void dispose_explode(EXPLODE* pExplode)
//
//	[  ]
//		EXPLODE* pExplode     폜IuWFNgւ̃|C^
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		IuWFNg폜X^bNɕԂ܂B
//--------------------------------------------------------------------
void dispose_explode(EXPLODE* pExplode)
{
	pExplode->obj.status = status_absent;

	// IuWFNgԂ
	PUSH_IDSTACK_EXPLODE(pExplode->obj.array_index);

	// NqȂ
	DISCONNECT_STAGE_OBJECT_LINK(pExplode, explode_top);
}

//--------------------------------------------------------------------
//	[  ]
//		void dispose_esp(ESP* pItem)
//
//	[  ]
//		ESP* pEsp     폜IuWFNgւ̃|C^
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		ACe폜X^bNɕԂ܂B
//--------------------------------------------------------------------
void dispose_esp(ESP* pESP)
{
	pESP->obj.status = status_absent;

	// IuWFNgԂ
	PUSH_IDSTACK_ESP(pESP->obj.array_index);

	// NqȂ
	DISCONNECT_STAGE_OBJECT_LINK(pESP, esp_top);
}


//--------------------------------------------------------------------
//	[  ]
//		void start_combo(OBJPOS* pPos)
//
//	[  ]
//		OBJPOS* pPos		R{̃IuWFNg̈ʒu
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		R{Jn܂
//--------------------------------------------------------------------
void start_combo(OBJPOS* pPos)
{
	// R{xグ
	if (p_stage_objects->combo_lv < 5) {
		p_stage_objects->combo_lv += 1;
	}
	// R{JEg_Eݒ
	p_stage_objects->combo_timeout = COMBO_TIMEOUT;
}


//--------------------------------------------------------------------
//	[  ]
//		int move_common(CHROBJ* pObj, int downstair, int gravity)
//
//	[  ]
//		CHAROBJ* pObj	Ώۂ̃IuWFNgւ̃|C^
//		int downstair	ړw̏ꍇ1
//		int gravity		d͉x
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		eLN^ʂ̈ړ
//--------------------------------------------------------------------
void move_common(CHROBJ* pObj, int downstair, int gravity)
{
	OBJPOS* pPos = &(pObj->pos);
	GROUNDING_COLLISION* collision = &(pObj->gcol);

	// d͂𔽉f
	if (gravity != 0) {
		pPos->ay = gravity;
	}

	// ړ
	move_obj(pPos);

	// GROUNDING
	if (pObj->grounding != NULL) {
		// ڒn֐̎w肪AĂяo
		pObj->grounding(pObj, downstair, collision);
	}

	// Xe[gJ
	//state_transition(pObj, collision);

	// uO̒lvXV
	pObj->prev_pos = *pPos;

	// t[JEg
	pObj->frame_count += 1;
	return;
}

//--------------------------------------------------------------------
//	[  ]
//		void move_obj(OBJPOS* pPos)
//
//	[  ]
//		OBJPOS* pPos	ʒũIuWFNgւ̃|C^
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		LN^IuWFNg̋ʈړs܂B
//--------------------------------------------------------------------
void move_obj(OBJPOS* pPos) {
	// WvZ
	pPos->vx += pPos->ax;
	pPos->vy += pPos->ay;

	pPos->hx += pPos->vx;
	pPos->hy += pPos->vy;

	pPos->px = pPos->hx >> 8;
	pPos->py = pPos->hy >> 8;

	// I
	return;
}


//--------------------------------------------------------------------
//	[  ]
//		void move_grounding(struct _CHROBJ* pObj, int downstair)
//
//	[  ]
//		CHAROBJ* pObj					Ώۂ̃IuWFNgւ̃|C^
//		int downstair					ɍ~Ƃ1AȊO0
//		GROUNDING_COLLISION* collision	ڐG茋ʂ̊i[
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		LN^ƏEVEǂƂ̐ڐGsALN^
//		ʒu␳܂B
//--------------------------------------------------------------------
void move_grounding(struct _CHROBJ* pObj, int downstair, GROUNDING_COLLISION* collision)
{
	OBJPOS from;
	OBJPOS to;
	BBOX* pBBox = &(pObj->grd_bbox);

	// 
	memset(collision, 0, sizeof(GROUNDING_COLLISION));

	// FROMʒu荞
	from = pObj->prev_pos;

	// XړĔ
	to = from;
	to.hx = pObj->pos.hx;
	to.px = pObj->pos.px;
	move_grounding_stage_area(&to, pBBox, collision);	// Xe[WŜł̃NbsO
	if (pObj->pos.vx > 0) {
		// Xړ
		move_grounding_xpos(&from, &to, pBBox, collision);
	}
	else if (pObj->pos.vx < 0) {
		// Xړ
		move_grounding_xneg(&from, &to, pBBox, collision);
	}
	// Xm
	from = to;

	// YɈړĔ
	to.hy = pObj->pos.hy;
	to.py = pObj->pos.py;
	move_grounding_stage_area(&to, pBBox, collision);	// Xe[WŜł̃NbsO
	if (pObj->pos.vy > 0) {
		move_grounding_ypos(&from, &to, pBBox, downstair, collision);
	}
	else if (pObj->pos.vy < 0) {
		move_grounding_yneg(&from, &to, pBBox, collision);
	}

	// ʒuAxm
	pObj->pos.px = to.px;
	pObj->pos.py = to.py;
	pObj->pos.hx = to.hx;
	pObj->pos.hy = to.hy;
	pObj->pos.vx = pObj->pos.hx - pObj->prev_pos.hx;
	pObj->pos.vy = pObj->pos.hy - pObj->prev_pos.hy;
	//pObj->pos.ax = pObj->pos.vx - pObj->prev_pos.vx;
	//pObj->pos.ay = pObj->pos.vy - pObj->prev_pos.vy;

	// I
	return;
}


//--------------------------------------------------------------------
//	[  ]
//		void move_grounding_jiki(struct _CHROBJ* pObj, int downstair)
//
//	[  ]
//		CHAROBJ* pObj					Ώۂ̃IuWFNgւ̃|C^
//		int downstair					ɍ~Ƃ1AȊO0
//		GROUNDING_COLLISION* collision	ڐG茋ʂ̊i[
//
//	[ ߂l ]
//		F0
//		sF0ȊO
//
//	[  ]
//		LN^ƏEVEǂƂ̐ڐGsALN^
//		ʒu␳܂B
//		@p̃\bhłBʏ̔̂قAԂ牺蔻肪
//		ǉĂ܂B
//--------------------------------------------------------------------
void move_grounding_jiki(struct _CHROBJ* pObj, int downstair, GROUNDING_COLLISION* collision)
{
	OBJPOS from;
	OBJPOS to;
	BBOX* pBBox = &(pObj->grd_bbox);

	// 
	memset(collision, 0, sizeof(GROUNDING_COLLISION));

	// FROMʒu荞
	from = pObj->prev_pos;

	// XړĔ
	to = from;
	to.hx = pObj->pos.hx;
	to.px = pObj->pos.px;
	move_grounding_stage_area(&to, pBBox, collision);	// Xe[WŜł̃NbsO
	if (pObj->pos.vx > 0) {
		// Xړ
		move_grounding_xpos(&from, &to, pBBox, collision);
	}
	else if (pObj->pos.vx < 0) {
		// Xړ
		move_grounding_xneg(&from, &to, pBBox, collision);
	}
	// Xm
	from = to;

	// YɈړĔ
	to.hy = pObj->pos.hy;
	to.py = pObj->pos.py;
	move_grounding_stage_area(&to, pBBox, collision);	// Xe[WŜł̃NbsO
	if (pObj->pos.vy > 0) {
		move_grounding_ypos(&from, &to, pBBox, downstair, collision);
		// Ԃ牺蔻B_[W͂Ԃ牺ɑJڂłȂB
		if ((pObj->status != status_damage) && (pObj->status != status_on_down)) {
			move_grounding_ypos_hook(&from, &to, pBBox, downstair, collision);
		}
	}
	else if (pObj->pos.vy < 0) {
		move_grounding_yneg(&from, &to, pBBox, collision);
	}

	// ʒuAxm
	pObj->pos.px = to.px;
	pObj->pos.py = to.py;
	pObj->pos.hx = to.hx;
	pObj->pos.hy = to.hy;
	pObj->pos.vx = pObj->pos.hx - pObj->prev_pos.hx;
	pObj->pos.vy = pObj->pos.hy - pObj->prev_pos.hy;
	//pObj->pos.ax = pObj->pos.vx - pObj->prev_pos.vx;
	//pObj->pos.ay = pObj->pos.vy - pObj->prev_pos.vy;

	// I
	return;
}


//--------------------------------------------------------------------
//	[  ]
//		void move_grounding_bottom_single(struct _CHROBJ* pObj, int downstair)
//
//	[  ]
//		CHAROBJ* pObj					Ώۂ̃IuWFNgւ̃|C^
//		int downstair					ɍ~Ƃ1AȊO0
//		GROUNDING_COLLISION* collision	ڐG茋ʂ̊i[
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		LN^ƏEVEǂƂ̐ڐGsALN^
//		ʒu␳܂B
//--------------------------------------------------------------------
void move_grounding_bottom_single(struct _CHROBJ* pObj, int downstair, GROUNDING_COLLISION* collision)
{
	OBJPOS* pPos = &(pObj->pos);
	OBJPOS* from;
	OBJPOS to;
	BBOX groundingBbox;
	// y1gȂ
	//groundingBbox.x0 = (pObj->grd_bbox.x0 + pObj->grd_bbox.x1) >> 1;
	//groundingBbox.x0 = 0;
	//groundingBbox.x1 = 1;
	//groundingBbox.y0 = pObj->grd_bbox.y1 - 1;
	groundingBbox.y1 = pObj->grd_bbox.y1;

	// 茋ʂ
	memset(collision, 0, sizeof(GROUNDING_COLLISION));

	// FROMʒu荞
	from = &(pObj->prev_pos);

	// TOʒupӂ
	to = *pPos;

	// Xe[WS
	//move_grounding_stage_area(&to, &groundingBbox, collision);	// Xe[WŜł̃NbsO
	if (to.px < p_stage_context->stage_clipping_area.x0) {
		to.px = p_stage_context->stage_clipping_area.x0;
		to.hx = to.px << 8;
	}
	if (to.px > p_stage_context->stage_clipping_area.x1) {
		to.px = p_stage_context->stage_clipping_area.x1;
		to.hx = to.px << 8;
	}

	// YɈړĔ
	if (pObj->pos.vy > 0) {
		move_grounding_ypos_single(from, &to, &groundingBbox, downstair, collision);
	}

	// ʒuAxAxm
	*pPos = to;
	pPos->vx = pPos->hx - pObj->prev_pos.hx;
	pPos->vy = pPos->hy - pObj->prev_pos.hy;

	// I
	return;
}


//--------------------------------------------------------------------
//	[  ]
//		void move_grounding_bottom_simple(struct _CHROBJ* pObj, int downstair)
//
//	[  ]
//		CHAROBJ* pObj					Ώۂ̃IuWFNgւ̃|C^
//		int downstair					ɍ~Ƃ1AȊO0
//		GROUNDING_COLLISION* collision	ڐG茋ʂ̊i[
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		LN^ƏEVEǂƂ̐ڐGsALN^
//		ʒu␳܂B
//		move_grounding_bottom_single ̋ɉāA
//		Eړ̊ȑfǔ{ZNVV䔻s܂B
//--------------------------------------------------------------------
void move_grounding_bottom_simple(struct _CHROBJ* pObj, int downstair, GROUNDING_COLLISION* collision)
{
	OBJPOS* pPos = &(pObj->pos);
	OBJPOS* from;
	OBJPOS to;
	int bgx, bgy;
	unsigned char att;
	BBOX* pClip = &(p_stage_context->stage_clipping_area);
	BBOX groundingBbox;
	// y1gȂ
	//groundingBbox.x0 = (pObj->grd_bbox.x0 + pObj->grd_bbox.x1) >> 1;
	//groundingBbox.x0 = 0;
	//groundingBbox.x1 = 1;
	//groundingBbox.y0 = pObj->grd_bbox.y1 - 1;
	groundingBbox.y1 = pObj->grd_bbox.y1;

	// 茋ʂ
	memset(collision, 0, sizeof(GROUNDING_COLLISION));

	// FROMʒu荞
	from = &(pObj->prev_pos);

	// TOʒupӂ
	to = *pPos;

	// NbsOGAE
	if (to.px < pClip->x0) {
		to.px = pClip->x0;
		to.hx = to.px << 8;
	}
	if (to.px > pClip->x1) {
		to.px = pClip->x1;
		to.hx = to.px << 8;
	}
	// NbsOGAV䔻
	if (to.py < pClip->y0) {
		to.py = pClip->y0;
		to.hy = to.py << 8;
	}

	// Eړ悪ǂẌړ߂
	bgx = (((to.hx + pPos->vx) >> 8) >> 3);
	bgy = ((to.hy) >> 8) >> 3;
	if (bgx < 0) { bgx = 0; }
	if (bgy < 0) { bgy = 0; }
	if (bgx >= p_stage_context->bgmap_width) { bgx = p_stage_context->bgmap_width - 1; }
	if (bgy >= p_stage_context->bgmap_height) { bgy = p_stage_context->bgmap_height - 1; }
	att = GET_BG_ATTRIBUTE(0, bgx, bgy);
	if (BG_WALL_CONDITION(att)) {
		// ړ߂
		to.px = from->px;
		to.hx = from->hx;
	}

	// YɈړĔ
	if (pObj->pos.vy > 0) {
		move_grounding_ypos_single(from, &to, &groundingBbox, downstair, collision);
	}

	// ʒuAxAxm
	*pPos = to;
	pPos->vx = pPos->hx - pObj->prev_pos.hx;
	pPos->vy = pPos->hy - pObj->prev_pos.hy;

	// I
	return;
}


//--------------------------------------------------------------------
//	[  ]
//		void move_grounding_flying_simple(struct _CHROBJ* pObj, int downstair)
//
//	[  ]
//		CHAROBJ* pObj					Ώۂ̃IuWFNgւ̃|C^
//		int downstair					ɍ~Ƃ1AȊO0
//		GROUNDING_COLLISION* collision	ڐG茋ʂ̊i[
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		LN^ƏEVEǂƂ̐ڐGsALN^
//		ʒu␳܂B
//		move_grounding_bottom_single ̋ɉāA
//		Eړ̊ȑfǔ{ZNVV䔻s܂B
//--------------------------------------------------------------------
void move_grounding_flying_simple(struct _CHROBJ* pObj, int downstair, GROUNDING_COLLISION* collision)
{
	OBJPOS* pPos = &(pObj->pos);
	OBJPOS* from;
	OBJPOS to;
	int bgx, bgy;
	unsigned char att;
	BBOX* pClip = &(p_stage_context->stage_clipping_area);
	BBOX* pBBox = &(pObj->grd_bbox);

	// 茋ʂ
	memset(collision, 0, sizeof(GROUNDING_COLLISION));

	// FROMʒu荞
	from = &(pObj->prev_pos);

	// TOʒupӂ
	to = *pPos;

	// NbsOGAE
	if ((to.px + pBBox->x0) < pClip->x0) {
		to.px = pClip->x0 - pBBox->x0;	// x0͒ʏ핉̒l
		to.hx = to.px << 8;
	}
	if ((to.px + pBBox->x1) > pClip->x1) {
		to.px = pClip->x1 - pBBox->x1;	// x1͒ʏ퐳̒l
		to.hx = to.px << 8;
	}
	// NbsOGA㉺
	if ((to.py + pBBox->y0) < pClip->y0) {
		to.py = pClip->y0 - pBBox->y0;	// y0͒ʏ핉̒l
		to.hy = to.py << 8;
	}
	if ((to.py + pBBox->y1) > pClip->y1) {
		to.py = pClip->y1 - pBBox->y1;	// y1͒ʏ퐳̒l
		to.hy = to.py << 8;
	}

	// ړ悪ǂړ߂
	bgx = ((to.hx + pPos->vx) >> 8) >> 3;
	bgy = ((to.hy + pPos->vy) >> 8) >> 3;
	if (bgx < 0) { bgx = 0; }
	if (bgy < 0) { bgy = 0; }
	if (bgx >= p_stage_context->bgmap_width) { bgx = p_stage_context->bgmap_width - 1; }
	if (bgy >= p_stage_context->bgmap_height) { bgy = p_stage_context->bgmap_height - 1; }
	att = GET_BG_ATTRIBUTE(0, bgx, bgy);
	if (BG_WALL_CONDITION(att)) {
		// ȈՔ
		if (pPos->vx > 0) { collision->right = att; }
		if (pPos->vx < 0) { collision->left  = att; }
		if (pPos->vy > 0) { collision->bottom = att; }
		if (pPos->vy < 0) { collision->top = att; }

		// ړ߂
		to.px = from->px;
		to.hx = from->hx;
		to.py = from->py;
		to.hy = from->hy;
	}

	// ʒuAxAxm
	*pPos = to;
	pPos->vx = pPos->hx - pObj->prev_pos.hx;
	pPos->vy = pPos->hy - pObj->prev_pos.hy;

	// I
	return;
}

/*
//--------------------------------------------------------------------
//	[  ]
//		BBOX get_bbox_position(OBJPOS* pPos, BBOX* bbox)
//
//	[  ]
//		OBJPOS* pPos	IuWFNg̒SW
//		BBOX*   bbox	IuWFNgSW猩oEfBO{bNX
//
//	[ ߂l ]
//		oEfBO{bNXBBOX\
//
//	[  ]
//		LN^̃oEfBO{bNXgWnœ
//--------------------------------------------------------------------
BBOX get_bbox_position(OBJPOS* pPos, BBOX* bbox)
{
	BBOX bbox_position;

	bbox_position.x0 = pPos->hx + (bbox->x0 << 8);
	bbox_position.y0 = pPos->hy + (bbox->y0 << 8);
	bbox_position.x1 = pPos->hx + (bbox->x1 << 8);
	bbox_position.y1 = pPos->hy + (bbox->y1 << 8);

	return bbox_position;
}
*/

//--------------------------------------------------------------------
//	[  ]
//		void get_collision_bgs(OBJPOS* pPos, BBOX* bbox, BBOX* pTarget)
//
//	[  ]
//		OBJPOS* pPos	IuWFNg̒SW
//		BBOX*   bbox	IuWFNgSW猩oEfBO{bNX
//		BBOX*	pTarget	ʊi[
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		bbox_positionƐڐGBG͈̔͂pTargetɐݒ肵܂B
//--------------------------------------------------------------------
void get_collision_bgs(OBJPOS* pPos, BBOX* bbox, BBOX* pTarget)
{
	BBOX bbox_position;

	bbox_position.x0 = pPos->hx + (bbox->x0 << 8);
	bbox_position.y0 = pPos->hy + (bbox->y0 << 8);
	bbox_position.x1 = pPos->hx + (bbox->x1 << 8);
	bbox_position.y1 = pPos->hy + (bbox->y1 << 8);

	// ڐGĂBG͈̔͂𓾂
	pTarget->x0 = (bbox_position.x0 >> 8) >> 3;
	pTarget->y0 = (bbox_position.y0 >> 8) >> 3;
	pTarget->x1 = (bbox_position.x1 >> 8) >> 3;
	pTarget->y1 = (bbox_position.y1 >> 8) >> 3;

	// ʂԂ
	return;
}

//=============================================================================
// ڒn Xړ
//=============================================================================
void move_grounding_xpos(OBJPOS* pFrom, OBJPOS* pTo, BBOX* grd_bbox, GROUNDING_COLLISION* collision)
{
	//BBOX bbox_position;
	BBOX bg_collision;
	int checked;
	int bX, bY;
	int minDx;
	int pw_page;
	int w;
	minDx = 65535;
	pw_page = p_stage_context->pworld_page;	// p[h̃y[Wԍ

	// oEfBO{bNẌʒum肷B
	//bbox_position = get_bbox_position(pTo, grd_bbox);

	// ڐGĂBG͈̔͂𓾂
	get_collision_bgs(pTo, grd_bbox, &bg_collision);

	// BGp^[XLȂ珈
	checked = 0;
	w = (pTo->px - pFrom->px) >> 3;	// XL
	for (bY = bg_collision.y0; bY <= bg_collision.y1; bY++) {
		for (bX = bg_collision.x1 - w; bX <= bg_collision.x1; bX++) {
			int rightX, dX;
			int bgAttribute;
			bgAttribute = GET_BG_ATTRIBUTE(pw_page, bX, bY);
			if (!BG_WALL_CONDITION(bgAttribute)) {
				continue;
			}
			checked = 1;

			// L̉E[W͂
			rightX = ( bX << 3 ) -1;
			// ߂ʂZo
			dX = (((bX << 3) << 8) - 1) - (pTo->hx + (grd_bbox->x1 << 8));
			if (dX > 0) {
				// 
				continue;
			}
			minDx = (dX < minDx ? dX : minDx);
		}
	}

	// o
	if (checked != 0) {
		pTo->hx += minDx;
		pTo->px = pTo->hx >> 8;

		// EڐG
		collision->right = 1;
	}
	return;
}

//=============================================================================
// ڒn Xړ
//=============================================================================
void move_grounding_xneg(OBJPOS* pFrom, OBJPOS* pTo, BBOX* grd_bbox, GROUNDING_COLLISION* collision)
{
	//BBOX bbox_position;
	BBOX bg_collision;
	int checked;
	int bX, bY;
	int maxDx;
	int pw_page;
	int w;
	maxDx = -1;
	pw_page = p_stage_context->pworld_page;	// p[h̃y[Wԍ

	// oEfBO{bNẌʒum肷B
	//bbox_position = get_bbox_position(pTo, grd_bbox);

	// ڐGĂBG͈̔͂𓾂
	get_collision_bgs(pTo, grd_bbox, &bg_collision);

	// BGp^[XLȂ珈
	checked = 0;
	w = (pFrom->px - pTo->px) >> 3;	// XL
	for (bY = bg_collision.y0; bY <= bg_collision.y1; bY++) {
		for (bX = bg_collision.x0; bX <= bg_collision.x0 + w; bX++) {
			int leftX, dX;
			int bgAttribute;
			bgAttribute = GET_BG_ATTRIBUTE(pw_page, bX, bY);
			if (!BG_WALL_CONDITION(bgAttribute)) {
				continue;
			}
			checked = 1;

			// L̍[W͂
			leftX = (bX + 1) << 3;
			// ߂ʂZo
			dX = (((bX + 1) << 3)<<8) - (pTo->hx + (grd_bbox->x0 << 8));
			if (dX < 0) {
				// 
				continue;
			}
			maxDx = ( dX>maxDx ? dX : maxDx );
		}
	}

	// o
	if (checked != 0) {
		pTo->hx += maxDx;
		pTo->px = pTo->hx >> 8;

		// ڐG
		collision->left = 1;
	}
	return;
}

//=============================================================================
// ڒn Yړ
//=============================================================================
void move_grounding_ypos(OBJPOS* pFrom, OBJPOS* pTo, BBOX* grd_bbox, int downstair, GROUNDING_COLLISION* collision)
{
	//BBOX bbox_position;
	BBOX bg_collision;
	int checked;
	int bX, bY;
	int minDy;
	int pw_page;
	int h;
	minDy = 65535;
	pw_page = p_stage_context->pworld_page;	// p[h̃y[Wԍ

	// oEfBO{bNẌʒum肷B
	//bbox_position = get_bbox_position(pTo, grd_bbox);

	// ڐGĂBG͈̔͂𓾂
	get_collision_bgs(pTo, grd_bbox, &bg_collision);

	// ʏ폰
	checked = 0;
	{
		// BGp^[XLȂ珈
		h = (pTo->py - pFrom->py) >> 3;	// XL
		for (bY = bg_collision.y1 - h; bY <= bg_collision.y1; bY++) {
			for (bX = bg_collision.x0; bX <= bg_collision.x1; bX++) {
				int dY;
				int bgAttribute;
				bgAttribute = GET_BG_ATTRIBUTE(pw_page, bX, bY);
				if (!BG_WALL_CONDITION(bgAttribute)) {
					continue;
				}
				checked = bgAttribute;

				// ߂ʂZo
				dY = (((bY << 3) << 8) - 1) - (pTo->hy + (grd_bbox->y1 << 8));
				if (dY > 0) {
					// 
					continue;
				}
				minDy = (dY < minDy ? dY : minDy);
			}
		}
	}

	// F1sNZ̃C̏ʂʉ߂ۂŔ肷
	if (downstair == 0) {
		BBOX foot_bg_collision;

		// ̃CYړ͈͂`ŕ]
		BBOX bottomBox;
		bottomBox.x0 = pTo->hx + (grd_bbox->x0 << 8);
		bottomBox.y0 = pFrom->hy + (grd_bbox->y1 << 8);	// ړỎ[
		bottomBox.x1 = pTo->hx + (grd_bbox->x1 << 8);
		bottomBox.y1 = pTo->hy + (grd_bbox->y1 << 8);	// ړỎ[

		// ڐGĂBG͈̔͂𓾂
		foot_bg_collision.x0 = (bottomBox.x0 >> 8) >> 3;
		foot_bg_collision.y0 = (bottomBox.y0 >> 8) >> 3;
		foot_bg_collision.x1 = (bottomBox.x1 >> 8) >> 3;
		foot_bg_collision.y1 = (bottomBox.y1 >> 8) >> 3;

		// ڐG͈͂𓾂
		//foot_bg_collision = get_collision_bgs(&bottomBox);
		// 肵{bNX2sڈȍ~Ŕ肷B
		for (bY = foot_bg_collision.y0+1; bY <= foot_bg_collision.y1;bY++) {
			for (bX = foot_bg_collision.x0; bX <= foot_bg_collision.x1; bX++) {
				int dY;
				int attribute = GET_BG_ATTRIBUTE(pw_page, bX, bY);
				if (!BG_BOARD_CONDITION(attribute)) {
					// łȂΖ
					continue;
				}
				checked = attribute;

				// ߂ʂZo
				dY = (((bY << 3) << 8) - 1) - (pTo->hy + (grd_bbox->y1 << 8));
				if (dY > 0) {
					// 
					continue;
				}
				minDy = (dY < minDy ? dY : minDy);
			}
		}
	}

	// o
	if (checked != 0) {
		pTo->hy += minDy;
		pTo->py = pTo->hy >> 8;

		// ڐG
		collision->bottom = checked;
	}
	return;
}

//=============================================================================
// ڒn Yړ Ԃ牺蔻
//=============================================================================
void move_grounding_ypos_hook(OBJPOS* pFrom, OBJPOS* pTo, BBOX* grd_bbox, int downstair, GROUNDING_COLLISION* collision)
{
	//BBOX bbox_position;
	BBOX bg_collision;
	int checked;
	int bY;
	int minDy;
	int pw_page;
	int handOffset = 24;
	minDy = 65535;
	pw_page = p_stage_context->pworld_page;	// p[h̃y[Wԍ

	// ڐGĂBG͈̔͂𓾂
	get_collision_bgs(pTo, grd_bbox, &bg_collision);

	// Ԃ牺菰F1sNZ̃C̏ʂʉ߂ۂŔ肷
	checked = 0;
	if (downstair == 0) {
		BBOX hand_bg_collision;

		// [̃CYړ͈͂`ŕ]
		BBOX handBox;
		handBox.x0 = pTo->hx;	// LS1_Ŕ
		handBox.x1 = pTo->hx;
		handBox.y0 = pFrom->hy - (handOffset << 8);	// ړỎ[
		handBox.y1 = pTo->hy - (handOffset << 8);	// ړỎ[

		// ڐGĂBG͈̔͂𓾂
		hand_bg_collision.x0 = (handBox.x0 >> 8) >> 3;
		hand_bg_collision.x1 = (handBox.x1 >> 8) >> 3;
		hand_bg_collision.y0 = (handBox.y0 >> 8) >> 3;
		hand_bg_collision.y1 = (handBox.y1 >> 8) >> 3;
		if (hand_bg_collision.y0 < 0) {
			hand_bg_collision.y0 = 0;
		}
		if (hand_bg_collision.y1 < 0) {
			hand_bg_collision.y1 = 0;
		}

		// ڐG͈͂𓾂
		//foot_bg_collision = get_collision_bgs(&bottomBox);
		// 肵{bNX2sڈȍ~Ŕ肷B
		for (bY = hand_bg_collision.y0 + 1; bY <= hand_bg_collision.y1; bY++) {
			int dY;
			int attribute = GET_BG_ATTRIBUTE(pw_page, hand_bg_collision.x0, bY);
			if (!BG_HOOK_CONDITION(attribute)) {
				// Ԃ牺菰łȂΖ
				continue;
			}
			checked = 1;

			// ߂ʂZo
			dY = (((bY << 3) << 8) - 1) - (pTo->hy - (handOffset << 8));
			if (dY > 0) {
				// 
				continue;
			}
			minDy = (dY < minDy ? dY : minDy);
		}
	}

	// o
	if (checked != 0) {
		pTo->hy += minDy;
		pTo->py = pTo->hy >> 8;

		// ڐG
		collision->hook = 1;
	}
	return;
}

//=============================================================================
// ڒn Yړ P_ȑf
//=============================================================================
void move_grounding_ypos_single(OBJPOS* pFrom, OBJPOS* pTo, BBOX* grd_bbox, int downstair, GROUNDING_COLLISION* collision)
{
	//BBOX bbox_position;
	//BBOX bg_collision;
	int bgcol_x, bgcol_y;
	int checked;
	int bY;
	int minDy;
	int pw_page;
	int h, sY;
	int minY, maxY;
	minDy = 65535;
	pw_page = p_stage_context->pworld_page;	// p[h̃y[Wԍ

	// oEfBO{bNẌʒum肷B
	//bbox_position = get_bbox_position(pTo, grd_bbox);

	// ڐGĂBG͈̔͂𓾂
	//get_collision_bgs(pTo, grd_bbox, &bg_collision);
	// ڐGĂBG̃ubNʒu𓾂
	bgcol_x = pTo->px >> 3;
	bgcol_y = ( pTo->py + grd_bbox->y1 )  >> 3;

	// ʏ폰E
	// BGp^[XLȂ珈
	checked = 0;
	h = (pTo->py - pFrom->py) >> 3;	// XL
	sY = bgcol_y - h;
	if (sY < 0) { sY = 0; }
	
	minY = max(sY, 0);	// sŶƂ̃NbsO
	maxY = min(bgcol_y, def_stage_bg_size[p_stage_context->stage - 1][1] - 1);	// bgcol_y͈͊OɂȂȂ悤ɃNbsO
	for (bY = minY; bY <= maxY; bY++) {
		int dY;
		int bgAttribute;
		bgAttribute = GET_BG_ATTRIBUTE(pw_page, bgcol_x, bY);
		if (!BG_STEP_CONDITION(bgAttribute)) {
			continue;
		}
		if ((downstair != 0) && (BG_BOARD_CONDITION(bgAttribute))) {
			// ~郂[VŔȂ~
			continue;
		}
		checked = 1;

		// ߂ʂZo
		dY = (((bY << 3) << 8) - 1) - (pTo->hy + (grd_bbox->y1 << 8));
		if (dY > 0) {
			// 
			continue;
		}
		minDy = (dY < minDy ? dY : minDy);
	}

	// o
	if (checked != 0) {
		pTo->hy += minDy;
		pTo->py = pTo->hy >> 8;

		// ڐG
		collision->bottom = 1;
	}
	return;
}

//=============================================================================
// ڒn Yړ
//=============================================================================
void move_grounding_yneg(OBJPOS* pFrom, OBJPOS* pTo, BBOX* grd_bbox, GROUNDING_COLLISION* collision)
{
	//BBOX bbox_position;
	BBOX bg_collision;
	int checked;
	int bX, bY;
	int maxDy;
	int pw_page;
	int h;
	maxDy = -1;
	pw_page = p_stage_context->pworld_page;	// p[h̃y[Wԍ

	// oEfBO{bNẌʒum肷B
	//bbox_position = get_bbox_position(pTo, grd_bbox);

	// ڐGĂBG͈̔͂𓾂
	get_collision_bgs(pTo, grd_bbox, &bg_collision);

	// BGp^[XLȂ珈
	checked = 0;
	h = (pFrom->py - pTo->py) >> 3;	// XL
	for (bY = bg_collision.y0; bY <= bg_collision.y0 + h; bY++) {
		for (bX = bg_collision.x0; bX <= bg_collision.x1; bX++) {
			int topY, dY;
			int bgAttribute;
			bgAttribute = GET_BG_ATTRIBUTE(pw_page, bX, bY);
			if (!BG_WALL_CONDITION(bgAttribute)) {
				continue;
			}
			checked = 1;

			// L̍[W͂
			topY = (bY + 1) << 3;
			// ߂ʂZo
			dY = (((bY + 1) << 3) << 8) - (pTo->hy + (grd_bbox->y0 << 8));
			if (dY < 0) {
				// 
				continue;
			}
			maxDy = (dY > maxDy ? dY : maxDy);
		}
	}

	// o
	if (checked != 0) {
		pTo->hy += maxDy;
		pTo->py = pTo->hy >> 8;

		// 㑤ڐG
		collision->top = 1;
	}
	return;
}

//=============================================================================
// ڒn [hŜ̃NbsO
//=============================================================================
void move_grounding_stage_area(OBJPOS* pTo, BBOX* grd_bbox, GROUNDING_COLLISION* collision)
{
	BBOX area;
	area.x0 = p_stage_context->stage_clipping_area.x0 - grd_bbox->x0;
	area.x1 = p_stage_context->stage_clipping_area.x1 - grd_bbox->x1;
	area.y0 = p_stage_context->stage_clipping_area.y0 - grd_bbox->y0;
	area.y1 = p_stage_context->stage_clipping_area.y1 - grd_bbox->y1;
	if (pTo->px < area.x0) {
		pTo->px = area.x0;
		pTo->hx = pTo->px << 8;

		// ڐG
		collision->left = 1;
	}
	if (pTo->px > area.x1) {
		pTo->px = area.x1;
		pTo->hx = pTo->px << 8;

		// EڐG
		collision->right = 1;
	}
	if (pTo->py < area.y0) {
		pTo->py = area.y0;
		pTo->hy = pTo->py << 8;

		// 㑤ڐG
		collision->top = 1;
	}
	if (pTo->py > area.y1) {
		pTo->py = area.y1;
		pTo->hy = pTo->py << 8;

		// ڐG
		collision->bottom = 1;
	}
	return;
}


//=============================================================================
// {̉Z
//=============================================================================
//--------------------------------------------------------------------
//	[  ]
//		void add_digit(int* target, int target_digits, int digit, int value)
//
//	[  ]
//		int* target			Ώۂ̑{z
//		int target_digits	{̌B10̏ꍇɂ10wB
// 		int digit			̃CfbNXԍ 1̈ʂ0
//		int value			ZlB0`9łȂ΂ȂȂ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		{ target ɂāAdigitŎw肵ʂ value 
//		Z
//--------------------------------------------------------------------
void add_digit(int* target, int target_digits, int digit, int value)
{
	int i;

	// Z
	target[digit] += value;	// ɒl𑫂
	if (target[digit] > 9) {
		// オ菈B0`9̉ZȂ̂ŁAǨɂ1Jオ
		target[digit] -= 10;
		if ((digit + 1) < target_digits) {
			// ̌1ZċNĂяo
			add_digit(target, target_digits, digit + 1, 1);
		}
		else {
			// ŏʌȂJEgXgbv
			for (i = 0; i < target_digits; i++) {
				target[i] = 9;
			}
		}
	}
}

//--------------------------------------------------------------------
//	[  ]
//		void add_digit_def(int* target, int target_digits, int* score_def)
//
//	[  ]
//		int* target			Ώۂ̑{z
//		int target_digits	{̌B10̏ꍇɂ10wB
//		int* score_def		ZXRA̒`̔zB
//							[G][{(log2X)][w茅, index, l]
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		{ target ɂāAdigitŎw肵ʂ value 
//		Z
//--------------------------------------------------------------------
void add_digit_def(int* target, int target_digits, int* score_def)
{
	int i;
	int digit, value;
	int index = 1;

	// z
	for (i = 0; i < score_def[0]; i++) {
		digit = score_def[index++];
		value = score_def[index++];
		add_digit(target, target_digits, digit, value);
	}
}


//--------------------------------------------------------------------
//	[  ]
//		int sub_digit(int* target, int target_digits, int digit, int value)
//
//	[  ]
//		int* target			Ώۂ̑{z
//		int target_digits	{̌B10̏ꍇɂ10wB
// 		int digit			̃CfbNXԍ 1̈ʂ0
//		int value			ZlB0`9łȂ΂ȂȂ
//
//	[ ߂l ]
//		0 : Z
//		-1 : ZłȂiZ悤Ƃĕ̒lɂȂꍇj
//
//	[  ]
//		{ target ɂāAdigitŎw肵ʂ value 
//		Z܂BZłȂꍇɂ-1Ԃ܂B
//--------------------------------------------------------------------
int sub_digit(int* target, int target_digits, int digit, int value)
{
	int res;

	// 傫疳
	if (digit >= target_digits) {
		return -1;
	}

	// J艺
	if (target[digit] < value) {
		// J艺肪KvȂA܂J艺
		res = sub_digit(target, target_digits, digit + 1, 1);
		if (res != 0) {
			// J艺łȂ
			return -1;
		}
		target[digit] = 10;
	}

	// Z
	target[digit] -= value;
	return 0;
}


//=============================================================================
// {intɕϊidj
//=============================================================================
int digits_get_int(int* target, int target_digits)
{
	int i;
	int result = 0;
	int base = 1;

	for (i = 0; i < target_digits; i++) {
		result += (base * target[i]);
		base *= 10;
	}

	return result;
}

//=============================================================================
// int𑽔{ɐݒidj
//=============================================================================
void digits_set_int(int value, int* target, int target_digits)
{
	int i;
	int d;

	memset(target, 0, sizeof(int) * target_digits);

	for (i = 0; i < target_digits; i++) {
		d = value % 10;
		value /= 10;
		target[i] = d;
	}
}


//--------------------------------------------------------------------
//	[  ]
//		void draw_digits(int value, int px, int py)
//
//	[  ]
//		int value		`悷鐔
//		int px			XW
//		int py			YW
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		(px, py)̈ʒudigit̐valueSPŕ`悵܂Bidj
//		(px, py)ɂ́A1̌̉Eʒuw肵܂B
//--------------------------------------------------------------------
void draw_digits(int value, int px, int py)
{
	int force = 1;	// 1ڋ`̃tO
	int x, d;
	SP_UNIT* pSpUnit;

	// SP̐擪I
	int sp_code_top = p_stage_context->cmn_sp_top;

	x = px;
	while((value!=0) || (force)) {
		// SP̐ςȂA܂
		if (p_stage_objects->sp_index_seq >= 128) {
			return;
		}
		// ̒l𓾂
		if ((value == 0) && (force == 0)) { return; }
		d = value % 10;
		value /= 10;
		force = 0;

		// SPjbg𓾂
		pSpUnit = &(p_memory_map_buffer->sp_unit[p_stage_objects->sp_index_seq++]);

		// `悷
		SP_SET(pSpUnit, x, py , sp_code_top + 0x06 + d, 5, 0, 0, 3);
		x -= 8;
	}
}


//--------------------------------------------------------------------
//	[  ]
//		void draw_digits_bigint(int value, int max_digits, int px, int py, int sp_code_zero, int pal, int width, int force_full)
//
//	[  ]
//		int value			{zւ̃|C^
//		int max_digits		ž
//		int px				Xʒu
//		int py				Yʒu
//		int sp_code_zero	0SPR[hԍ
//		int pal				pbgubN
//		int width			1̕
//		int force_full		S\
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		(px, py)̈ʒuɑ{`悵܂B
//		(px, py)ɂ́A1̌̉Eʒuw肵܂B
//--------------------------------------------------------------------
void draw_digits_bigint(int* value, int max_digits, int px, int py, int sp_code_zero, int pal, int width, int force_full)
{
	int i, x;
	int digits;
	int allocsp;
	SP_UNIT* sp;
	int* pVal;

	// v
	digits = max_digits;
	if (force_full == 0) {
		pVal = value + max_digits - 1;
		for (i = 0; i < (max_digits - 1); i++) {
			if (*pVal != 0) {
				// 0ȊO炻Ŏ~߂
				break;
			}
			// ЂƂ炷
			pVal--;
			digits -= 1;
		}
	}

	// `
	x = px;
	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;
	pVal = value;	// 1̌ɂ킹
	for (i = 0; i < digits; i++) {
		// \
		allocsp = sp_alloc_index(1);
		if (allocsp == 0) { break; }
		SP_SET(sp, x, py, sp_code_zero + (*pVal), pal, 0, 0, 3);
		sp++;
		pVal += 1;	// ̌

		// ʒu炷
		x -= width;
	}
}

//--------------------------------------------------------------------
//	[  ]
//		void play_se(SE_ITEM* pSE)
//
//	[  ]
//		SE_ITEM* pSE	SȄi[\̂ւ̃|C^
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		wSEĐ܂
//--------------------------------------------------------------------
void play_se(SE_ITEM* pItem)
{
	int do_play = 0;
	
	// Đ֎~
	if (p_game_properties->disable_sound == 1) {
		return;
	}
	// LɂȂĂȂ΍ĐȂ
	if(pItem->valid==0) {
		return;
	}

	// Dxł̑҂
	if (
		(pItem->same_priority_wait == 1)	// Đ҂̃ACeł
		&& (pItem->priority == p_sound_context->se_play_priority)	// ߍĐ̂ACe(priority)ł
		&& (p_sound_context->se_play_timeout != 0)	// ҂ĂȂ
		 ) {
		// ̂ŁȀꍇ͍ĐȂ
		return;
	}

	// XVIȏ̃XybN邩AĐtimeoutԂȂɍĐOK
	if ((p_game_properties->XVI) || (p_sound_context->se_play_timeout==0)) {
		sound_play_se(pItem->index, pItem->x68frq);
		p_sound_context->se_play_priority = pItem->priority;
		p_sound_context->se_play_timeout = pItem->frames;
		return;
	}
	
	// ĐDx΍Đ
	do_play = 0;
	if (pItem->priority <= p_sound_context->se_play_priority) {
		do_play = 1;
	}

	// Đ
	if(do_play) {
		// DxȂ̂ōĐJn
		sound_play_se(pItem->index, pItem->x68frq);
		p_sound_context->se_play_priority = pItem->priority;
		p_sound_context->se_play_timeout = pItem->frames;
	}
}


//--------------------------------------------------------------------
//	[  ]
//		void save_all_clear_log_file(char* path)
//
//	[  ]
//		char* path	o͐pX
//		void* pTim	litime_t^ւ̃|C^j
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		SNAOo͂
//--------------------------------------------------------------------
void save_all_clear_log_file(char* path, void* pTim)
{
	int i;
	int start_digit;
	FILE* fn;
	struct tm* tm;

	// Ƃ
	tm = localtime((time_t*)pTim);

	// <<< t@CJ >>>
	fn = fopen(path, "wt");
	if (fn == NULL) {
		// t@CJȂ
		return;
	}

	// <<< t@Cɏ >>>
	// o[Wԍ
	fprintf(fn, "Version : "VERSION_INFO_F"\n", VERSION_0, VERSION_1, VERSION_2);
	fprintf(fn, "--------------------------------------------------\n");

	// 
	fprintf(fn, "TIME STAMP   : %04d/%02d/%02d %02d:%02d:%02d\n",
		tm->tm_year + 1900, tm->tm_mon + 1, tm->tm_mday,
		tm->tm_hour, tm->tm_min, tm->tm_sec);

	// XRA
	fprintf(fn, "SCORE        : ");
	if (force_zero_all_clear_score() == 0) {
		start_digit = 0;
		for (i = SCORE_DIGITS - 1; i > 0; i--) {
			if (p_application_context->score[i] != 0) {
				start_digit = i;
				break;
			}
		}
		for (i = start_digit; i >= 0; i--) {
			fprintf(fn, "%d", p_application_context->score[i]);
		}
	}
	else {
		fprintf(fn, "0 (Debug option was set)");
	}
	fprintf(fn, "\n");

	// ReBj[
	fprintf(fn, "CONTINUED    : %d\n", p_application_context->cont);

	// Q[x
	fprintf(fn, "LEVEL        : ");
	switch (p_game_properties->game_level) {
	case 0:
		fprintf(fn, "EASY");
		break;
	case 1:
		fprintf(fn, "NOVICE");
		break;
	case 2:
		fprintf(fn, "NORMAL");
		break;
	case 3:
		fprintf(fn, "HARD");
		break;
	default:
		fprintf(fn, "unknown");
		break;
	}
	fprintf(fn, "\n");

	// Ct
	fprintf(fn, "INITIAL LIFE : %d\n", p_game_properties->life);

	// Message
	fprintf(fn, "--------------------------------------------------\n");
	fprintf(fn, "Thank you for your playing.\n");
	fprintf(fn, "Presented by Team MUGEN Unagi 2025.\n");
	fprintf(fn, "񂱂.\n");

	// <<< t@C >>>
	fclose(fn);
}

//==============================================================
// XRAOL^ƂɁAIvVwŋ
// ꍇ̓XRA 0 ɂ
//==============================================================
int force_zero_all_clear_score()
{
	int result = 0;
	
	// fobOp̃IvVw肪ꍇɃXRA𖳌ɂ
	if (
		(startup_param.start_stage_specified != 0)
		|| (startup_param.start_lv >= 1)
		) {
		result = 1;
	}
	return result;
}