#define __COLLISION_C__
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "constants.h"
#include "kon_util.h"
#include "game_context.h"
#include "structs.h"
#include "game_context.h"
#include "common.h"
#include "collision.h"
#include "explode.h"
#include "enemy.h"

// -----< 萔` >-----
//
#define MAGIC_HITAREA_CHARGE  (30)
#define MAGIC_HITAREA_SHOT    (60)
int jiki_dash_ap[] = JIKI_DASH_AP;	// _bV̍U

// -----< vg^Cv錾 >-----
//
// BGbV
int get_bgmesh_area(CHROBJ* pObj, BBOX* result_bbox);	// IuWFNgBGbV̈ʒu𓾂

// 蔻֘AFUn
void collision_blade_enemy();
void collision_subweapon_enemy(SUBWEAPON* pSubWeapon);
void collision_jiki_enemy_eneshot();
void collision_magic_enemy_eneshot();
// 蔻֘AF_[Wn
void collision_enemy_jiki();
void collision_eneshot_jiki();

//--------------------------------------------------------------------
//	[  ]
//		int collision_check()
//
//	[  ]
//		Ȃ
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		蔻菈s܂
//--------------------------------------------------------------------
void collision_check()
{
	SUBWEAPON* sub_weapon;

	// -----< 蔻iUnj >-----
	//
	// GƍU
	collision_blade_enemy();

	// GƃTuVbg
	sub_weapon = p_stage_objects->subweapon_top;
	while (sub_weapon != NULL) {
		if (sub_weapon->obj.status != status_absent) {
			collision_subweapon_enemy(sub_weapon);
		}
		sub_weapon = sub_weapon->p_next;
	}

	// @ƓGCGe
	collision_magic_enemy_eneshot();

	// LƓGi_bVUj
	collision_jiki_enemy_eneshot();

	// -----< 蔻i_[Wnj >-----
	//
	// GƎL
	collision_enemy_jiki();

	// GeƎL
	collision_eneshot_jiki();

	// -----< 蔻iACej >-----
	//
	collision_jiki_item();
	return;
}


//=============================================================================
// 蔻FBGbV̏Ԃ
//=============================================================================
void collision_clear_bgmesh()
{
	BGMESH* pMesh = &(p_stage_objects->bgmesh);

	// <<< o^JEg >>>
	memset(pMesh->bgmesh_count_enemy, 0, sizeof(pMesh->bgmesh_count_enemy));
	memset(pMesh->bgmesh_count_eneshot, 0, sizeof(pMesh->bgmesh_count_eneshot));
	memset(pMesh->bgmesh_count_item, 0, sizeof(pMesh->bgmesh_count_item));
}


//=============================================================================
// 蔻Fw肵ENEMYBGMESHɔzu
//=============================================================================
int collision_put_bgmesh_enemy(CHROBJ* pObject)
{
	BGMESH* pMesh = &(p_stage_objects->bgmesh);
	BBOX obj_bbox;
	int bbox_result;
	int x, y, cnt;

	// LN^dȂBGbV͈̔͂𓾂
	bbox_result = get_bgmesh_area(pObject, &obj_bbox);
	if (bbox_result != 0) {
		pObject->out_of_screen = 1;
		return bbox_result;
	}

	// BGbVɃCfbNXԍzu
	for (y = obj_bbox.y0; y <= obj_bbox.y1; y++) {
		for (x = obj_bbox.x0; x <= obj_bbox.x1; x++) {
			cnt = pMesh->bgmesh_count_enemy[y][x];
			pMesh->bgmesh_enemy[y][x][cnt] = pObject->array_index;
			pMesh->bgmesh_count_enemy[y][x]++;
		}
	}

	// zu
	pObject->out_of_screen = 0;
	return 0;
}


//=============================================================================
// 蔻Fw肵ENESHOTBGMESHɔzu
//=============================================================================
int collision_put_bgmesh_eneshot(CHROBJ* pObject)
{
	BGMESH* pMesh = &(p_stage_objects->bgmesh);
	BBOX obj_bbox;
	int bbox_result;
	int x, y, cnt;

	// LN^dȂBGbV͈̔͂𓾂
	bbox_result = get_bgmesh_area(pObject, &obj_bbox);
	if (bbox_result != 0) {
		pObject->out_of_screen = 1;
		return bbox_result;
	}

	// BGbVɃCfbNXԍzu
	for (y = obj_bbox.y0; y <= obj_bbox.y1; y++) {
		for (x = obj_bbox.x0; x <= obj_bbox.x1; x++) {
			cnt = pMesh->bgmesh_count_eneshot[y][x];
			pMesh->bgmesh_eneshot[y][x][cnt] = pObject->array_index;
			pMesh->bgmesh_count_eneshot[y][x]++;
		}
	}

	// zu
	pObject->out_of_screen = 0;
	return 0;
}


//=============================================================================
// 蔻Fw肵ITEMBGMESHɔzu
//=============================================================================
int collision_put_bgmesh_item(CHROBJ* pObject)
{
	BGMESH* pMesh = &(p_stage_objects->bgmesh);
	BBOX obj_bbox;
	int bbox_result;
	int x, y, cnt;

	// LN^dȂBGbV͈̔͂𓾂
	bbox_result = get_bgmesh_area(pObject, &obj_bbox);
	if (bbox_result != 0) {
		pObject->out_of_screen = 1;
		return bbox_result;
	}

	// BGbVɃCfbNXԍzu
	for (y = obj_bbox.y0; y <= obj_bbox.y1; y++) {
		for (x = obj_bbox.x0; x <= obj_bbox.x1; x++) {
			cnt = pMesh->bgmesh_count_item[y][x];
			pMesh->bgmesh_item[y][x][cnt] = pObject->array_index;
			pMesh->bgmesh_count_item[y][x]++;
		}
	}

	// zu
	pObject->out_of_screen = 0;
	return 0;
}

//--------------------------------------------------------------------
//	[  ]
//		int get_bgmesh_area(CHROBJ* pObj, BBOX* result_bbox)
//
//	[  ]
//		CHROBJ* pObj			肷IuWFNgւ̃|C^
//		BBOX* result_bbox		ʊi[ւ̃|C^
//
//	[ ߂l ]
//		F0
//		͈͊OF-1
//
//	[  ]
//		IuWFNgBGMesh͈̔͂𓾂
//--------------------------------------------------------------------
int get_bgmesh_area(CHROBJ* pObj, BBOX* result_bbox)
{
	int px, py;
	BBOX* pBBox = &(pObj->hit_bbox);
	OBJPOS* pPos = &(pObj->pos);

	// LN^̃XN[W𓾂
	px = (pPos->hx - p_stage_context->bgview_hx) >> 8;
	py = (pPos->hy - p_stage_context->bgview_hy) >> 8;

	// BBOX̎lBGMesh̃P[V𓾂
	result_bbox->x0 = (px + pBBox->x0) >> 6;	// 64i256/4jŊ
	result_bbox->x1 = (px + pBBox->x1) >> 6;
	result_bbox->y0 = (py + pBBox->y0) >> 6;
	result_bbox->y1 = (py + pBBox->y1) >> 6;
	if ((result_bbox->x1 < 0) || (result_bbox->x0 >= BGMESH_SIZE)
		|| (result_bbox->y1 < 0) || (result_bbox->y0 >= BGMESH_SIZE)) {
		// gOȂ0ȊO
		return -1;
	}

	// NbsO
	if (result_bbox->x0 < 0) { result_bbox->x0 = 0; }
	if (result_bbox->y0 < 0) { result_bbox->y0 = 0; }
	if (result_bbox->x1 >= BGMESH_SIZE) { result_bbox->x1 = (BGMESH_SIZE-1); }
	if (result_bbox->y1 >= BGMESH_SIZE) { result_bbox->y1 = (BGMESH_SIZE-1); }

	// ʂԂ
	return 0;
}

//--------------------------------------------------------------------
//	[  ]
//		int collision_objects(CHROBJ* obj1, CHROBJ* obj2)
//
//	[  ]
//		CHROBJ* obj1			肷IuWFNgւ̃|C^1
//		CHROBJ* obj2			肷IuWFNgւ̃|C^2
//
//	[ ߂l ]
//		qbgF1
//		͂F0
//
//	[  ]
//		IuWFNgm̓蔻sAqbĝƂ1Ԃ܂B
//		IuWFNghit_bboxɂāAx0<x1, y0<y1ł邱Ƃ
//		OƂĂ܂B
//--------------------------------------------------------------------
int collision_objects(CHROBJ* obj1, CHROBJ* obj2)
{
	BBOX* bbox1;
	BBOX* bbox2;
	int px1, py1;
	int px2, py2;
	int dx, dy;
	int distx, disty;

	// bboxV[gJbg
	bbox1 = &(obj1->hit_bbox);
	bbox2 = &(obj2->hit_bbox);

	// obj1, obj2̃oEfBO{bNX̒S𓾂
	px1 = obj1->pos.px + ((bbox1->x0 + bbox1->x1) >> 1);
	py1 = obj1->pos.py + ((bbox1->y0 + bbox1->y1) >> 1);
	px2 = obj2->pos.px + ((bbox2->x0 + bbox2->x1) >> 1);
	py2 = obj2->pos.py + ((bbox2->y0 + bbox2->y1) >> 1);

	// 苗𓾂
	distx = ((bbox1->x1 - bbox1->x0) + (bbox2->x1 - bbox2->x0)) >> 1;
	disty = ((bbox1->y1 - bbox1->y0) + (bbox2->y1 - bbox2->y0)) >> 1;

	// obj2Ƃ̋𑪂Ĕ
	dx = abs(px1 - px2);
	dy = abs(py1 - py2);
	if ((dx > distx) || (dy > disty)) {
		// O
		return 0;
	}
	// 
	return 1;
}


//=============================================================================
// 蔻Fu[hƓG
//=============================================================================
void collision_blade_enemy()
{
	int i;
	BGMESH* bgmesh = &(p_stage_objects->bgmesh);
	//
	BLADE* pBlade;
	CHROBJ* pBladeObj;
	BBOX blade_bbox;
	int bbox_result;
	//
	ENEMY* pEnemy;
	CHROBJ* pEneObj;
	int x, y;

	pBlade = &(p_stage_objects->blade);
	pBladeObj = &(pBlade->obj);

	// u[hoĂȂ疳
	if (pBladeObj->status == status_absent) {
		return;
	}

	// u[h͈̔͂𓾂
	bbox_result = get_bgmesh_area(pBladeObj, &blade_bbox);
	if (bbox_result != 0) {
		// u[h͈͊OȂ̂Ŗ
		return;
	}

	// GƂ̓蔻FσtO
	memset(bgmesh->processed_enemy, 0, sizeof(bgmesh->processed_enemy));
	// GƂ̓蔻
	for (y = blade_bbox.y0; y <= blade_bbox.y1; y++) {
		for (x = blade_bbox.x0; x <= blade_bbox.x1; x++) {
			for (i = 0; i < bgmesh->bgmesh_count_enemy[y][x];i++) {
				// CfbNX𓾂
				unsigned char idx = bgmesh->bgmesh_enemy[y][x][i];
				if (bgmesh->processed_enemy[idx]) {
					// ςȂ玟
					continue;
				}
				pEnemy = &(p_stage_objects->enemy[idx]);
				pEneObj = &(pEnemy->obj);
				if (pEneObj->status == status_absent) {
					// oĂȂ玟
					continue;
				}

				// 蔻
				if (collision_objects(pEneObj, pBladeObj) == 0) {
					// ͂
					continue;
				}

				// qbg̏
				pEneObj->on_hit(hittype_blade, pEnemy, pBladeObj, pBlade->ap);

				// ς݂𗧂ĂĎ
				bgmesh->processed_enemy[idx] = 1;
			}
		}
	}
	return;
}


//=============================================================================
// 蔻FTuEF|ƓG
//=============================================================================
void collision_subweapon_enemy(SUBWEAPON* pSub)
{
	int i;
	//
	BGMESH* bgmesh = &(p_stage_objects->bgmesh);
	BBOX subshot_bbox;
	int bbox_result;
	int x, y;
	//
	ENEMY* pEnemy;
	CHROBJ* pEneObj;

	// ̈𓾂
	bbox_result = get_bgmesh_area(&(pSub->obj), &subshot_bbox);
	if (bbox_result != 0) {
		// NbsOŉʊOȂ疳
		return;
	}

	// GƂ̓蔻
	memset(bgmesh->processed_enemy, 0, sizeof(bgmesh->processed_enemy));
	for(y=subshot_bbox.y0;y<=subshot_bbox.y1;y++) {
		for (x = subshot_bbox.x0; x <= subshot_bbox.x1; x++) {
			for (i = 0; i < bgmesh->bgmesh_count_enemy[y][x]; i++) {
				unsigned char idx = bgmesh->bgmesh_enemy[y][x][i];
				if (bgmesh->processed_enemy[idx] != 0) {
					// ς݂Ȃ玟
					continue;
				}
				pEnemy = &(p_stage_objects->enemy[idx]);
				pEneObj = &(pEnemy->obj);
				if (pEneObj->status == status_absent) {
					// oĂȂ玟
					continue;
				}

				// 蔻
				if (collision_objects(pEneObj, &(pSub->obj)) == 0){
					// ͂
					continue;
				}

				// qbg
				pEneObj->on_hit(pSub->hittype, pEnemy, &(pSub->obj), pSub->ap);

				// ς݂}[N
				bgmesh->processed_enemy[idx] = 1;
			}
		}
	}
	return;
}

//=============================================================================
// 蔻F@ƓGCGe
//=============================================================================
void collision_magic_enemy_eneshot()
{
	int i;
	MAGIC* pMagic;
	CHROBJ* pObj;
	//
	BGMESH* bgmesh = &(p_stage_objects->bgmesh);
	BBOX magic_bbox;
	int bbox_result;
	int x, y;
	//
	ENEMY* pEnemy;
	CHROBJ* pEneObj;
	ENESHOT* pEneShot;
	CHROBJ* pEneShotObj;
	HitType hittype;
	int magic_ap;
	int hit_exists;

	pMagic = &(p_stage_objects->magic);
	pObj = &(pMagic->obj);
	magic_ap = pMagic->ap;

	// `[WE@łȂΖ
	if (   (pObj->status != status_charge)
		&& (pObj->status != status_on_magic)
		&& (pObj->status != status_on_return)) {
		return;
	}
	hittype = (pObj->status == status_charge ? hittype_charge : hittype_magic);

	// ԂɂĔ͈͂߂
	if (pObj->status == status_charge) {
		pObj->hit_bbox.x0 = -MAGIC_HITAREA_CHARGE;
		pObj->hit_bbox.x1 = +MAGIC_HITAREA_CHARGE;
		pObj->hit_bbox.y0 = -MAGIC_HITAREA_CHARGE;
		pObj->hit_bbox.y1 = +MAGIC_HITAREA_CHARGE;
		// ԂɂčU͂Ⴄ
		magic_ap = MAGIC_SHAVE_AP;
	}
	if ((pObj->status == status_on_magic) || (pObj->status == status_on_return)) {
		pObj->hit_bbox.x0 = -MAGIC_HITAREA_SHOT;
		pObj->hit_bbox.x1 = +MAGIC_HITAREA_SHOT;
		pObj->hit_bbox.y0 = -MAGIC_HITAREA_SHOT;
		pObj->hit_bbox.y1 = +MAGIC_HITAREA_SHOT;
		// ԂɂčU͂Ⴄ
		magic_ap = pMagic->ap;
	}

	// ̈𓾂
	bbox_result = get_bgmesh_area(pObj, &magic_bbox);
	if (bbox_result != 0) {
		// NbsOŉʊOȂ疳
		return;
	}

	// GƂ̓蔻
	memset(bgmesh->processed_enemy, 0, sizeof(bgmesh->processed_enemy));
	// GƂ̓蔻
	hit_exists = 0;
	for (y = magic_bbox.y0; y <= magic_bbox.y1; y++) {
		for (x = magic_bbox.x0; x <= magic_bbox.x1; x++) {
			for (i = 0; i < bgmesh->bgmesh_count_enemy[y][x]; i++) {
				// CfbNX𓾂
				unsigned char idx = bgmesh->bgmesh_enemy[y][x][i];
				if (bgmesh->processed_enemy[idx]) {
					// ςȂ玟
					continue;
				}
				pEnemy = &(p_stage_objects->enemy[idx]);
				pEneObj = &(pEnemy->obj);
				if (pEneObj->status == status_absent) {
					// oĂȂ玟
					continue;
				}

				// 蔻
				if (collision_objects(pEneObj, pObj) == 0) {
					// ͂
					continue;
				}

				// qbg
				pEneObj->on_hit(hittype, pEnemy, &(pMagic->obj), magic_ap);
				hit_exists = 1;
			}
		}
	}
	// qbgXgbv
	if (hit_exists) {
		if ((pObj->hit_stop_ready) && (pObj->status != status_charge)) {
			p_stage_objects->hit_stop = 1;
			pObj->hit_stop_ready = 0;
			play_se(&(p_sound_context->se_item[setype_dashhit]));
		}
	}

	// GeƂ̓蔻
	memset(bgmesh->processed_eneshot, 0, sizeof(bgmesh->processed_eneshot));
	// GeƂ̓蔻
	for (y = magic_bbox.y0; y <= magic_bbox.y1; y++) {
		for (x = magic_bbox.x0; x <= magic_bbox.x1; x++) {
			for (i = 0; i < bgmesh->bgmesh_count_eneshot[y][x]; i++) {
				// CfbNX𓾂
				unsigned char idx = bgmesh->bgmesh_eneshot[y][x][i];
				if (bgmesh->processed_eneshot[idx]) {
					// ςȂ玟
					continue;
				}
				pEneShot = &(p_stage_objects->eneshot[idx]);
				pEneShotObj = &(pEneShot->obj);
				if (pEneShotObj->status == status_absent) {
					// oĂȂ玟
					continue;
				}

				// 蔻
				if (collision_objects(pEneShotObj, pObj) == 0) {
					// ͂
					continue;
				}

				// qbg
				pEneShotObj->on_hit(hittype, pEneShot, pObj, magic_ap);
			}
		}
	}
	return;
}

//=============================================================================
// 蔻F@ƓGCGe
//=============================================================================
void collision_jiki_enemy_eneshot()
{
	int i;
	JIKI* pJiki;
	CHROBJ* pJikiObj;
	int ap;
	//
	BGMESH* bgmesh = &(p_stage_objects->bgmesh);
	BBOX jiki_bbox;
	int bbox_result;
	int x, y;
	//
	ENEMY* pEnemy;
	CHROBJ* pEneObj;
	ENESHOT* pEneShot;
	CHROBJ* pEneShotObj;
	int hit_exists;

	pJiki = &(p_stage_objects->jiki);
	pJikiObj = &(pJiki->obj);
	ap = jiki_dash_ap[p_application_context->lv_blade];

	// L_bVłȂΖ
	if (pJikiObj->status != status_dash) {
		return;
	}

	// ̈𓾂
	bbox_result = get_bgmesh_area(pJikiObj, &jiki_bbox);
	if (bbox_result != 0) {
		// NbsOŉʊOȂ疳
		return;
	}

	// GƂ̓蔻
	memset(bgmesh->processed_enemy, 0, sizeof(bgmesh->processed_enemy));
	// GƂ̓蔻
	hit_exists = 0;
	for (y = jiki_bbox.y0; y <= jiki_bbox.y1; y++) {
		for (x = jiki_bbox.x0; x <= jiki_bbox.x1; x++) {
			for (i = 0; i < bgmesh->bgmesh_count_enemy[y][x]; i++) {
				// CfbNX𓾂
				unsigned char idx = bgmesh->bgmesh_enemy[y][x][i];
				if (bgmesh->processed_enemy[idx]) {
					// ςȂ玟
					continue;
				}
				pEnemy = &(p_stage_objects->enemy[idx]);
				pEneObj = &(pEnemy->obj);
				if (pEneObj->status == status_absent) {
					// oĂȂ玟
					continue;
				}

				// 蔻
				if (collision_objects(pEneObj, pJikiObj) == 0) {
					// ͂
					continue;
				}

				// _bVUŃqbgiЗ͉͂j
				pEneObj->on_hit(hittype_dash, pEnemy,pJikiObj, ap);
				hit_exists = 1;
			}
		}
	}
	// qbgXgbv
	if (hit_exists) {
		if (pJikiObj->hit_stop_ready) {
			p_stage_objects->hit_stop = 1;
			pJikiObj->hit_stop_ready = 0;
			play_se(&(p_sound_context->se_item[setype_dashhit]));
		}
	}

	// GeƂ̓蔻
	memset(bgmesh->processed_eneshot, 0, sizeof(bgmesh->processed_eneshot));
	// GeƂ̓蔻
	for (y = jiki_bbox.y0; y <= jiki_bbox.y1; y++) {
		for (x = jiki_bbox.x0; x <= jiki_bbox.x1; x++) {
			for (i = 0; i < bgmesh->bgmesh_count_eneshot[y][x]; i++) {
				// CfbNX𓾂
				unsigned char idx = bgmesh->bgmesh_eneshot[y][x][i];
				if (bgmesh->processed_eneshot[idx]) {
					// ςȂ玟
					continue;
				}
				pEneShot = &(p_stage_objects->eneshot[idx]);
				pEneShotObj = &(pEneShot->obj);
				if (pEneShotObj->status == status_absent) {
					// oĂȂ玟
					continue;
				}

				// 蔻
				if (collision_objects(pEneShotObj, pJikiObj) == 0) {
					// ͂
					continue;
				}

				// _bVUŃqbgiЗ͉͂j
				pEneShotObj->on_hit(hittype_dash, pEneShot, pJikiObj, 5);
			}
		}
	}
	return;
}


//=============================================================================
// 蔻FGƎ@
//=============================================================================
void collision_enemy_jiki()
{
	int i;
	JIKI* pJiki;
	CHROBJ* pJikiObj;
	//
	BGMESH* bgmesh = &(p_stage_objects->bgmesh);
	BBOX jiki_bbox;
	int bbox_result;
	int x, y;
	//
	ENEMY* pEnemy;
	CHROBJ* pEneObj;

	pJiki = &(p_stage_objects->jiki);
	pJikiObj = &(pJiki->obj);

	// LʏԂłȂΖ
	// GȂ疳
	if (
		   (pJikiObj->status != status_normal)
		|| (pJiki->invincible > 0)
		) {
		return;
	}

	// ̈𓾂
	bbox_result = get_bgmesh_area(pJikiObj, &jiki_bbox);
	if (bbox_result != 0) {
		// NbsOŉʊOȂ疳
		return;
	}

	// GƂ̓蔻
	memset(bgmesh->processed_enemy, 0, sizeof(bgmesh->processed_enemy));
	// GƂ̓蔻
	for (y = jiki_bbox.y0; y <= jiki_bbox.y1; y++) {
		for (x = jiki_bbox.x0; x <= jiki_bbox.x1; x++) {
			for (i = 0; i < bgmesh->bgmesh_count_enemy[y][x]; i++) {
				unsigned char idx;
				if (pJikiObj->status == status_damage) { break; }

				// CfbNX𓾂
				idx = bgmesh->bgmesh_enemy[y][x][i];
				if (bgmesh->processed_enemy[idx]) {
					// ςȂ玟
					continue;
				}
				pEnemy = &(p_stage_objects->enemy[idx]);
				pEneObj = &(pEnemy->obj);
				if (pEneObj->status == status_absent) {
					// oĂȂ玟
					continue;
				}

				// 蔻
				if (collision_objects(pEneObj, pJikiObj) == 0) {
					// ͂
					continue;
				}

				// LɃ_[W^ămbNobNԂɂ
				pJikiObj->on_hit(hittype_enemy, pJiki, pEneObj, 1);
			}
		}
	}
	return;
}


//=============================================================================
// 蔻FGeƎ@
//=============================================================================
void collision_eneshot_jiki()
{
	int i;
	JIKI* pJiki;
	CHROBJ* pJikiObj;
	//
	BGMESH* bgmesh = &(p_stage_objects->bgmesh);
	BBOX jiki_bbox;
	int bbox_result;
	int x, y;
	//
	ENESHOT* pEneShot;
	CHROBJ* pEneShotObj;

	pJiki = &(p_stage_objects->jiki);
	pJikiObj = &(pJiki->obj);


	// LʏԂłȂΖ
	// GȂ疳
	if ((pJikiObj->status != status_normal) || (pJiki->invincible > 0)) {
		return;
	}

	// ̈𓾂
	bbox_result = get_bgmesh_area(pJikiObj, &jiki_bbox);
	if (bbox_result != 0) {
		// NbsOŉʊOȂ疳
		return;
	}

	// GeƂ̓蔻
	memset(bgmesh->processed_eneshot, 0, sizeof(bgmesh->processed_eneshot));
	// GeƂ̓蔻
	for (y = jiki_bbox.y0; y <= jiki_bbox.y1; y++) {
		for (x = jiki_bbox.x0; x <= jiki_bbox.x1; x++) {
			for (i = 0; i < bgmesh->bgmesh_count_eneshot[y][x]; i++) {
				unsigned char idx;
				if (pJikiObj->status == status_damage) { break; }

				// CfbNX𓾂
				idx = bgmesh->bgmesh_eneshot[y][x][i];
				if (bgmesh->processed_eneshot[idx]) {
					// ςȂ玟
					continue;
				}
				pEneShot = &(p_stage_objects->eneshot[idx]);
				pEneShotObj = &(pEneShot->obj);
				if (pEneShotObj->status == status_absent) {
					// oĂȂ玟
					continue;
				}

				// 蔻
				if (collision_objects(pEneShotObj, pJikiObj) == 0) {
					// ͂
					continue;
				}

				// LɃ_[W^ămbNobNԂɂ
				pJikiObj->on_hit(hittype_eneshot, pJiki, pEneShotObj, 1);

				// Ge
				dispose_eneshot(pEneShot);
			}
		}
	}
	return;
}


//=============================================================================
// 蔻F@ƃACe
//=============================================================================
void collision_jiki_item()
{
	int i;
	JIKI* pJiki;
	CHROBJ* pJikiObj;
	//
	BGMESH* bgmesh = &(p_stage_objects->bgmesh);
	BBOX jiki_bbox;
	int bbox_result;
	int x, y;
	//
	ITEM* pItem;
	CHROBJ* pItemObj;

	pJiki = &(p_stage_objects->jiki);
	pJikiObj = &(pJiki->obj);

	// ̈𓾂
	bbox_result = get_bgmesh_area(pJikiObj, &jiki_bbox);
	if (bbox_result != 0) {
		// NbsOŉʊOȂ疳
		return;
	}

	// ACeƂ̓蔻
	memset(bgmesh->processed_item, 0, sizeof(bgmesh->processed_item));
	// ACeƂ̓蔻
	for (y = jiki_bbox.y0; y <= jiki_bbox.y1; y++) {
		for (x = jiki_bbox.x0; x <= jiki_bbox.x1; x++) {
			for (i = 0; i < bgmesh->bgmesh_count_item[y][x]; i++) {
				// CfbNX𓾂
				unsigned char idx = bgmesh->bgmesh_item[y][x][i];
				if (bgmesh->processed_item[idx]) {
					// ςȂ玟
					continue;
				}
				pItem = &(p_stage_objects->item[idx]);
				pItemObj = &(pItem->obj);
				if (pItemObj->status == status_absent) {
					// oĂȂ玟
					continue;
				}

				// 蔻
				if (collision_objects(pItemObj, pJikiObj) == 0) {
					// ͂
					continue;
				}

				// ACe
				pItemObj->on_hit(hittype_item, pItem, pJikiObj, 1);
			}
		}
	}
	return;
}


//=============================================================================
// qbgɉȂNOPnh
//=============================================================================
void on_hit_nop(HitType hittype, void* pTarget, CHROBJ* pObject, int ap)
{
	// Nothing to do.
}