#define __BOSSSHOT_C__

#include "stdio.h"
#include "stdlib.h"
#include "string.h"

#include "game_context.h"
#include "common.h"
#include "stage.h"
#include "collision.h"
#include "kon_util.h"
#include "esp.h"
#include "eneshot.h"
#include "bossshot.h"

// -----< vg^Cv錾 >-----
//
// <<<<< {X1pA >>>>>
void init_bossshot_bubble(void* pTarget, int array_index, int hx, int hy, int vx, int vy);
void move_bossshot_bubble(void* pTarget);
void draw_bossshot_bubble(void* pTarget);
//
// <<<<< {X2pRE >>>>>
void init_bossshot_bat(void* pTarget, int array_index, int hx, int hy, int vx, int vy);
void move_bossshot_bat(void* pTarget);
void draw_bossshot_bat(void* pTarget);
//
// <<<<< {X3pS~ >>>>>
void init_bossshot_dust(void* pTarget, int array_index, int hx, int hy, int vx, int vy);
void move_bossshot_dust(void* pTarget);
void draw_bossshot_dust(void* pTarget);
void on_hit_bossshot_dust(HitType hittype, void* pTarget, CHROBJ* pObject, int ap);
//
// <<<<< {X4p >>>>>
void init_bossshot_rock(void* pTarget, int array_index, int hx, int hy, int vx, int vy);
void move_bossshot_rock(void* pTarget);
void draw_bossshot_rock(void* pTarget);


//--------------------------------------------------------------------
//	[  ]
//		ENESHOT* appear_bossshot(EneShotType type, int hx, int hy, int vel)
//
//	[  ]
//		EneShotType type	oGe̎
//		int hx				oʒui256{Wnj
//		int hy				oʒui256{Wnj
//		int vx				xi256{Wnj
//		int vy				xi256{Wnj
//
//	[ ߂l ]
//		oGeւ̃|C^BoȂƂNULLԂB
//
//	[  ]
//		
//--------------------------------------------------------------------
ENESHOT* appear_bossshot(EneShotType type, int hx, int hy, int vx, int vy)
{
	int absent_index;
	ENESHOT* pEneShot;

	// X^bN^[Qbg̃CfbNX𓾂
	absent_index = POP_IDSTACK_ENESHOT;
	if (absent_index < 0) {
		// oE
		return NULL;
	}

	// o
	pEneShot = &(p_stage_objects->eneshot[absent_index]);
	memset(pEneShot, 0, sizeof(ENESHOT));

	switch (type) {
	case eneshottype_bubble:
		// {X1pA
		init_bossshot_bubble(pEneShot, absent_index, hx, hy, vx, vy);
		break;

	case eneshottype_boss2bat:
		// {X2pRE
		init_bossshot_bat(pEneShot, absent_index, hx, hy, vx, vy);
		break;

	case eneshottype_boss3dust:
		// {X3pS~
		init_bossshot_dust(pEneShot, absent_index, hx, hy, vx, vy);
		break;

	case eneshottype_boss4rock:
		// {X4p
		init_bossshot_rock(pEneShot, absent_index, hx, hy, vx, vy);
		break;

	default:
		// sȃ^Cv̂ƂɂIDԂĖ
		kon_log_single(ERROR_INVALID_ENESHOT_TYPE, "{Xe̎ʂsłBtype=%d\n", type);
		PUSH_IDSTACK_ENESHOT(absent_index);
		break;
	}
	pEneShot->type = type;

	// I
	return pEneShot;
}


//=============================================================================
// GeɃ_[W^
//=============================================================================
void on_hit_bossshot(HitType hittype, void* pTarget, CHROBJ* pObject, int ap)
{
	ENESHOT* pEneShot = pTarget;

	{
		// 
		pEneShot->obj.status = status_absent;

		// X^bNIDԂ
		dispose_eneshot(pEneShot);
	}
}


//=============================================================================
// {X3dustɃ_[W^
//=============================================================================
void on_hit_bossshot_dust(HitType hittype, void* pTarget, CHROBJ* pObject, int ap)
{
	ENESHOT* pEneShot = pTarget;
	OBJPOS* pEnePos = &(pEneShot->obj.pos);

	{
		// ESPo
		appear_esp_rnd(esptype_spark, pEnePos->hx, pEnePos->hy, 256);
		appear_esp_rnd(esptype_spark, pEnePos->hx, pEnePos->hy, 384);

		// 
		pEneShot->obj.status = status_absent;

		// ʉ
		play_se(&(p_sound_context->se_item[setype_dashhit]));

		// X^bNIDԂ
		dispose_eneshot(pEneShot);
	}
}


//=============================================================================
// A
//=============================================================================
//-----------------------------------------------------------------------------
// 
//-----------------------------------------------------------------------------
void init_bossshot_bubble(void* pTarget, int absent_index, int hx, int hy, int vx, int vy)
{
	ENESHOT* pEneShot = pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);

	// z̃CfbNXݒ
	pObj->array_index = absent_index;
	// NXg̐擪ɍ
	if (p_stage_objects->eneshot_top != NULL) {
		p_stage_objects->eneshot_top->p_prev = pEneShot;
	}
	pEneShot->p_next = p_stage_objects->eneshot_top;
	p_stage_objects->eneshot_top = pEneShot;

	// 蔻͈͂ݒ
	pObj->hit_bbox.x0 = -1;
	pObj->hit_bbox.x1 = +1;
	pObj->hit_bbox.y0 = -1;
	pObj->hit_bbox.y1 = +1;

	// ^Cvݒ
	pEneShot->type = eneshottype_normal;	// ^Cv

	// ʒuݒ
	pPos->ax = 0;
	pPos->ay = 0;
	pPos->vx = vx;
	pPos->vy = vy;
	pPos->hx = hx;
	pPos->hy = hy;
	pPos->px = pPos->hx >> 8;
	pPos->py = pPos->hy >> 8;
	pObj->prev_pos = *pPos;

	// Ԃݒ肷
	pEneShot->obj.status = status_normal;	// ʏ

	// ݒ
	pObj->move = move_bossshot_bubble;			// ړ֐
	pObj->draw = draw_bossshot_bubble;			// `֐
	pObj->grounding = NULL;	// ڒn֐
	pObj->on_hit = on_hit_bossshot;	// Gj󎞂̋ʏ

	return;
}

//-----------------------------------------------------------------------------
// ړ
//-----------------------------------------------------------------------------
void move_bossshot_bubble(void* pTarget)
{
	ENESHOT* pEneShot = pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);

	// ړ
	//move_obj(pPos);
	move_common(pObj, 0, MOVE_GRAVITY >> 2);

	// BGbVɔzuʊO肷
	collision_put_bgmesh_eneshot(pObj);

	// ʊOȂ
	if ((pPos->py < p_stage_context->stage_clipping_area.y0)
		|| (pPos->py > p_stage_context->stage_clipping_area.y1)) {
		// Ge
		dispose_eneshot(pEneShot);
	}

	// t[JEg
	pObj->frame_count += 1;
	return;
}

//-----------------------------------------------------------------------------
// `揈
//-----------------------------------------------------------------------------
void draw_bossshot_bubble(void* pTarget)
{
	ENESHOT* pEneShot = (ENESHOT*)pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int hx, hy;
	int px, py;
	int anim = 0;
	int allocsp = 0;

	// SPR[h̐擪I
	int sp_code_top = p_stage_context->cmn_sp_top + 0x45;

	// Aj[ṼCfbNXԍ
	anim = (pObj->frame_count >> 2) & 3;

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(1);	// SP1g
	if (allocsp < 1) {
		// SPmۂłȂ疳
		return;
	}

	// }bvobt@Ƀf[^i[
	SP_SET(sp, px + 8, py + 8, sp_code_top + 5 + anim, 7, 0, 0, 3);
	sp++;

	// I
	return;
}


//=============================================================================
// {X2pRE
//=============================================================================
//-----------------------------------------------------------------------------
// 
//-----------------------------------------------------------------------------
void init_bossshot_bat(void* pTarget, int absent_index, int hx, int hy, int vx, int vy)
{
	ENESHOT* pEneShot = pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);

	// z̃CfbNXݒ
	pObj->array_index = absent_index;
	// NXg̐擪ɍ
	if (p_stage_objects->eneshot_top != NULL) {
		p_stage_objects->eneshot_top->p_prev = pEneShot;
	}
	pEneShot->p_next = p_stage_objects->eneshot_top;
	p_stage_objects->eneshot_top = pEneShot;

	// 蔻͈͂ݒ
	pObj->hit_bbox.x0 = -1;
	pObj->hit_bbox.x1 = +1;
	pObj->hit_bbox.y0 = -1;
	pObj->hit_bbox.y1 = +1;

	// ^Cvݒ
	pEneShot->type = eneshottype_normal;	// ^Cv

	// ʒuݒ
	pPos->ax = 0;
	pPos->ay = 0;
	pPos->vx = vx;
	pPos->vy = vy;
	pPos->hx = hx;
	pPos->hy = hy;
	pPos->px = pPos->hx >> 8;
	pPos->py = pPos->hy >> 8;
	pObj->prev_pos = *pPos;

	// Ԃݒ肷
	pEneShot->obj.status = status_normal;	// ʏ

	// ݒ
	pObj->move = move_bossshot_bat;			// ړ֐
	pObj->draw = draw_bossshot_bat;			// `֐
	pObj->grounding = NULL;	// ڒn֐
	pObj->on_hit = on_hit_bossshot;	// Gj󎞂̋ʏ

	return;
}

//-----------------------------------------------------------------------------
// ړ
//-----------------------------------------------------------------------------
void move_bossshot_bat(void* pTarget)
{
	ENESHOT* pEneShot = pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);
	OBJPOS* pJikiPos = &(p_stage_objects->jiki.obj.pos);

	// ړ
	if (pObj->frame_count == 40) {
		// t[Ŏ~܂
		pPos->vx = 0;
		pPos->vy = 0;
	}
	if ((pObj->frame_count > 60) && (pObj->frame_count < 300)) {
		// ΂炭z[~O
		int diff_x, diff_y, acc, vmax;

		// @ɊĂ
		diff_x = pJikiPos->hx - pPos->hx;
		diff_y = pJikiPos->hy - pPos->hy;
		acc = 24;
		vmax = 16 << 8;
		if (diff_x > 0) { pPos->vx += acc; }
		else { pPos->vx -= acc; }
		if (diff_y > 0) { pPos->vy += acc; }
		else { pPos->vy -= acc; }
		if (pPos->vx > vmax) { pPos->vx = vmax; }
		if (pPos->vx < -vmax) { pPos->vx = -vmax; }
		if (pPos->vy > vmax) { pPos->vy = vmax; }
		if (pPos->vy < -vmax) { pPos->vy = -vmax; }
	}

	// ړ
	//move_obj(pPos);
	move_common(pObj, 0, 0);

	// BGbVɔzuʊO肷
	collision_put_bgmesh_eneshot(pObj);

	// ʊOȂ
	if (
		(pPos->py < p_stage_context->stage_clipping_area.y0)
		|| (pPos->py > p_stage_context->stage_clipping_area.y1)
		|| (pPos->px < p_stage_context->stage_clipping_area.x0)
		|| (pPos->px > p_stage_context->stage_clipping_area.x1)
		|| ((pObj->frame_count>600) && (pObj->out_of_screen))
		) {
		// Ge
		dispose_eneshot(pEneShot);
	}

	// t[JEg
	pObj->frame_count += 1;
	return;
}

//-----------------------------------------------------------------------------
// `揈
//-----------------------------------------------------------------------------
void draw_bossshot_bat(void* pTarget)
{
	ENESHOT* pEneShot = (ENESHOT*)pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int hx, hy;
	int px, py;
	int anim = 0;
	int allocsp = 0;

	// SPR[h̐擪I
	int sp_code_top = 0x3E;

	// Aj[ṼCfbNXԍ
	anim = (pObj->frame_count >> 3) & 1;

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(1);	// SP1g
	if (allocsp < 1) {
		// SPmۂłȂ疳
		return;
	}

	// }bvobt@Ƀf[^i[
	SP_SET(sp, px + 8, py + 8, sp_code_top + anim, 12, 0, 0, 3);
	sp++;

	// I
	return;
}


//=============================================================================
// {X3pS~
//=============================================================================
//-----------------------------------------------------------------------------
// 
//-----------------------------------------------------------------------------
void init_bossshot_dust(void* pTarget, int absent_index, int hx, int hy, int vx, int vy)
{
	ENESHOT* pEneShot = pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);

	// z̃CfbNXݒ
	pObj->array_index = absent_index;
	// NXg̐擪ɍ
	if (p_stage_objects->eneshot_top != NULL) {
		p_stage_objects->eneshot_top->p_prev = pEneShot;
	}
	pEneShot->p_next = p_stage_objects->eneshot_top;
	p_stage_objects->eneshot_top = pEneShot;

	// 蔻͈͂ݒ
	pObj->hit_bbox.x0 = -1;
	pObj->hit_bbox.x1 = +1;
	pObj->hit_bbox.y0 = -1;
	pObj->hit_bbox.y1 = +1;

	// ^Cvݒ
	pEneShot->type = eneshottype_normal;	// ^Cv

	// ʒuݒ
	pPos->ax = 0;
	pPos->ay = 0;
	pPos->vx = vx;
	pPos->vy = vy;
	pPos->hx = hx;
	pPos->hy = hy;
	pPos->px = pPos->hx >> 8;
	pPos->py = pPos->hy >> 8;
	pObj->prev_pos = *pPos;

	// Ԃݒ肷
	pEneShot->obj.status = status_normal;	// ʏ

	// ݒ
	pObj->move = move_bossshot_dust;			// ړ֐
	pObj->draw = draw_bossshot_dust;			// `֐
	pObj->grounding = move_grounding_bottom_single;	// ڒn֐
	pObj->on_hit = on_hit_bossshot_dust;	// Gj󎞂̋ʏ

	return;
}

//-----------------------------------------------------------------------------
// ړ
//-----------------------------------------------------------------------------
void move_bossshot_dust(void* pTarget)
{
	ENESHOT* pEneShot = pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);
	int bounded = 0;
	int prev_vy = pPos->vy;

	// ړ
	//move_obj(pPos);
	move_common(pObj, 0, MOVE_GRAVITY >> 2);

	if (pObj->gcol.bottom!=0) {
		pPos->vy = -(prev_vy >> 1);
		if (abs(pPos->vy) < 384) {
			bounded = 1;
		}
	}

	// BGbVɔzuʊO肷
	collision_put_bgmesh_eneshot(pObj);

	// A莞Ԃŏ
	if ((bounded) || (pObj->frame_count > 500)) {
		// Ge
		dispose_eneshot(pEneShot);
	}

	// ʂɃu[hƂ̓蔻
	{
		int on_hit_attack = 0;
		BLADE* pBlade = &(p_stage_objects->blade);
		SUBWEAPON* sub_weapon;

		// U𒵂˕Ԃۂ̃GtFNgԊu̐
		if (pObj->effect_span > 0) {
			pObj->effect_span -= 1;
		}

		// u[hoĂqbg
		if ((pObj->effect_span == 0) && (pBlade->obj.status != status_absent)) {
			if (collision_objects(pObj, &(pBlade->obj)) != 0) {
				on_hit_attack = 1;
			}
		}

		// TuVbgƂ̃qbg
		if (on_hit_attack == 0) {
			sub_weapon = p_stage_objects->subweapon_top;
			while (sub_weapon != NULL) {
				if ((sub_weapon->obj.status != status_absent)
					&& (sub_weapon->hittype == hittype_blade)
				) {
					if (collision_objects(pObj, &(sub_weapon->obj)) != 0) {
						on_hit_attack = 1;
						break;
					}
				}
				sub_weapon = sub_weapon->p_next;
			}
		}

		// qbgĂꍇɃGtFNgo
		if ((on_hit_attack) && (pObj->effect_span == 0)) {
			// qbg
			pObj->effect_span = 5;	// GtFNg 6t[Ƃ1

			// ESPo
			appear_esp_rnd(esptype_spark, pObj->pos.hx, pObj->pos.hy, 256);

			// ʉ
			play_se(&(p_sound_context->se_item[setype_dashhit]));
		}
	}

	// t[JEg
	pObj->frame_count += 1;
	return;
}

//-----------------------------------------------------------------------------
// `揈
//-----------------------------------------------------------------------------
void draw_bossshot_dust(void* pTarget)
{
	ENESHOT* pEneShot = (ENESHOT*)pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int hx, hy;
	int px, py;
	int anim = 0;
	int allocsp = 0;

	// SPR[h̐擪I
	int sp_code_top = 0xA0;

	// Aj[ṼCfbNXԍ
	anim = ((pObj->frame_count >> 3) & 1) << 1;

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(2);	// SP1g
	if (allocsp < 2) {
		// SPmۂłȂ疳
		return;
	}

	// }bvobt@Ƀf[^i[
	SP_SET(sp, px + 8, py + 0, sp_code_top + anim, 13, 0, 0, 3);
	sp++;
	SP_SET(sp, px + 8, py + 16, sp_code_top + anim + 1, 13, 0, 0, 3);
	sp++;

	// I
	return;
}


//=============================================================================
// {X4p
//=============================================================================
//-----------------------------------------------------------------------------
// 
//-----------------------------------------------------------------------------
void init_bossshot_rock(void* pTarget, int absent_index, int hx, int hy, int vx, int vy)
{
	ENESHOT* pEneShot = pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);

	// z̃CfbNXݒ
	pObj->array_index = absent_index;
	// NXg̐擪ɍ
	if (p_stage_objects->eneshot_top != NULL) {
		p_stage_objects->eneshot_top->p_prev = pEneShot;
	}
	pEneShot->p_next = p_stage_objects->eneshot_top;
	p_stage_objects->eneshot_top = pEneShot;

	// 蔻͈͂ݒ
	pObj->hit_bbox.x0 = -1;
	pObj->hit_bbox.x1 = +1;
	pObj->hit_bbox.y0 = -1;
	pObj->hit_bbox.y1 = +1;

	// ^Cvݒ
	pEneShot->type = eneshottype_normal;	// ^Cv

	// ʒuݒ
	pPos->ax = 0;
	pPos->ay = 0;
	pPos->vx = vx;
	pPos->vy = vy;
	pPos->hx = hx;
	pPos->hy = hy;
	pPos->px = pPos->hx >> 8;
	pPos->py = pPos->hy >> 8;
	pObj->prev_pos = *pPos;

	// Ԃݒ肷
	pEneShot->obj.status = status_normal;	// ʏ

	// ݒ
	pObj->move = move_bossshot_rock;			// ړ֐
	pObj->draw = draw_bossshot_rock;			// `֐
	pObj->grounding = NULL;	// ڒn֐
	pObj->on_hit = on_hit_bossshot;	// Gj󎞂̋ʏ

	return;
}

//-----------------------------------------------------------------------------
// ړ
//-----------------------------------------------------------------------------
void move_bossshot_rock(void* pTarget)
{
	ENESHOT* pEneShot = pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);
	OBJPOS* pJikiPos = &(p_stage_objects->jiki.obj.pos);

	// ړ
	if (pObj->frame_count == 40) {
		// t[Ŏ~܂
		pPos->vx = 0;
		pPos->vy = 0;
	}
	if ((pObj->frame_count > 60) && (pObj->frame_count < 200)) {
		// ΂炭z[~O
		int diff_x, diff_y, acc, vmax;

		// @ɊĂ
		diff_x = pJikiPos->hx - pPos->hx;
		diff_y = pJikiPos->hy - pPos->hy;
		acc = 24;
		vmax = 16 << 8;
		if (diff_x > 0) { pPos->vx += acc; }
		else { pPos->vx -= acc; }
		if (diff_y > 0) { pPos->vy += acc; }
		else { pPos->vy -= acc; }
		if (pPos->vx > vmax) { pPos->vx = vmax; }
		if (pPos->vx < -vmax) { pPos->vx = -vmax; }
		if (pPos->vy > vmax) { pPos->vy = vmax; }
		if (pPos->vy < -vmax) { pPos->vy = -vmax; }
	}

	// ړ
	//move_obj(pPos);
	move_common(pObj, 0, 0);

	// BGbVɔzuʊO肷
	collision_put_bgmesh_eneshot(pObj);

	// ʊOȂ
	if (
		(pPos->py < p_stage_context->stage_clipping_area.y0)
		|| (pPos->py > p_stage_context->stage_clipping_area.y1)
		|| (pPos->px < p_stage_context->stage_clipping_area.x0)
		|| (pPos->px > p_stage_context->stage_clipping_area.x1)
		|| ((pObj->frame_count > 600) && (pObj->out_of_screen))
		) {
		// Ge
		dispose_eneshot(pEneShot);
	}

	// t[JEg
	pObj->frame_count += 1;
	return;
}

//-----------------------------------------------------------------------------
// `揈
//-----------------------------------------------------------------------------
void draw_bossshot_rock(void* pTarget)
{
	ENESHOT* pEneShot = (ENESHOT*)pTarget;
	CHROBJ* pObj = &(pEneShot->obj);
	OBJPOS* pPos = &(pObj->pos);
	SP_UNIT* sp;
	int hx, hy;
	int px, py;
	int anim = 0;
	int allocsp = 0;

	// SPR[h̐擪I
	int sp_code_top = 0xB0;

	// Aj[ṼCfbNXԍ
	anim = (pObj->frame_count >> 3) & 1;

	// LN^̃XN[W
	hx = (pPos->hx - p_stage_context->bgview_hx);
	hy = (pPos->hy - p_stage_context->bgview_hy);
	px = hx >> 8;
	py = hy >> 8;

	sp = p_memory_map_buffer->sp_unit + p_stage_objects->sp_index_seq;	// ^[QbgSP_UNITւ̃|C^
	allocsp = sp_alloc_index(4);	// SP1g
	if (allocsp < 4) {
		// SPmۂłȂ疳
		return;
	}

	// }bvobt@Ƀf[^i[
	SP_SET(sp, px + 0, py + 0, sp_code_top + 0, 13, 0, 0, 3);
	sp++;
	SP_SET(sp, px + 16, py + 0, sp_code_top + 1, 13, 0, 0, 3);
	sp++;
	SP_SET(sp, px + 0, py + 16, sp_code_top + 2, 13, 0, 0, 3);
	sp++;
	SP_SET(sp, px + 16, py + 16, sp_code_top + 3, 13, 0, 0, 3);
	sp++;

	// I
	return;
}
