#define __BLADE_C__
#include <string.h>

#include "../devs/devs.h"

#include "kon_util.h"
#include "game_context.h"
#include "structs.h"
#include "common.h"
#include "blade.h"
#include "subweapon.h"
#include "stage.h"

//=========================================
// vg^Cv錾
//=========================================
// u[h
void blade_move(void* pTarget);	// ړ֐ւ̃|C^
void blade_draw(void* pTarget);	// `֐ւ̃|C^

//--------------------------------------------------------------------
//	[  ]
//		void blade_init(void* pTarget, int x, int y, Direction direction)
//
//	[  ]
//		void* pTarget       u[hIuWFNgւ̃|C^
//      int px              ʒuX
//      int py              ʒuY
//      Direction direction Ă
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		u[h̏
//--------------------------------------------------------------------
void blade_init(void* pTarget, int px, int py, Direction direction)
{
    BLADE* pBlade = pTarget;
    memset(pTarget, 0, sizeof(BLADE));

    // \bh蓖
    pBlade->obj.move = blade_move;           // ړ֐
    pBlade->obj.draw = blade_draw;           // `֐
    //p_stage_objects->jiki.obj.grounding = move_grounding; // ڒn֐

    // 苫Eݒ
    pBlade->obj.hit_bbox.x0 = -26;
    pBlade->obj.hit_bbox.x1 = +26;
    pBlade->obj.hit_bbox.y0 = -14;
    pBlade->obj.hit_bbox.y1 = +14;

    // ʒuݒ
    pBlade->obj.pos.px = px;
    pBlade->obj.pos.py = py;
    pBlade->obj.pos.hx = px << 8;
    pBlade->obj.pos.hy = py << 8;
    pBlade->obj.prev_pos = pBlade->obj.pos;
    pBlade->obj.direction = direction;

    // Ԓl
    pBlade->obj.status = status_attack;   // ʏU
    pBlade->obj.frame_count = 0;
    pBlade->ap = BLADE_AP; // U

    // I
    return;
}


//--------------------------------------------------------------------
//	[  ]
//		void blade_move(void* pTarget)
//
//	[  ]
//		void* pTarget   u[hIuWFNgւ̃|C^
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		u[ḧړ
//--------------------------------------------------------------------
void blade_move(void* pTarget) {
    BLADE* pBlade;
    CHROBJ* pBladeObj;
    OBJPOS* pBladePos;
    JIKI* pJiki;
    CHROBJ* pJikiObj;
    OBJPOS* pJikiPos;
    int idx;
    SubWeaponType type;

    // SPR[h̐擪I
    int sp_code_top = p_stage_context->cmn_sp_top + 0x16;

    // W
    pBlade = pTarget;
    pBladeObj = &(pBlade->obj);
    pBladePos = &(pBladeObj->pos);
    pJiki = &(p_stage_objects->jiki);
    pJikiObj = &(pJiki->obj);
    pJikiPos = &(pJikiObj->pos);

    // @Ȃ΃u[hs
    if (pJikiObj->status == status_absent) {
        pBladeObj->status = status_absent;
        return;
    }

    // `p^[̃CfbNX𓾂
    idx = (pBladeObj->frame_count >> 1);
    if (idx >= 4) {
        // őt[𒴂
        pBladeObj->status = status_absent;
        pBladeObj->frame_count = 0;
        return;
    }

    // u[ḧʒu@ɍ킹
	if (pJikiObj->direction == dir_left) {
		// 
        pBladePos->hx = pJikiPos->hx - (24 << 8);
        pBladePos->hy = pJikiPos->hy;
    }
	else {
		// E
        pBladePos->hx = pJikiPos->hx + (24 << 8);
        pBladePos->hy = pJikiPos->hy;
	}
    pBladePos->px = pBladePos->hx >> 8;
    pBladePos->py = pBladePos->hy >> 8;

    // -----< PCG]w >-----
    //
    // p^[]
    blade_stack_trans_sp(pBlade);

    // -----< TuVbgo >-----
    //
    // 
	if ((pBladeObj->frame_count == 1)
		&& (p_application_context->lv_blade >= 1)
		) {
        type = (p_application_context->lv_blade < 4) ? subweapon_subshot_w : subweapon_subshot_s;
		if (pJikiObj->direction == dir_right) {
			appear_subweapon(type, pBladePos->hx, pBladePos->hy, 2048, 0);
		}
		else {
			appear_subweapon(type, pBladePos->hx, pBladePos->hy, -2048, 0);
		}
	}
    // 
	if ((pBladeObj->frame_count == 3)
		&& (p_application_context->lv_blade >= 2)
		) {
		type = (p_application_context->lv_blade < 5) ? subweapon_subshot_w : subweapon_subshot_s;
		if (pJikiObj->direction == dir_right) {
			appear_subweapon(type, pBladePos->hx, pBladePos->hy - 1024, 1800, -512);
		}
		else {
			appear_subweapon(type, pBladePos->hx, pBladePos->hy - 1024, -1800, -512);
		}
	}
    // 
	if ((pBladeObj->frame_count == 5)
		&& (p_application_context->lv_blade >= 3)
		) {
        type = (p_application_context->lv_blade < 5) ? subweapon_subshot_w : subweapon_subshot_s;
        if (pJikiObj->direction == dir_right) {
            appear_subweapon(type, pBladePos->hx, pBladePos->hy+1024, 1800, 512);
        }
        else {
            appear_subweapon(type, pBladePos->hx, pBladePos->hy+1024, -1800, 512);
        }
    }

    // t[JEg𓮂
    pBladeObj->frame_count += 1;

    // I
    return;
}


//--------------------------------------------------------------------
//	[  ]
//		void blade_stack_trans_sp(BLADE* pBlade)
//
//	[  ]
//		BLADE* pBlade
//
//	[ ߂l ]
//		Ȃ
//
//	[  ]
//		u[hSPp^[]
//--------------------------------------------------------------------
void blade_stack_trans_sp(BLADE* pBlade) {
    int idx = (pBlade->obj.frame_count >> 1);
    int sp_code_top = p_stage_context->cmn_sp_top + 0x16;
    //stack_transfer_sp(0, 0x54 + (idx * 3), sp_code_top, 3);
	stack_transfer_sp(0, 0x54 + ((idx << 1) + idx), sp_code_top, 3);
}


//--------------------------------------------------------------------
//	[  ]
//		void blade_draw(void* pTarget)
//
//	[  ]
//		void* pTarget   ΏۂBLADEւ̃|C^
//
//	[ ߂l ]
//		F0
//      sF0ȊO
//
//	[  ]
//		`揈
//--------------------------------------------------------------------
void blade_draw(void* pTarget) {
    BLADE* pBlade;
    CHROBJ* pObj;
    SP_UNIT* sp;
    int hx, hy;
    int px, py;
    int ix;

    // SPR[h̐擪I
    int sp_code_top = p_stage_context->cmn_sp_top + 0x16;

    pBlade = pTarget;
    pObj = &(pBlade->obj);

    // LN^̃XN[W
    hx = (pObj->pos.hx - p_stage_context->bgview_hx);
    hy = (pObj->pos.hy - p_stage_context->bgview_hy);
    px = hx >> 8;
    py = hy >> 8;

    // LN^
    for (ix = 0; ix < 3; ix++) {
        // `ɎgSPR[h𓾂
        int sp_index = p_stage_objects->sp_index_seq;
        if (sp_index >= 128) {
            // ől𒴂Ă
            kon_log_single(SIGLE_REPORT_LOGCODE_COUNT, "draw_blade : SP̍ől𒴂܂B\n");
            continue;
        }
        p_stage_objects->sp_index_seq++;

        // }bvobt@Ƀf[^i[
        sp = (SP_UNIT*)(&(p_memory_map_buffer->sp_unit[sp_index]));
		if (pObj->direction == dir_left) {
			// 
			sp->x = px + 8 + 16 - (ix << 4);
		} else {
			// E
			sp->x = px - 8 + (ix << 4);
		}
        sp->y = py + 8;
        sp->code.bit.code = sp_code_top + ix;
        sp->code.bit.color = 6;
        sp->code.bit.h_rev = (pObj->direction==dir_left);
        sp->code.bit.v_rev = 0;
        sp->prw = 3;
    }
    return;
}
