﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace KonConf
{
    /// <summary>
    /// 画面モードを示すクラス
    /// </summary>
    internal class ScreenMode
    {
        /// <summary>
        /// モード（0:現在の画面サイズ, 1:指定）
        /// </summary>
        public int mode { get; set; }

        /// <summary>
        /// 幅
        /// </summary>
        public int width { get; set; }

        /// <summary>
        /// 高さ
        /// </summary>
        public int height { get; set; }

        /// <summary>
        /// デフォルトコンストラクタ
        /// </summary>
        public ScreenMode()
        {
            mode = 0;
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public ScreenMode(int width, int height)
        {
            this.mode = 1;
            this.width = width;
            this.height = height;
        }

        /// <summary>
        /// 文字列化する
        /// </summary>
        /// <returns></returns>
        public override string ToString()
        {
            if(mode==0)
            {
                return "現在の画面サイズ";
            }

            String str = "" + width + " × " + height;
            return str;
        }
    }
}
