using Microsoft.VisualBasic.Devices;
using System.Diagnostics;
using System.DirectoryServices.ActiveDirectory;
using System.Runtime.InteropServices;
using System.Text;
using System.Windows.Forms;
using static System.Formats.Asn1.AsnWriter;

namespace KonConf
{
    public partial class KonConf : Form
    {
        /// <summary>
        /// hCoT|[gĂXeBbN𓾂
        /// </summary>
        /// <returns></returns>
        [DllImport("winmm.dll")]
        public static extern int joyGetNumDevs();

        // <<< pXݒ >>>
        //String exe = @"konkonWin\Debug\konkonWin.exe";
        //String dir = @"D:\GTNWORK\X68\konkon";
        //String configFile = @"KonConf.cnf";
        //
        String exe = @"konkonWin.exe";
        String dir = @".";
        String configFile = @"KonConf.cnf";
        //        String manualHtmlPath = @"manual\index.html";
        String manualHtmlPath = @"manual\index.html";

        // <<< Bݒ荀 >>>
        String strScreenShotTrigger = "";
        String strScreenShotKey = "";
        String strReplayMode = "0";
        String strScoreLog = "0";

        /// <summary>
        /// RXgN^
        /// </summary>
        public KonConf()
        {
            InitializeComponent();
        }

        /// <summary>
        /// A{^̌o
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnDetectA_Click(object sender, EventArgs e)
        {
            // _CAOJ
            ButtonDetectDlg detectDlg = new ButtonDetectDlg();
            detectDlg.ShowDialog();

            // R{{bNXɔf
            int buttonId = detectDlg.buttonId;
            this.selectCBItem(ref cbControllerA, buttonId.ToString());

            // j
            detectDlg.Dispose();

        }

        /// <summary>
        /// _CAO\̃Cxg
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void KonConf_Load(object sender, EventArgs e)
        {
            // ftHglݒ肷
            setDefault();

            // ݒ[h
            LoadConfig();
        }

        private void setDefault()
        {
            // <<< Rg[ID >>>
            // ACeĂ
            cbControllerId.Items.Clear();
            cbControllerId.Items.Add("-");

            // ACeo^
            int deviceNumber = joyGetNumDevs();
            for (int i = 0; i < deviceNumber; i++)
            {
                cbControllerId.Items.Add(i.ToString());
            }

            // ԑI
            if (deviceNumber > 0)
            {
                cbControllerId.SelectedIndex = 1;
            }
            else
            {
                cbControllerId.SelectedIndex = 0;

            }

            // <<< Rg[{^ >>>
            initControllerCb(ref cbControllerA);
            initControllerCb(ref cbControllerB);
            initControllerCb(ref cbControllerPause);
            cbControllerA.SelectedIndex = 1;
            cbControllerB.SelectedIndex = 2;
            cbControllerPause.SelectedIndex = 10;

            // <<< L[{[h >>>
            initKeyboardCb(ref cbKeyboardA);
            initKeyboardCb(ref cbKeyboardB);
            initKeyboardCb(ref cbKeyboardPause);
            cbKeyboardA.SelectedIndex = 24;
            cbKeyboardB.SelectedIndex = 26;
            cbKeyboardPause.SelectedIndex = 27;

            // <<< ʃ[h >>>
            // ʃ[h̃v_EɑI
            cbFullScreenSize.Items.Clear();
            cbFullScreenSize.Items.Add(new ScreenMode());
            cbFullScreenSize.Items.Add(new ScreenMode(640, 480));
            cbFullScreenSize.Items.Add(new ScreenMode(800, 600));
            cbFullScreenSize.Items.Add(new ScreenMode(1024, 768));
            cbFullScreenSize.Items.Add(new ScreenMode(1280, 1024));
            cbFullScreenSize.Items.Add(new ScreenMode(1280, 720));
            cbFullScreenSize.Items.Add(new ScreenMode(1920, 1080));
            cbFullScreenSize.SelectedIndex = 0;
            cbVirtualFullScreenMode.Checked = false;

            // <<< tXN[̉ʔԍ >>>
            cbFullScreenDisplayNo.Items.Clear();
            cbFullScreenDisplayNo.Items.Add("vC}fBXvC");
            cbFullScreenDisplayNo.Items.Add("0");
            cbFullScreenDisplayNo.Items.Add("1");
            cbFullScreenDisplayNo.Items.Add("2");
            cbFullScreenDisplayNo.Items.Add("3");
            cbFullScreenDisplayNo.Items.Add("4");
            cbFullScreenDisplayNo.SelectedIndex = 0;

            // <<< EBhETCY >>>
            tbWindowWidth.Text = "768";
            tbWindowHeight.Text = "512";

            // ʃ[hI
            rbWindowMode.Select();

            // VSync҂w
            checkWaitVSync.Checked = true;

            // <<< {[ >>>
            slBGMVolume.Value = 127;
            slSEVolume.Value = 127;
            tbBGMVolume.Text = slBGMVolume.Value.ToString();
            tbSEVolume.Text = slSEVolume.Value.ToString();

            // <<< XVI[h >>>
            cbXVIMode.Checked = true;

            // <<< oCjAtB^ >>>
            cbBilinearFilter.Checked = false;

            // <<< Փx >>>
            radioGLEasy.Checked = false;
            radioGLNovice.Checked = true;
            radioGLNormal.Checked = false;
            radioGLHard.Checked = false;
        }

        private void initControllerCb(ref ComboBox cb)
        {
            // NA
            cb.Items.Clear();

            // l
            cb.Items.Add("-");
            for (int i = 0; i < 32; i++)
            {
                cb.Items.Add(i.ToString());
            }

            // I
            cb.SelectedIndex = 0;
        }

        /// <summary>
        /// L[{[h̃v_E
        /// </summary>
        /// <param name="cb"></param>
        private void initKeyboardCb(ref ComboBox cb)
        {
            // NA
            cb.Items.Clear();

            // l
            cb.Items.Add("-");
            for (int i = 'A'; i <= 'Z'; i++)
            {
                String str = ((char)i).ToString();
                cb.Items.Add(str);
            }
            cb.Items.Add("ESCAPE");
            cb.Items.Add("TAB");
            cb.Items.Add("RETURN");
            cb.Items.Add("SPACE");

            // I
            cb.SelectedIndex = 0;
        }

        /// <summary>
        /// Rg[IĎo
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnDetectControllerId_Click(object sender, EventArgs e)
        {
            // _CAO\
            ButtonDetectDlg detectDlg = new ButtonDetectDlg();
            detectDlg.ShowDialog();
            int stickId = detectDlg.stickId;

            // ID擾
            if (detectDlg.stickId >= 0)
            {
                selectCBItem(ref cbControllerId, stickId);
            }

            // 
            detectDlg.Dispose();
        }

        /// <summary>
        /// v_EXgI
        /// </summary>
        /// <param name="rCb"></param>
        /// <param name="name"></param>
        private void selectCBItem(ref ComboBox rCb, int value)
        {
            String val = value.ToString();
            selectCBItem(ref rCb, val);
        }
        private void selectCBItem(ref ComboBox rCb, String name)
        {
            rCb.SelectedItem = 0;
            foreach (var val in rCb.Items)
            {
                if (val == null)
                {
                    continue;
                }
                if (val.ToString().Equals(name))
                {
                    rCb.SelectedItem = val;
                    break;
                }
            }
        }

        /// <summary>
        /// B{^̌o
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnDetectB_Click(object sender, EventArgs e)
        {
            // _CAOJ
            ButtonDetectDlg detectDlg = new ButtonDetectDlg();
            detectDlg.ShowDialog();

            // R{{bNXɔf
            int buttonId = detectDlg.buttonId;
            this.selectCBItem(ref cbControllerB, buttonId.ToString());

            // j
            detectDlg.Dispose();
        }

        /// <summary>
        /// |[Y{^̌o
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnDetectPause_Click(object sender, EventArgs e)
        {
            // _CAOJ
            ButtonDetectDlg detectDlg = new ButtonDetectDlg();
            detectDlg.ShowDialog();

            // R{{bNXɔf
            int buttonId = detectDlg.buttonId;
            this.selectCBItem(ref cbControllerPause, buttonId.ToString());

            // j
            detectDlg.Dispose();
        }

        /// <summary>
        /// v_EIꂽƂ̃Cxg
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void cbFullScreenSize_SelectedIndexChanged(object sender, EventArgs e)
        {
            ScreenMode screenMode = cbFullScreenSize.SelectedItem as ScreenMode;
            if (screenMode == null)
            {
                return;
            }
            if (screenMode.mode == 0)
            {
                // XN[[hu݂ƓTCYv
                tbFullScreenWidth.Text = "-";
                tbFullScreenHeight.Text = "-";
            }
            else
            {
                tbFullScreenWidth.Text = screenMode.width.ToString();
                tbFullScreenHeight.Text = screenMode.height.ToString();
            }
        }

        /// <summary>
        /// ftHgݒ肷
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnWindowSizeDefault_Click(object sender, EventArgs e)
        {
            tbWindowWidth.Text = "768";
            tbWindowHeight.Text = "512";
        }

        /// <summary>
        /// lύX
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void slBGMVolume_Scroll(object sender, EventArgs e)
        {
            // tH[JXĂȂΉȂ
            if (!slBGMVolume.Focused)
            {
                return;
            }

            int volume = slBGMVolume.Value;
            tbBGMVolume.Text = volume.ToString();
        }

        /// <summary>
        /// eLXgҏW̃CxgiBGM{[j
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void tbBGMVolume_TextChanged(object sender, EventArgs e)
        {
            if (!tbBGMVolume.Focused)
            {
                // tH[JXĂȂȂ牽Ȃ
                return;
            }

            int vol;
            bool bRes;
            bRes = int.TryParse(tbBGMVolume.Text, out vol);
            if (bRes)
            {
                if (vol < 0) { vol = 0; }
                if (vol >= 256) { vol = 255; }
                slBGMVolume.Value = vol;
                tbBGMVolume.Text = vol.ToString();
            }
            else
            {
                tbBGMVolume.Text = slBGMVolume.Value.ToString();
            }
        }

        /// <summary>
        /// SE{[̃XC_[
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void slSEVolume_Scroll(object sender, EventArgs e)
        {
            // tH[JXĂȂΉȂ
            if (!slSEVolume.Focused)
            {
                return;
            }

            int volume = slSEVolume.Value;
            tbSEVolume.Text = volume.ToString();
        }

        /// <summary>
        /// SE{[̃eLXgύX̃Cxg
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void tbSEVolume_TextChanged(object sender, EventArgs e)
        {
            if (!tbSEVolume.Focused)
            {
                // tH[JXĂȂȂ牽Ȃ
                return;
            }

            int vol;
            bool bRes;
            bRes = int.TryParse(tbSEVolume.Text, out vol);
            if (bRes)
            {
                if (vol < 0) { vol = 0; }
                if (vol >= 256) { vol = 255; }
                slSEVolume.Value = vol;
                tbSEVolume.Text = vol.ToString();
            }
            else
            {
                tbSEVolume.Text = slSEVolume.Value.ToString();
            }
        }

        /// <summary>
        /// ftHgɖ߂{^
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button9_Click(object sender, EventArgs e)
        {
            setDefault();
        }

        /// <summary>
        /// {^
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button8_Click(object sender, EventArgs e)
        {
            DialogResult result = MessageBox.Show("I܂H\nۑĂȂf[^͎܂B"
                , "mF"
                , MessageBoxButtons.YesNo
                );
            if (result == DialogResult.Yes)
            {
                Close();
            }
        }

        /// <summary>
        /// N
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnStart_Click(object sender, EventArgs e)
        {
            // ݒۑ
            saveConfig();

            // JgfBNg擾Ă
            String currentDirectory = System.IO.Directory.GetCurrentDirectory();

            // fBNgύX
            System.IO.Directory.SetCurrentDirectory(dir);

            // t@C݂̑mF
            if (!File.Exists(exe))
            {
                System.IO.Directory.SetCurrentDirectory(currentDirectory);
                MessageBox.Show("st@C[" + exe + "]܂łB");
                return;
            }

            // s
            ProcessStartInfo pInfo = new ProcessStartInfo();
            pInfo.FileName = exe;
            Process.Start(pInfo);

            // vO
            Close();
        }

        /// <summary>
        /// ۑ{^
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnSave_Click(object sender, EventArgs e)
        {
            // ݒۑ
            saveConfig();
        }

        /// <summary>
        /// ݒt@Cۑ
        /// </summary>
        private void saveConfig()
        {
            int gameLevel = 0;
            // <<< o͐ݒ >>>
            //
            // GR[fBOݒ
            EncodingProvider provider = System.Text.CodePagesEncodingProvider.Instance;
            var encoding = provider.GetEncoding("shift-jis");

            // o͐t@CpX
            String filePath = dir + @"\" + configFile;

            // Q[x
            if (radioGLEasy.Checked) { gameLevel = 0; }
            if (radioGLNovice.Checked) { gameLevel = 1; }
            if (radioGLNormal.Checked) { gameLevel = 2; }
            if (radioGLHard.Checked) { gameLevel = 3; }

            // <<< t@Co͂ >>>
            //
            StreamWriter sw = new StreamWriter(filePath, false, encoding);
            sw.WriteLine("#=========================================================================");
            sw.WriteLine("# KonKon-BLADE ݒt@C");
            sw.WriteLine("#=========================================================================");
            //
            // Rg[
            //
            sw.WriteLine("#---------------------------------------");
            sw.WriteLine("# Controller setting.");
            sw.WriteLine("#---------------------------------------");
            sw.WriteLine("CONTROLLER_ID=" + (cbControllerId.Text.Equals("-") ? "" : cbControllerId.Text));
            //
            sw.WriteLine("#");
            //
            sw.WriteLine("TRIGGER_A=" + (cbControllerA.Text.Equals("-") ? "" : cbControllerA.Text));
            sw.WriteLine("TRIGGER_B=" + (cbControllerB.Text.Equals("-") ? "" : cbControllerB.Text));
            sw.WriteLine("TRIGGER_PAUSE=" + (cbControllerPause.Text.Equals("-") ? "" : cbControllerPause.Text));
            sw.WriteLine("TRIGGER_SS=" + strScreenShotTrigger);
            //
            sw.WriteLine("#");
            //
            sw.WriteLine("KEYBOARD_A=" + (cbKeyboardA.Text.Equals("-") ? "" : cbKeyboardA.Text));
            sw.WriteLine("KEYBOARD_B=" + (cbKeyboardB.Text.Equals("-") ? "" : cbKeyboardB.Text));
            sw.WriteLine("KEYBOARD_PAUSE=" + (cbKeyboardPause.Text.Equals("-") ? "" : cbKeyboardPause.Text));
            sw.WriteLine("KEYBOARD_SS=" + strScreenShotKey);
            //
            sw.WriteLine("#");
            sw.WriteLine("#---------------------------------------");
            sw.WriteLine("# Screen setting.");
            sw.WriteLine("#---------------------------------------");
            sw.WriteLine("FULLSCREEN=" + (rbFullscreen.Checked == true ? "TRUE" : "FALSE"));
            sw.WriteLine("FULLSCREEN_MODE=" + ((ScreenMode)(cbFullScreenSize.SelectedItem)).mode);
            sw.WriteLine("FULLSCREEN_WIDTH=" + (tbFullScreenWidth.Text.Equals("-") ? "" : tbFullScreenWidth.Text));
            sw.WriteLine("FULLSCREEN_HEIGHT=" + (tbFullScreenHeight.Text.Equals("-") ? "" : tbFullScreenHeight.Text));
            sw.WriteLine("FULLSCREEN_DISPLAY=" + (cbFullScreenDisplayNo.SelectedIndex == 0 ? "" : cbFullScreenDisplayNo.SelectedItem.ToString()));
            sw.WriteLine("FULLSCREEN_VIRTUAL=" + (cbVirtualFullScreenMode.Checked == true ? "TRUE" : "FALSE"));
            sw.WriteLine("#");
            sw.WriteLine("WINDOWMODE_WIDTH=" + (tbWindowWidth.Text.Equals("-") ? "" : tbWindowWidth.Text));
            sw.WriteLine("WINDOWMODE_HEIGHT=" + (tbWindowHeight.Text.Equals("-") ? "" : tbWindowHeight.Text));
            //
            sw.WriteLine("#");
            sw.WriteLine("WAIT_VSYNC=" + ((checkWaitVSync.Checked) ? "TRUE" : "FALSE"));
            //
            sw.WriteLine("#");
            sw.WriteLine("#---------------------------------------");
            sw.WriteLine("# Sound setting.");
            sw.WriteLine("#---------------------------------------");
            sw.WriteLine("BGM_VOLUME=" + tbBGMVolume.Text);
            sw.WriteLine("SE_VOLUME=" + tbSEVolume.Text);
            //
            sw.WriteLine("#");
            sw.WriteLine("#---------------------------------------");
            sw.WriteLine("# MISC setting.");
            sw.WriteLine("#---------------------------------------");
            sw.WriteLine("XVI_MODE=" + (cbXVIMode.Checked == true ? "TRUE" : "FALSE"));
            sw.WriteLine("BILINEAR_FILTER=" + (cbBilinearFilter.Checked == true ? "TRUE" : "FALSE"));
            sw.WriteLine("REPLAY_MODE=" + strReplayMode);
            sw.WriteLine("SCORE_LOG=" + strScoreLog);
            sw.WriteLine("GAME_LEVEL=" + gameLevel);

            // <<<  >>>
            //
            sw.Close();
        }

        /// <summary>
        /// ݒt@Cǂݍ
        /// </summary>
        private void LoadConfig()
        {
            EncodingProvider provider = System.Text.CodePagesEncodingProvider.Instance;
            var encoding = provider.GetEncoding("shift-jis");

            // pXmF
            String path = dir + @"\" + configFile;
            if (!File.Exists(path))
            {
                // ݂ȂΉɏI
                return;
            }

            // [h
            var lines = File.ReadAllLines(path, encoding);

            // 1s
            foreach (String line in lines)
            {
                // so
                Debug.WriteLine(line);

                // s͖
                if (line.Trim().Length == 0)
                {
                    continue;
                }

                // 擪 # Ȃ疳
                String head = line.Trim().Substring(0, 1);
                if (head.Equals("#"))
                {
                    continue;
                }

                // = ŕ
                String[] keyValue = line.Split("=");
                if (keyValue.Length < 2)
                {
                    // lȂ玟
                    continue;
                }

                // l擾
                String key = keyValue[0];
                String value = keyValue[1];

                // ݒ𔽉f
                setConfigKeyValue(key, value);
            }

            // Ԃ𐮂
            if (cbFullScreenSize.SelectedIndex > 0)
            {
                // tXN[̑II
                bool bResWidth, bResHeight;
                int width, height;
                bResWidth = int.TryParse(tbFullScreenWidth.Text, out width);
                bResHeight = int.TryParse(tbFullScreenHeight.Text, out height);
                if (bResWidth && bResHeight)
                {
                    ScreenMode screenMode = new ScreenMode(width, height);
                    String modeString = screenMode.ToString();
                    selectCBItem(ref cbFullScreenSize, modeString);
                }
            }
            else
            {
                tbFullScreenWidth.Text = "-";
                tbFullScreenHeight.Text = "-";
            }

            // I
        }

        /// <summary>
        /// ݒKey-Value𔽉f
        /// </summary>
        /// <param name="key"></param>
        /// <param name="value"></param>
        private void setConfigKeyValue(String key, String value)
        {
            switch (key)
            {
                case "CONTROLLER_ID":
                    selectCBItem(ref cbControllerId, value);
                    break;

                case "TRIGGER_A":
                    selectCBItem(ref cbControllerA, value);
                    break;

                case "TRIGGER_B":
                    selectCBItem(ref cbControllerB, value);
                    break;

                case "TRIGGER_PAUSE":
                    selectCBItem(ref cbControllerPause, value);
                    break;

                case "TRIGGER_SS":
                    strScreenShotTrigger = value;
                    break;

                case "KEYBOARD_A":
                    selectCBItem(ref cbKeyboardA, value);
                    break;

                case "KEYBOARD_B":
                    selectCBItem(ref cbKeyboardB, value);
                    break;

                case "KEYBOARD_PAUSE":
                    selectCBItem(ref cbKeyboardPause, value);
                    break;

                case "KEYBOARD_SS":
                    strScreenShotKey = value;
                    break;

                case "FULLSCREEN":
                    if (value.Equals("TRUE"))
                    {
                        rbFullscreen.Checked = true;
                        rbWindowMode.Checked = false;
                    }
                    else
                    {
                        rbFullscreen.Checked = false;
                        rbWindowMode.Checked = true;
                    }
                    break;

                case "FULLSCREEN_MODE":
                    if (value.Equals("0"))
                    {
                        // ủ݂𑜓xvI
                        cbFullScreenSize.SelectedIndex = 0;
                    }
                    else
                    {
                        // U2ڂ̑IIł
                        cbFullScreenSize.SelectedIndex = 1;
                    }
                    break;

                case "FULLSCREEN_WIDTH":
                    tbFullScreenWidth.Text = value;
                    break;

                case "FULLSCREEN_HEIGHT":
                    tbFullScreenHeight.Text = value;
                    break;

                case "FULLSCREEN_DISPLAY":
                    if (value.Equals(""))
                    {
                        cbFullScreenDisplayNo.SelectedIndex = 0;
                    }
                    else
                    {
                        selectCBItem(ref cbFullScreenDisplayNo, value);
                    }
                    break;

                case "FULLSCREEN_VIRTUAL":
                    if (value.Equals("TRUE"))
                    {
                        cbVirtualFullScreenMode.Checked = true;
                    }
                    else
                    {
                        cbVirtualFullScreenMode.Checked = false;
                    }
                    break;

                case "WINDOWMODE_WIDTH":
                    tbWindowWidth.Text = value;
                    break;

                case "WINDOWMODE_HEIGHT":
                    tbWindowHeight.Text = value;
                    break;

                case "WAIT_VSYNC":
                    if (value.Equals("TRUE"))
                    {
                        checkWaitVSync.Checked = true;
                    } else
                    {
                        checkWaitVSync.Checked = false;
                    }
                    break;

                case "BGM_VOLUME":
                    {
                        int vol;
                        bool bRes = int.TryParse(value, out vol);
                        if (!bRes) { vol = 127; }
                        if (vol < 0) { vol = 0; }
                        if (vol > 255) { vol = 255; }
                        tbBGMVolume.Text = vol.ToString();
                        slBGMVolume.Value = vol;
                    }
                    break;

                case "SE_VOLUME":
                    {
                        int vol;
                        bool bRes = int.TryParse(value, out vol);
                        if (!bRes) { vol = 127; }
                        if (vol < 0) { vol = 0; }
                        if (vol > 255) { vol = 255; }
                        tbSEVolume.Text = vol.ToString();
                        slSEVolume.Value = vol;
                    }
                    break;

                case "XVI_MODE":
                    if (value.Equals("TRUE"))
                    {
                        cbXVIMode.Checked = true;
                    }
                    else
                    {
                        cbXVIMode.Checked = false;
                    }
                    break;

                case "BILINEAR_FILTER":
                    if (value.Equals("TRUE"))
                    {
                        cbBilinearFilter.Checked = true;
                    }
                    else
                    {
                        cbBilinearFilter.Checked = false;
                    }
                    break;

                case "REPLAY_MODE":
                    strReplayMode = value;
                    break;

                case "SCORE_LOG":
                    strScoreLog = value;
                    break;

                case "GAME_LEVEL":
                    radioGLEasy.Checked = false;
                    radioGLNovice.Checked = false;
                    radioGLNormal.Checked = false;
                    radioGLHard.Checked = false;
                    if (value.Equals("0")) { radioGLEasy.Checked = true; }
                    if (value.Equals("1")) { radioGLNovice.Checked = true; }
                    if (value.Equals("2")) { radioGLNormal.Checked = true; }
                    if (value.Equals("3")) { radioGLHard.Checked = true; }
                    break;

                default:
                    Debug.WriteLine("[ERROR] sȃL[w肳܂BKey = " + key);
                    break;
            }
        }

        /// <summary>
        /// }jAQƂ
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnManual_Click(object sender, EventArgs e)
        {
            // t@C݂邩mF
            if (System.IO.File.Exists(manualHtmlPath))
            {
                // ̃uEUŊJ
                Process.Start(new ProcessStartInfo
                {
                    FileName = manualHtmlPath,
                    UseShellExecute = true
                });
            }
            else
            {
                MessageBox.Show("HTMLt@C܂B", "G[", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        /// <summary>
        /// CXg[tH_\
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void buttonShowFolder_Click(object sender, EventArgs e)
        {
            // Explorers
            ProcessStartInfo pInfo = new ProcessStartInfo();
            pInfo.FileName = "explorer.exe";
            pInfo.ArgumentList.Add(dir);
            Process.Start(pInfo);
        }
    }
}
