﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Diagnostics;
using System.Runtime.InteropServices;
using static KonConf.ButtonDetectDlg;
using System.Drawing.Printing;

namespace KonConf
{
    /// <summary>
    /// ボタンが押されたことを判定するためのダイアログ
    /// </summary>
    public partial class ButtonDetectDlg : Form
    {
        // 全ての情報を取得する。取得しておいて損はないだろう。
        const int JOY_RETURNALL = 0x0FF;

        /// <summary>
        /// スティックの入力情報を格納する構造体
        /// </summary>
        [StructLayout(LayoutKind.Sequential)]
        public struct JOYINFOEX
        {
            public int dwSize;
            public int dwFlags;
            public int dwXpos;
            public int dwYpos;
            public int dwZpos;
            public int dwRpos;
            public int dwUpos;
            public int dwVpos;
            public int dwButtons;
            public int dwButtonNumber;
            public int dwPOV;
            public int dwReserved1;
            public int dwReserved2;
        }

        /// <summary>
        /// ドライバがサポートしているスティック数を得る
        /// </summary>
        /// <returns></returns>
        [DllImport("winmm.dll")]
        public static extern int joyGetNumDevs();

        /// <summary>
        /// スティックの入力情報を得る
        /// </summary>
        /// <param name="uJoyID"></param>
        /// <param name="pji"></param>
        /// <returns></returns>
        [DllImport("winmm.dll")]
        public static extern int joyGetPosEx(int uJoyID, ref JOYINFOEX pji);

        // スティック情報の格納先
        public JOYINFOEX pji;

        //=============================
        // 取得情報
        //=============================
        /// <summary>
        /// ジョイスティックのID
        /// </summary>
        public int stickId;

        /// <summary>
        /// ボタン入力状態（raw）
        /// </summary>
        public int buttons;

        /// <summary>
        /// ボタンID
        /// </summary>
        public int buttonId;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public ButtonDetectDlg()
        {
            // 属性値を初期化する
            stickId = -1;
            buttonId = -1;

            // スティック情報の格納先を初期化する
            this.pji = new JOYINFOEX();
            this.pji.dwSize = Marshal.SizeOf(pji);
            this.pji.dwFlags = JOY_RETURNALL;

            // コンポーネント初期化
            InitializeComponent();
        }

        /// <summary>
        /// 閉じるボタン
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnCancel_Click(object sender, EventArgs e)
        {
            pollingTimer.Stop();
            Close();
        }

        /// <summary>
        /// 画面表示直後のイベント
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ButtonDetectDlg_Load(object sender, EventArgs e)
        {
            pollingTimer.Interval = 50;
            pollingTimer.Start();
        }

        /// <summary>
        /// タイマーイベント
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void pollingTimer_Tick(object sender, EventArgs e)
        {
            // サイズ確認
            //Debug.WriteLine("px=" + button1.Location.X+", py="+button1.Location.Y);
            //Debug.WriteLine("X="+btnCancel.Location.X + ", Y="+btnCancel.Location.Y+", w="+btnCancel.Width+", h="+btnCancel.Height);
            int w = btnCancel.Location.X + btnCancel.Width + button1.Location.X;
            int h = btnCancel.Location.Y + btnCancel.Height + button1.Location.Y;
            ClientSize = new Size(w, h);

            // スティックの最大数を得る
            int devs = joyGetNumDevs();
            //Debug.WriteLine("Joy count = " + devs);

            // スティックごとに確認していく
            this.stickId = -1;
            for (int i = 0; i < devs; i++)
            {
                // 情報を得る
                joyGetPosEx(i, ref pji);

                // 入力があったら抜ける
                if (pji.dwButtons != 0)
                {
                    this.stickId = i;
                    this.buttons = pji.dwButtons;
                    break;
                }
            }

            // 入力がなければ、ここまで
            if(this.stickId == -1)
            {
                return;
            }

            // 入力があったら値を更新する
            for(int i=0;i<32;i++)
            {
                int pressed = this.buttons & (1 << i);
                if(pressed!=0)
                {
                    this.buttonId = i;
                    break;
                }
            }

            // ポーリングを終了して閉じる
            pollingTimer.Stop();
            Close();
        }
    }
}
