// _VF[_[̓
struct VS_INPUT
{
	float4 Position                 : POSITION0 ;		// W( [J )
	float3 Normal                   : NORMAL0 ;			// @( [J )
	float4 Diffuse                  : COLOR0 ;			// fBt[YJ[
	float4 Specular                 : COLOR1 ;			// XyLJ[
	float4 TexCoords0               : TEXCOORD0 ;		// eNX`W
} ;

// _VF[_[̏o
struct VS_OUTPUT
{
	float4 ProjectionPosition       : POSITION ;	// W( ˉe )
	float4 ViewPosition             : TEXCOORD0 ;	// W( r[ )
	float4 ProjectionPositionSub    : TEXCOORD1 ;	// W( ˉe )sNZVF[_[ŎQƂׂ̕
	float4 Diffuse                  : COLOR0 ;		// fBt[YJ[
} ;



// C++ Őݒ肷萔̒`
float4              cfProjectionMatrix[ 4 ] : register( c2  ) ;		// r[@@@ˉes
float4              cfViewMatrix[ 3 ]       : register( c6  ) ;		// [h@@r[s
float4              cfLocalWorldMatrix[ 3 ] : register( c94 ) ;		// [J@@[hs


// main֐
VS_OUTPUT main( VS_INPUT VSInput )
{
	VS_OUTPUT VSOutput ;
	float4 lWorldPosition ;


	// _Wϊ ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++( Jn )

	// [JW[hWɕϊ
	lWorldPosition.x = dot( VSInput.Position, cfLocalWorldMatrix[ 0 ] ) ;
	lWorldPosition.y = dot( VSInput.Position, cfLocalWorldMatrix[ 1 ] ) ;
	lWorldPosition.z = dot( VSInput.Position, cfLocalWorldMatrix[ 2 ] ) ;
	lWorldPosition.w = 1.0f ;

	// [hWr[Wɕϊ
	VSOutput.ViewPosition.x = dot( lWorldPosition, cfViewMatrix[ 0 ] ) ;
	VSOutput.ViewPosition.y = dot( lWorldPosition, cfViewMatrix[ 1 ] ) ;
	VSOutput.ViewPosition.z = dot( lWorldPosition, cfViewMatrix[ 2 ] ) ;
	VSOutput.ViewPosition.w = 1.0f ;

	// r[WˉeWɕϊ
	VSOutput.ProjectionPosition.x = dot( VSOutput.ViewPosition, cfProjectionMatrix[ 0 ] ) ;
	VSOutput.ProjectionPosition.y = dot( VSOutput.ViewPosition, cfProjectionMatrix[ 1 ] ) ;
	VSOutput.ProjectionPosition.z = dot( VSOutput.ViewPosition, cfProjectionMatrix[ 2 ] ) ;
	VSOutput.ProjectionPosition.w = dot( VSOutput.ViewPosition, cfProjectionMatrix[ 3 ] ) ;
	
	// _Wϊ ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++( I )


	// sNZVF[_[Ŏgp邽߂̎ˉeWZbg
	VSOutput.ProjectionPositionSub = VSOutput.ProjectionPosition ;

	// fBt[YJ[͂̂܂ܓn
	VSOutput.Diffuse = VSInput.Diffuse ;


	// o̓p[^Ԃ
	return VSOutput ;
}
