// ̐[ɂēx𒲐VF[_[

#include "DxLib.h"
#include <math.h>


// ʂ̉𑜓x
#define SCREEN_W			(640)
#define SCREEN_H			(480)

// [x̎擾ɎgpXN[̉𑜓x
#define DEPTH_SCREEN_W		(1024)
#define DEPTH_SCREEN_H		(512)

// J̑x
#define CAMERA_SPEED		(32.0f)


// LN^[fƃXe[Wf
int CharaModel ;		
int StageModel ;		

// [x̕`ɎgpVF[_[
int Depth_NormalMeshVS ;
int Depth_SkinMeshVS ;
int DepthPS ;

// [xĐʂ`悷VF[_[
int VolumeWaterVS ;
int VolumeWaterPS ;

// [x擾XN[
int DepthScreen ;

// ʂ̃[hW
VECTOR WaterWorldPos[ 4 ] =
{
	{ -8000.0f, 400.0f,  8000.0f },
	{  8000.0f, 400.0f,  8000.0f },
	{ -8000.0f, 400.0f, -8000.0f },
	{  8000.0f, 400.0f, -8000.0f },
} ;

// ʂ Diffuse Color
COLOR_U8 MirrorDiffuseColor =
{
	255, 255,   0, 255,
} ;

// RcԂ̕`
void World_RenderProcess( int DepthDraw )
{
	// [x`̏ꍇ͐[x`p̒_VF[_[Zbg
	if( DepthDraw )
	{
		MV1SetUseOrigShader( TRUE ) ;

		SetUsePixelShader( DepthPS ) ;
		SetUseTextureToShader( 0, -1 ) ;
	}
	else
	{
		MV1SetUseOrigShader( FALSE ) ;
	}

	// Xe[Wf̕`
	if( DepthDraw ) 
	{
		SetUseVertexShader( Depth_NormalMeshVS ) ;
	}
	MV1DrawModel( StageModel ) ;

	// LN^[f̕`
	if( DepthDraw ) 
	{
		SetUseVertexShader( Depth_SkinMeshVS ) ;
	}
	MV1DrawModel( CharaModel ) ;
}

// WinMain֐
int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow )
{
	int CameraAngle ;		// J̐px
	VECTOR CameraEyePosition ;	// J̍W
	VECTOR CameraDirection ;	// J̌Ă
	VECTOR CameraTargetPosition ;	// J̒_
	int i ;

	// EChE[hŋN
	ChangeWindowMode( TRUE );

	// ʂ̉𑜓xƐFrbg[xݒ
	SetGraphMode( SCREEN_W, SCREEN_H, 32 ) ;

	// Direct3D9Ex gp
	SetUseDirect3DVersion( DX_DIRECT3D_9EX ) ;

	// cwCȕ
	if( DxLib_Init() < 0 )
		return -1 ;

	// VF[_[fQDOgpł邩ǂ`FbN
	if( GetValidShaderVersion() < 200 )
	{
		DrawString( 0, 0, "VF[_[fQDOgpł܂", GetColor( 255,255,255 ) ) ;
		DxLib_End() ;
		return 0 ;
	}

	// [x`悷邽߂̃VF[_[ǂݍ
	Depth_NormalMeshVS = LoadVertexShader( "Depth_NormalMeshVS.vso" ) ;
	Depth_SkinMeshVS = LoadVertexShader( "Depth_SkinMeshVS.vso" ) ;
	DepthPS = LoadPixelShader( "DepthPS.pso" ) ;

	// [x`悷eNX`̍쐬( P`l_PUrbgeNX` )
	SetCreateDrawValidGraphChannelNum( 1 ) ;
	SetDrawValidFloatTypeGraphCreateFlag( TRUE ) ;
	SetCreateGraphChannelBitDepth( 16 ) ;
	DepthScreen = MakeScreen( DEPTH_SCREEN_W, DEPTH_SCREEN_H, FALSE ) ;
	SetCreateDrawValidGraphChannelNum( 0 ) ;
	SetDrawValidFloatTypeGraphCreateFlag( FALSE ) ;
	SetCreateGraphChannelBitDepth( 0 ) ;

	// [xĐʂ`悷VF[_[̓ǂݍ
	VolumeWaterVS = LoadVertexShader( "VolumeWaterVS.vso" ) ;
	VolumeWaterPS = LoadPixelShader( "VolumeWaterPS.pso" ) ;

	// LN^[f̓ǂݍ
	CharaModel = MV1LoadModel( "DxChara.x" ) ;

	// Xe[Wf̓ǂݍ
	StageModel = MV1LoadModel( "Stage.mqo" ) ;

	// Xe[Wf̔zu
	MV1SetPosition( StageModel, VGet( 0.0f, 800.0f, 0.0f ) ) ;

	// LN^[f̐ݒu
	MV1SetPosition( CharaModel, VGet( 0.0f, 0.0f, -3500.0f ) ) ;
	MV1SetRotationXYZ( CharaModel, VGet( 0.0f, 3.14159f / 2.0f, 0.0f ) ) ;
	MV1AttachAnim( CharaModel, 7 ) ;

	// J̊px
	CameraAngle = 325 ;

	// J̍WZbg
	CameraEyePosition = VGet( -2605.0f, 670.0f, -2561.0f ) ;

	// CǧZbg
	SetLightDirection( VGet( 1.0f, -1.0f, -1.0f ) ) ;

	// C[v(L[ꂽ烋[v𔲂)
	while( ProcessMessage() == 0 )
	{
		// EL[ꂽJ]
		if( CheckHitKey( KEY_INPUT_LEFT  ) )
		{
			CameraAngle += 3 ;
			if( CameraAngle > 360 )
			{
				CameraAngle -= 360 ;
			}
		}
		if( CheckHitKey( KEY_INPUT_RIGHT ) )
		{
			CameraAngle -= 3 ;
			if( CameraAngle < 0 )
			{
				CameraAngle += 360 ;
			}
		}

		// J̌ĂZo
		CameraDirection.x = cos( CameraAngle * 3.14159f / 180.0f ) ;
		CameraDirection.y = 0.0f ;
		CameraDirection.z = sin( CameraAngle * 3.14159f / 180.0f ) ;

		// ㉺L[ꂽJOiEi
		if( CheckHitKey( KEY_INPUT_UP ) )
		{
			CameraEyePosition = VAdd( CameraEyePosition, VScale( CameraDirection, CAMERA_SPEED ) ) ;
		}
		if( CheckHitKey( KEY_INPUT_DOWN ) )
		{
			CameraEyePosition = VSub( CameraEyePosition, VScale( CameraDirection, CAMERA_SPEED ) ) ;
		}

		// J̒_WZo
		CameraTargetPosition = VAdd( CameraEyePosition, CameraDirection ) ;

		// ɂ
		CameraTargetPosition.y -= 0.3f ;
		
		// [x`
		{
			// `[xXN[ɕύX
			SetDrawScreen( DepthScreen ) ;

			// ʂ
			ClearDrawScreen() ;

			// `͈͂ʃTCYɌ
			SetDrawArea( 0, 0, SCREEN_W, SCREEN_H ) ;

			// _ʃTCY̒SɕύX
			SetCameraScreenCenter( SCREEN_W / 2.0f, SCREEN_H / 2.0f ) ;

			// \ʂɍ悤ɃXP[O
			SetDraw3DScale( ( float )SCREEN_H / DEPTH_SCREEN_H ) ;

			// J̐ݒs
			SetCameraPositionAndTarget_UpVecY( CameraEyePosition, CameraTargetPosition ) ;

			// f̕`
			World_RenderProcess( TRUE ) ;

			// XP[Oݒɖ߂
			SetDraw3DScale( 1.0f ) ;
		}
		
		// ʏ탂f̕`
		{
			// `𗠉ʂɕύX
			SetDrawScreen( DX_SCREEN_BACK ) ;

			// J̐ݒs
			SetCameraPositionAndTarget_UpVecY( CameraEyePosition, CameraTargetPosition ) ;

			// ʂ
			ClearDrawScreen() ;

			// f̕`
			World_RenderProcess( FALSE ) ;
		}
		
		// ʂ̕`
		{
			VERTEX3DSHADER Vertex[ 6 ] ;
			FLOAT4 Param ;

			// _f[^̏
			for( i = 0 ; i < 4 ; i ++ )
			{
				Vertex[ i ].pos = WaterWorldPos[ i ] ;
				Vertex[ i ].dif = MirrorDiffuseColor ;
			}
			Vertex[ 4 ] = Vertex[ 2 ] ;
			Vertex[ 5 ] = Vertex[ 1 ] ;

			// gpVF[_[̃Zbg
			SetUseVertexShader( VolumeWaterVS ) ;
			SetUsePixelShader( VolumeWaterPS ) ;

			// gpeNX`ƂĐ[xXN[Zbg
			SetUseTextureToShader( 0, DepthScreen ) ;

			// sxőɂȂ鋗Zbg
			Param.x = 6000.0f ;
			Param.y = 0.0f ;
			Param.z = 0.0f ;
			Param.w = 0.0f ;
			SetPSConstF( 0, Param ) ;

			// ŒsxZbg
			Param.x = 0.1f ;
			SetPSConstF( 1, Param ) ;

			// [xeNX`̎gpĂTCYZbg
			Param.x = ( float )SCREEN_W / DEPTH_SCREEN_W ;
			Param.y = ( float )SCREEN_H / DEPTH_SCREEN_H ;
			SetPSConstF( 2, Param ) ;

			// `uh[hAt@uhɃZbg
			SetDrawBlendMode( DX_BLENDMODE_ALPHA, 255 ) ;

			// yobt@gp
			SetUseZBufferFlag( TRUE ) ;

			// yobt@ɏ݂s
			SetWriteZBufferFlag( TRUE ) ;

			// |S̕`
			DrawPolygon3DToShader( Vertex, 2 ) ;

			// `uh[h߂
			SetDrawBlendMode( DX_BLENDMODE_NOBLEND, 255 ) ;
		}
	
		// ʂ̓e\ʂɔf
		ScreenFlip();
	}

	// cwCǔn
	DxLib_End();

	// \tg̏I
	return 0;
}
