// _VF[_[̓
struct VS_INPUT
{
	float4 Position                 : POSITION0 ;		// W( [J )
	float4 MirrorProjectionPosition : POSITION1 ;		// ɉff̎_ł̎ˉeW
	float3 Normal                   : NORMAL0 ;			// @( [J )
	float4 Diffuse                  : COLOR0 ;			// fBt[YJ[
	float4 Specular                 : COLOR1 ;			// XyLJ[
	float4 TexCoords0               : TEXCOORD0 ;		// eNX`W
} ;

// _VF[_[̏o
struct VS_OUTPUT
{
	float4 ProjectionPosition       : POSITION ;	// ˉeW
	float4 MirrorProjectionPosition : TEXCOORD0 ;	// ɉff̎_ł̎ˉeW
	float4 Diffuse                  : COLOR0 ;		// fBt[YJ[
} ;



// C++ Őݒ肷萔̒`
float4              cfProjectionMatrix[ 4 ] : register( c2  ) ;		// r[@@@ˉes
float4              cfViewMatrix[ 3 ]       : register( c6  ) ;		// [h@@r[s
float4              cfLocalWorldMatrix[ 3 ] : register( c94 ) ;		// [J@@[hs


// main֐
VS_OUTPUT main( VS_INPUT VSInput )
{
	VS_OUTPUT VSOutput ;
	float4 lWorldPosition ;
	float4 lViewPosition ;


	// _Wϊ ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++( Jn )

	// [JW[hWɕϊ
	lWorldPosition.x = dot( VSInput.Position, cfLocalWorldMatrix[ 0 ] ) ;
	lWorldPosition.y = dot( VSInput.Position, cfLocalWorldMatrix[ 1 ] ) ;
	lWorldPosition.z = dot( VSInput.Position, cfLocalWorldMatrix[ 2 ] ) ;
	lWorldPosition.w = 1.0f ;

	// [hWr[Wɕϊ
	lViewPosition.x = dot( lWorldPosition, cfViewMatrix[ 0 ] ) ;
	lViewPosition.y = dot( lWorldPosition, cfViewMatrix[ 1 ] ) ;
	lViewPosition.z = dot( lWorldPosition, cfViewMatrix[ 2 ] ) ;
	lViewPosition.w = 1.0f ;

	// r[WˉeWɕϊ
	VSOutput.ProjectionPosition.x = dot( lViewPosition, cfProjectionMatrix[ 0 ] ) ;
	VSOutput.ProjectionPosition.y = dot( lViewPosition, cfProjectionMatrix[ 1 ] ) ;
	VSOutput.ProjectionPosition.z = dot( lViewPosition, cfProjectionMatrix[ 2 ] ) ;
	VSOutput.ProjectionPosition.w = dot( lViewPosition, cfProjectionMatrix[ 3 ] ) ;
	
	// _Wϊ ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++( I )

	// fBt[YJ[͂̂܂ܓn
	VSOutput.Diffuse = VSInput.Diffuse ;

	// ɉff̎_ł̎ˉeW
	VSOutput.MirrorProjectionPosition = VSInput.MirrorProjectionPosition ;


	// o̓p[^Ԃ
	return VSOutput ;
}
