// L[RtBÕeXg

#include "DxLib.h"
#include "KeyConfig.h"

#define KEYCONFIG_FILE_NAME     "KeyConfig.txt"     // L[RtBOf[^̃t@C
#define INFO_X                  (10)                // `JnW
#define INFO_Y                  (10)
#define INFO_SPACE              (24)                // Psɋ󂯂Xy[X
#define INFO_NAME_X             (140)               // ͖`悷wW
#define INFO_INPUT_X            (320)               // ͏Ԃ`悷wW

// L[RtBOeڂ̖O
static const char *g_KeyConfigMenuTable[ KEYCONFIG_INPUT_NUM ] =
{
    "",
    "E",
    "",
    "",
    "J",
    "JE",
    "J",
    "J",
    "U",
    "Wv",
} ;

int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow )
{
    int i ;
    int Input ;
    int DrawY ;
    VECTOR CameraInput ;

    // EChE[hŋN
    ChangeWindowMode( TRUE );

    // cwCȕ
    if( DxLib_Init() < 0 ) return -1 ;

    // `𗠉ʂɂ
    SetDrawScreen( DX_SCREEN_BACK ) ;

    // L[RtBO
    KeyConfig_Initialize() ;

    // L[RtBOt@Cǂݍ
    if( KeyConfig_Load( KEYCONFIG_FILE_NAME ) == FALSE )
    {
        // RtBOt@Cǂݍ߂ȂftHgݒɂ
        KeyConfig_SetDefault() ;
    }

    // C[v
    while( ProcessMessage() == 0 )
    {
        // ʂ̃NA
        ClearDrawScreen() ;

        // L[RtBO̓͏s
        KeyConfig_InputProcess() ;

        // ͏Ԃ擾
        Input = KeyConfig_GetInput() ;

        // ڂ̐JԂ
        DrawY = INFO_Y ;
        for( i = 0; i < KEYCONFIG_INPUT_NUM; i++ )
        {
            char InputString[ 256 ] ;

            // ږ̕`
            DrawString( INFO_X, DrawY, g_KeyConfigMenuTable[ i ], GetColor( 255,255,255 ) ) ;

            // ͂Ɋ蓖ĂĂ͖擾
            KeyConfig_GetInputTypeString( i, InputString ) ;

            // 蓖ĂĂ͖`悷
            DrawString( INFO_NAME_X, DrawY, InputString, GetColor( 255,255,255 ) ) ;

            // ͏Ԃ`悷
            DrawString( INFO_INPUT_X, DrawY, ( Input & ( 1 << i ) ) != 0 ? "" : "Q", GetColor( 255,255,255 ) ) ;

            // ڂ̕`YWPڕɈړ
            DrawY += INFO_SPACE ;
        }

        // Jp͂̏Ԃ`悷
        CameraInput = KeyConfig_GetCameraInput() ;
        DrawFormatString( INFO_X, DrawY, GetColor( 255,255,255 ), "J  X:%.3f  Y:%.3f", CameraInput.x, CameraInput.y ) ;

        // ʂ̓e\ʂɔf
        ScreenFlip() ;
    }

    // cwCǔn
    DxLib_End();

    // \tg̏I
    return 0;
}
