// L[RtBO

#include "DxLib.h"
#include "KeyConfig.h"

#define KEYCONFIG_FILE_NAME     "KeyConfig.txt"     // L[RtBOf[^̃t@C
#define INFO_X                  (10)                // ̕`JnW
#define INFO_Y                  (10)
#define INFO_SPACE              (24)                // sɋ󂯂Xy[X
#define INFO_NAME_X             (140)               // ͖`悷wW

// L[RtBOΏۂ̍
int TargetIndex ;

// L[RtBOeڂ̖O
static const char *g_KeyConfigMenuTable[ KEYCONFIG_INPUT_NUM ] =
{
    "",
    "E",
    "",
    "",
    "J",
    "JE",
    "J",
    "J",
    "U",
    "Wv",
} ;

// WinMain ֐
int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow )
{
    int i ;
    int DrawY ;
    int InputWait ;

    // EChE[hŋN
    ChangeWindowMode( TRUE ) ;

    // cwCȕ
    if( DxLib_Init() < 0 ) return -1 ;

    // `𗠉ʂɂ
    SetDrawScreen( DX_SCREEN_BACK ) ;

    // L[RtBȌs
    KeyConfig_Initialize() ;

    // L[RtBOt@Cǂݍ
    if( KeyConfig_Load( KEYCONFIG_FILE_NAME ) == FALSE )
    {
        // RtBOt@Cǂݍ߂ȂftHgݒɂ
        KeyConfig_SetDefault() ;
    }

    // u͂牽ȂvtO|
    InputWait = FALSE ;

    // C[v
    while( ProcessMessage() == 0 )
    {
        // ʂ̃NA
        ClearDrawScreen() ;

        // L[RtBO̓͏s
        KeyConfig_InputProcess() ;

        // u͂牽ȂvtOĂꍇ͏𕪊
        if( InputWait == TRUE )
        {
            // ͂u͂牽ȂvtO|
            if( KeyConfig_CheckInput() == FALSE )
            {
                InputWait = FALSE ;
            }
        }
        else
        {
            // L[pbh̉Ԃ`FbNāAĂL[RtBOݒɔf
            if( KeyConfig_UpdateInputTypeInfo( TargetIndex ) )
            {
                // {^ꂽ玟̍ڂɈړ
                TargetIndex ++ ;

                // u͂牽ȂvtO𗧂Ă
                InputWait = TRUE ;
            }
        }

        // ڂ̐JԂ
        DrawY = INFO_Y ;
        for( i = 0; i < KEYCONFIG_INPUT_NUM; i++ )
        {
            int DrawColor ;
            char InputString[ 256 ] ;

            // ύXΏۂ̍ڂǂŕ`Fς
            DrawColor = TargetIndex == i ? GetColor( 255,0,0 ) : GetColor( 255,255,255 ) ;

            // ږ̕`
            DrawString( INFO_X, DrawY, g_KeyConfigMenuTable[ i ], DrawColor ) ;

            // ͂Ɋ蓖ĂĂ͖擾
            KeyConfig_GetInputTypeString( i, InputString ) ;

            // 蓖ĂĂ͖`悷
            DrawString( INFO_NAME_X, DrawY, InputString, DrawColor ) ;

            // ڂ̕`YWPڕɈړ
            DrawY += INFO_SPACE ;
        }

        // ʂ̓e\ʂɔf
        ScreenFlip() ;

        // SĂ̓͂̐ݒ肪I烋[v𔲂
        if( TargetIndex == KEYCONFIG_INPUT_NUM )
        {
            break ;
        }
    }

    // L[RtBOݒۑ
    KeyConfig_Save( KEYCONFIG_FILE_NAME ) ;

    // cwCǔn
    DxLib_End() ;

    // \tg̏I
    return 0 ;
}








