// L[RtBÕvO

#include "KeyConfig.h"
#include "DxLib.h"
#include <string.h>

#define MAX_GAMEPAD_NUM             (16)            // `FbNQ[pbh̐
#define KEY_STATE_BUFFER_SIZE       (256)           // L[{[h̓͏Ԃ擾邽߂̃obt@̃TCY
#define DIRECTINPUT_MAX_VALUE       (1000)          // DirectInput 瓾l̍ől

// DirectInput ̓͏^Cv
#define DIRECTINPUT_TYPE_X          (0)             // ͂̂w
#define DIRECTINPUT_TYPE_Y          (1)             // ͂̂x
#define DIRECTINPUT_TYPE_Z          (2)             // ͂̂y
#define DIRECTINPUT_TYPE_RX         (3)             // ͂̂w]
#define DIRECTINPUT_TYPE_RY         (4)             // ͂̂x]
#define DIRECTINPUT_TYPE_RZ         (5)             // ͂̂y]
#define DIRECTINPUT_TYPE_POV        (6)             // Rg[
#define DIRECTINPUT_TYPE_BUTTON     (7)             // {^
#define DIRECTINPUT_TYPE_KEY        (8)             // L[{[h̃L[

// L[{[ĥPL[ӂ̏
struct KEYINFO
{
    int             KeyInput;           // ̓R[h( KEY_INPUT_LEFT Ȃ )
    const char *    Name;               // L[̖O
};

// Q[ł̓͂ƃL[pbhȂǂ̓͂Ƃ̑Ή
struct KEYCONFIGINFO
{
    int             PadNo;              // pbhԍ
    int             DirectInputType;    // DirectInput ̓͏^Cv( DIRECTINPUT_TYPE_X Ȃ )
    int             SubInfo[ 2 ];       // Tu( DirectInputType ɂĈӖς )
};

// ͏p̏
struct KEYCONFIGSYSTEMDATA
{
    KEYCONFIGINFO   KeyConfigInfo[ KEYCONFIG_INPUT_NUM ];           // Q[̓͂ƃL[pbhȂǂ̓͂Ƃ̑Ή
    DINPUT_JOYSTATE NeutralDirectInputState[ MAX_GAMEPAD_NUM ];     // DirectInput ̃pbh̏͏
    DINPUT_JOYSTATE DirectInputState[ MAX_GAMEPAD_NUM ];            // DirectInput ̃pbh̓͏
    char            NeutralKeyInput[ KEY_STATE_BUFFER_SIZE ];       // L[̏͏
    char            KeyInput[ KEY_STATE_BUFFER_SIZE ];              // L[̓͏
    int             ButtonInput;                                    // {^̓͏
    int             ButtonEdgeInput;                                // {^̉ꂽuԂ݂̂̓͏
    VECTOR          CameraStickInput;                               // Jp̓͏
};

// ͏p̏
static KEYCONFIGSYSTEMDATA g_KeyConfSys;

// Q[ł̊e͂ƃL[pbhȂǂ̓͂Ƃ̃ftHg̑Ήݒ
static KEYCONFIGINFO g_DefaultInputTypeInfo[ KEYCONFIG_INPUT_NUM ] =
{
    0, DIRECTINPUT_TYPE_X,      -1, 0,      // KEYCONFIG_INPUT_LEFT
    0, DIRECTINPUT_TYPE_X,       1, 0,      // KEYCONFIG_INPUT_RIGHT
    0, DIRECTINPUT_TYPE_Y,      -1, 0,      // KEYCONFIG_INPUT_UP 
    0, DIRECTINPUT_TYPE_Y,       1, 0,      // KEYCONFIG_INPUT_DOWN 
    0, DIRECTINPUT_TYPE_RX,     -1, 0,      // KEYCONFIG_INPUT_CAMERA_LEFT
    0, DIRECTINPUT_TYPE_RX,      1, 0,      // KEYCONFIG_INPUT_CAMERA_RIGHT
    0, DIRECTINPUT_TYPE_RY,     -1, 0,      // KEYCONFIG_INPUT_CAMERA_UP
    0, DIRECTINPUT_TYPE_RY,      1, 0,      // KEYCONFIG_INPUT_CAMERA_DOWN
    0, DIRECTINPUT_TYPE_BUTTON,  0, 0,      // KEYCONFIG_INPUT_ATTACK
    0, DIRECTINPUT_TYPE_BUTTON,  2, 0,      // KEYCONFIG_INPUT_JUMP
};

// pbh̎ʎqe[u
static int g_PadIDTable[ MAX_GAMEPAD_NUM ] =
{
    DX_INPUT_PAD1,
    DX_INPUT_PAD2,
    DX_INPUT_PAD3,
    DX_INPUT_PAD4,
    DX_INPUT_PAD5,
    DX_INPUT_PAD6,
    DX_INPUT_PAD7,
    DX_INPUT_PAD8,
    DX_INPUT_PAD9,
    DX_INPUT_PAD10,
    DX_INPUT_PAD11,
    DX_INPUT_PAD12,
    DX_INPUT_PAD13,
    DX_INPUT_PAD14,
    DX_INPUT_PAD15,
    DX_INPUT_PAD16,
};

// L[R[h̏
static KEYINFO g_KeyInfoTable[] =
{
    KEY_INPUT_BACK,         "BACK",         // obNXy[XL[
    KEY_INPUT_TAB,          "TAB",          // ^uL[
    KEY_INPUT_RETURN,       "ENTER",        // G^[L[

    KEY_INPUT_LSHIFT,       "L SHIFT",      // VtgL[
    KEY_INPUT_RSHIFT,       "R SHIFT",      // EVtgL[
    KEY_INPUT_LCONTROL,     "L CONTROL",    // Rg[L[
    KEY_INPUT_RCONTROL,     "R CONTROL",    // ERg[L[
    KEY_INPUT_ESCAPE,       "ESCAPE",       // GXP[vL[
    KEY_INPUT_SPACE,        "SPACE",        // Xy[XL[
    KEY_INPUT_PGUP,         "PAGE UP",      // otoL[
    KEY_INPUT_PGDN,         "PAGE DOWN",    // ocL[
    KEY_INPUT_END,          "END",          // GhL[
    KEY_INPUT_HOME,         "HOME",         // z[L[
    KEY_INPUT_LEFT,         "LEFT",         // L[
    KEY_INPUT_UP,           "UP",           // L[
    KEY_INPUT_RIGHT,        "RIGHT",        // EL[
    KEY_INPUT_DOWN,         "DOWN",         // L[
    KEY_INPUT_INSERT,       "INSERT",       // CT[gL[
    KEY_INPUT_DELETE,       "DELETE",       // f[gL[

    KEY_INPUT_MINUS,        "-",            // |L[
    KEY_INPUT_YEN,          "\\",           // L[
    KEY_INPUT_PREVTRACK,    "^",            // OL[
    KEY_INPUT_PERIOD,       ".",            // DL[
    KEY_INPUT_SLASH,        "/",            // ^L[
    KEY_INPUT_LALT,         "L ALT",        // `ksL[
    KEY_INPUT_RALT,         "R ALT",        // E`ksL[
    KEY_INPUT_SCROLL,       "SCROLL LOCK",  // ScrollLockL[
    KEY_INPUT_SEMICOLON,    ";",            // GL[
    KEY_INPUT_COLON,        ":",            // FL[
    KEY_INPUT_LBRACKET,     "[",            // mL[
    KEY_INPUT_RBRACKET,     "]",            // nL[
    KEY_INPUT_AT,           "@",            // L[
    KEY_INPUT_BACKSLASH,    "BACK SLASH",   // _L[
    KEY_INPUT_COMMA,        ",",            // CL[
    KEY_INPUT_KANJI,        "KANJI",        // L[
    KEY_INPUT_CONVERT,      "CONVERT",      // ϊL[
    KEY_INPUT_NOCONVERT,    "NO CONVERT",   // ϊL[
    KEY_INPUT_KANA,         "KANA",         // JiL[
    KEY_INPUT_APPS,         "APPS",         // AvP[Vj[L[
    KEY_INPUT_CAPSLOCK,     "CAPS LOCK",    // CaspLockL[
    KEY_INPUT_SYSRQ,        "PRINT SCREEN", // PrintScreenL[
    KEY_INPUT_PAUSE,        "PAUSE BREAK",  // PauseBreakL[
    KEY_INPUT_LWIN,         "L WIN",        // vL[
    KEY_INPUT_RWIN,         "R WIN",        // EvL[

    KEY_INPUT_NUMLOCK,      "NUM LOCK",     // eL[O
    KEY_INPUT_NUMPAD0,      "NUMPAD 0",     // eL[O
    KEY_INPUT_NUMPAD1,      "NUMPAD 1",     // eL[P
    KEY_INPUT_NUMPAD2,      "NUMPAD 2",     // eL[Q
    KEY_INPUT_NUMPAD3,      "NUMPAD 3",     // eL[R
    KEY_INPUT_NUMPAD4,      "NUMPAD 4",     // eL[S
    KEY_INPUT_NUMPAD5,      "NUMPAD 5",     // eL[T
    KEY_INPUT_NUMPAD6,      "NUMPAD 6",     // eL[U
    KEY_INPUT_NUMPAD7,      "NUMPAD 7",     // eL[V
    KEY_INPUT_NUMPAD8,      "NUMPAD 8",     // eL[W
    KEY_INPUT_NUMPAD9,      "NUMPAD 9",     // eL[X
    KEY_INPUT_MULTIPLY,     "NUMPAD *",     // eL[L[
    KEY_INPUT_ADD,          "NUMPAD +",     // eL[{L[
    KEY_INPUT_SUBTRACT,     "NUMPAD -",     // eL[|L[
    KEY_INPUT_DECIMAL,      "NUMPAD .",     // eL[DL[
    KEY_INPUT_DIVIDE,       "NUMPAD /",     // eL[^L[
    KEY_INPUT_NUMPADENTER,  "NUMPAD ENTER", // eL[̃G^[L[

    KEY_INPUT_F1,           "F1",           // ePL[
    KEY_INPUT_F2,           "F2",           // eQL[
    KEY_INPUT_F3,           "F3",           // eRL[
    KEY_INPUT_F4,           "F4",           // eSL[
    KEY_INPUT_F5,           "F5",           // eTL[
    KEY_INPUT_F6,           "F6",           // eUL[
    KEY_INPUT_F7,           "F7",           // eVL[
    KEY_INPUT_F8,           "F8",           // eWL[
    KEY_INPUT_F9,           "F9",           // eXL[
    KEY_INPUT_F10,          "F10",          // ePOL[
    KEY_INPUT_F11,          "F11",          // ePPL[
    KEY_INPUT_F12,          "F12",          // ePQL[

    KEY_INPUT_A,            "A",            // `L[
    KEY_INPUT_B,            "B",            // aL[
    KEY_INPUT_C,            "C",            // bL[
    KEY_INPUT_D,            "D",            // cL[
    KEY_INPUT_E,            "E",            // dL[
    KEY_INPUT_F,            "F",            // eL[
    KEY_INPUT_G,            "G",            // fL[
    KEY_INPUT_H,            "H",            // gL[
    KEY_INPUT_I,            "I",            // hL[
    KEY_INPUT_J,            "J",            // iL[
    KEY_INPUT_K,            "K",            // jL[
    KEY_INPUT_L,            "L",            // kL[
    KEY_INPUT_M,            "M",            // lL[
    KEY_INPUT_N,            "N",            // mL[
    KEY_INPUT_O,            "O",            // nL[
    KEY_INPUT_P,            "P",            // oL[
    KEY_INPUT_Q,            "Q",            // pL[
    KEY_INPUT_R,            "R",            // qL[
    KEY_INPUT_S,            "S",            // rL[
    KEY_INPUT_T,            "T",            // sL[
    KEY_INPUT_U,            "U",            // tL[
    KEY_INPUT_V,            "V",            // uL[
    KEY_INPUT_W,            "W",            // vL[
    KEY_INPUT_X,            "X",            // wL[
    KEY_INPUT_Y,            "Y",            // xL[
    KEY_INPUT_Z,            "Z",            // yL[

    KEY_INPUT_0,            "0",            // OL[
    KEY_INPUT_1,            "1",            // PL[
    KEY_INPUT_2,            "2",            // QL[
    KEY_INPUT_3,            "3",            // RL[
    KEY_INPUT_4,            "4",            // SL[
    KEY_INPUT_5,            "5",            // TL[
    KEY_INPUT_6,            "6",            // UL[
    KEY_INPUT_7,            "7",            // VL[
    KEY_INPUT_8,            "8",            // WL[
    KEY_INPUT_9,            "9",            // XL[

    -1,                     NULL,
};

// L[RtBȌs
void KeyConfig_Initialize( void )
{
    int              i;
    int              PadNum;

    // pbh̐擾
    PadNum = GetJoypadNum();

    // pbh̐vOΉĂ鐔葽ꍇ́AΉĂ鐔ɐ
    if( PadNum > MAX_GAMEPAD_NUM )
    {
        PadNum = MAX_GAMEPAD_NUM;
    }

    // pbh̏Ԃ DirectInput 擾
    for( i = 0; i < PadNum; i++ )
    {
        GetJoypadDirectInputState( g_PadIDTable[ i ], &g_KeyConfSys.NeutralDirectInputState[ i ] );
    }

    // L[͂̏Ԃ擾
    GetHitKeyStateAll( g_KeyConfSys.NeutralKeyInput );
}

// KeyConfig_InputProcess p̎̓^Cv̏s⏕֐
static void KeyConfig_InputProcess_Assist(
    // ʂϐ̃AhX
    int *InputState,

    // ̓^CṽTu
    //    (  1:InputValue vX̒l̏ꍇɓ͂Ƃ
    //      -1:InputValue }CiX̒l̏ꍇɓ͂Ƃ )
    int SubInfo,

    // ͂̒l
    int InputValue
)
{
    // Tu 1  -1 ŏ𕪊
    switch( SubInfo )
    {
    case 1:     // 1̏ꍇ InputValue vX̏ꍇ̂ݓ͂Ƃ
        if( InputValue > 0 )
        {
            *InputState = InputValue;
        }
        break;

    case -1:    // -1̏ꍇ InputValue vX̏ꍇ̂ݓ͂Ƃ
        if( InputValue < 0 )
        {
            *InputState = -InputValue;
        }
        break;
    }
}

// L[RtBO̓͏s( t[s )
void KeyConfig_InputProcess( void )
{
    int              i;
    KEYCONFIGINFO   *KCInfo;
    int              InputState[ KEYCONFIG_INPUT_NUM ];
    int              PadNum;
    DINPUT_JOYSTATE *DIJState;
    int              ButtonPrevInput;
    int              Total;

    // pbh̐擾
    PadNum = GetJoypadNum();

    // pbh̐vOΉĂ鐔葽ꍇ́AΉĂ鐔ɐ
    if( PadNum > MAX_GAMEPAD_NUM )
    {
        PadNum = MAX_GAMEPAD_NUM;
    }

    // pbh̓͏ DirectInput 擾
    for( i = 0; i < PadNum; i++ )
    {
        GetJoypadDirectInputState( g_PadIDTable[ i ], &g_KeyConfSys.DirectInputState[ i ] );
    }

    // ݂̃L[̓͏Ԃ擾
    GetHitKeyStateAll( g_KeyConfSys.KeyInput );

    // Q[Ŏgp͏\z
    KCInfo = g_KeyConfSys.KeyConfigInfo;
    for( i = 0; i < KEYCONFIG_INPUT_NUM; i++, KCInfo++ )
    {
        // w͂ȂxԂɂĂ
        InputState[ i ] = 0;

        // Ή DirectInput ̏^Cvɂď𕪊
        DIJState = KCInfo->PadNo < 0 ? NULL : &g_KeyConfSys.DirectInputState[ KCInfo->PadNo ];
        switch( KCInfo->DirectInputType )
        {
        case DIRECTINPUT_TYPE_X:    // ͂̂w̏ꍇ
            KeyConfig_InputProcess_Assist( &InputState[ i ], KCInfo->SubInfo[ 0 ], DIJState->X );
            break;

        case DIRECTINPUT_TYPE_Y:    // ͂̂x̏ꍇ
            KeyConfig_InputProcess_Assist( &InputState[ i ], KCInfo->SubInfo[ 0 ], DIJState->Y );
            break;

        case DIRECTINPUT_TYPE_Z:    // ͂̂y̏ꍇ
            KeyConfig_InputProcess_Assist( &InputState[ i ], KCInfo->SubInfo[ 0 ], DIJState->Z );
            break;

        case DIRECTINPUT_TYPE_RX:   // ͂̂w]̏ꍇ
            KeyConfig_InputProcess_Assist( &InputState[ i ], KCInfo->SubInfo[ 0 ], DIJState->Rx );
            break;

        case DIRECTINPUT_TYPE_RY:   // ͂̂x]̏ꍇ
            KeyConfig_InputProcess_Assist( &InputState[ i ], KCInfo->SubInfo[ 0 ], DIJState->Ry );
            break;

        case DIRECTINPUT_TYPE_RZ:   // ͂̂y]̏ꍇ
            KeyConfig_InputProcess_Assist( &InputState[ i ], KCInfo->SubInfo[ 0 ], DIJState->Rz );
            break;

        case DIRECTINPUT_TYPE_POV:  // Rg[̏ꍇ
            // ݒ肳Ăɓ͂Ăw͂xɂ
            if( DIJState->POV[ KCInfo->SubInfo[ 0 ] ] == KCInfo->SubInfo[ 1 ] )
            {
                InputState[ i ] = DIRECTINPUT_MAX_VALUE;
            }
            break;

        case DIRECTINPUT_TYPE_BUTTON:   // {^̏ꍇ
            // ݒ肳Ă{^Ăw͂xɂ
            if( DIJState->Buttons[ KCInfo->SubInfo[ 0 ] ] == 128 )
            {
                InputState[ i ] = DIRECTINPUT_MAX_VALUE;
            }
            break;

        case DIRECTINPUT_TYPE_KEY:  // L[{[h̃L[̏ꍇ
            // ݒ肳ĂL[Ăw͂xɂ
            if( g_KeyConfSys.KeyInput[ KCInfo->SubInfo[ 0 ] ] )
            {
                InputState[ i ] = DIRECTINPUT_MAX_VALUE;
            }
            break;
        }
    }

    // Pt[O̓͏ԂƂĂ
    ButtonPrevInput = g_KeyConfSys.ButtonInput;

    // ͏Ԃ̏
    g_KeyConfSys.ButtonInput = 0;

    // e͂ɑΉrbgw͂x̏ꍇ͗Ă
    for( i = 0; i < KEYCONFIG_INPUT_NUM; i++ )
    {
        if( InputState[ i ] > 0 )
        {
            g_KeyConfSys.ButtonInput |= 1 << i;
        }
    }

    // ̃t[Łw͂xɂȂn߂rbgZo
    g_KeyConfSys.ButtonEdgeInput = g_KeyConfSys.ButtonInput & ~ButtonPrevInput;

    // Jp̓͏ԂZo
    Total = InputState[ KEYCONFIG_INPUT_CAMERA_RIGHT ] - InputState[ KEYCONFIG_INPUT_CAMERA_LEFT ];
    g_KeyConfSys.CameraStickInput.x = Total / ( float )DIRECTINPUT_MAX_VALUE;

    Total = InputState[ KEYCONFIG_INPUT_CAMERA_DOWN  ] - InputState[ KEYCONFIG_INPUT_CAMERA_UP   ];
    g_KeyConfSys.CameraStickInput.y = Total / ( float )DIRECTINPUT_MAX_VALUE;

    g_KeyConfSys.CameraStickInput.z = 0.0f;
}

// {^̓͏Ԃ擾( ߂l : {^̓͏ )
int KeyConfig_GetInput( void )
{
    return g_KeyConfSys.ButtonInput;
}

// {^̉ꂽuԂ݂̂̓͏Ԃ擾( ߂l : {^̉ꂽuԂ݂̂̓͏ )
int KeyConfig_GetEdgeInput( void )
{
    return g_KeyConfSys.ButtonEdgeInput;
}

// Jp̓͏Ԃ擾( ߂l : Jp̓͏ )
VECTOR KeyConfig_GetCameraInput( void )
{
    return g_KeyConfSys.CameraStickInput;
}

// L[RtBOݒt@Cɕۑ( ߂l : ۑFTRUE   ۑsFFALSE )
int KeyConfig_Save( const char *FilePath )
{
    FILE          *fp;
    KEYCONFIGINFO *KCInfo;
    int            i;

    // Ήۑt@CJ
    fp = fopen( FilePath, "wt" );
    if( fp == NULL )
    {
        // JȂ牽ɏI
        return FALSE;
    }

    // Q[̊e͂ƃL[pbhȂǂ̓͂Ƃ̑Ήt@Cɏo
    KCInfo = g_KeyConfSys.KeyConfigInfo;
    for( i = 0; i < KEYCONFIG_INPUT_NUM; i++, KCInfo++ )
    {
        fprintf( fp, "PadNo = %d  DirectInputType = %d  SubInfo0 = %d  SubInfo1 = %d \n",
            KCInfo->PadNo,
            KCInfo->DirectInputType,
            KCInfo->SubInfo[ 0 ],
            KCInfo->SubInfo[ 1 ]
        );
    }

    // t@C
    fclose( fp );

    // I
    return TRUE;
}

// L[RtBOݒt@Cǂݍ( ߂l : ǂݍݐFTRUE   ǂݍݎsFFALSE )
int KeyConfig_Load( const char *FilePath )
{
    FILE          *fp;
    KEYCONFIGINFO *KCInfo;
    int            i;

    // Ήۑt@CJ
    fp = fopen( FilePath, "rt" );
    if( fp == NULL )
    {
        // JȂꍇ͉ɏI
        return FALSE;
    }

    // Q[̊e͂ƃL[pbhȂǂ̓͂Ƃ̑Ήt@Cǂݍ
    KCInfo = g_KeyConfSys.KeyConfigInfo;
    for( i = 0; i < KEYCONFIG_INPUT_NUM; i++, KCInfo++ )
    {
        fscanf( fp, "PadNo = %d  DirectInputType = %d  SubInfo0 = %d  SubInfo1 = %d \n",
            &KCInfo->PadNo,
            &KCInfo->DirectInputType,
            &KCInfo->SubInfo[ 0 ],
            &KCInfo->SubInfo[ 1 ]
        );
    }

    // t@C
    fclose( fp );

    // I
    return TRUE;
}

// L[RtBOݒftHgɂ
void  KeyConfig_SetDefault( void )
{
    int i;

    // ftHgݒ̏Rs[
    for( i = 0; i < KEYCONFIG_INPUT_NUM; i++ )
    {
        g_KeyConfSys.KeyConfigInfo[ i ] = g_DefaultInputTypeInfo[ i ];
    }
}

// UpdateInputTypeInfo p̎̓^Cv̏s⏕֐
static void UpdateInputTypeInfo_Assist(
    KEYCONFIGINFO *KCInfo,                  // L[pbhȂǂ̓͏
    int           *ValidMaxDInput,          // MaxInput ɗLȒlĂ邩ǂۑĂϐ̃AhX
    int           *MaxDInput,               // Lȓ͒l̍őlۑĂϐ̃AhX
    int            PadNo,                   // pbhԍ
    int            DirectInputType,         // DirectInput ̓͏^Cv
    int            DirectInputValue,        // DirectInput ̓͒l
    int            NeutralDirectInputValue  // Ԃ DirectInput ̓͒l
)
{
    // Ԃƒlꍇ͉Ȃ
    if( DirectInputValue == NeutralDirectInputValue )
    {
        return;
    }

    // DirectInput ̓͒l}CiXvXŏ𕪊
    if( DirectInputValue < 0 )
    {
        // MaxDirectInputValue ɂ܂LȒlĂȂ
        //  MaxDirectInputValue ̒l DirectInputValue ̒l傫`FbN
        if( *ValidMaxDInput == FALSE || *MaxDInput < -DirectInputValue )
        {
            // ۑ
            KCInfo->PadNo             = PadNo;
            KCInfo->DirectInputType   = DirectInputType;
            KCInfo->SubInfo[ 0 ]      = -1;
            KCInfo->SubInfo[ 1 ]      = 0;

            *ValidMaxDInput = TRUE;
            *MaxDInput      = -DirectInputValue;
        }
    }
    else
    if( DirectInputValue > 0 )
    {
        // MaxDirectInputValue ɂ܂LȒlĂȂ
        //  MaxDirectInputValue ̒l DirectInputValue ̒l傫`FbN
        if( *ValidMaxDInput == FALSE || *MaxDInput < DirectInputValue )
        {
            // ۑ
            KCInfo->PadNo             = PadNo;
            KCInfo->DirectInputType   = DirectInputType;
            KCInfo->SubInfo[ 0 ]      = 1;
            KCInfo->SubInfo[ 1 ]      = 0;

            *ValidMaxDInput = TRUE;
            *MaxDInput      = DirectInputValue;
        }
    }
}

// ݉ĂL[pbh̓͏`FbNāA͂ꍇ͏XV( L[RtBOʗp )
//     ߂l : ͂ǂ( TRUE:͂  FALSE:͖͂ )
int KeyConfig_UpdateInputTypeInfo( int UpdateInputType )
{
    int              i;
    int              j;
    int              ValidMaxDInput;
    int              MaxDInput;
    int              PadNum;
    DINPUT_JOYSTATE *DIJState;
    DINPUT_JOYSTATE *NDIJState;
    KEYCONFIGINFO   *KCInfo = &g_KeyConfSys.KeyConfigInfo[ UpdateInputType ];
    int              Result;

    // ߂ĺw͂xɂĂ
    Result = FALSE;

    // ڑĂpbh̐擾
    PadNum = GetJoypadNum();

    // pbh̐vOΉĂ鐔葽ꍇ́AΉĂ鐔ɐ
    if( PadNum > MAX_GAMEPAD_NUM )
    {
        PadNum = MAX_GAMEPAD_NUM;
    }

    // wMaxDInput ɗLȒlĂ邩ǂx̃tO|A
    // MaxDInput ̒lĂ
    ValidMaxDInput = FALSE;
    MaxDInput      = 0;

    // SẴpbh̓͏Ԃ`FbN
    DIJState  = g_KeyConfSys.DirectInputState;
    NDIJState = g_KeyConfSys.NeutralDirectInputState;
    for( i = 0; i < PadNum; i++, DIJState++, NDIJState++ )
    {
        // ͏Ԃ`FbN
        UpdateInputTypeInfo_Assist( KCInfo, &ValidMaxDInput, &MaxDInput, i, DIRECTINPUT_TYPE_X,  DIJState->X,  NDIJState->X );
        UpdateInputTypeInfo_Assist( KCInfo, &ValidMaxDInput, &MaxDInput, i, DIRECTINPUT_TYPE_Y,  DIJState->Y,  NDIJState->Y );
        UpdateInputTypeInfo_Assist( KCInfo, &ValidMaxDInput, &MaxDInput, i, DIRECTINPUT_TYPE_Z,  DIJState->Z,  NDIJState->Z );
        UpdateInputTypeInfo_Assist( KCInfo, &ValidMaxDInput, &MaxDInput, i, DIRECTINPUT_TYPE_RX, DIJState->Rx, NDIJState->Rx );
        UpdateInputTypeInfo_Assist( KCInfo, &ValidMaxDInput, &MaxDInput, i, DIRECTINPUT_TYPE_RY, DIJState->Ry, NDIJState->Ry );
        UpdateInputTypeInfo_Assist( KCInfo, &ValidMaxDInput, &MaxDInput, i, DIRECTINPUT_TYPE_RZ, DIJState->Rz, NDIJState->Rz );

        // Rg[̓͏Ԃ`FbN
        for( j = 0; j < 4; j++ )
        {
            // POV LȒl( -1 ȊO̒l )ŁAԂƈقȂ邩`FbN
            if( DIJState->POV[ j ] != -1 &&
                DIJState->POV[ j ] != NDIJState->POV[ j ] )
            {
                // ۑ
                KCInfo->PadNo           = i;
                KCInfo->DirectInputType = DIRECTINPUT_TYPE_POV;
                KCInfo->SubInfo[ 0 ]    = j;
                KCInfo->SubInfo[ 1 ]    = DIJState->POV[ j ];

                // ߂lw͂xɂ
                Result = TRUE;
            }
        }

        // {^̓͏Ԃ`FbN
        for( j = 0; j < 32; j++ )
        {
            // {^ĂāAԂƈقȂ邩`FbN
            if( DIJState->Buttons[ j ] == 128 &&
                DIJState->Buttons[ j ] != NDIJState->Buttons[ j ] )
            {
                // ۑ
                KCInfo->PadNo           = i;
                KCInfo->DirectInputType = DIRECTINPUT_TYPE_BUTTON;
                KCInfo->SubInfo[ 0 ]    = j;
                KCInfo->SubInfo[ 1 ]    = 0;

                // ߂lw͂xɂ
                Result = TRUE;
            }
        }
    }

    // ValidMaxDirectInputValue  true ̏ꍇ́ALȓ͂ƂƂȂ̂Ŗ߂lw͂xɂ
    if( ValidMaxDInput )
    {
        Result = TRUE;
    }

    // L[̓͏Ԃ`FbN
    for( i = 0; i < KEY_STATE_BUFFER_SIZE; i++ )
    {
        // ͂ԂƈقȂ邩`FbN
        if( g_KeyConfSys.KeyInput[ i ] != g_KeyConfSys.NeutralKeyInput[ i ] )
        {
            // ۑ
            KCInfo->PadNo           = -1;
            KCInfo->DirectInputType = DIRECTINPUT_TYPE_KEY;
            KCInfo->SubInfo[ 0 ]    = i;

            // ߂lw͂xɂ
            Result = TRUE;
        }
    }

    // ͂ǂԂ
    return Result;
}

// pbhL[̓͂邩ǂ擾( L[RtBOʗp )
//     ߂l : ͂ǂ( TRUE:͂  FALSE:͖͂ )
int KeyConfig_CheckInput( void )
{
    int              i;
    int              PadNum;

    // ڑĂpbh̐擾
    PadNum = GetJoypadNum();

    // pbh̐vOΉĂ鐔葽ꍇ́AΉĂ鐔ɐ
    if( PadNum > MAX_GAMEPAD_NUM )
    {
        PadNum = MAX_GAMEPAD_NUM;
    }

    // SẴpbh̓͏Ԃ`FbN
    for( i = 0; i < PadNum; i++ )
    {
        // ԂƏ񂪈قȂꍇ͉͂ƂƂȂ̂ŁATRUE Ԃ
        if( memcmp( &g_KeyConfSys.DirectInputState[ i ],
                        &g_KeyConfSys.NeutralDirectInputState[ i ], sizeof( DINPUT_JOYSTATE ) ) != 0 )
        {
            return TRUE;
        }
    }

    // L[̓͏ԂԂƈقȂꍇ̓L[̓͂ƂƂȂ̂ TRUE Ԃ
    if( memcmp( g_KeyConfSys.NeutralKeyInput, g_KeyConfSys.KeyInput, sizeof( g_KeyConfSys.NeutralKeyInput ) ) != 0 )
    {
        return TRUE;
    }

    // ɗƂƂ͉͂ƂƂȂ̂ FALSE Ԃ
    return FALSE;
}

// w̓͏^CvɊ蓖ĂĂpbhL[̖̓͂O擾( L[RtBOʗp )
void KeyConfig_GetInputTypeString( int InputType, char *InputString )
{
    KEYCONFIGINFO *KCInfo = &g_KeyConfSys.KeyConfigInfo[ InputType ];
    KEYINFO       *KInfo;
    char           String[ 256 ];

    // L[{[h͂ǂŏ𕪊
    if( KCInfo->DirectInputType == DIRECTINPUT_TYPE_KEY )
    {
        // L[R[h̏e[uɖL[R[hłꍇɔāAŏ UNKNOWN Ă
        strcpy( InputString, "Key UNKNOWN" );

        // vL[R[he[uT
        for( KInfo = g_KeyInfoTable; KInfo->Name != NULL; KInfo++ )
        {
            if( KInfo->KeyInput == KCInfo->SubInfo[ 0 ] )
            {
                sprintf( InputString, "Key %s", KInfo->Name );
                break;
            }
        }
    }
    else
    {
        // pbh͖̓͐擪Ƀpbh̔ԍt
        sprintf( String, "Pad No.%d", KCInfo->PadNo );

        // ΉĂpbh DirectInput ̏^Cvɂĕ
        switch( KCInfo->DirectInputType )
        {
        case DIRECTINPUT_TYPE_X:        // X͂̏ꍇ̓vX̏ꍇ RIGHTA}CiX̏ꍇ LEFT t
            sprintf( InputString, "%s %s",   String, KCInfo->SubInfo[ 0 ] > 0 ? "RIGHT" : "LEFT" );
            break;

        case DIRECTINPUT_TYPE_Y:        // Y͂̏ꍇ̓vX̏ꍇ DOWNA}CiX̏ꍇ UP t
            sprintf( InputString, "%s %s",   String, KCInfo->SubInfo[ 0 ] > 0 ? "DOWN" : "UP" );
            break;

        case DIRECTINPUT_TYPE_Z:        // Z͂̏ꍇ̓vX̏ꍇ +A}CiX̏ꍇ - t
            sprintf( InputString, "%s %sZ",  String, KCInfo->SubInfo[ 0 ] > 0 ? "+" : "-" );
            break;

        case DIRECTINPUT_TYPE_RX:       // X]͂̏ꍇ̓vX̏ꍇ +A}CiX̏ꍇ - t
            sprintf( InputString, "%s %sRx", String, KCInfo->SubInfo[ 0 ] > 0 ? "+" : "-" );
            break;

        case DIRECTINPUT_TYPE_RY:       // Y]͂̏ꍇ̓vX̏ꍇ +A}CiX̏ꍇ - t
            sprintf( InputString, "%s %sRy", String, KCInfo->SubInfo[ 0 ] > 0 ? "+" : "-" );
            break;

        case DIRECTINPUT_TYPE_RZ:       // Z]͂̏ꍇ̓vX̏ꍇ +A}CiX̏ꍇ - t
            sprintf( InputString, "%s %sRz", String, KCInfo->SubInfo[ 0 ] > 0 ? "+" : "-" );
            break;

        case DIRECTINPUT_TYPE_POV:      // Rg[͂̏ꍇ POV ł邱ƂƁAPOV̏ԍƓ͊pxt
            sprintf( InputString, "%s POV %d Angle %d", String, KCInfo->SubInfo[ 0 ], KCInfo->SubInfo[ 1 ] / 100 );
            break;

        case DIRECTINPUT_TYPE_BUTTON:   // {^͂̏ꍇ BUTTON ƃ{^ԍt
            sprintf( InputString, "%s BUTTON %d", String, KCInfo->SubInfo[ 0 ] );
            break;
        }
    }
}


