// sNZVF[_[̓
struct PS_INPUT
{
	float4 MirrorProjectionPosition : TEXCOORD0 ;	// ɉff̎_ł̎ˉeW
	float3 ViewPosition             : TEXCOORD1 ;	// W( r[ )
	float3 ViewNormal               : TEXCOORD2 ;	// @( r[ )
	float4 Diffuse                  : COLOR0 ;		// fBt[YJ[
};

// sNZVF[_[̏o
struct PS_OUTPUT
{
	float4 Color0         : COLOR0 ;
};


// C++ Őݒ肷萔̒`
sampler  MirrorTexture : register( s0 ) ;		// ɉfeNX`

float4   cfMulColor : register( c0  ) ;			// eNX`FɏZF


// main֐
PS_OUTPUT main( PS_INPUT PSInput )
{
	PS_OUTPUT PSOutput ;
	float2 TexCoords ;
	float4 TexColor ;
	float refractiveRatio ;

	// eNX`W̎Zo
	TexCoords.x = PSInput.MirrorProjectionPosition.x / PSInput.MirrorProjectionPosition.w ;
	TexCoords.y = PSInput.MirrorProjectionPosition.y / PSInput.MirrorProjectionPosition.w ;

	// ɉfeNX`F擾
	TexColor = tex2D( MirrorTexture, TexCoords ) ;

	// fBt[YJ[ƏZďo͂ɃZbg
	PSOutput.Color0 = TexColor * PSInput.Diffuse ;


	// ̋ܗ = 1.333    C̋ܗ = 1.000293
	refractiveRatio = 1.333f / 1.000293f ;

	// tl˗vZ( }yP[ǂƃRl̃tlˉp )
	float A = refractiveRatio ;
	float B = dot( -normalize( PSInput.ViewPosition ), normalize( PSInput.ViewNormal ) ) ;
	float C = sqrt( 1.0f - A * A * ( 1 - B * B ) ) ;
	float Rs = ( A * B - C ) * ( A * B - C ) / ( ( A * B + C ) * ( A * B + C ) ) ;
	float Rp = ( A * C - B ) * ( A * C - B ) / ( ( A * C + B ) * ( A * C + B ) ) ;
	float alpha = ( Rs + Rp ) / 2.0f ;

	alpha = min( alpha + 0.20f, 1.0f ) ; 

	// At@lZbg
	PSOutput.Color0.a = alpha ;

   
	return PSOutput ;
}
