// tlˊ{

#include "DxLib.h"
#include <math.h>


// ʂ̉𑜓x
#define SCREEN_W			(640)
#define SCREEN_H			(480)

// ɉff̎擾ɎgpXN[̉𑜓x
#define MIRROR_SCREEN_W		(1024)
#define MIRROR_SCREEN_H		(512)

// ̐
#define MIRROR_NUM			(1)

// J̑x
#define CAMERA_SPEED		(32.0f)


// LN^[fƃXe[Wf
int CharaModel ;		
int StageModel ;		

// s_VF[_[ƃsNZVF[_[
int FresnelReflectionVS ;
int FresnelReflectionPS ;

// ɉff̎擾ɎgpXN[
int MirrorHandle[ MIRROR_NUM ] ;

// ɉff̎擾ɎgpN[̒̋̎l̍W( W )
FLOAT4 MirrorScreenPosW[ MIRROR_NUM ][ 4 ] ;

// ̃[hW
VECTOR MirrorWorldPos[ MIRROR_NUM ][ 4 ] =
{
	{
		{ -4000.0f, 400.0f,  4500.0f },
		{  4000.0f, 400.0f,  4500.0f },
		{ -4000.0f, 400.0f, -4500.0f },
		{  4000.0f, 400.0f, -4500.0f },
	}
} ;

//  Diffuse Color
COLOR_U8 MirrorDiffuseColor[ MIRROR_NUM ] =
{
	{ 255, 255,   0, 255 },
} ;


// ̏
void Mirror_Initialize( void ) ;

// ɉff`悷邽߂̃J̐ݒs
void Mirror_SetupCamera( int MirrorNo, VECTOR CameraEyePos, VECTOR CameraTargetPos ) ;

// ̕`
void Mirror_Render( int MirrorNo ) ;

// RcԂ̕`
void World_RenderProcess() ;


// ̏
void Mirror_Initialize( void )
{
	int i ;

	// tlˏs߂̒_VF[_[ƃsNZVF[ǂݍ
	FresnelReflectionVS = LoadVertexShader( "FresnelReflectionVS.vso" ) ;
	FresnelReflectionPS = LoadPixelShader( "FresnelReflectionPS.pso" ) ;

	// ɉff̎擾ɎgpXN[̍쐬
	for( i = 0 ; i < MIRROR_NUM ; i ++ )
	{
		MirrorHandle[ i ] = MakeScreen( MIRROR_SCREEN_W, MIRROR_SCREEN_H, FALSE ) ;
	}
}

// ɉff`悷邽߂̃J̐ݒs
void Mirror_SetupCamera( int MirrorNo, VECTOR CameraEyePos, VECTOR CameraTargetPos )
{
	int i ;
	float EyeLength, TargetLength ;
	VECTOR MirrorNormal ;
	VECTOR *MirrorWorldPosP ;
	VECTOR MirrorCameraEyePos, MirrorCameraTargetPos ;

	MirrorWorldPosP = MirrorWorldPos[ MirrorNo ] ;

	// ̖ʂ̖@Zo
	MirrorNormal = VNorm( VCross( VSub( MirrorWorldPosP[ 1 ], MirrorWorldPosP[ 0 ] ), VSub( MirrorWorldPosP[ 2 ], MirrorWorldPosP[ 0 ] ) ) ) ;

	// ̖ʂJ̍W܂ł̍ŒZA̖ʂJ̒_܂ł̍ŒZZo
	EyeLength    = Plane_Point_MinLength( MirrorWorldPosP[ 0 ], MirrorNormal, CameraEyePos    ) ;
	TargetLength = Plane_Point_MinLength( MirrorWorldPosP[ 0 ], MirrorNormal, CameraTargetPos ) ;

	// ɉff`悷ۂɎgpJ̍WƃJ̒_Zo
	MirrorCameraEyePos    = VAdd( CameraEyePos,    VScale( MirrorNormal, -EyeLength    * 2.0f ) ) ;
	MirrorCameraTargetPos = VAdd( CameraTargetPos, VScale( MirrorNormal, -TargetLength * 2.0f ) ) ;

	// vZœꂽJ̍WƃJ̒_̍WJ̐ݒ肷
	SetCameraPositionAndTarget_UpVecY( MirrorCameraEyePos, MirrorCameraTargetPos ) ;

	// ɉff̒ł̋̎l̍WZo( W )
	for( i = 0 ; i < 4 ; i ++ )
	{
		MirrorScreenPosW[ MirrorNo ][ i ] = ConvWorldPosToScreenPosPlusW( MirrorWorldPosP[ i ] ) ;
	}
}

// ̕`
void Mirror_Render( int MirrorNo )
{
	int i ;
	VERTEX3DSHADER Vert[ 6 ] ;
	VECTOR MirrorNormal ;

	// ̖ʂ̖@Zo
	MirrorNormal = VNorm( VCross( VSub( MirrorWorldPos[ MirrorNo ][ 1 ], MirrorWorldPos[ MirrorNo ][ 0 ] ), VSub( MirrorWorldPos[ MirrorNo ][ 2 ], MirrorWorldPos[ MirrorNo ][ 0 ] ) ) ) ;

	// ̕`Ɏgp钸_̃ZbgAbv
	for( i = 0 ; i < 4 ; i ++ )
	{
		// WZbg
		Vert[ i ].pos = MirrorWorldPos[ MirrorNo ][ i ] ;

		// @Zbg
		Vert[ i ].norm = MirrorNormal ;

		// Diffuse Color Zbg
		Vert[ i ].dif = MirrorDiffuseColor[ MirrorNo ] ;

		// ⏕Wɋɉf鎋_ł̎ˉeW
		Vert[ i ].spos.x = MirrorScreenPosW[ MirrorNo ][ i ].x / MIRROR_SCREEN_W ;
		Vert[ i ].spos.y = MirrorScreenPosW[ MirrorNo ][ i ].y / MIRROR_SCREEN_H ;
		Vert[ i ].spos.z = MirrorScreenPosW[ MirrorNo ][ i ].z ;
		Vert[ i ].spos.w = MirrorScreenPosW[ MirrorNo ][ i ].w ;
	}
	Vert[ 4 ] = Vert[ 2 ] ;
	Vert[ 5 ] = Vert[ 1 ] ;

	// `惂[hoCjAtB^Oɐݒ
	SetDrawMode( DX_DRAWMODE_BILINEAR ) ;

	// `uh[hZbg
	SetDrawBlendMode( DX_BLENDMODE_ALPHA, 255 ) ;

	// `ɂyobt@gp
	SetUseZBuffer3D( TRUE ) ;

	// yobt@ɏ݂s
	SetWriteZBuffer3D( TRUE ) ;

	// gp钸_VF[_[Zbg
	SetUseVertexShader( FresnelReflectionVS ) ;

	// gpsNZVF[_[Zbg
	SetUsePixelShader( FresnelReflectionPS ) ;

	// gpeNX`Zbg
	SetUseTextureToShader( 0, MirrorHandle[ MirrorNo ] ) ;

	// tl˂̋`
	DrawPolygon3DToShader( Vert, 2 ) ;

	// yobt@ɏ݂sݒɖ߂
	SetWriteZBuffer3D( FALSE ) ;

	// yobt@gpݒɖ߂
	SetUseZBuffer3D( FALSE ) ;

	// `uh[hɖ߂
	SetDrawBlendMode( DX_BLENDMODE_NOBLEND, 255 ) ;

	// `惂[hɖ߂
	SetDrawMode( DX_DRAWMODE_NEAREST ) ;
}

// RcԂ̕`
void World_RenderProcess()
{
	// Xe[Wf̕`
	MV1DrawModel( StageModel ) ;

	// LN^[f̕`
	MV1DrawModel( CharaModel ) ;
}


// WinMain֐
int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow )
{
	int CameraAngle ;		// J̐px
	VECTOR CameraEyePosition ;	// J̍W
	VECTOR CameraDirection ;	// J̌Ă
	VECTOR CameraTargetPosition ;	// J̒_
	int i ;

	// EChE[hŋN
	ChangeWindowMode( TRUE );

	// ʂ̉𑜓xƐFrbg[xݒ
	SetGraphMode( SCREEN_W, SCREEN_H, 32 ) ;

	// Direct3D9Ex gp
	SetUseDirect3DVersion( DX_DIRECT3D_9EX ) ;

	// cwCȕ
	if( DxLib_Init() < 0 )
		return -1 ;

	// VF[_[fQDOgpł邩ǂ`FbN
	if( GetValidShaderVersion() < 200 )
	{
		DrawString( 0, 0, "VF[_[fQDOgpł܂", GetColor( 255,255,255 ) ) ;
		DxLib_End() ;
		return 0 ;
	}

	// ̏
	Mirror_Initialize() ;

	// LN^[f̓ǂݍ
	CharaModel = MV1LoadModel( "DxChara.x" ) ;

	// Xe[Wf̓ǂݍ
	StageModel = MV1LoadModel( "ColTestStage.mqo" ) ;

	// LN^[f̐ݒu
	MV1SetPosition( CharaModel, VGet( 0.0f, 0.0f, -3500.0f ) ) ;
	MV1SetRotationXYZ( CharaModel, VGet( 0.0f, 3.14159f / 2.0f, 0.0f ) ) ;
	MV1AttachAnim( CharaModel, 7 ) ;

	// J̊px
	CameraAngle = 325 ;

	// J̍WZbg
	CameraEyePosition = VGet( -2605.0f, 670.0f, -2561.0f ) ;

	// CǧZbg
	SetLightDirection( VGet( 1.0f, -1.0f, -1.0f ) ) ;

	// C[v(L[ꂽ烋[v𔲂)
	while( ProcessMessage() == 0 )
	{
		// EL[ꂽJ]
		if( CheckHitKey( KEY_INPUT_LEFT  ) )
		{
			CameraAngle += 3 ;
			if( CameraAngle > 360 )
			{
				CameraAngle -= 360 ;
			}
		}
		if( CheckHitKey( KEY_INPUT_RIGHT ) )
		{
			CameraAngle -= 3 ;
			if( CameraAngle < 0 )
			{
				CameraAngle += 360 ;
			}
		}

		// J̌ĂZo
		CameraDirection.x = cos( CameraAngle * 3.14159f / 180.0f ) ;
		CameraDirection.y = 0.0f ;
		CameraDirection.z = sin( CameraAngle * 3.14159f / 180.0f ) ;

		// ㉺L[ꂽJOiEi
		if( CheckHitKey( KEY_INPUT_UP ) )
		{
			CameraEyePosition = VAdd( CameraEyePosition, VScale( CameraDirection, CAMERA_SPEED ) ) ;
		}
		if( CheckHitKey( KEY_INPUT_DOWN ) )
		{
			CameraEyePosition = VSub( CameraEyePosition, VScale( CameraDirection, CAMERA_SPEED ) ) ;
		}

		// J̒_WZo
		CameraTargetPosition = VAdd( CameraEyePosition, CameraDirection ) ;


		// ɉff`
		for( i = 0 ; i < MIRROR_NUM ; i ++ )
		{
			// `ɉff̎擾Ɏgp摜`悷XN[ɂ
			SetDrawScreen( MirrorHandle[ i ] ) ;

			// ʂ
			ClearDrawScreen() ;

			// ɉff`悷ۂɎgpJ̐ݒs
			Mirror_SetupCamera( i, CameraEyePosition, CameraTargetPosition ) ;

			// RcԂ̕`
			World_RenderProcess() ;
		}


		// ʂ`Ώۂɂ
		SetDrawScreen( DX_SCREEN_BACK ) ;

		// ʂNA
		ClearDrawScreen() ;

		// J̐ݒs
		SetCameraPositionAndTarget_UpVecY( CameraEyePosition, CameraTargetPosition ) ;

		// RcԂ̕`
		World_RenderProcess() ;

		// ̕`
		for( i = 0 ; i < MIRROR_NUM ; i ++ )
		{
			Mirror_Render( i ) ;
		}


		// ʂ̓e\ʂɔf
		ScreenFlip();
	}

	// cwCǔn
	DxLib_End();

	// \tg̏I
	return 0;
}
