// sNZVF[_[̓
struct PS_INPUT
{
	float2 TexCoords0      : TEXCOORD0 ;
} ;

// sNZVF[_[̏o
struct PS_OUTPUT
{
	float4 Color0          : COLOR0 ;
} ;

// C++ Őݒ肷eNX`̒`
float2   cfDOF_Focus : register( c0 ) ;		// ʊE[x̃tH[JX   x:tH[JXJnʒu   y:tH[JXIʒu

sampler  ColorMapTexture0            : register( s0 ) ;		// J[}bveNX`( eNX` )
sampler  ColorMapTexture1            : register( s1 ) ;		// J[}bveNX`( アڂ̃eNX` )
sampler  ColorMapTexture2            : register( s2 ) ;		// J[}bveNX`( ڂ̃eNX` )
sampler  DepthMapTexture             : register( s3 ) ;		// [x}bveNX`

// main֐
PS_OUTPUT main( PS_INPUT PSInput )
{
	PS_OUTPUT PSOutput ;
	float4 Color1, Color2 ;
	float BlendRate ;
	float Fade ;
	float Depth ;

	// [xl擾
	Depth = tex2D( DepthMapTexture, PSInput.TexCoords0 ) ;

	// tH[JX񂩂ڂ₯Zo
	if( Depth < cfDOF_Focus.x )
	{
		Fade = 1.0f - Depth / cfDOF_Focus.x ;
	}
	else
	if( Depth < cfDOF_Focus.y )
	{
		Fade = 0.0f;
	}
	else
	{
		Fade = ( Depth - cfDOF_Focus.y ) / ( 1.0f - cfDOF_Focus.y ) ;
	}

	// ڂ₯FZo
	if( Fade < 0.5f )
	{
		// ڂ₯ 0.5f ȉ̏ꍇ͂ڂ摜Ǝアڂ摜
		Color1 = tex2D( ColorMapTexture0, PSInput.TexCoords0 ) ;
		Color2 = tex2D( ColorMapTexture1, PSInput.TexCoords0 ) ;
		BlendRate = Fade / 0.5f ;
	}
	else
	{
		// ڂ₯ 0.5f ȏ̏ꍇ͎アڂ摜Ƌڂ摜
		Color1 = tex2D( ColorMapTexture1, PSInput.TexCoords0 ) ;
		Color2 = tex2D( ColorMapTexture2, PSInput.TexCoords0 ) ;
		BlendRate = ( Fade - 0.5f ) / 0.5f ;
	}

	// F̒lZo
	PSOutput.Color0 = lerp( Color1, Color2, BlendRate ) ;
   
	return PSOutput ;    
}
