#include "DxLib.h"
#include <math.h>


// LN^[̂wW
#define CHARAMODEL_X		(-3500.0f)

// LN^[̂Plڂ̂yW
#define CHARAMODEL_Z		(-3500.0f)

// `悷LN^[̐
#define CHARAMODEL_NUM		(8)

// LN^[Pl̃Xy[X
#define CHARAMODEL_SPACE	(800.0f)


// J̑x
#define CAMERA_SPEED		(32.0f)


// ʂ̉𑜓x
#define SCREEN_W			(640)

// ʂ̏c𑜓x
#define SCREEN_H			(480)

// `peNX`̉𑜓x
#define SCREEN_TEX_W		(1024)

// `peNX`̏c𑜓x
#define SCREEN_TEX_H		(512)


// Xe[WfƃLN^[f̃nh
int StageModelHandle ;
int CharacterModelHandle ;


// ̃bVp̐[xl`p_VF[_[nh
int Depth_NormalMeshVS ;

// XLjObVp̐[xl`p_VF[_[nh
int Depth_SkinMeshVS ;

// [xl`psNZVF[_[nh
int DepthPS ;

// ʊE[xp̃sNZVF[_[nh
int DepthOfFieldPS ;


// łڂƂƂڂ̂Ƃ̕ԋ
float DepthOfField_InterpSize ;

// ڂ͈̔͂̒Sʒu
float DepthOfField_Focus ;

// ڂ͈̔
float DepthOfField_FocusSize ;

// Ԕ͈͂Ƃڂ͈̔͂̍v
float DepthOfField_TotalSize ;


// [xl`peNX`
int DepthMapTexture ;

// 0:ʏ`peNX`
// 1:ʏ`Ɏアڂ摜ۑp̃eNX`
// 2:ʏ`ɋڂ摜ۑp̃eNX`
int ColorMapTexture[ 3 ] ;


int CameraAngle ;		// J̐px
VECTOR CameraEyePosition ;	// J̍W
VECTOR CameraDirection ;	// J̌Ă
VECTOR CameraTargetPosition ;	// J̒_


// w̉ʂɂRcf`
void DrawScreen( int ScreenGraphHandle, int UseDepthShader )
{
	int i ;
	FLOAT4 ParamF ;

	// `ΏۂύX
	SetDrawScreen( ScreenGraphHandle ) ;

	// `͈͂ݒ
	SetDrawArea( 0, 0, SCREEN_W, SCREEN_H ) ;

	// _Wݒ
	SetCameraScreenCenter( SCREEN_W / 2.0f, SCREEN_H / 2.0f ) ;

	// \ʂɍ悤ɃXP[O
	SetDraw3DScale( ( float )SCREEN_H / SCREEN_TEX_H ) ;

	// ʂ
	ClearDrawScreen() ;

	// J̐ݒs
	SetCameraPositionAndTarget_UpVecY( CameraEyePosition, CameraTargetPosition ) ;

	// [xl`悷邩ǂŏ𕪊
	if( UseDepthShader != 0 )
	{
		// [xl`悷ꍇ̓IWĩVF[_[gpăf`悷ݒɂ
		MV1SetUseOrigShader( TRUE ) ;

		// [xl`悷邽߂̃sNZVF[_[Zbg
		SetUsePixelShader( DepthPS ) ;

		// ʊE[x̊JnʒuvZ
		ParamF.x = DepthOfField_Focus - DepthOfField_FocusSize / 2.0f - DepthOfField_InterpSize ;

		// ʊE[x̏IʒuvZ
		ParamF.y = DepthOfField_Focus + DepthOfField_FocusSize / 2.0f + DepthOfField_InterpSize ;

		// ʊE[x͈̔͂̋tvZ
		ParamF.z = 1.0f / ( ParamF.y - ParamF.x ) ;

		// sNZVF[_[̒萔ɃZbg
		SetPSConstF( 0, ParamF ) ;
	}
	else
	{
		// [xl`悷킯ł͂Ȃꍇ̓IWĩVF[_[͎gpȂ
		MV1SetUseOrigShader( FALSE ) ;
	}

	// [xl`悷ꍇ͒_VF[_[̃bVp̐[xl`p_VF[_[ɂ
	if( UseDepthShader != 0 )
	{
		SetUseVertexShader( Depth_NormalMeshVS ) ;
	}

	// Xe[Wf( ̃bV )`
	MV1DrawModel( StageModelHandle ) ;


	// [xl`悷ꍇ͒_VF[_[XLjObVp̐[xl`p_VF[_[ɂ
	if( UseDepthShader != 0 )
	{
		SetUseVertexShader( Depth_SkinMeshVS ) ;
	}

	// LN^[f( XLjObV )`
	for( i = 0 ; i < CHARAMODEL_NUM ; i ++ )
	{
		MV1SetPosition( CharacterModelHandle, VGet( CHARAMODEL_X, 0.0f, CHARAMODEL_Z + i * CHARAMODEL_SPACE ) ) ;
		MV1DrawModel( CharacterModelHandle ) ;
	}
}

// WinMain ֐
int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow )
{
	FLOAT4 ParamF ;
	float RightU, BottomV ;
	VERTEX2DSHADER Vertex[ 6 ] ;


	// EChE[hŋN
	ChangeWindowMode( TRUE ) ;

	// ʃ[hݒ
	SetGraphMode( SCREEN_W, SCREEN_H, 32 ) ;

	// Direct3D9Ex gp
	SetUseDirect3DVersion( DX_DIRECT3D_9EX ) ;

	// cwCȕ
	if( DxLib_Init() < 0 )
	{
		// G[璼ɏI
		return -1 ;
	}

	// VF[_[fQDOgpł邩ǂ`FbN
	if( GetValidShaderVersion() < 200 )
	{
		DrawString( 0, 0, "VF[_[fQDOgpł܂", GetColor( 255,255,255 ) ) ;
		DxLib_End() ;
		return 0 ;
	}

	// ʏ`p̃eNX`쐬
	ColorMapTexture[ 0 ] = MakeScreen( SCREEN_TEX_W, SCREEN_TEX_H, TRUE ) ;

	// ʏ`悵fɎアڂ摜ۑ邽߂̃eNX`쐬
	ColorMapTexture[ 1 ] = MakeScreen( SCREEN_TEX_W, SCREEN_TEX_H, TRUE ) ;

	// ʏ`悵fɋڂ摜ۑ邽߂̃eNX`쐬
	ColorMapTexture[ 2 ] = MakeScreen( SCREEN_TEX_W, SCREEN_TEX_H, TRUE ) ;

	// [xl`悷P`l摜쐬
	SetCreateDrawValidGraphChannelNum( 1 ) ;
	DepthMapTexture = MakeScreen( SCREEN_TEX_W, SCREEN_TEX_H, TRUE ) ;
	SetCreateDrawValidGraphChannelNum( 0 ) ;

	// Xe[WfƃLN^[f̓ǂݍ
	StageModelHandle     = MV1LoadModel( "ColTestStage.mqo" ) ;
	CharacterModelHandle = MV1LoadModel( "DxChara.x" ) ;

	// [xl`p̒_VF[_[ƃsNZVF[_[ǂݍ
	Depth_NormalMeshVS = LoadVertexShader( "Depth_NormalMeshVS.vso" ) ;
	Depth_SkinMeshVS   = LoadVertexShader( "Depth_SkinMeshVS.vso" ) ;
	DepthPS            = LoadPixelShader( "DepthPS.pso" ) ;

	// [xlgpĔʊE[xs߂̃sNZVF[_[ǂݍ
	DepthOfFieldPS     = LoadPixelShader( "DepthOfFieldPS.pso" ) ;

	// ʊE[xp̃p[^
	DepthOfField_InterpSize = 3000.0f ;
	DepthOfField_Focus = 3200.0f ;
	DepthOfField_FocusSize = 500.0f ;

	// J̊px
	CameraAngle = 90 ;

	// J̍WZbg
	CameraEyePosition = VGet( -2900.0f, 570.0f, -4600.0f ) ;

	// C[v
	while( ProcessMessage() == 0 )
	{
		// EL[ꂽJ]
		if( CheckHitKey( KEY_INPUT_LEFT  ) )
		{
			CameraAngle += 3 ;
			if( CameraAngle > 360 )
			{
				CameraAngle -= 360 ;
			}
		}
		if( CheckHitKey( KEY_INPUT_RIGHT ) )
		{
			CameraAngle -= 3 ;
			if( CameraAngle < 0 )
			{
				CameraAngle += 360 ;
			}
		}

		// J̌ĂZo
		CameraDirection.x = cos( CameraAngle * 3.14159f / 180.0f ) ;
		CameraDirection.y = 0.0f ;
		CameraDirection.z = sin( CameraAngle * 3.14159f / 180.0f ) ;

		// ㉺L[ꂽJOiEi
		if( CheckHitKey( KEY_INPUT_UP ) )
		{
			CameraEyePosition = VAdd( CameraEyePosition, VScale( CameraDirection, CAMERA_SPEED ) ) ;
		}
		if( CheckHitKey( KEY_INPUT_DOWN ) )
		{
			CameraEyePosition = VSub( CameraEyePosition, VScale( CameraDirection, CAMERA_SPEED ) ) ;
		}

		// J̒_WZo
		CameraTargetPosition = VAdd( CameraEyePosition, CameraDirection ) ;

		// p[^쏈
		{
			if( CheckHitKey( KEY_INPUT_A ) == 1 )
			{
				DepthOfField_Focus += 5.0f ;
			}

			if( CheckHitKey( KEY_INPUT_Z ) == 1 )
			{
				DepthOfField_Focus -= 5.0f ;
			}

			if( CheckHitKey( KEY_INPUT_S ) == 1 )
			{
				DepthOfField_FocusSize += 5.0f ;
			}

			if( CheckHitKey( KEY_INPUT_X ) == 1 )
			{
				DepthOfField_FocusSize -= 5.0f ;
			}

			if( CheckHitKey( KEY_INPUT_D ) == 1 )
			{
				DepthOfField_InterpSize += 5.0f ;
			}

			if( CheckHitKey( KEY_INPUT_C ) == 1 )
			{
				DepthOfField_InterpSize -= 5.0f ;
			}
		}

		// ʊE[x`̏
		{
			// Ԕ͈͂ƃtH[JXĂ͈͂܂߂Zo
			DepthOfField_TotalSize = DepthOfField_InterpSize * 2.0f + DepthOfField_FocusSize ;

			// ʏ`peNX`Ƀfʏ`
			DrawScreen( ColorMapTexture[ 0 ], FALSE ) ;

			// ʏ`̌ʂɂڂ摜ۑ
			GraphFilterRectBlt( ColorMapTexture[ 0 ], ColorMapTexture[ 1 ], 0, 0, SCREEN_W, SCREEN_H, 0, 0, DX_GRAPH_FILTER_GAUSS, 16, 200 ) ;

			// ڂ摜ɍXɂڂĕۑ
			GraphFilterRectBlt( ColorMapTexture[ 1 ], ColorMapTexture[ 2 ], 0, 0, SCREEN_W, SCREEN_H, 0, 0, DX_GRAPH_FILTER_GAUSS, 16, 200 ) ;

			// [xl`peNX`ɐ[xl`
			DrawScreen( DepthMapTexture, TRUE ) ;
		}
		

		// `𗠉ʂɕύX
		SetDrawScreen( DX_SCREEN_BACK ) ;

		// ʊE[x{摜𗠉ʂɕ`
		{
			// gpeNX`Zbg
			SetUseTextureToShader( 0, ColorMapTexture[ 0 ] ) ;
			SetUseTextureToShader( 1, ColorMapTexture[ 1 ] ) ;
			SetUseTextureToShader( 2, ColorMapTexture[ 2 ] ) ;
			SetUseTextureToShader( 3, DepthMapTexture ) ;

			// ʊE[xp̃sNZVF[_[Zbg
			SetUsePixelShader( DepthOfFieldPS ) ;

			// ʊE[x̂ڂ̊JnʒuvZ
			ParamF.x = DepthOfField_InterpSize / DepthOfField_TotalSize ;

			// ʊE[x̂ڂ̏IʒuvZ
			ParamF.y = ( DepthOfField_InterpSize + DepthOfField_FocusSize ) / DepthOfField_TotalSize ;

			// sNZVF[_[̒萔ɃZbg
			SetPSConstF( 0, ParamF ) ;

			// ʑŜɕ`悷钸_̏
			Vertex[ 0 ].pos = VGet(     0.0f,     0.0f, 0.0f ) ;
			Vertex[ 1 ].pos = VGet( SCREEN_W,     0.0f, 0.0f ) ;
			Vertex[ 2 ].pos = VGet(     0.0f, SCREEN_H, 0.0f ) ;
			Vertex[ 3 ].pos = VGet( SCREEN_W, SCREEN_H, 0.0f ) ;

			Vertex[ 0 ].rhw = 1.0f ;
			Vertex[ 1 ].rhw = 1.0f ;
			Vertex[ 2 ].rhw = 1.0f ;
			Vertex[ 3 ].rhw = 1.0f ;

			RightU  = ( float )SCREEN_W / SCREEN_TEX_W ;
			BottomV = ( float )SCREEN_H / SCREEN_TEX_H ;
			Vertex[ 0 ].u = 0.0f ;		Vertex[ 0 ].v = 0.0f ;
			Vertex[ 1 ].u = RightU ;	Vertex[ 1 ].v = 0.0f ;
			Vertex[ 2 ].u = 0.0f ;		Vertex[ 2 ].v = BottomV ;
			Vertex[ 3 ].u = RightU ;	Vertex[ 3 ].v = BottomV ;

			Vertex[ 4 ] = Vertex[ 2 ] ;
			Vertex[ 5 ] = Vertex[ 1 ] ;

			// |SQgpĉʑŜɔʊE[x{RcV[̕`
			DrawPolygon2DToShader( Vertex, 2 ) ;
		}

		// p[^`
		DrawFormatString( 0, 0, GetColor( 255,255,255 ), "ԋ:%.1f ڂS:%.3f ڂ͈:%.3f",
							DepthOfField_InterpSize, DepthOfField_Focus, DepthOfField_FocusSize ) ;

		// L[`
		DrawString( 0, 480 - 16, "AZL[:ڂSύX@SXL[:ڂ͈͕ύX@DCL[:ԋύX", GetColor( 255,255,255 ) ) ;
		DrawString( 0, 480 - 32, "L[:J̑", GetColor( 255,255,255 ) ) ;

		// ʂ̓e\ʂɔf
		ScreenFlip() ;
	}


	// cwCǔn
	DxLib_End() ;

	// \tg̏I
	return 0 ;
}
