// _VF[_[̓
struct VS_INPUT
{
	float4 Position        : POSITION ;         // W( [J )
	int4   BlendIndices0   : BLENDINDICES0 ;    // XLjOp Float^萔zCfbNX
	float4 BlendWeight0    : BLENDWEIGHT0 ;     // XLjOpEGCgl
	float3 Normal          : NORMAL0 ;          // @( [J )
	float4 Diffuse         : COLOR0 ;           // fBt[YJ[
	float4 Specular        : COLOR1 ;           // XyLJ[
	float4 TexCoords0      : TEXCOORD0 ;        // eNX`W
} ;

// _VF[_[̏o
struct VS_OUTPUT
{
	float4 Position        : POSITION ;     // W( ˉe )
	float4 Diffuse         : COLOR0 ;       // fBt[YJ[
	float4 Specular        : COLOR1 ;       // XyLJ[
	float2 TexCoords0      : TEXCOORD0 ;    // eNX`W
	float4 DPPosition0     : TEXCOORD1 ;    // [xobt@O_O̍W( ˉe )
	float4 DPPosition1     : TEXCOORD2 ;    // [xobt@P_O̍W( ˉe )
	float4 DPPosition2     : TEXCOORD3 ;    // [xobt@Q_O̍W( ˉe )
	float4 DPPosition3     : TEXCOORD4 ;    // [xobt@R_O̍W( ˉe )
	float4 DPPosition4     : TEXCOORD5 ;    // [xobt@S_O̍W( ˉe )
	float4 DPPosition5     : TEXCOORD6 ;    // [xobt@T_O̍W( ˉe )
} ;

// }eAp[^
struct VS_CONST_MATERIAL
{
	float4 Diffuse ;                // }eAfBt[YJ[
	float4 Specular ;               // }eAXyLJ[
	float4 Power ;                  // }eAXyLnCCg̋
} ;

// Cgp[^
struct VS_CONST_LIGHT
{
	float4 Position ;               // W( r[ )
	float3 Direction ;              // ( r[ )
	float4 Diffuse ;                // fBt[YJ[
	float4 Specular ;               // XyLJ[
	float4 Ambient ;                // ArGgJ[ƃ}eÃArGgJ[Z
	float4 Range_FallOff_AT0_AT1 ;  // x:L  y:X|bgCgpFallOff  z:ɂ錸pp[^O  w:ɂ錸pp[^P
	float4 AT2_SpotP0_SpotP1 ;      // x:ɂ錸pp[^Q  y:X|bgCgpp[^O( cos( Phi / 2.0f ) )  z:X|bgCgpp[^P( 1.0f / ( cos( Theta / 2.0f ) - cos( Phi / 2.0f ) ) )
} ;



// C++ Őݒ肷萔̒`
float4              cfAmbient_Emissive      : register( c1  ) ;		// }eAG~bVuJ[ + }eAArGgJ[ * O[oArGgJ[
float4              cfProjectionMatrix[ 4 ] : register( c2  ) ;		// r[@@@ˉes
float4              cfViewMatrix[ 3 ]       : register( c6  ) ;		// [h@@r[s
float4              cfLocalWorldMatrix[ 162 ] : register( c94 ) ;	// [J@@[hs
VS_CONST_MATERIAL   cfMaterial              : register( c11 ) ;		// }eAp[^
VS_CONST_LIGHT      cfLight                 : register( c14 ) ;		// LCgOԂ̃p[^

matrix              cfDepthViewMatrix0       : register( c43  ) ;	// [xobt@O_Õ[h@@r[s
matrix              cfDepthProjectionMatrix0 : register( c47  ) ;	// [xobt@O_Õr[@@@ˉes
matrix              cfDepthViewMatrix1       : register( c51  ) ;	// [xobt@P_Õ[h@@r[s
matrix              cfDepthProjectionMatrix1 : register( c55  ) ;	// [xobt@P_Õr[@@@ˉes
matrix              cfDepthViewMatrix2       : register( c59  ) ;	// [xobt@Q_Õ[h@@r[s
matrix              cfDepthProjectionMatrix2 : register( c63  ) ;	// [xobt@Q_Õr[@@@ˉes
matrix              cfDepthViewMatrix3       : register( c67  ) ;	// [xobt@R_Õ[h@@r[s
matrix              cfDepthProjectionMatrix3 : register( c71  ) ;	// [xobt@R_Õr[@@@ˉes
matrix              cfDepthViewMatrix4       : register( c75  ) ;	// [xobt@S_Õ[h@@r[s
matrix              cfDepthProjectionMatrix4 : register( c79  ) ;	// [xobt@S_Õr[@@@ˉes
matrix              cfDepthViewMatrix5       : register( c83  ) ;	// [xobt@T_Õ[h@@r[s
matrix              cfDepthProjectionMatrix5 : register( c87  ) ;	// [xobt@T_Õr[@@@ˉes


// main֐
VS_OUTPUT main( VS_INPUT VSInput )
{
	VS_OUTPUT VSOutput ;
	float4 lWorldPosition ;
	float4 lViewPosition ;
	float4 lDViewPosition ;
	float3 lWorldNrm ;
	float3 lViewNrm ;
	float3 lLightHalfVec ;
	float4 lLightLitParam ;
	float4 lLightLitDest ;
	float4 lLocalWorldMatrix[ 3 ] ;
	float3 lLightDir ;
	float3 lLightTemp ;
	float lLightDistancePow2 ;
	float lLightGen ;


	// ̃t[̃uhs̍쐬
	lLocalWorldMatrix[ 0 ]  = cfLocalWorldMatrix[ VSInput.BlendIndices0.x + 0 ] * VSInput.BlendWeight0.x;
	lLocalWorldMatrix[ 1 ]  = cfLocalWorldMatrix[ VSInput.BlendIndices0.x + 1 ] * VSInput.BlendWeight0.x;
	lLocalWorldMatrix[ 2 ]  = cfLocalWorldMatrix[ VSInput.BlendIndices0.x + 2 ] * VSInput.BlendWeight0.x;

	lLocalWorldMatrix[ 0 ] += cfLocalWorldMatrix[ VSInput.BlendIndices0.y + 0 ] * VSInput.BlendWeight0.y;
	lLocalWorldMatrix[ 1 ] += cfLocalWorldMatrix[ VSInput.BlendIndices0.y + 1 ] * VSInput.BlendWeight0.y;
	lLocalWorldMatrix[ 2 ] += cfLocalWorldMatrix[ VSInput.BlendIndices0.y + 2 ] * VSInput.BlendWeight0.y;

	lLocalWorldMatrix[ 0 ] += cfLocalWorldMatrix[ VSInput.BlendIndices0.z + 0 ] * VSInput.BlendWeight0.z;
	lLocalWorldMatrix[ 1 ] += cfLocalWorldMatrix[ VSInput.BlendIndices0.z + 1 ] * VSInput.BlendWeight0.z;
	lLocalWorldMatrix[ 2 ] += cfLocalWorldMatrix[ VSInput.BlendIndices0.z + 2 ] * VSInput.BlendWeight0.z;

	lLocalWorldMatrix[ 0 ] += cfLocalWorldMatrix[ VSInput.BlendIndices0.w + 0 ] * VSInput.BlendWeight0.w;
	lLocalWorldMatrix[ 1 ] += cfLocalWorldMatrix[ VSInput.BlendIndices0.w + 1 ] * VSInput.BlendWeight0.w;
	lLocalWorldMatrix[ 2 ] += cfLocalWorldMatrix[ VSInput.BlendIndices0.w + 2 ] * VSInput.BlendWeight0.w;


	// _Wϊ ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++( Jn )

	// [JW[hWɕϊ
	lWorldPosition.x = dot( VSInput.Position, lLocalWorldMatrix[ 0 ] ) ;
	lWorldPosition.y = dot( VSInput.Position, lLocalWorldMatrix[ 1 ] ) ;
	lWorldPosition.z = dot( VSInput.Position, lLocalWorldMatrix[ 2 ] ) ;
	lWorldPosition.w = 1.0f ;

	// [hWr[Wɕϊ
	lViewPosition.x = dot( lWorldPosition, cfViewMatrix[ 0 ] ) ;
	lViewPosition.y = dot( lWorldPosition, cfViewMatrix[ 1 ] ) ;
	lViewPosition.z = dot( lWorldPosition, cfViewMatrix[ 2 ] ) ;
	lViewPosition.w = 1.0f ;

	// r[WˉeWɕϊ
	VSOutput.Position.x = dot( lViewPosition, cfProjectionMatrix[ 0 ] ) ;
	VSOutput.Position.y = dot( lViewPosition, cfProjectionMatrix[ 1 ] ) ;
	VSOutput.Position.z = dot( lViewPosition, cfProjectionMatrix[ 2 ] ) ;
	VSOutput.Position.w = dot( lViewPosition, cfProjectionMatrix[ 3 ] ) ;

	// _Wϊ ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++( I )



	// Cg̏ ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++( Jn )

	// @r[Ԃ̊pxɕϊ =========================================( Jn )

	// [JxNg[hxNgɕϊ
	lWorldNrm.x = dot( VSInput.Normal, lLocalWorldMatrix[ 0 ].xyz ) ;
	lWorldNrm.y = dot( VSInput.Normal, lLocalWorldMatrix[ 1 ].xyz ) ;
	lWorldNrm.z = dot( VSInput.Normal, lLocalWorldMatrix[ 2 ].xyz ) ;

	// [hxNgr[xNgɕϊ
	lViewNrm.x = dot( lWorldNrm, cfViewMatrix[ 0 ].xyz ) ;
	lViewNrm.y = dot( lWorldNrm, cfViewMatrix[ 1 ].xyz ) ;
	lViewNrm.z = dot( lWorldNrm, cfViewMatrix[ 2 ].xyz ) ;

	// @r[Ԃ̊pxɕϊ =========================================( I )

	// CgxNǧvZ
	lLightDir = normalize( lViewPosition.xyz - cfLight.Position.xyz ) ;


	// lvZ ===================================================================( Jn )

	// _ƃCgʒuƂ̋̓߂
	lLightTemp = lViewPosition.xyz - cfLight.Position.xyz ;
	lLightDistancePow2 = dot( lLightTemp, lLightTemp ) ;

	// ̌vZ lLightGen = 1 / ( l0 + l1 *  + l2 * (  *  ) )
	lLightGen = 1.0f / ( cfLight.Range_FallOff_AT0_AT1.z + cfLight.Range_FallOff_AT0_AT1.w * sqrt( lLightDistancePow2 ) + cfLight.AT2_SpotP0_SpotP1.x * lLightDistancePow2 ) ;

	// LO猸őɂ鏈
	lLightGen *= step( lLightDistancePow2, cfLight.Range_FallOff_AT0_AT1.x ) ;

	// lvZ ===================================================================( I )


	// CgfBt[YJ[ƃCgXyLJ[̊pxvZ ===================( Jn )

	// @ƃCg̋txNgƂ̓ς lLightLitParam.x ɃZbg
	lLightLitParam.x = dot( lViewNrm, -lLightDir ) ;

	// n[txNǧvZ norm( ( norm( _ʒu王_ւ̃xNg ) + Cg̕ ) )
	lLightHalfVec = normalize( normalize( -lViewPosition.xyz ) - lLightDir ) ;

	// @ƃn[txNg̓ς lLightLitParam.y ɃZbg
	lLightLitParam.y = dot( lLightHalfVec, lViewNrm ) ;

	// XyL˗ lLightLitParam.w ɃZbg
	lLightLitParam.w = cfMaterial.Power.x ;

	// Cgp[^vZ
	lLightLitDest = lit( lLightLitParam.x, lLightLitParam.y, lLightLitParam.w ) ;

	// CgfBt[YJ[ƃCgXyLJ[̊pxvZ ===================( I )

	// Cg̏ ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++( I )



	// o̓p[^Zbg ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++( Jn )

	// fBt[YJ[ =
	//            l *
	//            ( fBt[YpxvZ *
	//              Cg̃fBt[YJ[ *
	//              }eÃfBt[YJ[ +
	//              Cg̃ArGgJ[ƃ}eÃArGgJ[Z ) +
	//            }eÃArGgJ[ƃO[oArGgJ[Ẑƃ}eAG~bVuJ[Z
	VSOutput.Diffuse = lLightGen * ( lLightLitDest.y * cfLight.Diffuse * cfMaterial.Diffuse + cfLight.Ambient ) + cfAmbient_Emissive ;

	// fBt[YAt@̓}eÃfBt[YJ[̃At@̂܂܎g
	VSOutput.Diffuse.w = cfMaterial.Diffuse.w ;

	// XyLJ[ = l * XyLpxvZ * Cg̃XyLJ[ * }eÃXyLJ[
	VSOutput.Specular = lLightGen * lLightLitDest.z * cfLight.Specular * cfMaterial.Specular ;


	// eNX`W̃Zbg
	VSOutput.TexCoords0 = VSInput.TexCoords0;

	// o̓p[^Zbg ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++( I )



	// [xobt@_ÕJݒł̎ˉesZo ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++( Jn )

	lDViewPosition = mul( cfDepthViewMatrix0, lWorldPosition ) ;
	VSOutput.DPPosition0 = mul( cfDepthProjectionMatrix0, lDViewPosition ) ;

	lDViewPosition = mul( cfDepthViewMatrix1, lWorldPosition ) ;
	VSOutput.DPPosition1 = mul( cfDepthProjectionMatrix1, lDViewPosition ) ;

	lDViewPosition = mul( cfDepthViewMatrix2, lWorldPosition ) ;
	VSOutput.DPPosition2 = mul( cfDepthProjectionMatrix2, lDViewPosition ) ;

	lDViewPosition = mul( cfDepthViewMatrix3, lWorldPosition ) ;
	VSOutput.DPPosition3 = mul( cfDepthProjectionMatrix3, lDViewPosition ) ;

	lDViewPosition = mul( cfDepthViewMatrix4, lWorldPosition ) ;
	VSOutput.DPPosition4 = mul( cfDepthProjectionMatrix4, lDViewPosition ) ;

	lDViewPosition = mul( cfDepthViewMatrix5, lWorldPosition ) ;
	VSOutput.DPPosition5 = mul( cfDepthProjectionMatrix5, lDViewPosition ) ;

	// [xobt@_ÕJݒł̎ˉesZo ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++( I )


	// o̓p[^Ԃ
	return VSOutput ;
}

