// _VF[_[̓
struct VS_INPUT
{
	float4 Position        : POSITION ;     // W( [J )
	float3 Normal          : NORMAL0 ;      // @( [J )
	float4 Diffuse         : COLOR0 ;       // fBt[YJ[
	float4 Specular        : COLOR1 ;       // XyLJ[
	float4 TexCoords0      : TEXCOORD0 ;	// eNX`W
} ;

// _VF[_[̏o
struct VS_OUTPUT
{
	float4 Position        : POSITION ;     // W( ˉe )
	float4 Diffuse         : COLOR0 ;       // fBt[YJ[
	float4 Specular        : COLOR1 ;       // XyLJ[
	float2 TexCoords0      : TEXCOORD0 ;    // eNX`W
	float4 LPPosition      : TEXCOORD1 ;    // Cg݂W( Cg̎ˉe )
} ;

// }eAp[^
struct VS_CONST_MATERIAL
{
	float4 Diffuse ;                // }eAfBt[YJ[
	float4 Specular ;               // }eAXyLJ[
	float4 Power ;                  // }eAXyLnCCg̋
} ;

// Cgp[^
struct VS_CONST_LIGHT
{
	float4 Position ;               // W( r[ )
	float3 Direction ;              // ( r[ )
	float4 Diffuse ;                // fBt[YJ[
	float4 Specular ;               // XyLJ[
	float4 Ambient ;                // ArGgJ[ƃ}eÃArGgJ[Z
	float4 Range_FallOff_AT0_AT1 ;  // x:L  y:X|bgCgpFallOff  z:ɂ錸pp[^O  w:ɂ錸pp[^P
	float4 AT2_SpotP0_SpotP1 ;      // x:ɂ錸pp[^Q  y:X|bgCgpp[^O( cos( Phi / 2.0f ) )  z:X|bgCgpp[^P( 1.0f / ( cos( Theta / 2.0f ) - cos( Phi / 2.0f ) ) )
} ;



// C++ Őݒ肷萔̒`
float4              cfAmbient_Emissive      : register( c1  ) ;		// }eAG~bVuJ[ + }eAArGgJ[ * O[oArGgJ[
float4              cfProjectionMatrix[ 4 ] : register( c2  ) ;		// r[@@@ˉes
float4              cfViewMatrix[ 3 ]       : register( c6  ) ;		// [h@@r[s
float4              cfLocalWorldMatrix[ 3 ] : register( c94 ) ;		// [J@@[hs
VS_CONST_MATERIAL   cfMaterial              : register( c11 ) ;		// }eAp[^
VS_CONST_LIGHT      cfLight                 : register( c14 ) ;		// LCgOԂ̃p[^

matrix              cfLightViewMatrix       : register( c43  ) ;	// Cg̃[h@@r[s
matrix              cfLightProjectionMatrix : register( c47  ) ;	// Cg̃r[@@@ˉes


// main֐
VS_OUTPUT main( VS_INPUT VSInput )
{
	VS_OUTPUT VSOutput ;
	float4 lWorldPosition ;
	float4 lViewPosition ;
	float4 lLViewPosition ;
	float3 lWorldNrm ;
	float3 lViewNrm ;
	float3 lLightHalfVec ;
	float4 lLightLitParam ;
	float4 lLightLitDest ;


	// _Wϊ ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++( Jn )

	// [JW[hWɕϊ
	lWorldPosition.x = dot( VSInput.Position, cfLocalWorldMatrix[ 0 ] ) ;
	lWorldPosition.y = dot( VSInput.Position, cfLocalWorldMatrix[ 1 ] ) ;
	lWorldPosition.z = dot( VSInput.Position, cfLocalWorldMatrix[ 2 ] ) ;
	lWorldPosition.w = 1.0f ;

	// [hWr[Wɕϊ
	lViewPosition.x = dot( lWorldPosition, cfViewMatrix[ 0 ] ) ;
	lViewPosition.y = dot( lWorldPosition, cfViewMatrix[ 1 ] ) ;
	lViewPosition.z = dot( lWorldPosition, cfViewMatrix[ 2 ] ) ;
	lViewPosition.w = 1.0f ;

	// r[WˉeWɕϊ
	VSOutput.Position.x = dot( lViewPosition, cfProjectionMatrix[ 0 ] ) ;
	VSOutput.Position.y = dot( lViewPosition, cfProjectionMatrix[ 1 ] ) ;
	VSOutput.Position.z = dot( lViewPosition, cfProjectionMatrix[ 2 ] ) ;
	VSOutput.Position.w = dot( lViewPosition, cfProjectionMatrix[ 3 ] ) ;

	// _Wϊ ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++( I )



	// Cg̏ ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++( Jn )

	// @r[Ԃ̊pxɕϊ =========================================( Jn )

	// [JxNg[hxNgɕϊ
	lWorldNrm.x = dot( VSInput.Normal, cfLocalWorldMatrix[ 0 ].xyz ) ;
	lWorldNrm.y = dot( VSInput.Normal, cfLocalWorldMatrix[ 1 ].xyz ) ;
	lWorldNrm.z = dot( VSInput.Normal, cfLocalWorldMatrix[ 2 ].xyz ) ;

	// [hxNgr[xNgɕϊ
	lViewNrm.x = dot( lWorldNrm, cfViewMatrix[ 0 ].xyz ) ;
	lViewNrm.y = dot( lWorldNrm, cfViewMatrix[ 1 ].xyz ) ;
	lViewNrm.z = dot( lWorldNrm, cfViewMatrix[ 2 ].xyz ) ;

	// @r[Ԃ̊pxɕϊ =========================================( I )


	// CgfBt[YJ[ƃCgXyLJ[̊pxvZ =======( Jn )

	// @ƃCg̋txNgƂ̓ς lLightLitParam.x ɃZbg
	lLightLitParam.x = dot( lViewNrm, -cfLight.Direction ) ;

	// n[txNǧvZ norm( ( norm( _ʒu王_ւ̃xNg ) + Cg̕ ) )
	lLightHalfVec = normalize( normalize( -lViewPosition.xyz ) - cfLight.Direction ) ;

	// @ƃn[txNg̓ς lLightLitParam.y ɃZbg
	lLightLitParam.y = dot( lLightHalfVec, lViewNrm ) ;

	// XyL˗ lLightLitParam.w ɃZbg
	lLightLitParam.w = cfMaterial.Power.x ;

	// Cgp[^vZ
	lLightLitDest = lit( lLightLitParam.x, lLightLitParam.y, lLightLitParam.w ) ;

	// CgfBt[YJ[ƃCgXyLJ[̊pxvZ =======( I )

	// Cg̏ ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++( I )



	// o̓p[^Zbg ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++( Jn )

	// fBt[YJ[ =
	//            fBt[YpxvZ *
	//            Cg̃fBt[YJ[ *
	//            }eÃfBt[YJ[ +
	//            Cg̃ArGgJ[ƃ}eÃArGgJ[Z +
	//            }eÃArGgJ[ƃO[oArGgJ[Ẑƃ}eAG~bVuJ[Z
	VSOutput.Diffuse = lLightLitDest.y * cfLight.Diffuse * cfMaterial.Diffuse + cfLight.Ambient + cfAmbient_Emissive ;

	// fBt[YAt@̓}eÃfBt[YJ[̃At@̂܂܎g
	VSOutput.Diffuse.w = cfMaterial.Diffuse.w ;

	// XyLJ[ = XyLpxvZ * Cg̃XyLJ[ * }eÃXyLJ[
	VSOutput.Specular = lLightLitDest.z * cfLight.Specular * cfMaterial.Specular ;


	// eNX`W̃Zbg
	VSOutput.TexCoords0 = VSInput.TexCoords0;

	// o̓p[^Zbg ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++( I )



	// [xep̃Cg猩ˉeWZo ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++( Jn )

	// [hWCg̃r[Wɕϊ
	lLViewPosition = mul( cfLightViewMatrix, lWorldPosition ) ;

	// Cg̃r[WCg̎ˉeWɕϊ
	VSOutput.LPPosition = mul( cfLightProjectionMatrix, lLViewPosition ) ;

	// yl̓Cg̃r[Wɂ
	VSOutput.LPPosition.z = lLViewPosition.z ;

	// [xep̃Cg猩ˉeWZo ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++( I )


	// o̓p[^Ԃ
	return VSOutput ;
}

