// RcANV{

#include "DxLib.h"
#include <math.h>

// Œl` -------------------------------------------------------------------------------------

// LN^[ʂ̏
#define CHARA_PLAY_ANIM_SPEED			250.0f		// Aj[Vx
#define CHARA_MOVE_SPEED			30.0f		// ړx
#define CHARA_ANIM_BLEND_SPEED			0.1f		// Aj[Ṽuhωx
#define CHARA_ANGLE_SPEED			0.2f		// pxωx
#define CHARA_JUMP_POWER			100.0f		// Wv
#define CHARA_FALL_UP_POWER			20.0f		// 𓥂݊ÕWv
#define CHARA_GRAVITY				3.0f		// d
#define CHARA_MAX_HITCOLL			2048		// RW|S̍ő吔
#define CHARA_ENUM_DEFAULT_SIZE			800.0f		// ͂̃|SoɎgp鋅̏TCY
#define CHARA_HIT_WIDTH				200.0f		// 蔻JvZ̔a
#define CHARA_HIT_HEIGHT			700.0f		// 蔻JvZ̍
#define CHARA_HIT_TRYNUM			16		// ǉo̍ő厎s
#define CHARA_HIT_SLIDE_LENGTH			5.0f		// x̕ǉoŃXCh鋗
#define CHARA_HIT_PUSH_POWER			40.0f		// LN^[mœƂ̉o
#define CHARA_SHADOW_SIZE			200.0f		// ȇ傫
#define CHARA_SHADOW_HEIGHT			700.0f		// e鍂

// J֌W̒`
#define CAMERA_ANGLE_SPEED			0.05f		// 񑬓x
#define CAMERA_PLAYER_TARGET_HEIGHT		400.0f		// vC[Wǂꂾʒu𒍎_Ƃ邩
#define CAMERA_PLAYER_LENGTH			1600.0f		// vC[Ƃ̋
#define CAMERA_COLLISION_SIZE			50.0f		// J̓蔻TCY

// vC[LȊOL̏
#define NOTPLAYER_NUM				4		// vC[ȊÕL̐
#define NOTPLAYER_MOVETIME			120		// ̕Ɉړ鎞
#define NOTPLAYER_JUMPRATIO			250		// vC[ȊÕLWvm


// \̒` -------------------------------------------------------------------------------------

// ͏\
struct PADINPUT
{
	int		NowInput ;				// ݂̓
	int		EdgeInput ;				// ݂̃t[ŉꂽ{^̂݃rbgĂ͒l
} ;

// LN^[
struct CHARA
{
	VECTOR		Position ;				// W
	VECTOR		TargetMoveDirection ;			// fׂ̃xNg
	float		Angle ;					// fĂ̊px
	float		JumpPower ;				// x̑x
	int		ModelHandle ;				// fnh
	int		State ;					// ( 0:~܂  1:  2:Wv )

	int		PlayAnim1 ;				// ĐĂAj[VP̃A^b`ԍ( -1:Aj[VA^b`ĂȂ )
	float		AnimPlayCount1 ;			// ĐĂAj[VP̍Đ
	int		PlayAnim2 ;				// ĐĂAj[VQ̃A^b`ԍ( -1:Aj[VA^b`ĂȂ )
	float		AnimPlayCount2 ;			// ĐĂAj[VQ̍Đ
	float		AnimBlendRate ;				// ĐĂAj[VPƂQ̃uh
} ;

// vC[\
struct PLAYER
{
	CHARA		CharaInfo ;				// LN^[
} ;

// vC[ȊOL\
struct NOTPLAYER
{
	CHARA		CharaInfo ;				// LN^[
	int		MoveTime ;				// ړ
	float		MoveAngle ;				// ړ
} ;

// LN^[ʏ
struct CHARA_COMMON
{
	int		BaseModelHandle ;			// ʂ̔hfnh
	int		ShadowHandle ;				// e`p̃OtBbNnh
} ;

// Xe[W\
struct STAGE
{
	int		ModelHandle ;				// fnh
} ;

// J\
struct CAMERA
{
	float		AngleH ;				// px
	float		AngleV ;				// px
	VECTOR		Eye ;					// JW
	VECTOR		Target ;				// _W
} ;


// ֐vg^Cv錾 ---------------------------------------------------------------------------

void Input_Process( void ) ;			// ͏

void Chara_Initialize( CHARA *ch, VECTOR Position ) ;			// LN^[̏
void Chara_Terminate( CHARA *ch ) ;					// LN^[̌n
void Chara_Process( CHARA *ch, VECTOR MoveVec, int JumpFlag ) ;		// LN^[̏
void Chara_Move( CHARA *ch, VECTOR MoveVector ) ;			// LN^[̈ړ
void Chara_Collision( CHARA *ch, VECTOR *ch_MoveVec, CHARA *chk_ch ) ;	// LN^[ɓĂ牟os( chk_ch  ch Ă ch  )
void Chara_AngleProcess( CHARA *ch ) ;					// LN^[̌ς鏈
void Chara_PlayAnim( CHARA *ch, int PlayAnim ) ;			// LN^[ɐVȃAj[VĐ
void Chara_AnimProcess( CHARA *ch ) ;					// LN^[̃Aj[V

void Player_Initialize( void ) ;		// vC[̏
void Player_Terminate( void ) ;			// vC[̌n
void Player_Process( void ) ;			// vC[̏

void Stage_Initialize( void ) ;			// Xe[W̏
void Stage_Terminate( void ) ;			// Xe[W̌n

void Camera_Initialize( void ) ;		// J̏
void Camera_Process( void ) ;			// J̏

void SetupDepthImage( void ) ;			// e`p̐[xL^摜
void DrawModelWithDepthShadow( void ) ;	// ep̐[xL^摜ge𗎂Ƃ܂߂f̕`

void Render_Process( void ) ;			// `揈


// ̐錾 ---------------------------------------------------------------------------------------

PADINPUT inp ;		// ͏̎̐錾
PLAYER pl ;		// vC[̎̐錾
NOTPLAYER npl[ NOTPLAYER_NUM ] ;	// vC[ł͂ȂL̎̐錾
CHARA_COMMON chcmn ;	// LN^[̋ʏ̎̐錾
STAGE stg ;		// Xe[W̎̐錾
CAMERA cam ;		// J̎̐錾


// ep̐[xlۑ`\OtBbN
int DepthBufferGraphHandle ;

// ep̐[xL^摜쐬ۂ̃J̃r[sƎˉes
MATRIX LightCamera_ViewMatrix ;
MATRIX LightCamera_ProjectionMatrix ;

// [xL^摜ւ̕`p̍̃bVp_VF[_[
// XLjObVp̒_VF[_[
int Skin4_DepthShadow_Step1_VertexShader ;	
int Normal_DepthShadow_Step1_VertexShader ;

// [xL^摜ւ̕`p̃sNZVF[_[
int DepthShadow_Step1_PixelShader ;

// [xL^摜gfBNViCgt̕`p̍̃bVp_VF[_[
// XLjObVp̒_VF[_[
int Skin4_DirLight_DepthShadow_Step2_VertexShader ;
int Normal_DirLight_DepthShadow_Step2_VertexShader ;

// [xL^摜gfBNViCgt̕`p̃sNZVF[_[
int DirLight_DepthShadow_Step2_PixelShader ;



// ֐ ---------------------------------------------------------------------------------------

// ͏
void Input_Process( void )
{
	int Old ;

	// ЂƂÕt[̓͂ϐɂƂĂ
	Old = inp.NowInput ;

	// ݂̓͏Ԃ擾
	inp.NowInput = GetJoypadInputState( DX_INPUT_KEY_PAD1 ) ;

	// ̃t[ŐVɉꂽ{^̃rbgĂl EdgeInput ɑ
	inp.EdgeInput = inp.NowInput & ~Old ;
}

// LN^[̋ʏ
void CharaCommon_Initialize( void )
{
	// f̓ǂݍ
	chcmn.BaseModelHandle = MV1LoadModel( "DxChara.x" ) ;

	// e`p̉摜̓ǂݍ
	chcmn.ShadowHandle = LoadGraph( "Shadow.tga" ) ;
}

// LN^[ʏ̌n
void CharaCommon_Terminate( void )
{
	// f̍폜
	MV1DeleteModel( chcmn.BaseModelHandle ) ;

	// ep摜̍폜
	DeleteGraph( chcmn.ShadowHandle ) ;
}

// LN^[̏
void Chara_Initialize( CHARA *ch, VECTOR Position )
{
	// W͌_
	ch->Position = Position ;

	// ]l͂O
	ch->Angle = 0.0f ;

	// Wv͂͏Ԃł͂O
	ch->JumpPower = 0.0f ;

	// fnh̍쐬
	ch->ModelHandle = MV1DuplicateModel( chcmn.BaseModelHandle ) ;

	// Ԃł́u~v
	ch->State = 0 ;

	// Ԃ͂w
	ch->TargetMoveDirection = VGet( 1.0f, 0.0f, 0.0f ) ;

	// Aj[Ṽuh
	ch->AnimBlendRate = 1.0f ;

	// Ԃł̓Aj[V̓A^b`ĂȂɂ
	ch->PlayAnim1 = -1 ;
	ch->PlayAnim2 = -1 ;

	// ĂAj[VĐ
	Chara_PlayAnim( ch, 4 ) ;
}

// LN^[̌n
void Chara_Terminate( CHARA *ch )
{
	// f̍폜
	MV1DeleteModel( ch->ModelHandle ) ;
}

// LN^[̏
void Chara_Process( CHARA *ch, VECTOR MoveVec, int JumpFlag )
{
	int MoveFlag ;			// ړǂ̃tO( 1:ړ  0:ړĂȂ )

	// [gt[̂ÿړp[^𖳌ɂ
	{
		MATRIX LocalMatrix ;

		// [U[s
		MV1ResetFrameUserLocalMatrix( ch->ModelHandle, 2 ) ;

		// ݂̃[gt[̍s擾
		LocalMatrix = MV1GetFrameLocalMatrix( ch->ModelHandle, 2 ) ;

		// y̕sړ𖳌ɂ
		LocalMatrix.m[ 3 ][ 2 ] = 0.0f ;

		// [U[sƂĕsړ𖳌ɂs[gt[ɃZbg
		MV1SetFrameUserLocalMatrix( ch->ModelHandle, 2, LocalMatrix ) ;
	}

	// ړǂ̃tOZbgAłړĂuړĂv\Pɂ
	MoveFlag = 0 ;
	if( MoveVec.x < -0.001f || MoveVec.x > 0.001f ||
		MoveVec.y < -0.001f || MoveVec.y > 0.001f ||
		MoveVec.z < -0.001f || MoveVec.z > 0.001f )
	{
		MoveFlag = 1 ;
	}

	// LN^[̏ԂuWvvł͂ȂAWvtOĂWv
	if( ch->State != 2 && JumpFlag == 1 )
	{
		// ԂuWvvɂ
		ch->State = 2 ;

		// x̑xZbg
		ch->JumpPower = CHARA_JUMP_POWER ;

		// WvAj[V̍Đ
		Chara_PlayAnim( ch, 2 ) ;
	}

	// ړ{^ꂽǂŏ𕪊
	if( MoveFlag )
	{
		// ړxNg𐳋K̂LN^[ׂƂĕۑ
		ch->TargetMoveDirection = VNorm( MoveVec ) ;

		// ܂Łu~܂vԂ
		if( ch->State == 0 )
		{
			// Aj[VĐ
			Chara_PlayAnim( ch, 1 ) ;

			// Ԃuvɂ
			ch->State = 1 ;
		}
	}
	else
	{
		// ̃t[ňړĂȂāAԂuv
		if( ch->State == 1 )
		{
			// ~Aj[VĐ
			Chara_PlayAnim( ch, 4 ) ;

			// Ԃu~vɂ
			ch->State = 0 ;
		}
	}

	// ԂuWvv̏ꍇ
	if( ch->State == 2 )
	{
		// x̑xd͕Z
		ch->JumpPower -= CHARA_GRAVITY ;

		// ĂĊĐĂAj[V㏸p̂̂ꍇ
		if( ch->JumpPower < 0.0f && MV1GetAttachAnim( ch->ModelHandle, ch->PlayAnim1 ) == 2 )
		{
			// 悤̃Aj[VĐ
			Chara_PlayAnim( ch, 3 ) ;
		}

		// ړxNĝxx̑xɂ
		MoveVec.y = ch->JumpPower ;
	}

	// LN^[̈ړɃf̕߂Â
	Chara_AngleProcess( ch ) ;

	// ړxNgɃRWlLN^[ړ
	Chara_Move( ch, MoveVec ) ;

	// Aj[V
	Chara_AnimProcess( ch ) ;
}

// LN^[̈ړ
void Chara_Move( CHARA *ch, VECTOR MoveVector )
{
	int i, j, k ;						// ėpJE^ϐ
	int MoveFlag ;						// Ɉړǂ̃tO( O:ړĂȂ  P:ړ )
	int HitFlag ;						// |SɓǂLĂ̂Ɏgϐ( O:ĂȂ  P: )
	MV1_COLL_RESULT_POLY_DIM HitDim ;			// LN^[̎͂ɂ|Soʂ铖蔻茋ʍ\
	int KabeNum ;						// ǃ|SƔfꂽ|S̐
	int YukaNum ;						// |SƔfꂽ|S̐
	MV1_COLL_RESULT_POLY *Kabe[ CHARA_MAX_HITCOLL ] ;	// ǃ|SƔfꂽ|S̍\̂̃AhXۑĂ߂̃|C^z
	MV1_COLL_RESULT_POLY *Yuka[ CHARA_MAX_HITCOLL ] ;	// |SƔfꂽ|S̍\̂̃AhXۑĂ߂̃|C^z
	MV1_COLL_RESULT_POLY *Poly ;				// |S̍\̂ɃANZX邽߂Ɏgp|C^( gȂĂς܂܂vOȂ̂ŁEEE )
	HITRESULT_LINE LineRes ;				// ƃ|SƂ̓蔻̌ʂ\
	VECTOR OldPos ;						// ړO̍W	
	VECTOR NowPos ;						// ړ̍W

	// ړO̍Wۑ
	OldPos = ch->Position ;

	// ړ̍WZo
	NowPos = VAdd( ch->Position, MoveVector ) ;

	// LN^[̎͂ɂXe[W|S擾
	// ( o͈͈͂ړl )
	HitDim = MV1CollCheck_Sphere( stg.ModelHandle, -1, ch->Position, CHARA_ENUM_DEFAULT_SIZE + VSize( MoveVector ) ) ;

	// xy 0.01f ȏړꍇ́uړvtOPɂ
	if( fabs( MoveVector.x ) > 0.01f || fabs( MoveVector.z ) > 0.01f )
	{
		MoveFlag = 1 ;
	}
	else
	{
		MoveFlag = 0 ;
	}

	// oꂽ|Sǃ|S( wyʂɐȃ|S )|S( wyʂɐł͂Ȃ|S )𔻒f
	{
		// ǃ|SƏ|S̐
		KabeNum = 0 ;
		YukaNum = 0 ;

		// oꂽ|S̐JԂ
		for( i = 0 ; i < HitDim.HitNum ; i ++ )
		{
			// wyʂɐǂ̓|S̖@̂xOɌȂ߂ǂŔf
			if( HitDim.Dim[ i ].Normal.y < 0.000001f && HitDim.Dim[ i ].Normal.y > -0.000001f )
			{
				// ǃ|SƔfꂽꍇłALN^[̂xW{PDO荂|Ŝݓ蔻s
				if( HitDim.Dim[ i ].Position[ 0 ].y > ch->Position.y + 1.0f ||
					HitDim.Dim[ i ].Position[ 1 ].y > ch->Position.y + 1.0f ||
					HitDim.Dim[ i ].Position[ 2 ].y > ch->Position.y + 1.0f )
				{
					// |S̐񋓂łEɒBĂȂ|Szɒǉ
					if( KabeNum < CHARA_MAX_HITCOLL )
					{
						// |S̍\̂̃AhXǃ|S|C^zɕۑ
						Kabe[ KabeNum ] = &HitDim.Dim[ i ] ;

						// ǃ|S̐Z
						KabeNum ++ ;
					}
				}
			}
			else
			{
				// |S̐񋓂łEɒBĂȂ|Szɒǉ
				if( YukaNum < CHARA_MAX_HITCOLL )
				{
					// |S̍\̂̃AhX|S|C^zɕۑ
					Yuka[ YukaNum ] = &HitDim.Dim[ i ] ;

					// |S̐Z
					YukaNum ++ ;
				}
			}
		}
	}

	// ǃ|SƂ̓蔻菈
	if( KabeNum != 0 )
	{
		// ǂɓǂ̃tO͏Ԃł́uĂȂvɂĂ
		HitFlag = 0 ;

		// ړǂŏ𕪊
		if( MoveFlag == 1 )
		{
			// ǃ|S̐JԂ
			for( i = 0 ; i < KabeNum ; i ++ )
			{
				// iԖڂ̕ǃ|S̃AhXǃ|S|C^z񂩂擾
				Poly = Kabe[ i ] ;

				// |SƃLN^[ĂȂ玟̃JEg
				if( HitCheck_Capsule_Triangle( NowPos, VAdd( NowPos, VGet( 0.0f, CHARA_HIT_HEIGHT, 0.0f ) ), CHARA_HIT_WIDTH, Poly->Position[ 0 ], Poly->Position[ 1 ], Poly->Position[ 2 ] ) == FALSE ) continue ;

				// ɂ|SƃLN^[ĂƂƂȂ̂ŁA|SɓtO𗧂Ă
				HitFlag = 1 ;

				// ǂɓǂɎՂȂړړ
				{
					VECTOR SlideVec ;	// LN^[XChxNg

					// isxNgƕǃ|S̖@xNgɐȃxNgZo
					SlideVec = VCross( MoveVector, Poly->Normal ) ;

					// ZoxNgƕǃ|S̖@xNgɐȃxNgZoAꂪ
					// ̈ړǕ̈ړ𔲂xNg
					SlideVec = VCross( Poly->Normal, SlideVec ) ;

					// ړO̍Wɑ̂VȍWƂ
					NowPos = VAdd( OldPos, SlideVec ) ;
				}

				// VȈړWŕǃ|SƓĂȂǂ𔻒肷
				for( j = 0 ; j < KabeNum ; j ++ )
				{
					// jԖڂ̕ǃ|S̃AhXǃ|S|C^z񂩂擾
					Poly = Kabe[ j ] ;

					// Ă烋[v甲
					if( HitCheck_Capsule_Triangle( NowPos, VAdd( NowPos, VGet( 0.0f, CHARA_HIT_HEIGHT, 0.0f ) ), CHARA_HIT_WIDTH, Poly->Position[ 0 ], Poly->Position[ 1 ], Poly->Position[ 2 ] ) == TRUE ) break ;
				}

				// j  KabeNum ꍇ͂ǂ̃|SƂȂƂƂȂ̂
				// ǂɓtO|Ń[v甲
				if( j == KabeNum )
				{
					HitFlag = 0 ;
					break ;
				}
			}
		}
		else
		{
			// ړĂȂꍇ̏
			
			// ǃ|S̐JԂ
			for( i = 0 ; i < KabeNum ; i ++ )
			{
				// iԖڂ̕ǃ|S̃AhXǃ|S|C^z񂩂擾
				Poly = Kabe[ i ] ;

				// |SɓĂ瓖tO𗧂ĂŃ[v甲
				if( HitCheck_Capsule_Triangle( NowPos, VAdd( NowPos, VGet( 0.0f, CHARA_HIT_HEIGHT, 0.0f ) ), CHARA_HIT_WIDTH, Poly->Position[ 0 ], Poly->Position[ 1 ], Poly->Position[ 2 ] ) == TRUE )
				{
					HitFlag = 1 ;
					break ;
				}
			}
		}

		// ǂɓĂǂ牟os
		if( HitFlag == 1 )
		{
			// ǂ̉o݂ő吔JԂ
			for( k = 0 ; k < CHARA_HIT_TRYNUM ; k ++ )
			{
				// ǃ|S̐JԂ
				for( i = 0 ; i < KabeNum ; i ++ )
				{
					// iԖڂ̕ǃ|S̃AhXǃ|S|C^z񂩂擾
					Poly = Kabe[ i ] ;

					// LN^[ƓĂ邩𔻒
					if( HitCheck_Capsule_Triangle( NowPos, VAdd( NowPos, VGet( 0.0f, CHARA_HIT_HEIGHT, 0.0f ) ), CHARA_HIT_WIDTH, Poly->Position[ 0 ], Poly->Position[ 1 ], Poly->Position[ 2 ] ) == FALSE ) continue ;

					// ĂK苗LN^[ǂ̖@Ɉړ
					NowPos = VAdd( NowPos, VScale( Poly->Normal, CHARA_HIT_SLIDE_LENGTH ) ) ;

					// ړŕǃ|SƐڐGĂ邩ǂ𔻒
					for( j = 0 ; j < KabeNum ; j ++ )
					{
						// Ă烋[v𔲂
						Poly = Kabe[ j ] ;
						if( HitCheck_Capsule_Triangle( NowPos, VAdd( NowPos, VGet( 0.0f, CHARA_HIT_HEIGHT, 0.0f ) ), CHARA_HIT_WIDTH, Poly->Position[ 0 ], Poly->Position[ 1 ], Poly->Position[ 2 ] ) == TRUE ) break ;
					}

					// SẴ|SƓĂȂ炱Ń[vI
					if( j == KabeNum ) break ;
				}

				// i  KabeNum ł͂Ȃꍇ͑S̃|Sŉo݂OɑSĂ̕ǃ|SƐڐGȂȂƂƂȂ̂Ń[v甲
				if( i != KabeNum ) break ;
			}
		}
	}

	// |SƂ̓蔻
	if( YukaNum != 0 )
	{
		// Wv㏸̏ꍇ͏𕪊
		if( ch->State == 2 && ch->JumpPower > 0.0f )
		{
			float MinY ;

			// VɓԂ鏈s

			// ԒႢVɂԂׂ̔pϐ
			MinY = 0.0f ;

			// ǂ̃tO𓖂ĂȂӖOɂĂ
			HitFlag = 0 ;

			// |S̐JԂ
			for( i = 0 ; i < YukaNum ; i ++ )
			{
				// iԖڂ̏|S̃AhX|S|C^z񂩂擾
				Poly = Yuka[ i ] ;

				// 悩瓪̍܂ł̊ԂŃ|SƐڐGĂ邩ǂ𔻒
				LineRes = HitCheck_Line_Triangle( NowPos, VAdd( NowPos, VGet( 0.0f, CHARA_HIT_HEIGHT, 0.0f ) ), Poly->Position[ 0 ], Poly->Position[ 1 ], Poly->Position[ 2 ] ) ;

				// ڐGĂȂ牽Ȃ
				if( LineRes.HitFlag == FALSE ) continue ;
				
				// Ƀ|SɓĂāA܂ŌoV|S荂ꍇ͉Ȃ
				if( HitFlag == 1 && MinY < LineRes.Position.y ) continue ;

				// |SɓtO𗧂Ă
				HitFlag = 1 ;

				// ڐGxWۑ
				MinY = LineRes.Position.y ;
			}

			// ڐG|Sǂŏ𕪊
			if( HitFlag == 1 )
			{
				// ڐGꍇ̓LN^[̂xWڐGWɍXV
				NowPos.y = MinY - CHARA_HIT_HEIGHT ;

				// x̑x͔]
				ch->JumpPower = -ch->JumpPower ;
			}
		}
		else
		{
			float MaxY ;

			// ~Wvł͂Ȃꍇ̏

			// |Sɓǂ̃tO|Ă
			HitFlag = 0 ;

			// ԍ|SɂԂׂ̔pϐ
			MaxY = 0.0f ;

			// |S̐JԂ
			for( i = 0 ; i < YukaNum ; i ++ )
			{
				// iԖڂ̏|S̃AhX|S|C^z񂩂擾
				Poly = Yuka[ i ] ;

				// Wvǂŏ𕪊
				if( ch->State == 2 )
				{
					// Wv̏ꍇ͓̐悩瑫菭ႢʒůԂœĂ邩𔻒
					LineRes = HitCheck_Line_Triangle( VAdd( NowPos, VGet( 0.0f, CHARA_HIT_HEIGHT, 0.0f ) ), VAdd( NowPos, VGet( 0.0f, -1.0f, 0.0f ) ), Poly->Position[ 0 ], Poly->Position[ 1 ], Poly->Position[ 2 ] ) ;
				}
				else
				{
					// Ăꍇ͓̐悩炻ႢʒůԂœĂ邩𔻒( X΂ŗԂɈڍsĂ܂Ȃ )
					LineRes = HitCheck_Line_Triangle( VAdd( NowPos, VGet( 0.0f, CHARA_HIT_HEIGHT, 0.0f ) ), VAdd( NowPos, VGet( 0.0f, -40.0f, 0.0f ) ), Poly->Position[ 0 ], Poly->Position[ 1 ], Poly->Position[ 2 ] ) ;
				}

				// ĂȂ牽Ȃ
				if( LineRes.HitFlag == FALSE ) continue ;

				// ɓ|SA܂Ōo|SႢꍇ͉Ȃ
				if( HitFlag == 1 && MaxY > LineRes.Position.y ) continue ;

				// |SɓtO𗧂Ă
				HitFlag = 1 ;

				// ڐGxWۑ
				MaxY = LineRes.Position.y ;
			}

			// |Sɓǂŏ𕪊
			if( HitFlag == 1 )
			{
				// ꍇ

				// ڐG|SňԍxWLN^[̂xWɂ
				NowPos.y = MaxY ;

				// ẍړx͂O
				ch->JumpPower = 0.0f ;

				// Wvꍇ͒nԂɂ
				if( ch->State == 2 )
				{
					// ړĂǂŒn̏ԂƍĐAj[V𕪊򂷂
					if( MoveFlag )
					{
						// ړĂꍇ͑Ԃ
						Chara_PlayAnim( ch, 1 ) ;
						ch->State = 1 ;
					}
					else
					{
						// ړĂȂꍇ͗~Ԃ
						Chara_PlayAnim( ch, 4 ) ;
						ch->State = 0 ;
					}

					// n̓Aj[Ṽuh͍sȂ
					ch->AnimBlendRate = 1.0f ;
				}
			}
			else
			{
				// RWɓĂȂĊWvԂł͂Ȃꍇ
				if( ch->State != 2 )
				{
					// Wvɂ
					ch->State = 2 ;

					// ƂWv
					ch->JumpPower = CHARA_FALL_UP_POWER ;

					// Aj[V͗̂̂ɂ
					Chara_PlayAnim( ch, 3 ) ;
				}
			}
		}
	}

	// VWۑ
	ch->Position = NowPos ;

	// LN^[̃f̍WXV
	MV1SetPosition( ch->ModelHandle, ch->Position ) ;

	// oLN^[̎͂̃|SJ
	MV1CollResultPolyDimTerminate( HitDim ) ;
}

// LN^[ɓĂ牟os( chk_ch  ch Ă ch  )
void Chara_Collision( CHARA *ch, VECTOR *ch_MoveVec, CHARA *chk_ch )
{
	VECTOR ChkChToChVec ;
	VECTOR PushVec ;
	VECTOR ChPosition ;
	float Length ;

	// ړ ch ̍WZo
	ChPosition = VAdd( ch->Position, *ch_MoveVec ) ;

	// ĂȂ牽Ȃ
	if( HitCheck_Capsule_Capsule(
			ChPosition, VAdd( ChPosition, VGet( 0.0f, CHARA_HIT_HEIGHT, 0.0f ) ), CHARA_HIT_WIDTH, 
			chk_ch->Position, VAdd( chk_ch->Position, VGet( 0.0f, CHARA_HIT_HEIGHT, 0.0f ) ), CHARA_HIT_WIDTH ) == TRUE )
	{
		// Ă ch  chk 痣鏈

		// chk_ch  ch ւ̃xNgZo
		ChkChToChVec = VSub( ChPosition, chk_ch->Position ) ;

		// x͌Ȃ
		ChkChToChVec.y = 0.0f ;

		// l̋Zo
		Length = VSize( ChkChToChVec ) ;

		// chk_ch  ch ւ̃xNg𐳋K( xNg̒ 1.0f ɂ )
		PushVec = VScale( ChkChToChVec, 1.0f / Length ) ;

		// oZoAl̋l̑傫lɉo͂𑫂ėĂ܂ꍇ́A҂肭Ɉړ
		if( Length - CHARA_HIT_WIDTH * 2.0f + CHARA_HIT_PUSH_POWER > 0.0f )
		{
			float TempY ;

			TempY = ChPosition.y ;
			ChPosition = VAdd( chk_ch->Position, VScale( PushVec, CHARA_HIT_WIDTH * 2.0f ) ) ; 

			// xW͕ωȂ
			ChPosition.y = TempY ;
		}
		else
		{
			// o
			ChPosition = VAdd( ChPosition, VScale( PushVec, CHARA_HIT_PUSH_POWER ) ) ;
		}
	}

	// 蔻菈̈ړxNgZbg
	*ch_MoveVec = VSub( ChPosition, ch->Position ) ;
}

// LN^[̌ς鏈
void Chara_AngleProcess( CHARA *ch )
{
	float TargetAngle ;			// ڕWpx
	float SaAngle ;				// ڕWpxƌ݂̊pxƂ̍

	// ڕW̕xNgpxlZo
	TargetAngle = atan2( ch->TargetMoveDirection.x, ch->TargetMoveDirection.z ) ;

	// ڕW̊pxƌ݂̊pxƂ̍o
	{
		// ŏ͒PɈZ
		SaAngle = TargetAngle - ch->Angle ;

		// 炠̍PWOxȏɂȂ邱Ƃ͖̂
		// ̒lPWOxȏɂȂĂC
		if( SaAngle < -DX_PI_F )
		{
			SaAngle += DX_TWO_PI_F ;
		}
		else
		if( SaAngle > DX_PI_F )
		{
			SaAngle -= DX_TWO_PI_F ;
		}
	}

	// px̍Oɋ߂Â
	if( SaAngle > 0.0f )
	{
		// vX̏ꍇ͈
		SaAngle -= CHARA_ANGLE_SPEED ;
		if( SaAngle < 0.0f )
		{
			SaAngle = 0.0f ;
		}
	}
	else
	{
		// }CiX̏ꍇ͑
		SaAngle += CHARA_ANGLE_SPEED ;
		if( SaAngle > 0.0f )
		{
			SaAngle = 0.0f ;
		}
	}

	// f̊pxXV
	ch->Angle = TargetAngle - SaAngle ;
	MV1SetRotationXYZ( ch->ModelHandle, VGet( 0.0f, ch->Angle + DX_PI_F, 0.0f ) ) ;
}

// LN^[ɐVȃAj[VĐ
void Chara_PlayAnim( CHARA *ch, int PlayAnim )
{
	// Đ̃[VQLf^b`
	if( ch->PlayAnim2 != -1 )
	{
		MV1DetachAnim( ch->ModelHandle, ch->PlayAnim2 ) ;
		ch->PlayAnim2 = -1 ;
	}

	// ܂ōĐ̃[VP̂̏QɈړ
	ch->PlayAnim2 = ch->PlayAnim1 ;
	ch->AnimPlayCount2 = ch->AnimPlayCount1 ;

	// VɎw̃[VfɃA^b`āAA^b`ԍۑ
	ch->PlayAnim1 = MV1AttachAnim( ch->ModelHandle, PlayAnim ) ;
	ch->AnimPlayCount1 = 0.0f ;

	// uh͍Đ̃[VQLł͂Ȃꍇ͂PDO( Đ̃[VPPOȌ )ɂ
	ch->AnimBlendRate = ch->PlayAnim2 == -1 ? 1.0f : 0.0f ;
}

// LN^[̃Aj[V
void Chara_AnimProcess( CHARA *ch )
{
	float AnimTotalTime ;		// ĐĂAj[V̑

	// uhPȉ̏ꍇ͂Pɋ߂Â
	if( ch->AnimBlendRate < 1.0f )
	{
		ch->AnimBlendRate += CHARA_ANIM_BLEND_SPEED ;
		if( ch->AnimBlendRate > 1.0f )
		{
			ch->AnimBlendRate = 1.0f ;
		}
	}

	// ĐĂAj[VP̏
	if( ch->PlayAnim1 != -1 )
	{
		// Aj[V̑Ԃ擾
		AnimTotalTime = MV1GetAttachAnimTotalTime( ch->ModelHandle, ch->PlayAnim1 ) ;

		// ĐԂi߂
		ch->AnimPlayCount1 += CHARA_PLAY_ANIM_SPEED ;

		// ĐԂԂɓBĂĐԂ[v
		if( ch->AnimPlayCount1 >= AnimTotalTime )
		{
			ch->AnimPlayCount1 = fmod( ch->AnimPlayCount1, AnimTotalTime ) ;
		}

		// ύXĐԂfɔf
		MV1SetAttachAnimTime( ch->ModelHandle, ch->PlayAnim1, ch->AnimPlayCount1 ) ;

		// Aj[VP̃fɑ΂锽fZbg
		MV1SetAttachAnimBlendRate( ch->ModelHandle, ch->PlayAnim1, ch->AnimBlendRate ) ;
	}

	// ĐĂAj[VQ̏
	if( ch->PlayAnim2 != -1 )
	{
		// Aj[V̑Ԃ擾
		AnimTotalTime = MV1GetAttachAnimTotalTime( ch->ModelHandle, ch->PlayAnim2 ) ;

		// ĐԂi߂
		ch->AnimPlayCount2 += CHARA_PLAY_ANIM_SPEED ;

		// ĐԂԂɓBĂĐԂ[v
		if( ch->AnimPlayCount2 > AnimTotalTime )
		{
			ch->AnimPlayCount2 = fmod( ch->AnimPlayCount2, AnimTotalTime ) ;
		}

		// ύXĐԂfɔf
		MV1SetAttachAnimTime( ch->ModelHandle, ch->PlayAnim2, ch->AnimPlayCount2 ) ;

		// Aj[VQ̃fɑ΂锽fZbg
		MV1SetAttachAnimBlendRate( ch->ModelHandle, ch->PlayAnim2, 1.0f - ch->AnimBlendRate ) ;
	}
}


// vC[̏
void Player_Initialize( void )
{
	// LN^[
	Chara_Initialize( &pl.CharaInfo, VGet( 0.0f, 0.0f, 0.0f ) ) ;
}

// vC[̌n
void Player_Terminate( void )
{
	// LN^[̌n
	Chara_Terminate( &pl.CharaInfo ) ;
}

// vC[̏
void Player_Process( void )
{
	VECTOR UpMoveVec ;		// {^uv͂Ƃ̃vC[̈ړxNg
	VECTOR LeftMoveVec ;		// {^uv͂Ƃ̃vC[̈ړxNg
	VECTOR MoveVec ;		// ̃t[̈ړxNg
	int JumpFlag ;			// WvtO
	int i ;

	// vC[̈ړ̃xNgZo
	{
		// {^uvƂ̃vC[̈ړxNg̓J̎x𔲂
		UpMoveVec = VSub( cam.Target, cam.Eye ) ;
		UpMoveVec.y = 0.0f ;

		// {^uvƂ̃vC[̈ړxNg͏Ƃ̕xNgƂx̃vX̃xNgɐȕ
		LeftMoveVec = VCross( UpMoveVec, VGet( 0.0f, 1.0f, 0.0f ) ) ;

		// ̃xNg𐳋K( xNg̒PDOɂ邱 )
		UpMoveVec = VNorm( UpMoveVec ) ;
		LeftMoveVec = VNorm( LeftMoveVec ) ;
	}

	// ̃t[ł̈ړxNg
	MoveVec = VGet( 0.0f, 0.0f, 0.0f ) ;

	// WvtO|
	JumpFlag = 0 ;

	// pbĥR{^ƍVtgǂĂȂvC[̈ړ
	if( CheckHitKey( KEY_INPUT_LSHIFT ) == 0 && ( inp.NowInput & PAD_INPUT_C ) == 0 )
	{
		// {^uv͂ꂽJ̌Ă猩čɈړ
		if( inp.NowInput & PAD_INPUT_LEFT  )
		{
			// ړxNgɁuv͂ꂽ̈ړxNgZ
			MoveVec = VAdd( MoveVec, LeftMoveVec ) ;
		}
		else
		// {^uv͂ꂽJ̌Ă猩ĉEɈړ
		if( inp.NowInput & PAD_INPUT_RIGHT )
		{
			// ړxNgɁuv͂ꂽ̈ړxNg𔽓]̂Z
			MoveVec = VAdd( MoveVec, VScale( LeftMoveVec, -1.0f ) ) ;
		}

		// {^uv͂ꂽJ̌ĂɈړ
		if( inp.NowInput & PAD_INPUT_UP    )
		{
			// ړxNgɁuv͂ꂽ̈ړxNgZ
			MoveVec = VAdd( MoveVec, UpMoveVec ) ;
		}
		else
		// {^uv͂ꂽJ̕Ɉړ
		if( inp.NowInput & PAD_INPUT_DOWN  )
		{
			// ړxNgɁuv͂ꂽ̈ړxNg𔽓]̂Z
			MoveVec = VAdd( MoveVec, VScale( UpMoveVec, -1.0f ) ) ;
		}

		// {^PĂWvtO𗧂Ă
		if( inp.EdgeInput & PAD_INPUT_A )
		{
			JumpFlag = 1 ;
		}
	}

	// ړړxŃXP[O
	MoveVec = VScale( MoveVec, CHARA_MOVE_SPEED ) ;

	// vC[LȊOƂ̓蔻s
	for( i = 0 ; i < NOTPLAYER_NUM ; i ++ )
	{
		Chara_Collision( &pl.CharaInfo, &MoveVec, &npl[ i ].CharaInfo ) ;
	}

	// LN^[𓮍삳鏈s
	Chara_Process( &pl.CharaInfo, MoveVec, JumpFlag ) ;
}

// vC[ȊOL̏
void NotPlayer_Initialize( void )
{
	int i ;
	static VECTOR FirstPosition[ NOTPLAYER_NUM ] =
	{
		{ -3000.0f, 0.0f, 2300.0f },
		{ -2500.0f, 7300.0f, -2500.0f },
		{ -2600.0f, 0.0f, -3100.0f },
		{  2800.0f, 0.0f, 200.0f },
	} ;

	for( i = 0 ; i < NOTPLAYER_NUM ; i ++ )
	{
		// LN^[
		Chara_Initialize( &npl[ i ].CharaInfo, FirstPosition[ i ] ) ;

		// ړԂ
		npl[ i ].MoveTime = 0 ;

		// ړ
		npl[ i ].MoveAngle = GetRand( 1000 ) * DX_PI_F * 2.0f / 1000.0f ;
	}
}

// vC[ȊOĽn
void NotPlayer_Terminate( void )
{
	int i ;

	// LN^̐JԂ
	for( i = 0 ; i < NOTPLAYER_NUM ; i ++ )
	{
		// LN^[̌n
		Chara_Terminate( &npl[ i ].CharaInfo ) ;
	}
}

// vC[ȊOL̏
void NotPlayer_Process( void )
{
	int i ;
	int j ;
	VECTOR MoveVec ;
	int JumpFlag ;

	// LN^̐JԂ
	for( i = 0 ; i < NOTPLAYER_NUM ; i ++ )
	{
		// WvtO|Ă
		JumpFlag = 0 ;

		// 莞Ԃo߂ړύX
		npl[ i ].MoveTime ++ ;
		if( npl[ i ].MoveTime >= NOTPLAYER_MOVETIME )
		{
			npl[ i ].MoveTime = 0 ;

			// V̌
			npl[ i ].MoveAngle = GetRand( 1000 ) * DX_PI_F * 2.0f / 1000.0f ;

			// mŃWv
			if( GetRand( 1000 ) < NOTPLAYER_JUMPRATIO )
			{
				JumpFlag = 1 ;
			}
		}

		// V̊pxxNgZo
		MoveVec.x = cos( npl[ i ].MoveAngle ) * CHARA_MOVE_SPEED ;
		MoveVec.y = 0.0f ;
		MoveVec.z = sin( npl[ i ].MoveAngle ) * CHARA_MOVE_SPEED ;

		// vC[Ƃ̓蔻s
		Chara_Collision( &npl[ i ].CharaInfo, &MoveVec, &pl.CharaInfo ) ;

		// ȊÕvC[LƂ̓蔻s
		for( j = 0 ; j < NOTPLAYER_NUM ; j ++ )
		{
			// Ƃ̓蔻͂Ȃ
			if( i == j ) continue ;

			Chara_Collision( &npl[ i ].CharaInfo, &MoveVec, &npl[ j ].CharaInfo ) ;
		}

		// ړs
		Chara_Process( &npl[ i ].CharaInfo, MoveVec, JumpFlag ) ; 
	}
}

// Xe[W̏
void Stage_Initialize( void )
{
	// Xe[Wf̓ǂݍ
	stg.ModelHandle = MV1LoadModel( "ColTestStage.mqo" ) ;

	// fŜ̃RW̃ZbgAbv
	MV1SetupCollInfo( stg.ModelHandle, -1 ) ;


	// 쐬摜̃tH[}bgs_^łP`lAPUrbgɂ
	SetDrawValidFloatTypeGraphCreateFlag( TRUE ) ;
	SetCreateDrawValidGraphChannelNum( 1 ) ;
	SetCreateGraphColorBitDepth( 16 ) ;

	// ep[xL^摜̍쐬
	DepthBufferGraphHandle = MakeScreen( 4096, 4096, FALSE ) ;

	// ݒɖ߂
	SetDrawValidFloatTypeGraphCreateFlag( FALSE ) ;
	SetCreateDrawValidGraphChannelNum( 4 ) ;
	SetCreateGraphColorBitDepth( 32 ) ;

	// [xL^摜`p̒_VF[_[ǂݍ
	Skin4_DepthShadow_Step1_VertexShader = LoadVertexShader( "SkinMesh4_DepthShadow_Step1VS.vso" ) ;
	Normal_DepthShadow_Step1_VertexShader = LoadVertexShader( "NormalMesh_DepthShadow_Step1VS.vso" ) ;

	// [xL^摜`p̃sNZVF[_[ǂݍ
	DepthShadow_Step1_PixelShader = LoadPixelShader( "DepthShadow_Step1PS.pso" ) ;

	// [xL^摜gfBNViCg̕`p_VF[_[ǂݍ
	Skin4_DirLight_DepthShadow_Step2_VertexShader = LoadVertexShader( "SkinMesh4_DirLight_DepthShadow_Step2VS.vso" ) ;
	Normal_DirLight_DepthShadow_Step2_VertexShader = LoadVertexShader( "NormalMesh_DirLight_DepthShadow_Step2VS.vso" ) ;

	// [xL^摜gfBNViCg̕`psNZVF[_[ǂݍ
	DirLight_DepthShadow_Step2_PixelShader = LoadPixelShader( "DirLight_DepthShadow_Step2PS.pso" ) ;
}

// Xe[W̌n
void Stage_Terminate( void )
{
	// Xe[Wf̌n
	MV1DeleteModel( stg.ModelHandle ) ;
}

// J̏
void Camera_Initialize( void )
{
	// J̏px͂PWOx
	cam.AngleH = DX_PI_F ;

	// px͂Ox
	cam.AngleV = 0.0f ;
}

// J̏
void Camera_Process( void )
{
	// pbĥR{^AVtgL[Ăꍇ̂݊pxύXs
	if( CheckHitKey( KEY_INPUT_LSHIFT ) || ( inp.NowInput & PAD_INPUT_C ) )
	{
		// uv{^Ă琅px}CiX
		if( inp.NowInput & PAD_INPUT_LEFT )
		{
			cam.AngleH -= CAMERA_ANGLE_SPEED ;

			// |PWOxȉɂȂpxl傫Ȃ肷Ȃ悤ɂRUOx𑫂
			if( cam.AngleH < -DX_PI_F )
			{
				cam.AngleH += DX_TWO_PI_F ;
			}
		}

		// uv{^Ă琅pxvX
		if( inp.NowInput & PAD_INPUT_RIGHT )
		{
			cam.AngleH += CAMERA_ANGLE_SPEED ;

			// PWOxȏɂȂpxl傫Ȃ肷Ȃ悤ɂRUOx
			if( cam.AngleH > DX_PI_F )
			{
				cam.AngleH -= DX_TWO_PI_F ;
			}
		}

		// uv{^Ă琂px}CiX
		if( inp.NowInput & PAD_INPUT_UP )
		{
			cam.AngleV -= CAMERA_ANGLE_SPEED ;

			// pxȉɂ͂ȂȂ悤ɂ
			if( cam.AngleV < -DX_PI_F / 2.0f + 0.6f )
			{
				cam.AngleV = -DX_PI_F / 2.0f + 0.6f ;
			}
		}

		// uv{^Ă琂pxvX
		if( inp.NowInput & PAD_INPUT_DOWN )
		{
			cam.AngleV += CAMERA_ANGLE_SPEED ;

			// pxȏɂ͂ȂȂ悤ɂ
			if( cam.AngleV > DX_PI_F / 2.0f - 0.6f )
			{
				cam.AngleV = DX_PI_F / 2.0f - 0.6f ;
			}
		}
	}

	// J̒_̓vC[WKlW
	cam.Target = VAdd( pl.CharaInfo.Position, VGet( 0.0f, CAMERA_PLAYER_TARGET_HEIGHT, 0.0f ) ) ;

	// J̍W肷
	{
		MATRIX RotZ, RotY ;
		float Camera_Player_Length ;
		MV1_COLL_RESULT_POLY_DIM HRes ;
		int HitNum ;

		// ̉]͂x]
		RotY = MGetRotY( cam.AngleH ) ;

		// ̉]͂y] )
		RotZ = MGetRotZ( cam.AngleV ) ;

		// JvC[܂ł̏Zbg
		Camera_Player_Length = CAMERA_PLAYER_LENGTH ;

		// J̍WZo
		// wɃJƃvC[Ƃ̋LтxNg
		// ]( y] )Ɛ]( x] )čX
		// _̍W𑫂̂J̍W
		cam.Eye = VAdd( VTransform( VTransform( VGet( -Camera_Player_Length, 0.0f, 0.0f ), RotZ ), RotY ), cam.Target ) ;

		// _J̍W܂ł̊ԂɃXe[W̃|S邩ׂ
		HRes = MV1CollCheck_Capsule( stg.ModelHandle, -1, cam.Target, cam.Eye, CAMERA_COLLISION_SIZE );
		HitNum = HRes.HitNum ;
		MV1CollResultPolyDimTerminate( HRes ) ;
		if( HitNum != 0 )
		{
			float NotHitLength ;
			float HitLength ;
			float TestLength ;
			VECTOR TestPosition ;

			// 疳ʒu܂ŃvC[ɋ߂Â

			// |SɓȂZbg
			NotHitLength = 0.0f ;

			// |Sɓ鋗Zbg
			HitLength = Camera_Player_Length ;
			do
			{
				// 邩ǂeXg鋗Zbg( ȂƓ鋗̒ )
				TestLength = NotHitLength + ( HitLength - NotHitLength ) / 2.0f ;

				// eXgp̃JWZo
				TestPosition = VAdd( VTransform( VTransform( VGet( -TestLength, 0.0f, 0.0f ), RotZ ), RotY ), cam.Target ) ;

				// VWŕǂɓ邩eXg
				HRes = MV1CollCheck_Capsule( stg.ModelHandle, -1, cam.Target, TestPosition, CAMERA_COLLISION_SIZE );
				HitNum = HRes.HitNum ;
				MV1CollResultPolyDimTerminate( HRes ) ;
				if( HitNum != 0 )
				{
					// 瓖鋗 TestLength ɕύX
					HitLength = TestLength ;
				}
				else
				{
					// Ȃ瓖Ȃ TestLength ɕύX
					NotHitLength = TestLength ;
				}

				// HitLength  NoHitLength \ɋ߂ÂĂȂ烋[v
			}while( HitLength - NotHitLength > 0.1f ) ;

			// J̍WZbg
			cam.Eye = TestPosition ;
		}
	}
}


// ep̐[xL^摜̏s
void SetupDepthImage( void )
{
	int i ;
	VECTOR LightDirection ;
	VECTOR LightPosition ;
	VECTOR LightTarget ;


	// `ep[xL^摜ɂ
	SetDrawScreen( DepthBufferGraphHandle ) ;

	// ep[xL^摜^ɃNA
	SetBackgroundColor( 255, 255, 255 ) ;
	ClearDrawScreen() ;
	SetBackgroundColor( 0, 0, 0 ) ;


	// J̃^Cv𐳎ˉe^CvɃZbgA`͈͂w
	SetupCamera_Ortho( 13250.0f ) ;

	// `悷鉜s͈͂Zbg
	SetCameraNearFar( 10.0f, 13050.0f ) ;

	// J̌̓Cǧ
	LightDirection = GetLightDirection() ;

	// J̈ʒuƒ_̓Xe[WŜnʒu
	LightTarget.x = 3620.0f ;
	LightTarget.y = 0.0f ;
	LightTarget.z = 3830.0f ;
	LightPosition = VAdd( LightTarget, VScale( LightDirection, -12400.0f ) ) ;
	SetCameraPositionAndTarget_UpVecY( LightPosition, LightTarget ) ;

	// ݒ肵J̃r[sƎˉes擾Ă
	LightCamera_ViewMatrix = GetCameraViewMatrix() ;
	LightCamera_ProjectionMatrix = GetCameraProjectionMatrix() ;


	// f̕`ɃIWĩVF[_[gp悤ɐݒ肷
	MV1SetUseOrigShader( TRUE ) ;

	// [xL^摜ւ̕`p̃sNZVF[_[Zbg
	SetUsePixelShader( DepthShadow_Step1_PixelShader ) ;


	// [xL^摜ւ̍̃bV`p̒_VF[_[Zbg
	SetUseVertexShader( Normal_DepthShadow_Step1_VertexShader ) ;

	// Xe[W`
	MV1DrawModel( stg.ModelHandle ) ;


	// [xL^摜ւ̃XLjObV`p̒_VF[_[Zbg
	SetUseVertexShader( Skin4_DepthShadow_Step1_VertexShader ) ;

	// vC[f̕`
	MV1DrawModel( pl.CharaInfo.ModelHandle ) ;

	// vC[ȊOLf̕`
	for( i = 0 ; i < NOTPLAYER_NUM ; i ++ )
	{
		MV1DrawModel( npl[ i ].CharaInfo.ModelHandle ) ;
	}


	// f̕`ɃIWĩVF[_[gp悤ɂݒ
	MV1SetUseOrigShader( FALSE ) ;

	// `𗠉ʂɖ߂
	SetDrawScreen( DX_SCREEN_BACK ) ;
}

// ep̐[xL^摜ge𗎂Ƃ܂߂f̕`
void DrawModelWithDepthShadow( void )
{
	int i ;

	// J̐ݒs
	SetCameraPositionAndTarget_UpVecY( cam.Eye, cam.Target ) ;

	// f̕`ɃIWĩVF[_[gp悤ɐݒ肷
	MV1SetUseOrigShader( TRUE ) ;

	// [xL^摜ge{fBNViCg`p̃sNZVF[_[Zbg
	SetUsePixelShader( DirLight_DepthShadow_Step2_PixelShader ) ;

	// ep[xL^摜`悵Ƃ̃J̃r[sƎˉes萔ɐݒ肷
	SetVSConstFMtx( 43, LightCamera_ViewMatrix ) ;
	SetVSConstFMtx( 47, LightCamera_ProjectionMatrix ) ;

	// ep[xL^摜eNX`PɃZbg
	SetUseTextureToShader( 1, DepthBufferGraphHandle ) ;


	// [xL^摜ge{fBNViCg̍̃bV`p̒_VF[_[Zbg
	SetUseVertexShader( Normal_DirLight_DepthShadow_Step2_VertexShader ) ;

	// Xe[Wf̕`
	MV1DrawModel( stg.ModelHandle ) ;


	// [xL^摜ge{fBNViCg̃XLjObV`p̒_VF[_[Zbg
	SetUseVertexShader( Skin4_DirLight_DepthShadow_Step2_VertexShader ) ;

	// vC[f̕`
	MV1DrawModel( pl.CharaInfo.ModelHandle ) ;

	// vC[ȊOLf̕`
	for( i = 0 ; i < NOTPLAYER_NUM ; i ++ )
	{
		MV1DrawModel( npl[ i ].CharaInfo.ModelHandle ) ;
	}

	// f̕`ɃIWĩVF[_[gp悤ɂݒ
	MV1SetUseOrigShader( FALSE ) ;

	// gpeNX`̐ݒ
	SetUseTextureToShader( 1, -1 ) ;

	// ݒ肵萔
	ResetVSConstF( 43, 8 ) ;
}

// `揈
void Render_Process( void )
{
	// ep̐[xL^摜̏s
	SetupDepthImage() ;

	// ep̐[xL^摜ge𗎂Ƃ܂߂f̕`
	DrawModelWithDepthShadow() ;
}

// WinMain
int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow )
{
	// EChE[hŋN
	ChangeWindowMode( TRUE ) ;

	// Direct3D9Ex gp
	SetUseDirect3DVersion( DX_DIRECT3D_9EX ) ;

	// Cȕ
	if( DxLib_Init() < 0 )
		return -1 ;

	// LN^[̋ʏ
	CharaCommon_Initialize() ;

	// vC[̏
	Player_Initialize() ;

	// vC[ȊOL̏
	NotPlayer_Initialize() ;

	// Xe[W̏
	Stage_Initialize() ;

	// J̏
	Camera_Initialize() ;

	// `𗠉ʂɂ
	SetDrawScreen( DX_SCREEN_BACK ) ;

	// drbL[邩AEChE܂Ń[v
	while( ProcessMessage() == 0 && CheckHitKey( KEY_INPUT_ESCAPE ) == 0 )
	{
		// ʂNA
		ClearDrawScreen() ;

		// ͏
		Input_Process() ;

		// vC[ȊOL̏
		NotPlayer_Process() ;

		// vC[̏
		Player_Process() ;

		// J̏
		Camera_Process() ;

		// `揈
		Render_Process() ;

		// ʂ̓e\ʂɔf
		ScreenFlip() ;
	}

	// vC[ȊOĽn
	NotPlayer_Terminate() ;

	// vC[̌n
	Player_Terminate() ;

	// LN^[ʏ̌n
	CharaCommon_Terminate() ;

	// Xe[W̌n
	Stage_Terminate() ;

	// Cǔn
	DxLib_End() ;

	// \tgI
	return 0 ;
}
