// ============================================================================
//
//	HuffmankCu
//
//	Huffman.cpp
//
//	Creator			: Rc@I
//	Creation Date	: 2018/12/16
//
// ============================================================================

// include --------------------------------------
#include "Huffman.h"
#include <stdio.h>
#include <malloc.h>
#include <string.h>

// data type ------------------------------------

// lƂ̏oZoꂽGR[h̃rbgȀ񓙂̍\
struct HUFFMAN_NODE
{
    u64 Weight ;                  // o( f[^ł͏o𑫂m )
    int BitNum ;                  // k̃rbg̃rbg( f[^ł͎gȂ )
    unsigned char BitArray[32] ;  // k̃rbg( f[^ł͎gȂ )
    int Index ;                   // f[^Ɋ蓖ĂꂽQƃCfbNX( 0 or 1 )

    int ParentNode ;              // ̃f[^]Ă錋f[^̗vfz̃CfbNX
    int ChildNode[2] ;            // ̃f[^Qvf̗vfzCfbNX( f[^ł͂Ȃꍇ͂ǂ -1 )
} ;

// rbgPʓo͗pf[^\
struct BIT_STREAM
{
	u8 *Buffer ;
	u64 Bytes ;
	u8 Bits ;
} ;

// kf[^̏
//   6bit      kÕf[^̃TCỸrbg(A) - 1( 0=1rbg 63=64rbg )
//   (A)bit    kÕf[^̃TCY
//   6bit      k̃f[^̃TCỸrbg(B) - 1( wb_܂܂Ȃ )( 0=1rbg 63=64rbg )
//   (B)bit    k̃f[^̃TCY
//
//   3bit      lƂ̏opx̍l̃rbg(C) / 2 - 1( 0=2rbg 7=16rbg )
//   1bit      rbg( 0=vX  1=}CiX )
//   (C)bit    lƂ̏opx̍l
//   ꂪ256

// proto type -----------------------------------

static void BitStream_Init(  BIT_STREAM *BitStream, void *Buffer, bool IsRead ) ;		// rbgPʓo͂̏
static void BitStream_Write( BIT_STREAM *BitStream, u8 BitNum, u64 OutputData ) ;		// rbgPʂ̐l݂̏s
static u64  BitStream_Read(  BIT_STREAM *BitStream, u8 BitNum ) ;						// rbgPʂ̐l̓ǂݍ݂s
static u8   BitStream_GetBitNum( u64 Data ) ;											// w̐l̃rbg擾
static u64  BitStream_GetBytes( BIT_STREAM *BitStream ) ;								// rbgPʂ̓o̓f[^̃TCY( oCg )擾

// code -----------------------------------------

// rbgPʓo͂̏
void BitStream_Init( BIT_STREAM *BitStream, void *Buffer, bool IsRead )
{
	BitStream->Buffer = ( u8 * )Buffer ;
	BitStream->Bytes = 0 ;
	BitStream->Bits = 0 ;
	if( IsRead == false )
	{
		BitStream->Buffer[ 0 ] = 0 ;
	}
}

// rbgPʂ̐l݂̏s
void BitStream_Write( BIT_STREAM *BitStream, u8 BitNum, u64 OutputData )
{
	u32 i ;
	for( i = 0 ; i < BitNum ; i ++ )
	{
		BitStream->Buffer[ BitStream->Bytes ] |= ( ( OutputData >> ( BitNum - 1 - i ) ) & 1 ) << ( 7 - BitStream->Bits ) ;
		BitStream->Bits ++ ;
		if( BitStream->Bits == 8 )
		{
			BitStream->Bytes ++ ;
			BitStream->Bits = 0 ;
			BitStream->Buffer[ BitStream->Bytes ] = 0 ;
		}
	}
}

// rbgPʂ̐l̓ǂݍ݂s
u64 BitStream_Read( BIT_STREAM *BitStream, u8 BitNum )
{
	u64 Result = 0 ;
	u32 i ;
	for( i = 0 ; i < BitNum ; i ++ )
	{
		Result |= ( ( u64 )( ( BitStream->Buffer[ BitStream->Bytes ] >> ( 7 - BitStream->Bits ) ) & 1 ) ) << ( BitNum - 1 - i ) ;
		BitStream->Bits ++ ;
		if( BitStream->Bits == 8 )
		{
			BitStream->Bytes ++ ;
			BitStream->Bits = 0 ;
		}
	}

	return Result ;
}

// w̐l̃rbg擾
u8 BitStream_GetBitNum( u64 Data )
{
	u32 i ;
	for( i = 1 ; i < 64 ; i ++ )
	{
		if( Data < ( 1ULL << i ) )
		{
			return i ;
		}
	}

	return i ;
}

// rbgPʂ̓o̓f[^̃TCY( oCg )擾
u64 BitStream_GetBytes( BIT_STREAM *BitStream )
{
	return BitStream->Bytes + ( BitStream->Bits != 0 ? 1 : 0 ) ;
}

// f[^k
//
// ߂l:k̃TCY  0 ̓G[  Dest  NULL ƈkf[^i[ɕKvȃTCYԂ
u64 Huffman_Encode( void *Src, u64 SrcSize, void *Dest )
{
    // f[^Ɛlf[^AO`QTT܂łlf[^
    // (f[^̐ƈkf[^̎ނ̐𑫂ƕKwނ̐{(ނ̐|P)xɂȂB
    // wzgHxƎv̓nt}k̐ŏoĂ`,a,b,c,ď̐
    // Ă݂ĉAނTɑ΂Č͈ȂSɂȂĂ͂łB
    // ނU̎͌͂TɁAĎނQTU̎͌͂QTTɂȂ܂)
    HUFFMAN_NODE Node[256 + 255] ;

    unsigned char *SrcPoint ;
    u64 PressBitCounter, PressSizeCounter, SrcSizeCounter ;
    u64 i ;

    // void ^̃|C^ł̓AhX̑삪oȂ̂ unsigned char ^̃|C^ɂ
    SrcPoint = ( unsigned char * )Src ;

    // el̈k̃rbgZo
    {
        int NodeIndex, MinNode1, MinNode2 ;
        int NodeNum, DataNum ;

        // lf[^
        for( i = 0 ; i < 256 ; i ++ )
        {
            Node[i].Weight = 0 ;           // o͂ꂩZôłOɏ
            Node[i].ChildNode[0] = -1 ;    // lf[^I_Ȃ̂ -1 Zbg
            Node[i].ChildNode[1] = -1 ;    // lf[^I_Ȃ̂ -1 Zbg
            Node[i].ParentNode = -1 ;      // ܂ǂ̗vfƂĂȂ̂ -1 Zbg
        }

        // el̏oJEg
        for( i = 0 ; i < SrcSize ; i ++ )
        {
            Node[ SrcPoint[i] ].Weight ++ ;
        }

		// o 0`65535 ̔䗦ɕϊ
		for( i = 0 ; i < 256 ; i ++ )
		{
			Node[ i ].Weight = Node[ i ].Weight * 0xffff / SrcSize ;
		}

        // ȍȂlf[^ or f[^q
        // Vf[^쐬ASĂ̗vfqŎcPɂȂ܂ŌJԂ
        DataNum = 256 ; // cvf
        NodeNum = 256 ; // ɐV錋f[^̗vfz̃CfbNX
        while( DataNum > 1 )
        {
            // ol̒ႢvfT
            {
                MinNode1 = -1 ;
                MinNode2 = -1 ;
                
                // cĂvfSĂ𒲂ׂ܂Ń[v
                NodeIndex = 0 ;
                for( i = 0 ; i < DataNum ; NodeIndex ++ )
                {
                    // ɉ̗vfƌĂꍇ͑ΏۊO
                    if( Node[NodeIndex].ParentNode != -1 ) continue ;
                    
                    i ++ ;
                    
                    // ܂LȗvfZbgĂȂAol
                    // ȂvfXV
                    if( MinNode1 == -1 || Node[MinNode1].Weight > Node[NodeIndex].Weight )
                    {
                        // ܂ňԏolȂƎvꂽ
                        // vf͓Ԗڂɍ~i
                        MinNode2 = MinNode1 ;

                        // VԂ̗vf̗vfz̃CfbNXۑ
                        MinNode1 = NodeIndex ;
                    }
                    else
                    {
                        // Ԃ͏olĂAԖڂ͏ol
                        // ȂȂ̂ňꉞ`FbN(͓Ԗڂɏol
                        // ȂvfZbgĂȂꍇZbg)
                        if( MinNode2 == -1 || Node[MinNode2].Weight > Node[NodeIndex].Weight )
                        {
                            MinNode2 = NodeIndex ;
                        }
                    }
                }
            }
            
            // ̗vfqŐVvf(f[^)
            Node[NodeNum].ParentNode = -1 ;  // Vf[^͓R܂ƂqĂȂ̂ -1 
            Node[NodeNum].Weight = Node[MinNode1].Weight + Node[MinNode2].Weight ;    // ol͓̐l𑫂̂Zbg
            Node[NodeNum].ChildNode[0] = MinNode1 ;    // ̌ 0 I񂾂olԏȂvfɌq
            Node[NodeNum].ChildNode[1] = MinNode2 ;    // ̌ 1 I񂾂olԖڂɏȂvfɌq

            // ꂽvfɁABɉ̒l蓖ĂꂽZbg
            Node[MinNode1].Index = 0 ;    // ԏolȂvf 0 
            Node[MinNode2].Index = 1 ;    // ԖڂɏolȂvf 1 

            // ꂽvfɁABf[^̗vfzCfbNXZbg
            Node[MinNode1].ParentNode = NodeNum ;
            Node[MinNode2].ParentNode = NodeNum ;

            // vf̐₷
            NodeNum ++ ;

            // cvf̐́AvfVǉꂽ
            // ̗vfČ̑ΏۂOꂽ̂
            //  1 - 2  -1 
            DataNum -- ;
        }
        
        // el̈k̃rbgo
        {
            unsigned char TempBitArray[32] ;
            int TempBitIndex, TempBitCount, BitIndex, BitCount ;
        
            // lf[^̎ނ̐JԂ
            for( i = 0 ; i < 256 ; i ++ )
            {
                // lf[^猋f[^֏ւƒHărbg𐔂
                {
                    // rbgĂ
                    Node[i].BitNum = 0 ;
                    
                    // ꎞIɐlf[^kĂƂ̃rbgۑ鏈̏
                    TempBitIndex = 0 ;
                    TempBitCount = 0 ;
                    TempBitArray[TempBitIndex] = 0 ;
                    
                    // ƌĂJEg(Vӂ͉ƂĂȂ̂ŏI_ƕ)
                    for( NodeIndex = ( int )i ; Node[NodeIndex].ParentNode != -1 ; NodeIndex = Node[NodeIndex].ParentNode )
                    {
                        // zvfɓrbgf[^͂WȂ̂ŁAzvf
                        // ɂWۑĂ玟̔zvfɕۑύX
                        if( TempBitCount == 8 )
                        {
                            TempBitCount = 0 ;
                            TempBitIndex ++ ;
                            TempBitArray[TempBitIndex] = 0 ;
                        }
                        
                        // Vޏō܂ł̃f[^㏑Ă܂Ȃ悤ɂPrbgɃVtg
                        TempBitArray[TempBitIndex] <<= 1 ;

                        // f[^ɊUꂽCfbNXŉʃrbg(ԉẼrbg)ɏ
                        TempBitArray[TempBitIndex] |= (unsigned char)Node[NodeIndex].Index ;

                        // ۑrbg𑝂₷
                        TempBitCount ++ ;

                        // rbg𑝂₷
                        Node[i].BitNum ++ ;
                    }
                }
				
                // TempBitArray ɗ܂f[^͐lf[^猋f[^VӂɌ
                // ֏ւƑkẴrbgȂ̂ŁAt܂ɂȂƈk̃rbg
                // zƂĎgȂ(WJɓVӂ̌f[^琔lf[^܂ŒH邱Ƃ
                // oȂ)̂ŁAt܂ɂ̂𐔒lf[^̃rbgobt@ɕۑ
                {
                    BitCount = 0 ;
                    BitIndex = 0 ;
                    
                    // ŏ̃obt@Ă
                    // (S _a(or)Z ŏނ̂ŁAŏPɂȂĂ
                    // rbgɂOłP̂܂܂ɂȂĂ܂)
                    Node[i].BitArray[BitIndex] = 0 ;
                    
                    // ꎞIɕۑĂrbg̍ŏ܂ők
                    while( TempBitIndex >= 0 )
                    {
                        // 񂾃rbg̔zvfɓWrbg
                        // BĂ܂玟̔zvfɈڂ
                        if( BitCount == 8 )
                        {
                            BitCount = 0 ;
                            BitIndex ++ ;
                            Node[i].BitArray[BitIndex] = 0 ;
                        }

                        // ܂܂ĂȂrbgAhXɂPrbg
                        Node[i].BitArray[BitIndex] |= (unsigned char)( ( TempBitArray[TempBitIndex] & 1 ) << BitCount ) ;
						
                        // ݏIrbg͂Ȃ̂Ŏ̃rbg
                        // ߂悤ɂPrbgEɃVtg
                        TempBitArray[TempBitIndex] >>= 1 ;
                        
                        // Prbg񂾂̂ŎcrbgP炷
                        TempBitCount -- ;
                        
                        // ݏ݌ƂȂĂzvfɏłȂ
                        // rbg񂪖Ȃ玟̔zvfɈڂ
                        if( TempBitCount == 0 )
                        {
                            TempBitIndex -- ;
                            TempBitCount = 8 ;
                        }
                        
                        // 񂾃rbg𑝂₷
                        BitCount ++ ;
                    }
                }
            }
        }
    }

    // ϊ
    {
        unsigned char *PressData ;
        int BitData, BitCounter, BitIndex, BitNum, NodeIndex ;
        
        // kf[^i[AhXZbg
        // (kf[^{̂͌̃TCYAk̃TCYAel̏o
        // i[f[^̈̌Ɋi[)
        PressData = ( unsigned char * )Dest ;
        
        // kf[^̎QƃAhX
        SrcSizeCounter = 0 ;
        
        // kf[^̎QƃAhX
        PressSizeCounter = 0 ;
        
        // krbgf[^̃JE^
        PressBitCounter = 0 ;
        
        // kf[^̍ŏ̃oCgĂ
        if( Dest != NULL ) PressData[PressSizeCounter] = 0 ;

        // kΏƂ̃f[^SĈk̃rbgɕϊ܂Ń[v
        for( SrcSizeCounter = 0 ; SrcSizeCounter < SrcSize ; SrcSizeCounter ++ )
        {
            // ۑ鐔lf[^̃CfbNX擾
            NodeIndex = SrcPoint[SrcSizeCounter] ;
            
            // w̐lf[^̈k̃rbgo
            {
                // QƂz̃CfbNX
                BitIndex = 0 ;
                
                // zvf̏o͂rbg̏
                BitNum = 0 ;
                
                // ŏɏރrbg̔zvfZbg
                BitData = Node[NodeIndex].BitArray[0] ;

                // SẴrbgo͂܂Ń[v
                for( BitCounter = 0 ; BitCounter < Node[NodeIndex].BitNum ; BitCounter ++ )
                {
                    // 񂾃rbgWɂȂĂ玟̔zvfɈڂ
                    if( PressBitCounter == 8 )
                    {
                        PressSizeCounter ++ ;
                        if( Dest != NULL ) PressData[PressSizeCounter] = 0 ;
                        PressBitCounter = 0 ;
                    }
                    
                    // orbgWɂȂĂ玟̔zvfɈڂ
                    if( BitNum == 8 )
                    {
                        BitIndex ++ ;
                        BitData = Node[NodeIndex].BitArray[BitIndex] ;
                        BitNum = 0 ;
                    }
                    
                    // ܂܂ĂȂrbgAhXɂPrbg
                    if( Dest != NULL ) PressData[PressSizeCounter] |= (unsigned char)( ( BitData & 1 ) << PressBitCounter ) ;

                    // 񂾃rbg𑝂₷
                    PressBitCounter ++ ;

                    // ɏorbgŉʃrbg(ԉẼrbg)ɂׂ
                    // PrbgEVtg
                    BitData >>= 1 ;
                    
                    // orbg𑝂₷
                    BitNum ++ ;
                }
            }
        }
        
        // Ō̂PoCg̃TCY𑫂
        PressSizeCounter ++ ;
    }
    
    // kf[^̏ۑ
    {
		BIT_STREAM BitStream ;
		u8 HeadBuffer[ 256 * 2 + 32 ] ;
		u8 BitNum ;
		u64 HeadSize ;
		s32 WeightSaveData[ 256 ] ;

		BitStream_Init( &BitStream, HeadBuffer, false ) ;

        // ̃f[^̃TCYZbg
		BitNum = BitStream_GetBitNum( SrcSize ) ;
		if( BitNum > 0 )
		{
			BitNum -- ;
		}
        BitStream_Write( &BitStream, 6, BitNum ) ;
		BitStream_Write( &BitStream, BitNum + 1, SrcSize ) ;
        
        // k̃f[^̃TCYZbg
		BitNum = BitStream_GetBitNum( PressSizeCounter ) ;
        BitStream_Write( &BitStream, 6, BitNum ) ;
		BitStream_Write( &BitStream, BitNum + 1, PressSizeCounter ) ;
        
        // el̏o̍lۑ
		WeightSaveData[ 0 ] = ( s32 )Node[ 0 ].Weight ;
        for( i = 1 ; i < 256 ; i ++ )
        {
			WeightSaveData[ i ] = ( s32 )Node[ i ].Weight - ( s32 )Node[ i - 1 ].Weight ;
        }
        for( i = 0 ; i < 256 ; i ++ )
        {
			u64 OutputNum ;
			bool Minus ;

			if( WeightSaveData[ i ] < 0 )
			{
				OutputNum = ( u64 )( -WeightSaveData[ i ] ) ;
				Minus = true ;
			}
			else
			{
				OutputNum = ( u64 )WeightSaveData[ i ] ;
				Minus = false ;
			}

			BitNum = ( BitStream_GetBitNum( OutputNum ) + 1 ) / 2 ;
			if( BitNum > 0 )
			{
				BitNum -- ;
			}
	        BitStream_Write( &BitStream, 3, BitNum ) ;
			BitStream_Write( &BitStream, 1, Minus ? 1 : 0 ) ;
			BitStream_Write( &BitStream, ( BitNum + 1 ) * 2, OutputNum ) ;
        }
		
		// wb_TCY擾
		HeadSize = BitStream_GetBytes( &BitStream ) ;

		// kf[^̏kf[^ɃRs[
		if( Dest != NULL )
		{
			u64 j ;

			// wb_̕ړ
			for( j = PressSizeCounter - 1 ; j >= 0 ; j -- )
			{
				( ( u8 * )Dest )[ HeadSize + j ] = ( ( u8 * )Dest )[ j ] ;
				if( j == 0 )
				{
					break ;
				}
			}

			// wb_
			memcpy( Dest, HeadBuffer, ( size_t )HeadSize ) ;
		}

		// k̃TCYԂ
		return PressSizeCounter + HeadSize ;
    }
}

// kf[^
//
// ߂l:𓀌̃TCY  0 ̓G[  Dest  NULL Ɖ𓀃f[^i[ɕKvȃTCYԂ
u64 Huffman_Decode( void *Press, void *Dest )
{
    // f[^Ɛlf[^AO`QTT܂łlf[^
    HUFFMAN_NODE Node[256 + 255] ;

    u64 PressSizeCounter, DestSizeCounter, DestSize ;
    unsigned char *PressPoint, *DestPoint ;
	u64 OriginalSize ;
	u64 PressSize ;
	u64 HeadSize ;
	u16 Weight[ 256 ] ;
    int i ;

    // void ^̃|C^ł̓AhX̑삪oȂ̂ unsigned char ^̃|C^ɂ
    PressPoint = ( unsigned char * )Press ;
    DestPoint = ( unsigned char * )Dest ;

    // kf[^̏擾
	{
		BIT_STREAM BitStream ;
		u8 BitNum ;
		u8 Minus ;
		u16 SaveData ;

		BitStream_Init( &BitStream, PressPoint, true ) ;

		OriginalSize = BitStream_Read( &BitStream, ( u8 )( BitStream_Read( &BitStream, 6 ) + 1 ) ) ;
		PressSize    = BitStream_Read( &BitStream, ( u8 )( BitStream_Read( &BitStream, 6 ) + 1 ) ) ;

		// opx̃e[u𕜌
		BitNum      = ( u8 )( BitStream_Read( &BitStream, 3 ) + 1 ) * 2 ;
		Minus       = ( u8 )BitStream_Read( &BitStream, 1 ) ;
		SaveData    = ( u16 )BitStream_Read( &BitStream, BitNum ) ;
		Weight[ 0 ] = SaveData ;
        for( i = 1 ; i < 256 ; i ++ )
        {
			BitNum      = ( u8 )( BitStream_Read( &BitStream, 3 ) + 1 ) * 2 ;
			Minus       = ( u8 )BitStream_Read( &BitStream, 1 ) ;
			SaveData    = ( u16 )BitStream_Read( &BitStream, BitNum ) ;
			Weight[ i ] = Minus == 1 ? Weight[ i - 1 ] - SaveData : Weight[ i - 1 ] + SaveData ;
        }

		HeadSize = BitStream_GetBytes( &BitStream ) ;
	}
    
    // Dest  NULL ̏ꍇ 𓀌̃f[^̃TCYԂ
    if( Dest == NULL )
        return OriginalSize ;

    // 𓀌̃f[^̃TCY擾
    DestSize = OriginalSize ;

    // eľf[^\z
    {
        int NodeIndex, MinNode1, MinNode2 ;
        int NodeNum, DataNum ;

        // lf[^
        for( i = 0 ; i < 256 + 255 ; i ++ )
        {
            Node[i].Weight = Weight[i] ;    // o͕ۑĂf[^Rs[
            Node[i].ChildNode[0] = -1 ;    // lf[^I_Ȃ̂ -1 Zbg
            Node[i].ChildNode[1] = -1 ;    // lf[^I_Ȃ̂ -1 Zbg
            Node[i].ParentNode = -1 ;      // ܂ǂ̗vfƂĂȂ̂ -1 Zbg
        }

        // ȍȂlf[^ or f[^q
        // Vf[^쐬ASĂ̗vfqŎcPɂȂ܂ŌJԂ
        // (kƓR[hł)
        DataNum = 256 ; // cvf
        NodeNum = 256 ; // ɐV錋f[^̗vfz̃CfbNX
        while( DataNum > 1 )
        {
            // ol̒ႢvfT
            {
                MinNode1 = -1 ;
                MinNode2 = -1 ;
                
                // cĂvfSĂ𒲂ׂ܂Ń[v
                NodeIndex = 0 ;
                for( i = 0 ; i < DataNum ; NodeIndex ++ )
                {
                    // ɉ̗vfƌĂꍇ͑ΏۊO
                    if( Node[NodeIndex].ParentNode != -1 ) continue ;
                    
                    i ++ ;
                    
                    // ܂LȗvfZbgĂȂAol
                    // ȂvfXV
                    if( MinNode1 == -1 || Node[MinNode1].Weight > Node[NodeIndex].Weight )
                    {
                        // ܂ňԏolȂƎvꂽ
                        // vf͓Ԗڂɍ~i
                        MinNode2 = MinNode1 ;

                        // VԂ̗vf̗vfz̃CfbNXۑ
                        MinNode1 = NodeIndex ;
                    }
                    else
                    {
                        // Ԃ͏olĂAԖڂ͏ol
                        // ȂȂ̂ňꉞ`FbN(͓Ԗڂɏol
                        // ȂvfZbgĂȂꍇZbg)
                        if( MinNode2 == -1 || Node[MinNode2].Weight > Node[NodeIndex].Weight )
                        {
                            MinNode2 = NodeIndex ;
                        }
                    }
                }
            }
            
            // ̗vfqŐVvf(f[^)
            Node[NodeNum].ParentNode = -1 ;  // Vf[^͓R܂ƂqĂȂ̂ -1 
            Node[NodeNum].Weight = Node[MinNode1].Weight + Node[MinNode2].Weight ;    // ol͓̐l𑫂̂Zbg
            Node[NodeNum].ChildNode[0] = MinNode1 ;    // ̌ 0 I񂾂olԏȂvfɌq
            Node[NodeNum].ChildNode[1] = MinNode2 ;    // ̌ 1 I񂾂olԖڂɏȂvfɌq

            // ꂽvfɁABɉ̒l蓖ĂꂽZbg
            Node[MinNode1].Index = 0 ;    // ԏolȂvf 0 
            Node[MinNode2].Index = 1 ;    // ԖڂɏolȂvf 1 

            // ꂽvfɁABf[^̗vfzCfbNXZbg
            Node[MinNode1].ParentNode = NodeNum ;
            Node[MinNode2].ParentNode = NodeNum ;

            // vf̐₷
            NodeNum ++ ;

            // cvf̐́AvfVǉꂽ
            // ̗vfČ̑ΏۂOꂽ̂
            //  1 - 2  -1 
            DataNum -- ;
        }

        // el̈k̃rbgo
        {
            unsigned char TempBitArray[32] ;
            int TempBitIndex, TempBitCount, BitIndex, BitCount ;
        
            // lf[^ƌf[^̐JԂ
            for( i = 0 ; i < 256 + 254 ; i ++ )
            {
                // lf[^猋f[^֏ւƒHărbg𐔂
                {
                    // rbgĂ
                    Node[i].BitNum = 0 ;
                    
                    // ꎞIɐlf[^kĂƂ̃rbgۑ鏈̏
                    TempBitIndex = 0 ;
                    TempBitCount = 0 ;
                    TempBitArray[TempBitIndex] = 0 ;
                    
                    // ƌĂJEg(Vӂ͉ƂĂȂ̂ŏI_ƕ)
                    for( NodeIndex = ( int )i ; Node[NodeIndex].ParentNode != -1 ; NodeIndex = Node[NodeIndex].ParentNode )
                    {
                        // zvfɓrbgf[^͂WȂ̂ŁAzvf
                        // ɂWۑĂ玟̔zvfɕۑύX
                        if( TempBitCount == 8 )
                        {
                            TempBitCount = 0 ;
                            TempBitIndex ++ ;
                            TempBitArray[TempBitIndex] = 0 ;
                        }
                        
                        // Vޏō܂ł̃f[^㏑Ă܂Ȃ悤ɂPrbgɃVtg
                        TempBitArray[TempBitIndex] <<= 1 ;

                        // f[^ɊUꂽCfbNXŉʃrbg(ԉẼrbg)ɏ
                        TempBitArray[TempBitIndex] |= (unsigned char)Node[NodeIndex].Index ;

                        // ۑrbg𑝂₷
                        TempBitCount ++ ;

                        // rbg𑝂₷
                        Node[i].BitNum ++ ;
                    }
                }
				
                // TempBitArray ɗ܂f[^͐lf[^猋f[^VӂɌ
                // ֏ւƑkẴrbgȂ̂ŁAt܂ɂȂƈk̃rbg
                // zƂĎgȂ(WJɓVӂ̌f[^琔lf[^܂ŒH邱Ƃ
                // oȂ)̂ŁAt܂ɂ̂𐔒lf[^̃rbgobt@ɕۑ
                {
                    BitCount = 0 ;
                    BitIndex = 0 ;
                    
                    // ŏ̃obt@Ă
                    // (S _a(or)Z ŏނ̂ŁAŏPɂȂĂ
                    // rbgɂOłP̂܂܂ɂȂĂ܂)
                    Node[i].BitArray[BitIndex] = 0 ;
                    
                    // ꎞIɕۑĂrbg̍ŏ܂ők
                    while( TempBitIndex >= 0 )
                    {
                        // 񂾃rbg̔zvfɓWrbg
                        // BĂ܂玟̔zvfɈڂ
                        if( BitCount == 8 )
                        {
                            BitCount = 0 ;
                            BitIndex ++ ;
                            Node[i].BitArray[BitIndex] = 0 ;
                        }

                        // ܂܂ĂȂrbgAhXɂPrbg
                        Node[i].BitArray[BitIndex] |= (unsigned char)( ( TempBitArray[TempBitIndex] & 1 ) << BitCount ) ;
						
                        // ݏIrbg͂Ȃ̂Ŏ̃rbg
                        // ߂悤ɂPrbgEɃVtg
                        TempBitArray[TempBitIndex] >>= 1 ;
                        
                        // Prbg񂾂̂ŎcrbgP炷
                        TempBitCount -- ;
                        
                        // ݏ݌ƂȂĂzvfɏłȂ
                        // rbg񂪖Ȃ玟̔zvfɈڂ
                        if( TempBitCount == 0 )
                        {
                            TempBitIndex -- ;
                            TempBitCount = 8 ;
                        }
                        
                        // 񂾃rbg𑝂₷
                        BitCount ++ ;
                    }
                }
            }
		}
    }

    // 𓀏
    {
        unsigned char *PressData ;
        int PressBitCounter, PressBitData, Index, NodeIndex ;
		int NodeIndexTable[ 512 ] ;
		int j ;

		// erbgz񂪂ǂ̃m[hɌq邩̃e[u쐬
		{
			u16 BitMask[ 9 ] ;

			for( i = 0 ; i < 9 ; i ++ )
			{
				BitMask[ i ] = ( u16 )( ( 1 << ( i + 1 ) ) - 1 ) ;
			}

			for( i = 0 ; i < 512 ; i ++ )
			{
				NodeIndexTable[ i ] = -1 ;

				// rbgɓKm[hT
				for( j = 0 ; j < 256 + 254 ; j ++ )
				{
					u16 BitArray01 ;

					if( Node[ j ].BitNum > 9 )
					{
						continue ;
					}

					BitArray01 = ( u16 )Node[ j ].BitArray[ 0 ] | ( Node[ j ].BitArray[ 1 ] << 8 ) ;
					if( ( i & BitMask[ Node[ j ].BitNum - 1 ] ) == ( BitArray01 & BitMask[ Node[ j ].BitNum - 1 ] ) )
					{
						NodeIndexTable[ i ] = j ;
						break ;
					}
				}
			}
		}

        // kf[^{̂̐擪AhXZbg
        // (kf[^{̂͌̃TCYAk̃TCYAel̏o
        // i[f[^̈̌ɂ)
        PressData = PressPoint + HeadSize ;

        // 𓀂f[^̊i[AhX
        DestSizeCounter = 0 ;
        
        // kf[^̎QƃAhX
        PressSizeCounter = 0 ;
        
        // krbgf[^̃JE^
        PressBitCounter = 0 ;
        
        // kf[^̂PoCgڂZbg
        PressBitData = PressData[PressSizeCounter] ;

        // kÕf[^TCYɂȂ܂ŉ𓀏JԂ
        for( DestSizeCounter = 0 ; DestSizeCounter < DestSize ; DestSizeCounter ++ )
        {
            // rbg񂩂琔lf[^
            {
				// Ō17bytẽf[^͓VӂT( Ō̎̃oCgǂݏoƂă̕sȃANZXɂȂ\邽 )
				if( DestSizeCounter >= DestSize - 17 )
				{
					// f[^̓Vӂ͈ԍŌ̌f[^i[TPOԖ(OԂ琔)
					// Vӂ珇ɉɍ~Ă
					NodeIndex = 510 ;
				}
				else
				{
					// ȊȌꍇ̓e[ugp

                    //  PressBitData Ɋi[ĂSĂ
                    // rbgf[^g؂Ă܂ꍇ͎
                    // rbgf[^Zbg
                    if( PressBitCounter == 8 )
                    {
                        PressSizeCounter ++ ;
                        PressBitData = PressData[PressSizeCounter] ;
                        PressBitCounter = 0 ;
                    }

					// kf[^9bitpӂ
					PressBitData = ( PressBitData | ( PressData[ PressSizeCounter + 1 ] << ( 8 - PressBitCounter ) ) ) & 0x1ff ;

					// e[uŏ̌f[^T
					NodeIndex = NodeIndexTable[ PressBitData ] ;

					// gkf[^̃AhXi߂
					PressBitCounter += Node[ NodeIndex ].BitNum ;
					if( PressBitCounter >= 16 )
					{
						PressSizeCounter += 2 ;
						PressBitCounter -= 16 ;
						PressBitData = PressData[PressSizeCounter] >> PressBitCounter ;
					}
					else
					if( PressBitCounter >= 8 )
					{
						PressSizeCounter ++ ;
						PressBitCounter -= 8 ;
						PressBitData = PressData[PressSizeCounter] >> PressBitCounter ;
					}
					else
					{
						PressBitData >>= Node[ NodeIndex ].BitNum ;
					}
				}
                
                // lf[^ɒH蒅܂Ōf[^Ă
                while( NodeIndex > 255 )
                {
                    //  PressBitData Ɋi[ĂSĂ
                    // rbgf[^g؂Ă܂ꍇ͎
                    // rbgf[^Zbg
                    if( PressBitCounter == 8 )
                    {
                        PressSizeCounter ++ ;
                        PressBitData = PressData[PressSizeCounter] ;
                        PressBitCounter = 0 ;
                    }
                    
                    // Prbg擾
                    Index = PressBitData & 1 ;
                    
                    // gpPrbgEɃVtg
                    PressBitData >>= 1 ;
                    
                    // gprbg₷
                    PressBitCounter ++ ;
                    
                    // ̗vf(f[^lf[^͂܂Ȃ)Ɉڂ
                    NodeIndex = Node[NodeIndex].ChildNode[Index] ;
                }
            }

            // H蒅lf[^o
            DestPoint[DestSizeCounter] = (unsigned char)NodeIndex ;
        }
    }

    // 𓀌̃TCYԂ
    return OriginalSize ;
}

