// ============================================================================
//
//		t@C֌W̃Cu
//
//		Creator			: Rc@I
//		Creation Data	: 09/17/2004
//
// ============================================================================

#ifndef FILELIB_H
#define FILELIB_H

// include --------------------------------------
#include <stdio.h>
#include <tchar.h>
#include "DataType.h"

// define ---------------------------------------

// data type ------------------------------------

// t@C̓tf[^
typedef struct tagFILE_DATE
{
	u64 Create ;			// 쐬
	u64 LastAccess ;		// ŏIANZX
	u64 LastWrite ;			// ŏIXV
} FILE_DATE ;

// t@C
typedef struct tagFILE_INFO
{
	TCHAR *FileName ;			// t@C
	u32 FileNameHash ;			// t@C CRC32 ̃nbVl
	TCHAR *RelDirectoryPath ;	// 񋓏̃JgfBNg̑΃fBNgpX(  '\' Ă )
	TCHAR *AbsDirectoryPath ;	// ΃fBNgpX(  '\' Ă )
	u64 Size ;					// t@C̃TCY(fBNg̏ꍇ͉ĂȂ)
	u32 IsDirectory ;			// fBNgۂ
	FILE_DATE Date ;			// tf[^
	u32 Attributes ;			// t@C
} FILE_INFO ;

// t@C񃊃Xg
typedef struct tagFILE_INFOLIST
{
	int Num ;					// fBNg̃t@C̐
	FILE_INFO  *List ;			// fBNg̃t@C̏i[zւ̃|C^
} FILE_INFOLIST ;

// data -----------------------------------------

// function proto type --------------------------

extern void EasyEncode( void *Data , unsigned int Size ) ;					// f[^ȈՈÍ֐
extern void EasyEncodeFileWrite( void *Data, int Size, FILE *fp ) ;			// f[^ȈՈÍăt@Cɏo֐
extern void EasyEncodeFileRead( void *Data, int Size, FILE *fp ) ;			// f[^ȈՈÍăt@Cǂݍފ֐

extern unsigned int BinToChar128( void *Src, unsigned int SrcSize, void *Dest ) ;	// oCif[^𔼊pɕϊ( ߂l:ϊ̃f[^TCY )
extern unsigned int Char128ToBin( void *Src, void *Dest ) ;							// poCif[^ɕϊ( ߂l:ϊ̃f[^TCY )

extern unsigned int BinToBase64( void *Src, unsigned int SrcSize, void *Dest ) ;	// oCif[^Base64ɕϊ( ߂l:ϊ̃f[^TCY )
extern unsigned int Base64ToBin( void *Src, void *Dest ) ;							// Base64oCif[^ɕϊ( ߂l:ϊ̃f[^TCY )

extern int LoadFileMem( const TCHAR *Path, void **DataBuf, size_t *Size ) ;		// t@C̓eɓǂݍ( 0:  -1:s )
extern int LoadFileMem( const TCHAR *Path, void *DataBuf,  size_t *Size ) ;		// t@C̓eɓǂݍ( 0:  -1:s )
extern int SaveFileMem( const TCHAR *Path, void *Data,     size_t  Size ) ;		// ̓et@Cɏo 

// w̃fBNg쐬AԂ̃fBNg݂Ȃꍇ͍쐬
// Ō '\' Ă
// hCǔ '\' Ȃꍇ͐ɓ삵Ȃ
extern int __CreateDirectory( const TCHAR *Path ) ;

// w̃pXĂ̂fBNgǂ𓾂( 1:fBNg  0:t@C )
extern int IsDirectory( const TCHAR *Path ) ;

extern int CreateFileInfo( const TCHAR *Path, FILE_INFO *FileInfoBuffer ) ;	// w̃pX̏𓾂(-1:G[ 0:I)
extern int ReleaseFileInfo( FILE_INFO *FileInfo ) ;							// pX̌ns
extern int SetFileTimeStamp( const TCHAR *Path, FILE_INFO *FileInfo ) ;		// w̃pX̃t@C̃^CX^v FileInfo Ɋi[Ă^CX^vɂ
extern int CmpFileTimeStamp( FILE_INFO *FileInfo1, FILE_INFO *FileInfo2, bool Create = true, bool LastAccess = true, bool LastWrite = true );	// ̃t@C̃^CX^vvĂ邩ǂ𓾂(0:vĂ -1:vĂȂ)

// w̃fBNg̃t@CXg擾
// pX̍ŌɁw\xĂɍŌ̕fBNgƔf
// fBNgł͂ȂꍇԂ
// tpXł͂Ȃꍇ݂͌̃JgfBNg̑΃pXƂȂ
// FileListInfo  0 ł͂Ȃꍇgp ReleaseFileObjectList ĂԕKv
// SubDirectory  1 ɂƃTufBNg̃t@CSė񋓂
// NULL A͕ȂnꍇJgfBNg̃t@C񋓂
// ߂l : -1 = G[  0ȏ = 񋓂t@C̐
// OmitDirectory  1 ɂƃfBNg͗񋓂Ȃ
// OmitName ɏOt@CnƂ̕OĂ( ';'ŕ̕A\ )
// OmitExName ɏOgqnƂ̊gqt@COĂ( ';'ŕ̕A\ )
// ValidExName ɗLɂgqnƂ̊gqt@Ĉݗ񋓂Ă( OmitnDx, ';'ŕ̕A\ )
// EnumFileCallback  1t@CƂɌĂ΂R[obN֐APhase  0=t@C񋓒 1=t@C擾
extern int CreateFileList( const TCHAR *DirectoryPath, FILE_INFOLIST *FileListInfo = 0,
							int OmitDirectory = 0, int SubDirectory = 0,
							const TCHAR *OmitName = 0, const TCHAR *OmitExName = 0,
							const TCHAR *ValidExName = 0, void ( *EnumFileCallback )( int Phase, int NowFileNum, int TotalFileNum, const TCHAR *FileName, const TCHAR *RelDirPath, const TCHAR *AbsDirPath ) = 0 ) ;
extern int ReleaseFileList( FILE_INFOLIST *DirectoryInfo ) ;

// ̃pX񂩂FXȏ擾
// ( CurrentDir ̓tpXłKv(Ɂw\xĂĂǂ) )
// ( CurrentDir  0 ̏ꍇ͎ۂ̃JgfBNggp )
extern int AnalyseFilePath(
	const TCHAR *Src, // DirPath ̏I[ɂ \ ͕tȂ
	TCHAR *FullPath, TCHAR *DirPath, TCHAR *FileName, TCHAR *Name, TCHAR *ExeName, const TCHAR *CurrentDir = 0 );

// tpXł͂ȂpXtpXɕϊ
// ( CurrentDir ̓tpXłKv(Ɂw\xĂĂǂ) )
// ( CurrentDir  0 ̏ꍇ͎ۂ̃JgfBNggp )
extern int ConvertFullPath__( const TCHAR *Src, TCHAR *Dest, const TCHAR *CurrentDir = 0 ) ;

// t@CꏏɂȂĂƕĂpXt@CƃfBNgpX𕪊
// tpXłKv͖At@Cłǂ
// DirPath ̏I[  }[N͕tȂ
extern int AnalysisFileNameAndDirPath( const TCHAR *Src, TCHAR *FileName = 0, TCHAR *DirPath = 0 ) ;

// t@CpXt@CƊgq擾
extern int AnalysisFileNameAndExeName( const TCHAR *Src, TCHAR *Name = 0, TCHAR *ExeName = 0 ) ;

// t@CpX̊gqς𓾂
extern int GetChangeExeNamePath( const TCHAR *Src, TCHAR *Dest, const TCHAR *ExeName ) ;

extern void SetEnMark( TCHAR *PathBuf ) ;			// Ɂw\xĂȂꍇ͕t
extern void SetChr( TCHAR *PathBuf, TCHAR chr ) ;		// Ɏw̕Ȃꍇ͂
extern void DelChr( TCHAR *PathBuf, TCHAR chr ) ;		// Ɏw̕ꍇ͍폜

extern int GetExName( const TCHAR *Path, TCHAR *ExNameBuf ) ;						// gq𓾂
extern int SetExName( const TCHAR *Path, const TCHAR *ExName, TCHAR *DestBuf ) ;	// gqύX

extern int CheckTextData( void *buffer, int size ) ;		// eLXgf[^ǂ𔻒肷( VtgJISt@C^Cv̂ݑΉ )( 1:eLXgf[^  0:oCif[^ )
extern int CheckTextFile( const TCHAR *Path ) ;				// eLXgt@Cǂ𔻒肷( VtgJISt@C^Cv̂ݑΉ )( 1:eLXgf[^  0:oCif[^ )

// QoCgׂ( TRUE:QoCg FALSE:PoCg ) 
extern int CheckMultiByteChar( char *Buf ) ;

extern u32 FileLib_HashCRC32( const void *SrcData, size_t SrcDataSize ) ;		// CRC32 ̃nbVl擾

#endif
