// -------------------------------------------------------------------------------
// 
// 		cwCuA[JCo Ver5
// 
//	Creator			: Rc I
//	Creation Date	: 2003/09/11
//	Version			: 1.02
//
// -------------------------------------------------------------------------------

// dCN[hh~p`
#ifndef __DXARCHIVE_VER5
#define __DXARCHIVE_VER5

// include --------------------------------------
#include <stdio.h>

// define ---------------------------------------

// f[^^`
#ifndef u64
#define u64		unsigned __int64
#endif

#ifndef u32
#define u32		unsigned int
#endif

#ifndef u16
#define u16		unsigned short
#endif

#ifndef u8
#define u8		unsigned char
#endif

#ifndef s64
#define s64		signed __int64
#endif

#ifndef s32
#define s32		signed int
#endif

#ifndef s16
#define s16		signed short
#endif

#ifndef s8
#define s8		signed char
#endif

#ifndef f64
#define f64		double
#endif

#ifndef TRUE
#define TRUE	(1)
#endif

#ifndef FALSE
#define FALSE	(0)
#endif

#ifndef NULL
#define NULL	(0)
#endif

#define DXA_HEAD_VER5			*((u16 *)"DX")	// wb_
#define DXA_VER_VER5			(0x0005)		// o[W
#define DXA_BUFFERSIZE_VER5		(0x1000000)		// A[JCu쐬Ɏgpobt@̃TCY
#define DXA_KEYSTR_LENGTH_VER5	(12)			// ̒

/*
	o[WƂ̈Ⴂ

	0x0002 DARC_FILEHEAD_VER5  PressDataSize ǉ
	0x0004 DARC_HEAD_VER5  CodePage ǉ
	0x0005 ÍꕔύX
*/

/*
	f[^}bv
		
	DARC_HEAD_VER5
	t@Cf[^
	t@Ce[u
	DARC_FILEHEAD_VER5 e[u
	DARC_DIRECTORY_VER5 e[u
*/

/*
	t@C̃f[^`
	2byte:̒(oCgTCYS)
	2byte:̃peBf[^(SĂ̒̕l𑫂)
	p͑啶ɕϊꂽt@C̃f[^(S̔{̃TCY)
	p啶ɕϊĂȂt@C̃f[^
*/

// struct ---------------------------------------

#pragma pack(push)
#pragma pack(1)

// A[JCuf[^̍ŏ̃wb_
typedef struct tagDARC_HEAD_VER5
{
	u16 Head ;								// wb_
	u16 Version ;							// o[W
	u32 HeadSize ;							// wb_ DARC_HEAD_VER5 𔲂STCY
	u32 DataStartAddress ;					// ŏ̃t@C̃f[^i[Ăf[^AhX(t@C̐擪AhXAhXOƂ)
	u32 FileNameTableStartAddress ;			// t@Ce[u̐擪AhX(t@C̐擪AhXAhXOƂ)
	u32 FileTableStartAddress ;				// t@Ce[u̐擪AhX(oϐ FileNameTableStartAddress ̃AhXOƂ)
	u32 DirectoryTableStartAddress ;		// fBNge[u̐擪AhX(oϐ FileNameTableStartAddress ̃AhXOƂ)
											// AhXOzuĂ DARC_DIRECTORY_VER5 \̂[gfBNg
	u32 CodePage ;							// t@CɎgpĂR[hy[Wԍ
} DARC_HEAD_VER5 ;

// A[JCuf[^̍ŏ̃wb_(Ver 0x0003܂)
typedef struct tagDARC_HEAD_VER3
{
	u16 Head ;								// wb_
	u16 Version ;							// o[W
	u32 HeadSize ;							// wb_ DARC_HEAD_VER5 𔲂STCY
	u32 DataStartAddress ;					// ŏ̃t@C̃f[^i[Ăf[^AhX(t@C̐擪AhXAhXOƂ)
	u32 FileNameTableStartAddress ;			// t@Ce[u̐擪AhX(t@C̐擪AhXAhXOƂ)
	u32 FileTableStartAddress ;				// t@Ce[u̐擪AhX(oϐ FileNameTableStartAddress ̃AhXOƂ)
	u32 DirectoryTableStartAddress ;		// fBNge[u̐擪AhX(oϐ FileNameTableStartAddress ̃AhXOƂ)
											// AhXOzuĂ DARC_DIRECTORY_VER5 \̂[gfBNg
} DARC_HEAD_VER3 ;

// t@C̎ԏ
typedef struct tagDARC_FILETIME_VER5
{
	u64 Create ;			// 쐬
	u64 LastAccess ;		// ŏIANZX
	u64 LastWrite ;			// ŏIXV
} DARC_FILETIME_VER5 ;

// t@Ci[(Ver 0x0001)
typedef struct tagDARC_FILEHEAD_VER1
{
	u32 NameAddress ;			// t@Ci[ĂAhX( ARCHIVE_HEAD\ ̃oϐ FileNameTableStartAddress ̃AhXAhXOƂ) 

	u32 Attributes ;			// t@C
	DARC_FILETIME_VER5 Time ;	// ԏ
	u32 DataAddress ;			// t@Ci[ĂAhX
								//			t@C̏ꍇFDARC_HEAD_VER5\ ̃oϐ DataStartAddress AhXAhXOƂ
								//			fBNg̏ꍇFDARC_HEAD_VER5\ ̃oϐ DirectoryTableStartAddress ̂AhXAhXOƂ
	u32 DataSize ;				// t@C̃f[^TCY
} DARC_FILEHEAD_VER1 ;

// t@Ci[
typedef struct tagDARC_FILEHEAD_VER5
{
	u32 NameAddress ;			// t@Ci[ĂAhX( ARCHIVE_HEAD\ ̃oϐ FileNameTableStartAddress ̃AhXAhXOƂ) 

	u32 Attributes ;			// t@C
	DARC_FILETIME_VER5 Time ;	// ԏ
	u32 DataAddress ;			// t@Ci[ĂAhX
								//			t@C̏ꍇFDARC_HEAD_VER5\ ̃oϐ DataStartAddress AhXAhXOƂ
								//			fBNg̏ꍇFDARC_HEAD_VER5\ ̃oϐ DirectoryTableStartAddress ̂AhXAhXOƂ
	u32 DataSize ;				// t@C̃f[^TCY
	u32 PressDataSize ;			// k̃f[^̃TCY( 0xffffffff:kĂȂ ) ( Ver0x0002 Œǉꂽ )
} DARC_FILEHEAD_VER5 ;

// fBNgi[
typedef struct tagDARC_DIRECTORY_VER5
{
	u32 DirectoryAddress ;			//  DARC_FILEHEAD_VER5 i[ĂAhX( DARC_HEAD_VER5 \ ̃oϐ FileTableStartAddress AhXAhXOƂ)
	u32 ParentDirectoryAddress ;	// efBNg DARC_DIRECTORY_VER5 i[ĂAhX( DARC_HEAD_VER5\ ̃oϐ DirectoryTableStartAddress AhXAhXOƂ)
	u32 FileHeadNum ;				// fBNg̃t@C̐
	u32 FileHeadAddress ;			// fBNg̃t@C̃wb_񂪊i[ĂAhX( DARC_HEAD_VER5\ ̃oϐ FileTableStartAddress AhXAhXOƂ) 
} DARC_DIRECTORY_VER5 ;

#pragma pack(pop)

// class ----------------------------------------

// A[JCuNX
class DXArchive_VER5
{
public :
	// t̔r
	enum DATE_RESULT
	{
		DATE_RESULT_LEFTNEW = 0,		// V
		DATE_RESULT_RIGHTNEW,			// V
		DATE_RESULT_DRAW,				// t͓
	} ;

	DXArchive_VER5( char *ArchivePath = NULL ) ;
	~DXArchive_VER5() ;

	static int			EncodeArchive( char *OutputFileName, char **FileOrDirectoryPath, int FileNum, bool Press = false, const char *KeyString = NULL ) ;	// A[JCut@C쐬
	static int			EncodeArchiveOneDirectory( char *OutputFileName, char *FolderPath, bool Press = false, const char *KeyString = NULL ) ;		// A[JCut@C쐬(fBNg)
	static int			DecodeArchive( char *ArchiveName, char *OutputPath, const char *KeyString = NULL ) ;								// A[JCut@CWJ

	int					OpenArchiveFile( const char *ArchivePath, const char *KeyString = NULL ) ;				// A[JCut@CJ( 0:  -1:s )
	int					OpenArchiveFileMem( const char *ArchivePath, const char *KeyString = NULL ) ;			// A[JCut@CJŏɂׂăɓǂݍł珈( 0:  -1:s )
	int					OpenArchiveMem( void *ArchiveImage, int ArchiveSize, const char *KeyString = NULL ) ;	// ɂA[JCut@CC[WJ( 0:  -1:s )
	int					CloseArchiveFile( void ) ;																// A[JCut@C

	int					LoadFileToMem( const char *FilePath, void *Buffer, unsigned int BufferLength ) ;	// A[JCut@C̎w̃t@Cɓǂݍ( -1:G[ 0ȏ:t@CTCY )
	int					GetFileSize( const char *FilePath ) ;										// A[JCut@C̎w̃t@CTCY擾( -1:G[ )
	int					GetFileInfo( const char *FilePath, int *PositionP, int *SizeP ) ;			// A[JCut@C̎w̃t@C̃t@C̈ʒuƃt@C̑傫𓾂( -1:G[ )
	void				*GetFileImage( void ) ;														// A[JCut@Cɓǂݍ񂾏ꍇ̃t@CC[Wi[Ă擪AhX擾( JĂꍇ̂ݗLAkĂꍇ́AkꂽԂ̃f[^i[Ă̂Œ )
	class DXArchiveFile_VER5 *OpenFile( const char *FilePath ) ;											// A[JCut@C̎w̃t@CJAt@CANZXpIuWFNg쐬( t@CJĂꍇ̂ݗL )

	void *				LoadFileToCash( const char *FilePath ) ;									// A[JCut@C̎w̃t@CANX̃LbVobt@ɓǂݍ
	void *				GetCash( void ) ;															// LbVobt@̃AhX擾
	int					ClearCash( void ) ;															// LbVobt@J

	int					ChangeCurrentDir( const char *DirPath ) ;									// A[JCũfBNgpXύX( 0:  -1:s )
	int					GetCurrentDir( char *DirPathBuffer, int BufferLength ) ;					// A[JCũJgfBNgpX擾



	// ȉ͊ƓŎgp
	static void NotConv( void *Data , int Size ) ;									// f[^𔽓]֐
	static void NotConvFileWrite( void *Data, int Size, FILE *fp ) ;				// f[^𔽓]ăt@Cɏo֐
	static void NotConvFileRead( void *Data, int Size, FILE *fp ) ;					// f[^𔽓]ăt@Cǂݍފ֐
	static void KeyCreate( const char *Source, unsigned char *Key ) ;				// 쐬
	static void KeyConv( void *Data, int Size, int Position, unsigned char *Key ) ;	// gp Xor Z( Key ͕K DXA_KEYSTR_LENGTH_VER5 ̒Ȃ΂ȂȂ )
	static void KeyConvFileWrite( void *Data, int Size, FILE *fp, unsigned char *Key, int Position = -1 ) ;	// f[^gp Xor Zt@Cɏo֐( Key ͕K DXA_KEYSTR_LENGTH_VER5 ̒Ȃ΂ȂȂ )
	static void KeyConvFileRead( void *Data, int Size, FILE *fp, unsigned char *Key, int Position = -1 ) ;	// t@Cǂݍ񂾃f[^gp Xor Z֐( Key ͕K DXA_KEYSTR_LENGTH_VER5 ̒Ȃ΂ȂȂ )
	static DATE_RESULT DateCmp( DARC_FILETIME_VER5 *date1, DARC_FILETIME_VER5 *date2 ) ;		// ǂ炪Vr
	static int Encode( void *Src, unsigned int SrcSize, void *Dest ) ;				// f[^k( ߂l:k̃f[^TCY )
	static int Decode( void *Src, void *Dest ) ;									// f[^𓀂( ߂l:𓀌̃f[^TCY )

	DARC_DIRECTORY_VER5 *GetCurrentDirectoryInfo( void ) ;									// A[JCũJgfBNg̏擾
	DARC_FILEHEAD_VER5 *GetFileInfo( const char *FilePath ) ;							// t@C̏𓾂
	inline DARC_HEAD_VER5 *GetHeader( void ){ return &Head ; }
	inline u8 *GetKey( void ){ return Key ; }
	inline FILE *GetFilePointer( void ){ return fp ; }
	inline u8 *GetNameP( void ){ return NameP ; }

protected :
	FILE *fp ;							// A[JCut@C̃|C^	
	u8 *HeadBuffer ;					// wb_[obt@[
	u8 *FileP, *DirP, *NameP ;			// ee[u(t@Cwb_e[uAfBNge[uAOe[u)ւ̃|C^
	DARC_DIRECTORY_VER5 *CurrentDirectory ;	// JgfBNgf[^ւ̃|C^

	void *CashBuffer ;					// ǂݍ񂾃t@Cf[^ꎞIɕۑĂobt@
	u32 CashBufferSize ;				// LbVobt@ɊmۂĂ郁e
	bool MemoryOpenFlag ;				// ̃t@CJĂ邩AtO
	bool UserMemoryImageFlag ;			// [U[WJC[WgpĂ邩AtO
	int MemoryImageSize ;				// ̃t@CJĂꍇ̃C[W̃TCY
	u8 Key[DXA_KEYSTR_LENGTH_VER5] ;			// 

	DARC_HEAD_VER5 Head ;				// A[JCũwb_

	// TCYۑp\
	typedef struct tagSIZESAVE
	{
		u32 DataSize ;			// f[^̑
		u32 NameSize ;			// t@Cf[^̑
		u32 DirectorySize ;		// fBNgf[^̑
		u32 FileSize ;			// t@CvpeBf[^̑
	} SIZESAVE ;

	// t@Cpf[^\
	typedef struct tagSEARCHDATA
	{
		u8 FileName[1024] ;
		u16 Parity ;
		u16 PackNum ;
	} SEARCHDATA ;

	static int DirectoryEncode( char *DirectoryName, u8 *NameP, u8 *DirP, u8 *FileP, DARC_DIRECTORY_VER5 *ParentDir, SIZESAVE *Size, int DataNumber, FILE *DestP, void *TempBuffer, bool Press, unsigned char *Key ) ;	// w̃fBNgɂt@CA[JCuf[^ɓfo
	static int DirectoryDecode( u8 *NameP, u8 *DirP, u8 *FileP, DARC_HEAD_VER5 *Head, DARC_DIRECTORY_VER5 *Dir, FILE *ArcP, unsigned char *Key ) ;											// w̃fBNgf[^ɂt@CWJ
	static int StrICmp( const char *Str1, const char *Str2 ) ;							// rΏƂ̕񒆂̑啶ƂĈr( 0:  1:Ⴄ )
	static int ConvSearchData( SEARCHDATA *Dest, const char *Src, int *Length ) ;		// p̃f[^ɕϊ( k \ I )
	static int AddFileNameData( const char *FileName, u8 *FileNameTable ) ;				// t@Cf[^ǉ( ߂l͎gpf[^oCg )
	static const char *GetOriginalFileName( u8 *FileNameTable ) ;						// t@Cf[^猳̃t@C̕擾
	static int GetDirectoryFilePath( const char *DirectoryPath, char *FilePathBuffer = NULL ) ;	// fBNg̃t@C̃pX擾( FilePathBuffer ͈t@Cɕt256oCg̗eʂKv )
	int	ChangeCurrentDirectoryFast( SEARCHDATA *SearchData ) ;							// A[JCũfBNgpXύX( 0:  -1:s )
	int	ChangeCurrentDirectoryBase( const char *DirectoryPath, bool ErrorIsDirectoryReset, SEARCHDATA *LastSearchData = NULL ) ;		// A[JCũfBNgpXύX( 0:  -1:s )
	int DirectoryKeyConv( DARC_DIRECTORY_VER5 *Dir ) ;										// w̃fBNgf[^̈Í( ۂƃɓǂݍ񂾏ꍇp )

	// QoCgׂ( TRUE:QoCg FALSE:PoCg )
	inline static int CheckMultiByteChar( const char *Buf )
	{
		return  ( (unsigned char)*Buf >= 0x81 && (unsigned char)*Buf <= 0x9F ) || ( (unsigned char)*Buf >= 0xE0 && (unsigned char)*Buf <= 0xFC ) ;
	}

	// t@CꏏɂȂĂƕĂpXt@CpXƃfBNgpX𕪊
	// tpXłKv͖
	static int GetFilePathAndDirPath( char *Src, char *FilePath, char *DirPath ) ;
} ;


// A[JCuꂽt@C̃ANZXp̃NX
class DXArchiveFile_VER5
{
protected :
	DARC_FILEHEAD_VER5 *FileData ;		// t@Cf[^ւ̃|C^
	DXArchive_VER5 *Archive ;			// A[JCuNXւ̃|C^
	void *DataBuffer ;				// Ƀf[^WJۂ̃obt@̃|C^

	int EOFFlag ;					// EOFtO
	u32 FilePoint ;					// t@C|C^

public :
	DXArchiveFile_VER5( DARC_FILEHEAD_VER5 *FileHead, DXArchive_VER5 *Archive ) ;
	~DXArchiveFile_VER5() ;

	int Read( void *Buffer, int ReadLength ) ;					// t@C̓eǂݍ
	int Seek( int SeekPoint, int SeekMode ) ;					// t@C|C^ύX
	int Tell( void ) ;											// ݂̃t@C|C^𓾂
	int Eof( void ) ;											// t@C̏I[ɗĂ邩ÃtO𓾂
	int Size( void ) ;											// t@C̃TCY擾

	inline DARC_FILEHEAD_VER5 *GetFileData( void ){ return FileData ; }
} ;

#endif

