// -------------------------------------------------------------------------------
// 
// 		cwCuA[JCo Ver5
// 
//	Creator			: Rc I
//	Creation Date	: 2003/09/11
//	Version			: 1.02
// 
// -------------------------------------------------------------------------------

#define INLINE_ASM

// include ----------------------------
#include "DXArchiveVer5.h"
#include <stdio.h>
#include <windows.h>
#include <string.h>

// define -----------------------------

#define MIN_COMPRESS_VER5		(4)						// ŒሳkoCg
#define MAX_SEARCHLISTNUM_VER5	(64)					// ővTׂ̃XgHő吔
#define MAX_SUBLISTNUM_VER5		(65536)					// kԒZk̂߂̃TuXg̍ő吔
#define MAX_COPYSIZE_VER5 		(0x1fff + MIN_COMPRESS_VER5)	// QƃAhXRs[o؂őTCY( kR[h\łRs[TCY̍ől + ŒሳkoCg )
#define MAX_ADDRESSLISTNUM_VER5	(1024 * 1024 * 1)		// XCh̍őTCY
#define MAX_POSITION_VER5		(1 << 24)				// QƉ\ȍő告΃AhX( 16MB )

// struct -----------------------------

// kԒZkpXg
typedef struct LZ_LIST_VER5
{
	LZ_LIST_VER5 *next, *prev ;
	u32 address ;
} LZ_LIST_VER5 ;

// class code -------------------------

// t@CꏏɂȂĂƕĂpXt@CpXƃfBNgpX𕪊
// tpXłKv͖
int DXArchive_VER5::GetFilePathAndDirPath( char *Src, char *FilePath, char *DirPath )
{
	int i, Last ;
	
	// t@C𔲂o
	i = 0 ;
	Last = -1 ;
	while( Src[i] != '\0' )
	{
		if( CheckMultiByteChar( &Src[i] ) == FALSE )
		{
			if( Src[i] == '\\' || Src[i] == '/' || Src[i] == '\0' || Src[i] == ':' ) Last = i ;
			i ++ ;
		}
		else
		{
			i += 2 ;
		}
	}
	if( FilePath != NULL )
	{
		if( Last != -1 ) strcpy( FilePath, &Src[Last+1] ) ;
		else strcpy( FilePath, Src ) ;
	}
	
	// fBNgpX𔲂o
	if( DirPath != NULL )
	{
		if( Last != -1 )
		{
			strncpy( DirPath, Src, Last ) ;
			DirPath[Last] = '\0' ;
		}
		else
		{
			DirPath[0] = '\0' ;
		}
	}
	
	// I
	return 0 ;
}

// t@C̏𓾂
DARC_FILEHEAD_VER5 *DXArchive_VER5::GetFileInfo( const char *FilePath )
{
	DARC_DIRECTORY_VER5 *OldDir ;
	DARC_FILEHEAD_VER5 *FileH ;
	u8 *NameData ;
	int i, j, k, Num, FileHeadSize ;
	SEARCHDATA SearchData ;

	// ̃fBNgۑĂ
	OldDir = this->CurrentDirectory ;

	// t@CpX \ ܂܂ĂꍇAfBNgύXs
	if( strchr( FilePath, '\\' ) != NULL )
	{
		// JgfBNgړĨt@CfBNgɕύX
		if( this->ChangeCurrentDirectoryBase( FilePath, false, &SearchData ) >= 0 )
		{
			// G[NȂꍇ̓t@CfBNgƂɂȂ̂ŃG[
			goto ERR ;
		}
	}
	else
	{
		// t@Cpf[^ɕϊ
		ConvSearchData( &SearchData, FilePath, NULL ) ;
	}

	// ̃t@CT
	FileHeadSize = this->Head.Version >= 0x0002 ? sizeof( DARC_FILEHEAD_VER5 ) : sizeof( DARC_FILEHEAD_VER1 ) ;
	FileH = ( DARC_FILEHEAD_VER5 * )( this->FileP + this->CurrentDirectory->FileHeadAddress ) ;
	Num = (s32)this->CurrentDirectory->FileHeadNum ;
	for( i = 0 ; i < Num ; i ++, FileH = (DARC_FILEHEAD_VER5 *)( (u8 *)FileH + FileHeadSize ) )
	{
		// fBNg`FbN
		if( ( FileH->Attributes & FILE_ATTRIBUTE_DIRECTORY ) != 0 ) continue ;

		// 񐔂ƃpeB`FbN
		NameData = this->NameP + FileH->NameAddress ;
		if( SearchData.PackNum != ((u16 *)NameData)[0] || SearchData.Parity != ((u16 *)NameData)[1] ) continue ;

		// `FbN
		NameData += 4 ;
		for( j = 0, k = 0 ; j < SearchData.PackNum ; j ++, k += 4 )
			if( *((u32 *)&SearchData.FileName[k]) != *((u32 *)&NameData[k]) ) break ;

		// Kt@C炱ŏI
		if( SearchData.PackNum == j ) break ;
	}

	// G[
	if( i == Num ) goto ERR ;
	
	// fBNgɖ߂
	this->CurrentDirectory = OldDir ;
	
	// ړĨt@C̃AhXԂ
	return FileH ;
	
ERR :
	// fBNgɖ߂
	this->CurrentDirectory = OldDir ;
	
	// G[I
	return NULL ;

/*
	DARC_DIRECTORY_VER5 *OldCurrent ;
	DARC_FILEHEAD_VER5 *File ;
	char TPath[MAX_PATH], FPath[MAX_PATH], DPath[MAX_PATH] ;
	int i, len ;
		
	// ꕶȂꍇ͗O
	if( FilePath[0] == '\0' ) return ( DARC_FILEHEAD_VER5 * )FileP ;

	// ̃JgfBNgۑĂ
	OldCurrent = CurrentDirectory ;
	
	// t@CpXƃfBNgpX𕪉
	strcpy( TPath, FilePath ) ;
	if( TPath[(len = strlen( TPath ))-1] == '\\' ) TPath[len-1] = '\0' ;
	GetFilePathAndDirPath( TPath, FPath, DPath ) ;
	
	// JgfBNg̕ύX
	if( ChangeCurrentDirectory( DPath ) == -1 ) goto ERR ;
	
	// t@CpX̕ύX
	File = ( DARC_FILEHEAD_VER5 * )( FileP + CurrentDirectory->FileHeadAddress ) ;
	for( 	i = 0 ;
			i < (int)CurrentDirectory->FileHeadNum && strcmp( ( const char * )( NameP + File->NameAddress ), FPath ) != 0 ;
			i ++, File ++ ){}
	if( i == (int)CurrentDirectory->FileHeadNum ) goto ERR ;

	// JgfBNgɖ߂
	CurrentDirectory = OldCurrent ;

	// t@C̏Ԃ
	return File ;	

ERR :
	// JgfBNgɖ߂
	CurrentDirectory = OldCurrent ;
	
	return NULL ;
*/
}

// A[JCũJgfBNg̏擾
DARC_DIRECTORY_VER5 *DXArchive_VER5::GetCurrentDirectoryInfo( void )
{
	return CurrentDirectory ;
}

// ǂ炪Vr
DXArchive_VER5::DATE_RESULT DXArchive_VER5::DateCmp( DARC_FILETIME_VER5 *date1, DARC_FILETIME_VER5 *date2 )
{
	if( date1->LastWrite == date2->LastWrite ) return DATE_RESULT_DRAW ;
	else if( date1->LastWrite > date2->LastWrite ) return DATE_RESULT_LEFTNEW ;
	else return DATE_RESULT_RIGHTNEW ;
}

// rΏƂ̕񒆂̑啶ƂĈr( 0:  1:Ⴄ )
int DXArchive_VER5::StrICmp( const char *Str1, const char *Str2 )
{
	int c1, c2 ;
	
	while( *Str1 != '\0' && *Str2 != '\0' )
	{
		if( CheckMultiByteChar( Str1 ) == FALSE )
		{
			c1 = ( *Str1 >= 'A' && *Str1 <= 'Z' ) ? *Str1 - 'A' + 'a' : *Str1 ;
			c2 = ( *Str2 >= 'A' && *Str2 <= 'Z' ) ? *Str2 - 'A' + 'a' : *Str2 ;
			if( c1 != c2 ) return 1 ;
			Str1 ++ ;
			Str2 ++ ;
		}
		else
		{
			if( *( (unsigned short *)Str1 ) != *( (unsigned short *)Str2 ) ) return 1 ;
			Str1 += 2 ;
			Str2 += 2 ;
		}
	}
	if( *Str1 != '\0' || *Str2 != '\0' ) return 1 ;

	// ܂ŗď߂ē
	return 0 ;
}

// 񒆂̉p̏啶ɕϊ
int DXArchive_VER5::ConvSearchData( SEARCHDATA *SearchData, const char *Src, int *Length )
{
	int i, StringLength ;
	u16 ParityData ;

	ParityData = 0 ;
	for( i = 0 ; Src[i] != '\0' && Src[i] != '\\' ; )
	{
		if( CheckMultiByteChar( &Src[i] ) == TRUE )
		{
			// QoCg̏ꍇ͂̂܂܃Rs[
			*((u16 *)&SearchData->FileName[i]) = *((u16 *)&Src[i]) ;
			ParityData += (u8)Src[i] + (u8)Src[i+1] ;
			i += 2 ;
		}
		else
		{
			// ̏ꍇ͑啶ɕϊ
			if( Src[i] >= 'a' && Src[i] <= 'z' )	SearchData->FileName[i] = (u8)Src[i] - 'a' + 'A' ;
			else									SearchData->FileName[i] = Src[i] ;
			ParityData += (u8)SearchData->FileName[i] ;
			i ++ ;
		}
	}

	// ̒ۑ
	if( Length != NULL ) *Length = i ;

	// S̔{̈ʒu܂łO
	StringLength = ( ( i + 1 ) + 3 ) / 4 * 4 ;
	memset( &SearchData->FileName[i], 0, StringLength - i ) ;

	// peBf[^̕ۑ
	SearchData->Parity = ParityData ;

	// pbNf[^̕ۑ
	SearchData->PackNum = StringLength / 4 ;

	// I
	return 0 ;
}

// t@Cf[^ǉ( ߂l͎gpf[^oCg )
int DXArchive_VER5::AddFileNameData( const char *FileName, u8 *FileNameTable )
{
	int PackNum, Length, i ;
	u32 Parity ;

	// TCYZbg
	Length = strlen( FileName ) ;

	// ꕶꍇ̏
	if( Length == 0 )
	{
		// pbNƃpeB̂ݕۑ
		*((u32 *)&FileNameTable[0]) = 0 ;

		// gpTCYԂ
		return 4 ;
	}
	Length ++ ;

	PackNum = ( Length + 3 ) / 4 ;

	// pbNۑ
	*((u16 *)&FileNameTable[0]) = PackNum ;

	// obt@̏
	memset( &FileNameTable[4], 0, PackNum * 4 * 2 ) ;

	// Rs[
	strcpy( (char *)&FileNameTable[4 + PackNum * 4], FileName ) ;

	// p̏Sđ啶ɕϊt@Cۑ
	Parity = 0 ;
	for( i = 0 ; FileName[i] != '\0' ; )
	{
		// QoCgǂŏ𕪊
		if( CheckMultiByteChar( &FileName[i] ) == TRUE )
		{
			// QoCg
			*((u16 *)&FileNameTable[4 + i]) = *((u16 *)&FileName[i]) ;
			Parity += (u8)FileName[i] + (u8)FileName[i+1] ;
			i += 2 ;
		}
		else
		{
			// PoCg
			if( FileName[i] >= 'a' && FileName[i] <= 'z' )
			{
				// ̏ꍇ͑啶ɕϊ
				FileNameTable[4 + i] = (u8)FileName[i] - 'a' + 'A' ;
			}
			else
			{
				// ł͂Ȃꍇ͕ʂɃRs[
				FileNameTable[4 + i] = (u8)FileName[i] ;
			}
			Parity += FileNameTable[4 + i] ;
			i ++ ;
		}
	}

	// peBۑ
	*((u16 *)&FileNameTable[2]) = (u16)Parity ;

	// gpTCYԂ
	return PackNum * 4 * 2 + 4 ;
}

// t@Cf[^猳̃t@C̕擾
const char *DXArchive_VER5::GetOriginalFileName( u8 *FileNameTable )
{
	return (char *)FileNameTable + *((u16 *)&FileNameTable[0]) * 4 + 4 ;
}

// f[^𔽓]֐
void DXArchive_VER5::NotConv( void *Data , int Size )
{
	int DwordNum ;
	int ByteNum ;

	DwordNum = Size / 4 ;
	ByteNum = Size - DwordNum * 4 ;
#ifndef INLINE_ASM
	{
//		int i ;
		DWORD *dd ;
//		for( int i = 0 ; i < Size ; i ++ ) ( ( BYTE * )Data )[i] = ~( ( BYTE * )Data )[i] ;

		dd = ( DWORD * )Data ;
		if( DwordNum != 0 )
		{
			do
			{
				*dd++ = ~*dd ;
			}while( --DwordNum ) ;
		}
		if( ByteNum != 0 )
		{
			do
			{
				*((BYTE *)dd) = ~*((BYTE *)dd) ;
				dd = (DWORD *)(((BYTE *)dd) + 1) ;
			}while( --ByteNum ) ;
		}
	}
#else
	__asm
	{
		MOV ESI, Data
		MOV ECX, DwordNum
		CMP ECX, 0
		JE LABEL1
LOOP1:
		MOV EAX, [ESI]
		NOT EAX
		MOV [ESI], EAX
		ADD ESI, 4
		DEC ECX
		JNZ LOOP1

LABEL1:
		MOV ECX, ByteNum
		CMP ECX, 0
		JE END
LOOP2:
		MOV AL, [ESI]
		NOT AL
		MOV [ESI], AL
		INC ESI
		DEC ECX
		JNZ LOOP2
END:
	} ;
#endif
}


// f[^𔽓]ăt@Cɏo֐
void DXArchive_VER5::NotConvFileWrite( void *Data, int Size, FILE *fp )
{
	// f[^𔽓]
	NotConv( Data, Size ) ;

	// o
	fwrite( Data, Size, 1, fp ) ;

	// Ăє]
	NotConv( Data, Size ) ;
}

// f[^𔽓]ăt@Cǂݍފ֐
void DXArchive_VER5::NotConvFileRead( void *Data, int Size, FILE *fp )
{
	// ǂݍ
	fread( Data, 1, Size, fp ) ;

	// f[^𔽓]
	NotConv( Data, Size ) ;
}

// 쐬
void DXArchive_VER5::KeyCreate( const char *Source, unsigned char *Key )
{
	int Len ;

	if( Source == NULL )
	{
		memset( Key, 0xaaaaaaaa, DXA_KEYSTR_LENGTH_VER5 ) ;
	}
	else
	{
		Len = strlen( Source ) ;
		if( Len > DXA_KEYSTR_LENGTH_VER5 )
		{
			memcpy( Key, Source, DXA_KEYSTR_LENGTH_VER5 ) ;
		}
		else
		{
			//  DXA_KEYSTR_LENGTH_VER5 Z烋[v
			int i ;

			for( i = 0 ; i + Len <= DXA_KEYSTR_LENGTH_VER5 ; i += Len )
				memcpy( Key + i, Source, Len ) ;
			if( i < DXA_KEYSTR_LENGTH_VER5 )
				memcpy( Key + i, Source, DXA_KEYSTR_LENGTH_VER5 - i ) ;
		}
	}

	Key[0] = ~Key[0] ;
	Key[1] = ( Key[1] >> 4 ) | ( Key[1] << 4 ) ;
	Key[2] = Key[2] ^ 0x8a ;
	Key[3] = ~( ( Key[3] >> 4 ) | ( Key[3] << 4 ) ) ;
	Key[4] = ~Key[4] ;
	Key[5] = Key[5] ^ 0xac ;
	Key[6] = ~Key[6] ;
	Key[7] = ~( ( Key[7] >> 3 ) | ( Key[7] << 5 ) ) ;
	Key[8] = ( Key[8] >> 5 ) | ( Key[8] << 3 ) ;
	Key[9] = Key[9] ^ 0x7f ;
	Key[10] = ( ( Key[10] >> 4 ) | ( Key[10] << 4 ) ) ^ 0xd6 ;
	Key[11] = Key[11] ^ 0xcc ;
}

// gp Xor Z( Key ͕K DXA_KEYSTR_LENGTH_VER5 ̒Ȃ΂ȂȂ )
void DXArchive_VER5::KeyConv( void *Data, int Size, int Position, unsigned char *Key )
{
	Position %= DXA_KEYSTR_LENGTH_VER5 ;

#ifndef INLINE_ASM
	int i, j ;

	j = Position ;
	for( i = 0 ; i < Size ; i ++ )
	{
		((u8 *)Data)[i] ^= Key[j] ;

		j ++ ;
		if( j == DXA_KEYSTR_LENGTH_VER5 ) j = 0 ;
	}
#else
	u32 DataT, SizeT ;
	SizeT = (u32)Size ;
	DataT = (u32)Data ;
	Position %= DXA_KEYSTR_LENGTH_VER5 ;
	__asm
	{
		MOV EDI, DataT
		MOV ESI, Key

		MOV EAX, SizeT
		CMP EAX, DXA_KEYSTR_LENGTH_VER5
		JB LABEL2


		MOV EAX, Position
		CMP EAX, 0
		JE LABEL1


		MOV EDX, SizeT
LOOP1:
		MOV BL, [ESI+EAX]
		XOR [EDI], BL
		INC EAX
		INC EDI
		DEC EDX
		CMP EAX, DXA_KEYSTR_LENGTH_VER5
		JB LOOP1
		XOR ECX, ECX
		MOV Position, ECX

		MOV SizeT, EDX
		CMP EDX, DXA_KEYSTR_LENGTH_VER5
		JB LABEL2


LABEL1:
		MOV EAX, SizeT
		XOR EDX, EDX
		MOV ECX, DXA_KEYSTR_LENGTH_VER5
		DIV ECX
		MOV SizeT, EDX
		MOV ECX, EAX

		MOV EAX, [ESI]
		MOV EBX, [ESI+4]
		MOV EDX, [ESI+8]
LOOP2:
		XOR [EDI],    EAX
		XOR [EDI+4],  EBX
		XOR [EDI+8],  EDX
		ADD EDI, DXA_KEYSTR_LENGTH_VER5
		DEC ECX
		JNZ LOOP2


LABEL2:
		MOV EDX, SizeT
		CMP EDX, 0
		JE LABEL3


		MOV EAX, Position
LOOP3:
		MOV BL, [ESI+EAX]
		XOR [EDI], BL
		INC EAX
		CMP EAX, DXA_KEYSTR_LENGTH_VER5
		JNE LABEL4
		XOR EAX, EAX
LABEL4:
		INC EDI
		DEC EDX
		JNZ LOOP3
LABEL3:
	} ;
#endif
}

// f[^gp Xor Zt@Cɏo֐( Key ͕K DXA_KEYSTR_LENGTH_VER5 ̒Ȃ΂ȂȂ )
void DXArchive_VER5::KeyConvFileWrite( void *Data, int Size, FILE *fp, unsigned char *Key, int Position )
{
	int pos ;

	// t@C̈ʒu擾Ă
	if( Position == -1 ) pos = ftell( fp ) ;
	else                 pos = Position ;

	// f[^g Xor Z
	KeyConv( Data, Size, pos, Key ) ;

	// o
	fwrite( Data, Size, 1, fp ) ;

	// Ă Xor Z
	KeyConv( Data, Size, pos, Key ) ;
}

// t@Cǂݍ񂾃f[^gp Xor Z֐( Key ͕K DXA_KEYSTR_LENGTH_VER5 ̒Ȃ΂ȂȂ )
void DXArchive_VER5::KeyConvFileRead( void *Data, int Size, FILE *fp, unsigned char *Key, int Position )
{
	int pos ;

	// t@C̈ʒu擾Ă
	if( Position == -1 ) pos = ftell( fp ) ;
	else                 pos = Position ;

	// ǂݍ
	fread( Data, 1, Size, fp ) ;

	// f[^g Xor Z
	KeyConv( Data, Size, pos, Key ) ;
}

/*
// QoCgׂ( TRUE:QoCg FALSE:PoCg )
int DXArchive_VER5::CheckMultiByteChar( const char *Buf )
{
	return  ( (unsigned char)*Buf >= 0x81 && (unsigned char)*Buf <= 0x9F ) || ( (unsigned char)*Buf >= 0xE0 && (unsigned char)*Buf <= 0xFC ) ;
}
*/

// w̃fBNgɂt@CA[JCuf[^ɓfo
int DXArchive_VER5::DirectoryEncode( char *DirectoryName, u8 *NameP, u8 *DirP, u8 *FileP, DARC_DIRECTORY_VER5 *ParentDir, SIZESAVE *Size, int DataNumber, FILE *DestP, void *TempBuffer, bool Press, unsigned char *Key )
{
	char DirPath[MAX_PATH] ;
	WIN32_FIND_DATA FindData ;
	HANDLE FindHandle ;
	DARC_DIRECTORY_VER5 Dir ;
	DARC_FILEHEAD_VER5 File ;

	// fBNg̏𓾂
	FindHandle = FindFirstFile( DirectoryName, &FindData ) ;
	if( FindHandle == INVALID_HANDLE_VALUE ) return 0 ;
	
	// fBNgi[t@Cwb_Zbg
	{
		File.NameAddress     = Size->NameSize ;
		File.Time.Create     = ( ( ( LONGLONG )FindData.ftCreationTime.dwHighDateTime ) << 32 ) + FindData.ftCreationTime.dwLowDateTime ;
		File.Time.LastAccess = ( ( ( LONGLONG )FindData.ftLastAccessTime.dwHighDateTime ) << 32 ) + FindData.ftLastAccessTime.dwLowDateTime ;
		File.Time.LastWrite  = ( ( ( LONGLONG )FindData.ftLastWriteTime.dwHighDateTime ) << 32 ) + FindData.ftLastWriteTime.dwLowDateTime ;
		File.Attributes      = FindData.dwFileAttributes ;
		File.DataAddress     = Size->DirectorySize ;
		File.DataSize        = 0 ;
		File.PressDataSize	 = 0xffffffff ;
	}

	// fBNgo
	Size->NameSize += AddFileNameData( FindData.cFileName, NameP + Size->NameSize ) ;

	// fBNg񂪓t@Cwb_o
	memcpy( FileP + ParentDir->FileHeadAddress + DataNumber * sizeof( DARC_FILEHEAD_VER5 ),
			&File, sizeof( DARC_FILEHEAD_VER5 ) ) ;

	// Find nh
	FindClose( FindHandle ) ;

	// w̃fBNgɃJgfBNgڂ
	GetCurrentDirectory( MAX_PATH, DirPath ) ;
	SetCurrentDirectory( DirectoryName ) ;

	// fBNg̃Zbg
	{
		Dir.DirectoryAddress = ParentDir->FileHeadAddress + DataNumber * sizeof( DARC_FILEHEAD_VER5 ) ;
		Dir.FileHeadAddress  = Size->FileSize ;

		// efBNg̏ʒuZbg
		if( ParentDir->DirectoryAddress != 0xffffffff && ParentDir->DirectoryAddress != 0 )
		{
			Dir.ParentDirectoryAddress = ((DARC_FILEHEAD_VER5 *)( FileP + ParentDir->DirectoryAddress ))->DataAddress ;
		}
		else
		{
			Dir.ParentDirectoryAddress = 0 ;
		}

		// fBNg̃t@C̐擾
		Dir.FileHeadNum = GetDirectoryFilePath( "", NULL ) ;
	}

	// fBNg̏o͂
	memcpy( DirP + Size->DirectorySize, &Dir, sizeof( DARC_DIRECTORY_VER5 ) ) ;	

	// AhX𐄈ڂ
	Size->DirectorySize += sizeof( DARC_DIRECTORY_VER5 ) ;
	Size->FileSize      += sizeof( DARC_FILEHEAD_VER5 ) * Dir.FileHeadNum ;
	
	// t@Cꍇ͂ŏI
	if( Dir.FileHeadNum == 0 )
	{
		// Ƃ̃fBNgJgfBNgɃZbg
		SetCurrentDirectory( DirPath ) ;
		return 0 ;
	}

	// t@Co͂
	{
		int i ;
		
		i = 0 ;
		
		// 񋓊Jn
		FindHandle = FindFirstFile( "*", &FindData ) ;
		do
		{
			// ̃fBNgɖ߂肷邽߂̃pX͖
			if( strcmp( FindData.cFileName, "." ) == 0 || strcmp( FindData.cFileName, ".." ) == 0 ) continue ;

			// t@Cł͂ȂAfBNgꍇ͍ċA
			if( FindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY )
			{
				// fBNgꍇ̏
				if( DirectoryEncode( FindData.cFileName, NameP, DirP, FileP, &Dir, Size, i, DestP, TempBuffer, Press, Key ) < 0 ) return -1 ;
			}
			else
			{
				// t@Cꍇ̏

				// t@C̃f[^Zbg
				File.NameAddress     = Size->NameSize ;
				File.Time.Create     = ( ( ( LONGLONG )FindData.ftCreationTime.dwHighDateTime   ) << 32 ) + FindData.ftCreationTime.dwLowDateTime   ;
				File.Time.LastAccess = ( ( ( LONGLONG )FindData.ftLastAccessTime.dwHighDateTime ) << 32 ) + FindData.ftLastAccessTime.dwLowDateTime ;
				File.Time.LastWrite  = ( ( ( LONGLONG )FindData.ftLastWriteTime.dwHighDateTime  ) << 32 ) + FindData.ftLastWriteTime.dwLowDateTime  ;
				File.Attributes      = FindData.dwFileAttributes ;
				File.DataAddress     = Size->DataSize ;
				File.DataSize        = FindData.nFileSizeLow ;
				File.PressDataSize   = 0xffffffff ;

				// t@Co
				Size->NameSize += AddFileNameData( FindData.cFileName, NameP + Size->NameSize ) ;
				
				// t@Cf[^o
				if( (u64)FindData.nFileSizeLow + ( (u64)FindData.nFileSizeHigh << 32 ) != 0 )
				{
					FILE *SrcP ;
					u32 FileSize, WriteSize, MoveSize ;

					// t@CJ
					SrcP = fopen( FindData.cFileName, "rb" ) ;
					
					// TCY𓾂
					fseek( SrcP, 0, SEEK_END ) ;
					FileSize = ftell( SrcP ) ;
					fseek( SrcP, 0, SEEK_SET ) ;
					
					// t@CTCY 10MB ȉ̏ꍇŁAk̎w肪ꍇ͈k݂
					if( Press == true && (u64)FindData.nFileSizeLow + ( (u64)FindData.nFileSizeHigh << 32 ) < 10 * 1024 * 1024 )
					{
						void *SrcBuf, *DestBuf ;
						u32 DestSize, Len ;
						
						// ꕔ̃t@C`̏ꍇ͗\ߒe
						if( ( Len = strlen( FindData.cFileName ) ) > 4 )
						{
							char *sp ;
							
							sp = &FindData.cFileName[Len-3] ;
							if( StrICmp( sp, "wav" ) == 0 ||
								StrICmp( sp, "jpg" ) == 0 ||
								StrICmp( sp, "png" ) == 0 ||
								StrICmp( sp, "mpg" ) == 0 ||
								StrICmp( sp, "mp3" ) == 0 ||
								StrICmp( sp, "ogg" ) == 0 ||
								StrICmp( sp, "wmv" ) == 0 ||
								StrICmp( sp - 1, "jpeg" ) == 0 ) goto NOPRESS ;
						}
						
						// f[^ۂƓ郁̈̊m
						SrcBuf  = malloc( FileSize + FileSize * 2 + 64 ) ;
						DestBuf = (u8 *)SrcBuf + FileSize ;
						
						// t@CۂƓǂݍ
						fread( SrcBuf, FileSize, 1, SrcP ) ;
						
						// k
						DestSize = Encode( SrcBuf, FileSize, DestBuf ) ;
						
						// wǈkoȂꍇ͈kŃA[JCu
						if( (f64)DestSize / (f64)FileSize > 0.90 )
						{
							fseek( SrcP, 0L, SEEK_SET ) ;
							free( SrcBuf ) ;
							goto NOPRESS ;
						}
						
						// kf[^𔽓]ďo
						WriteSize = ( DestSize + 3 ) / 4 * 4 ;
						KeyConvFileWrite( DestBuf, WriteSize, DestP, Key, File.DataSize ) ;
						
						// ̉
						free( SrcBuf ) ;
						
						// kf[^̃TCYۑ
						File.PressDataSize = DestSize ;
					}
					else
					{
NOPRESS:					
						// ]Jn
						WriteSize = 0 ;
						while( WriteSize < FileSize )
						{
							// ]TCY
							MoveSize = DXA_BUFFERSIZE_VER5 < FileSize - WriteSize ? DXA_BUFFERSIZE_VER5 : FileSize - WriteSize ;
							MoveSize = ( MoveSize + 3 ) / 4 * 4 ;	// TCY͂S̔{ɍ킹
							
							// t@C̔]ǂݍ
							KeyConvFileRead( TempBuffer, MoveSize, SrcP, Key, File.DataSize + WriteSize ) ;

							// o
							fwrite( TempBuffer, MoveSize, 1, DestP ) ;
							
							// oTCỶZ
							WriteSize += MoveSize ;
						}
					}
					
					// ot@C
					fclose( SrcP ) ;
				
					// f[^TCỶZ
					Size->DataSize += WriteSize ;
				}
				
				// t@Cwb_o
				memcpy( FileP + Dir.FileHeadAddress + sizeof( DARC_FILEHEAD_VER5 ) * i, &File, sizeof( DARC_FILEHEAD_VER5 ) ) ;
			}
			
			i ++ ;
		}
		while( FindNextFile( FindHandle, &FindData ) != 0 ) ;
		
		// Find nh
		FindClose( FindHandle ) ;
	}
						
	// Ƃ̃fBNgJgfBNgɃZbg
	SetCurrentDirectory( DirPath ) ;

	// I
	return 0 ;
}

// w̃fBNgf[^ɂt@CWJ
int DXArchive_VER5::DirectoryDecode( u8 *NameP, u8 *DirP, u8 *FileP, DARC_HEAD_VER5 *Head, DARC_DIRECTORY_VER5 *Dir, FILE *ArcP, unsigned char *Key )
{
	char DirPath[MAX_PATH] ;
	
	// ݂̃JgfBNgۑ
	GetCurrentDirectory( MAX_PATH, DirPath ) ;

	// fBNg񂪂ꍇ́A܂WJp̃fBNg쐬
	if( Dir->DirectoryAddress != 0xffffffff && Dir->ParentDirectoryAddress != 0xffffffff )
	{
		DARC_FILEHEAD_VER5 *DirFile ;
		
		// DARC_FILEHEAD_VER5 ̃AhX擾
		DirFile = ( DARC_FILEHEAD_VER5 * )( FileP + Dir->DirectoryAddress ) ;
		
		// fBNg̍쐬
		CreateDirectory( GetOriginalFileName( NameP + DirFile->NameAddress ), NULL ) ;
		
		// ̃fBNgɃJgfBNgڂ
		SetCurrentDirectory( GetOriginalFileName( NameP + DirFile->NameAddress ) ) ;
	}

	// WJJn
	{
		u32 i, FileHeadSize ;
		DARC_FILEHEAD_VER5 *File ;

		// i[Ăt@C̐JԂ
		FileHeadSize = Head->Version >= 0x0002 ? sizeof( DARC_FILEHEAD_VER5 ) : sizeof( DARC_FILEHEAD_VER1 ) ;
		File = ( DARC_FILEHEAD_VER5 * )( FileP + Dir->FileHeadAddress ) ;
		for( i = 0 ; i < Dir->FileHeadNum ; i ++, File = (DARC_FILEHEAD_VER5 *)( (u8 *)File + FileHeadSize ) )
		{
			// fBNgǂŏ𕪊
			if( File->Attributes & FILE_ATTRIBUTE_DIRECTORY )
			{
				// fBNg̏ꍇ͍ċA
				DirectoryDecode( NameP, DirP, FileP, Head, ( DARC_DIRECTORY_VER5 * )( DirP + File->DataAddress ), ArcP, Key ) ;
			}
			else
			{
				FILE *DestP ;
				void *Buffer ;
			
				// t@C̏ꍇ͓WJ
				
				// obt@mۂ
				Buffer = malloc( DXA_BUFFERSIZE_VER5 ) ;
				if( Buffer == NULL ) return -1 ;

				// t@CJ
				DestP = fopen( GetOriginalFileName( NameP + File->NameAddress ), "wb" ) ;
				
				// f[^ꍇ̂ݓ]
				if( File->DataSize != 0 )
				{
					// ʒuZbg
					if( ftell( ArcP ) != ( s32 )( Head->DataStartAddress + File->DataAddress ) )
						fseek( ArcP, Head->DataStartAddress + File->DataAddress, SEEK_SET ) ;
						
					// f[^kĂ邩ǂŏ𕪊
					if( Head->Version >= 0x0002 && File->PressDataSize != 0xffffffff )
					{
						void *temp ;
						
						// kĂꍇ

						// kf[^܂郁̈̊m
						temp = malloc( File->PressDataSize + File->DataSize ) ;

						// kf[^̓ǂݍ
						if( Head->Version >= 0x0005 )
						{
							KeyConvFileRead( temp, File->PressDataSize, ArcP, Key, File->DataSize ) ;
						}
						else
						{
							KeyConvFileRead( temp, File->PressDataSize, ArcP, Key ) ;
						}
						
						// 
						Decode( temp, (u8 *)temp + File->PressDataSize ) ;
						
						// o
						fwrite( (u8 *)temp + File->PressDataSize, File->DataSize, 1, DestP ) ;
						
						// ̉
						free( temp ) ;
					}
					else
					{
						// kĂȂꍇ
					
						// ]Jn
						{
							u32 MoveSize, WriteSize ;
							
							WriteSize = 0 ;
							while( WriteSize < File->DataSize )
							{
								MoveSize = File->DataSize - WriteSize > DXA_BUFFERSIZE_VER5 ? DXA_BUFFERSIZE_VER5 : File->DataSize - WriteSize ;

								// t@C̔]ǂݍ
								if( Head->Version >= 0x0005 )
								{
									KeyConvFileRead( Buffer, MoveSize, ArcP, Key, File->DataSize + WriteSize ) ;
								}
								else
								{
									KeyConvFileRead( Buffer, MoveSize, ArcP, Key ) ;
								}

								// o
								fwrite( Buffer, MoveSize, 1, DestP ) ;
								
								WriteSize += MoveSize ;
							}
						}
					}
				}
				
				// t@C
				fclose( DestP ) ;

				// obt@J
				free( Buffer ) ;

				// t@C̃^CX^vݒ肷
				{
					HANDLE HFile ;
					FILETIME CreateTime, LastAccessTime, LastWriteTime ;

					HFile = CreateFile( GetOriginalFileName( NameP + File->NameAddress ),
										GENERIC_WRITE, 0, NULL,
										OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL ) ;
					if( HFile == INVALID_HANDLE_VALUE )
					{
						HFile = HFile ;
					}

					CreateTime.dwHighDateTime     = ( u32 )( File->Time.Create     >> 32        ) ;
					CreateTime.dwLowDateTime      = ( u32 )( File->Time.Create     & 0xffffffff ) ;
					LastAccessTime.dwHighDateTime = ( u32 )( File->Time.LastAccess >> 32        ) ;
					LastAccessTime.dwLowDateTime  = ( u32 )( File->Time.LastAccess & 0xffffffff ) ;
					LastWriteTime.dwHighDateTime  = ( u32 )( File->Time.LastWrite  >> 32        ) ;
					LastWriteTime.dwLowDateTime   = ( u32 )( File->Time.LastWrite  & 0xffffffff ) ;
					SetFileTime( HFile, &CreateTime, &LastAccessTime, &LastWriteTime ) ;
					CloseHandle( HFile ) ;
				}

				// t@Ct
				SetFileAttributes( GetOriginalFileName( NameP + File->NameAddress ), File->Attributes ) ;
			}
		}
	}
	
	// JgfBNgɖ߂
	SetCurrentDirectory( DirPath ) ;

	// I
	return 0 ;
}

// fBNg̃t@CpX擾
int DXArchive_VER5::GetDirectoryFilePath( const char *DirectoryPath, char *FileNameBuffer )
{
	WIN32_FIND_DATA FindData ;
	HANDLE FindHandle ;
	int FileNum ;
	char DirPath[256], String[256] ;

	// fBNgǂ`FbN
	if( DirectoryPath[0] != '\0' )
	{
		FindHandle = FindFirstFile( DirectoryPath, &FindData ) ;
		if( FindHandle == INVALID_HANDLE_VALUE || ( FindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY ) == 0 ) return -1 ;
		FindClose( FindHandle ) ;
	}

	// w̃tH_̃t@C̖O擾
	FileNum = 0 ;
	if( DirectoryPath[0] != '\0' )
	{
		strcpy( DirPath, DirectoryPath ) ;
		if( DirPath[ strlen( DirPath ) - 1 ] != '\\' ) strcat( DirPath, "\\" ) ;
		strcpy( String, DirPath ) ;
		strcat( String, "*" ) ;
	}
	else
	{
		strcpy( DirPath, "" ) ;
		strcpy( String, "*" ) ;
	}
	FindHandle = FindFirstFile( String, &FindData ) ;
	if( FindHandle != INVALID_HANDLE_VALUE )
	{
		do
		{
			// ̃fBNgɖ߂肷邽߂̃pX͖
			if( strcmp( FindData.cFileName, "." ) == 0 || strcmp( FindData.cFileName, ".." ) == 0 ) continue ;

			// t@CpXۑ
			if( FileNameBuffer != NULL )
			{
				strcpy( FileNameBuffer, DirPath ) ;
				strcat( FileNameBuffer, FindData.cFileName ) ;
				FileNameBuffer += 256 ;
			}

			// t@C̐𑝂₷
			FileNum ++ ;
		}
		while( FindNextFile( FindHandle, &FindData ) != 0 ) ;
		FindClose( FindHandle ) ;
	}

	// Ԃ
	return FileNum ;
}

// GR[h( ߂l:k̃TCY  -1 ̓G[  Dest  NULL 邱Ƃ\ )
int DXArchive_VER5::Encode( void *Src, unsigned int SrcSize, void *Dest )
{
	s32 dstsize ;
	s32    bonus,    conbo,    conbosize,    address,    addresssize ;
	s32 maxbonus, maxconbo, maxconbosize, maxaddress, maxaddresssize ;
	u8 keycode, *srcp, *destp, *dp, *sp, *sp2, *sp1 ;
	u32 srcaddress, nextprintaddress, code ;
	s32 j ;
	u32 i, m ;
	u32 maxlistnum, maxlistnummask, listaddp ;
	u32 sublistnum, sublistmaxnum ;
	LZ_LIST_VER5 *listbuf, *listtemp, *list, *newlist ;
	u8 *listfirsttable, *usesublistflagtable, *sublistbuf ;
	
	// TuXg̃TCY߂
	{
			 if( SrcSize < 100 * 1024 )			sublistmaxnum = 1 ;
		else if( SrcSize < 3 * 1024 * 1024 )	sublistmaxnum = MAX_SUBLISTNUM_VER5 / 3 ;
		else									sublistmaxnum = MAX_SUBLISTNUM_VER5 ;
	}

	// Xg̃TCY߂
	{
		maxlistnum = MAX_ADDRESSLISTNUM_VER5 ;
		if( maxlistnum > SrcSize )
		{
			while( ( maxlistnum >> 1 ) > 0x100 && ( maxlistnum >> 1 ) > SrcSize )
				maxlistnum >>= 1 ;
		}
		maxlistnummask = maxlistnum - 1 ;
	}

	// ̊m
	usesublistflagtable   = (u8 *)malloc(
		sizeof( u32 )     * 65536 +					// CXg̐擪IuWFNgp̈
		sizeof( LZ_LIST_VER5 ) * maxlistnum +			// CXgp̈
		sizeof( u8 )      * 65536 +					// TuXggpĂ邩tOp̈
		sizeof( u32 )     * 256 * sublistmaxnum ) ;	// TuXgp̈
		
	// AhX̃Zbg
	listfirsttable =     usesublistflagtable + sizeof(  u8 ) * 65536 ;
	sublistbuf     =          listfirsttable + sizeof( u32 ) * 65536 ;
	listbuf        = (LZ_LIST_VER5 *)( sublistbuf + sizeof( u32 ) * 256 * sublistmaxnum ) ;
	
	// 
	memset( usesublistflagtable, 0, sizeof(  u8 ) * 65536               ) ;
	memset(          sublistbuf, 0, sizeof( u32 ) * 256 * sublistmaxnum ) ;
	memset(      listfirsttable, 0, sizeof( u32 ) * 65536               ) ;
	list = listbuf ;
	for( i = maxlistnum / 8 ; i ; i --, list += 8 )
	{
		list[0].address =
		list[1].address =
		list[2].address =
		list[3].address =
		list[4].address =
		list[5].address =
		list[6].address =
		list[7].address = 0xffffffff ;
	}

	srcp  = (u8 *)Src ;
	destp = (u8 *)Dest ;

	// kf[^̒ňԏopxႢoCgR[h
	{
		u32 qnum, table[256], mincode ;

		for( i = 0 ; i < 256 ; i ++ )
			table[i] = 0 ;
		
		sp   = srcp ;
		qnum = SrcSize / 8 ;
		i    = qnum * 8 ;
		for( ; qnum ; qnum --, sp += 8 )
		{
			table[sp[0]] ++ ;
			table[sp[1]] ++ ;
			table[sp[2]] ++ ;
			table[sp[3]] ++ ;
			table[sp[4]] ++ ;
			table[sp[5]] ++ ;
			table[sp[6]] ++ ;
			table[sp[7]] ++ ;
		}
		for( ; i < SrcSize ; i ++, sp ++ )
			table[*sp] ++ ;
			
		keycode = 0 ;
		mincode = table[0] ;
		for( i = 1 ; i < 256 ; i ++ )
		{
			if( mincode < table[i] ) continue ;
			mincode = table[i] ;
			keycode = (u8)i ;
		}
	}

	// k̃TCYZbg
	((u32 *)destp)[0] = SrcSize ;

	// L[R[hZbg
	destp[8] = keycode ;

	// k
	dp               = destp + 9 ;
	sp               = srcp ;
	srcaddress       = 0 ;
	dstsize          = 0 ;
	listaddp         = 0 ;
	sublistnum       = 0 ;
	nextprintaddress = 1024 * 100 ;
	while( srcaddress < SrcSize )
	{
		// cTCYŒሳkTCYȉ̏ꍇ͈kȂ
		if( srcaddress + MIN_COMPRESS_VER5 >= SrcSize ) goto NOENCODE ;

		// Xg擾
		code = *((u16 *)sp) ;
		list = (LZ_LIST_VER5 *)( listfirsttable + code * sizeof( u32 ) ) ;
		if( usesublistflagtable[code] == 1 )
		{
			list = (LZ_LIST_VER5 *)( (u32 *)list->next + sp[2] ) ;
		}
		else
		{
			if( sublistnum < sublistmaxnum )
			{
				list->next = (LZ_LIST_VER5 *)( sublistbuf + sizeof( u32 ) * 256 * sublistnum ) ;
				list       = (LZ_LIST_VER5 *)( (u32 *)list->next + sp[2] ) ;
			
				usesublistflagtable[code] = 1 ;
				sublistnum ++ ;
			}
		}

		// Ԉv̒R[hT
		maxconbo   = -1 ;
		maxaddress = -1 ;
		maxbonus   = -1 ;
		for( m = 0, listtemp = list->next ; m < MAX_SEARCHLISTNUM_VER5 && listtemp != NULL ; listtemp = listtemp->next, m ++ )
		{
			address = srcaddress - listtemp->address ;
			if( address >= MAX_POSITION_VER5 )
			{
				if( listtemp->prev ) listtemp->prev->next = listtemp->next ;
				if( listtemp->next ) listtemp->next->prev = listtemp->prev ;
				listtemp->address = 0xffffffff ;
				continue ;
			}
			
			sp2 = &sp[-address] ;
			sp1 = sp ;
			if( srcaddress + MAX_COPYSIZE_VER5 < SrcSize )
			{
				conbo = MAX_COPYSIZE_VER5 / 4 ;
				while( conbo && *((u32 *)sp2) == *((u32 *)sp1) )
				{
					sp2 += 4 ;
					sp1 += 4 ;
					conbo -- ;
				}
				conbo = MAX_COPYSIZE_VER5 - ( MAX_COPYSIZE_VER5 / 4 - conbo ) * 4 ;

				while( conbo && *sp2 == *sp1 )
				{
					sp2 ++ ;
					sp1 ++ ;
					conbo -- ;
				}
				conbo = MAX_COPYSIZE_VER5 - conbo ;
			}
			else
			{
				for( conbo = 0 ;
						conbo < MAX_COPYSIZE_VER5 &&
						conbo + srcaddress < SrcSize &&
						sp[conbo - address] == sp[conbo] ;
							conbo ++ ){}
			}

			if( conbo >= 4 )
			{
				conbosize   = ( conbo - MIN_COMPRESS_VER5 ) < 0x20 ? 0 : 1 ;
				addresssize = address < 0x100 ? 0 : ( address < 0x10000 ? 1 : 2 ) ;
				bonus       = conbo - ( 3 + conbosize + addresssize ) ;

				if( bonus > maxbonus )
				{
					maxconbo       = conbo ;
					maxaddress     = address ;
					maxaddresssize = addresssize ;
					maxconbosize   = conbosize ;
					maxbonus       = bonus ;
				}
			}
		}

		// Xgɓo^
		newlist = &listbuf[listaddp] ;
		if( newlist->address != 0xffffffff )
		{
			if( newlist->prev ) newlist->prev->next = newlist->next ;
			if( newlist->next ) newlist->next->prev = newlist->prev ;
			newlist->address = 0xffffffff ;
		}
		newlist->address = srcaddress ;
		newlist->prev    = list ;
		newlist->next    = list->next ;
		if( list->next != NULL ) list->next->prev = newlist ;
		list->next       = newlist ;
		listaddp         = ( listaddp + 1 ) & maxlistnummask ;

		// vR[hȂ񈳏kR[hƂďo
		if( maxconbo == -1 )
		{
NOENCODE:
			// L[R[hꍇ͂QAŏo͂
			if( *sp == keycode )
			{
				if( destp != NULL )
				{
					dp[0]  =
					dp[1]  = keycode ;
					dp += 2 ;
				}
				dstsize += 2 ;
			}
			else
			{
				if( destp != NULL )
				{
					*dp = *sp ;
					dp ++ ;
				}
				dstsize ++ ;
			}
			sp ++ ;
			srcaddress ++ ;
		}
		else
		{
			// ꍇ͌ʒuƒo͂
			
			// L[R[hƌʒuƒo
			if( destp != NULL )
			{
				// L[R[h̏o
				*dp++ = keycode ;

				// o͂A͍Œ MIN_COMPRESS_VER5 邱ƂOȂ̂ - MIN_COMPRESS_VER5 ̂o͂
				maxconbo -= MIN_COMPRESS_VER5 ;

				// AO`SrbgƘAA΃AhX̃rbgo
				*dp = (u8)( ( ( maxconbo & 0x1f ) << 3 ) | ( maxconbosize << 2 ) | maxaddresssize ) ;

				// L[R[h̘A̓L[R[hƒl̓񈳏kR[h
				// f邽߁AL[R[h̒lȏ̏ꍇ͒l{P
				if( *dp >= keycode ) dp[0] += 1 ;
				dp ++ ;

				// AT`PQrbgo
				if( maxconbosize == 1 )
					*dp++ = (u8)( ( maxconbo >> 5 ) & 0xff ) ;

				// maxconbo ͂܂g - MIN_COMPRESS_VER5 ߂
				maxconbo += MIN_COMPRESS_VER5 ;

				// o͂鑊΃AhX͂O( ݂̃AhX|P )}̂ŁA|P̂o͂
				maxaddress -- ;

				// ΃AhXo
				*dp++ = (u8)( maxaddress ) ;
				if( maxaddresssize > 0 )
				{
					*dp++ = (u8)( maxaddress >> 8 ) ;
					if( maxaddresssize == 2 )
						*dp++ = (u8)( maxaddress >> 16 ) ;
				}
			}
			
			// o̓TCYZ
			dstsize += 3 + maxaddresssize + maxconbosize ;
			
			// Xgɏǉ
			if( srcaddress + maxconbo < SrcSize )
			{
				sp2 = &sp[1] ;
				for( j = 1 ; j < maxconbo && (u32)&sp2[2] - (u32)srcp < SrcSize ; j ++, sp2 ++ )
				{
					code = *((u16 *)sp2) ;
					list = (LZ_LIST_VER5 *)( listfirsttable + code * sizeof( u32 ) ) ;
					if( usesublistflagtable[code] == 1 )
					{
						list = (LZ_LIST_VER5 *)( (u32 *)list->next + sp2[2] ) ;
					}
					else
					{
						if( sublistnum < sublistmaxnum )
						{
							list->next = (LZ_LIST_VER5 *)( sublistbuf + sizeof( u32 ) * 256 * sublistnum ) ;
							list       = (LZ_LIST_VER5 *)( (u32 *)list->next + sp2[2] ) ;
						
							usesublistflagtable[code] = 1 ;
							sublistnum ++ ;
						}
					}

					newlist = &listbuf[listaddp] ;
					if( newlist->address != 0xffffffff )
					{
						if( newlist->prev ) newlist->prev->next = newlist->next ;
						if( newlist->next ) newlist->next->prev = newlist->prev ;
						newlist->address = 0xffffffff ;
					}
					newlist->address = srcaddress + j ;
					newlist->prev = list ;
					newlist->next = list->next ;
					if( list->next != NULL ) list->next->prev = newlist ;
					list->next = newlist ;
					listaddp = ( listaddp + 1 ) & maxlistnummask ;
				}
			}
			
			sp         += maxconbo ;
			srcaddress += maxconbo ;
		}

		// k̕\
		if( nextprintaddress < srcaddress )
		{
			nextprintaddress = srcaddress + 100 * 1024 ;
		}
	}

	// k̃f[^TCYۑ
	*((u32 *)&destp[4]) = dstsize + 9 ;

	// mۂ̉
	free( usesublistflagtable ) ;

	// f[^̃TCYԂ
	return dstsize + 9 ;
}

// fR[h( ߂l:𓀌̃TCY  -1 ̓G[  Dest  NULL 邱Ƃ\ )
int DXArchive_VER5::Decode( void *Src, void *Dest )
{
	u32 srcsize, destsize, code, indexsize, keycode, conbo, index ;
	u8 *srcp, *destp, *dp, *sp ;

	destp = (u8 *)Dest ;
	srcp  = (u8 *)Src ;
	
	// 𓀌̃f[^TCY𓾂
	destsize = *((u32 *)&srcp[0]) ;

	// kf[^̃TCY𓾂
	srcsize = *((u32 *)&srcp[4]) - 9 ;

	// L[R[h
	keycode = srcp[8] ;
	
	// o͐悪Ȃꍇ̓TCYԂ
	if( Dest == NULL )
		return destsize ;
	
	// WJJn
	sp  = srcp + 9 ;
	dp  = destp ;
	while( srcsize )
	{
		// L[R[hŏ𕪊
		if( sp[0] != keycode )
		{
			// 񈳏kR[h̏ꍇ͂̂܂܏o
			*dp = *sp ;
			dp      ++ ;
			sp      ++ ;
			srcsize -- ;
			continue ;
		}
	
		// L[R[hAĂꍇ̓L[R[ĥo
		if( sp[1] == keycode )
		{
			*dp = (u8)keycode ;
			dp      ++ ;
			sp      += 2 ;
			srcsize -= 2 ;
			
			continue ;
		}

		// oCg𓾂
		code = sp[1] ;

		// L[R[h傫Ȓlꍇ̓L[R[h
		// Ƃ̃obeBOh~ׂ̈Ɂ{PĂ̂Ł|P
		if( code > keycode ) code -- ;

		sp      += 2 ;
		srcsize -= 2 ;

		// A擾
		conbo = code >> 3 ;
		if( code & ( 0x1 << 2 ) )
		{
			conbo |= *sp << 5 ;
			sp      ++ ;
			srcsize -- ;
		}
		conbo += MIN_COMPRESS_VER5 ;	// ۑɌZŏkoCg𑫂

		// QƑ΃AhX擾
		indexsize = code & 0x3 ;
		switch( indexsize )
		{
		case 0 :
			index = *sp ;
			sp      ++ ;
			srcsize -- ;
			break ;
			
		case 1 :
			index = *((u16 *)sp) ;
			sp      += 2 ;
			srcsize -= 2 ;
			break ;
			
		case 2 :
			index = *((u16 *)sp) | ( sp[2] << 16 ) ;
			sp      += 3 ;
			srcsize -= 3 ;
			break ;
		}
		index ++ ;		// ۑɁ|PĂ̂Ł{P

		// WJ
		if( index < conbo )
		{
			u32 num ;

			num  = index ;
			while( conbo > num )
			{
				memcpy( dp, dp - num, num ) ;
				dp    += num ;
				conbo -= num ;
				num   += num ;
			}
			if( conbo != 0 )
			{
				memcpy( dp, dp - num, conbo ) ;
				dp += conbo ;
			}
		}
		else
		{
			memcpy( dp, dp - index, conbo ) ;
			dp += conbo ;
		}
	}

	// 𓀌̃TCYԂ
	return (int)destsize ;
}


// A[JCut@C쐬(fBNg)
int DXArchive_VER5::EncodeArchiveOneDirectory( char *OutputFileName, char *DirectoryPath, bool Press, const char *KeyString )
{
	int i, FileNum, Result ;
	char **FilePathList, *NameBuffer ;

	// t@C̐擾
	FileNum = GetDirectoryFilePath( DirectoryPath, NULL ) ;
	if( FileNum < 0 ) return -1 ;

	// t@C̐̕t@Cƃt@C|C^̊i[p̃mۂ
	NameBuffer = (char *)malloc( FileNum * ( 256 + 4 ) ) ;

	// t@C̃pX擾
	GetDirectoryFilePath( DirectoryPath, NameBuffer ) ;

	// t@CpX̃Xg쐬
	FilePathList = (char **)( NameBuffer + FileNum * 256 ) ;
	for( i = 0 ; i < FileNum ; i ++ )
		FilePathList[i] = NameBuffer + i * 256 ;

	// GR[h
	Result = EncodeArchive( OutputFileName, FilePathList, FileNum, Press, KeyString ) ;

	// mۂ̉
	free( NameBuffer ) ;

	// ʂԂ
	return Result ;
}

// A[JCut@C쐬
int DXArchive_VER5::EncodeArchive( char *OutputFileName, char **FileOrDirectoryPath, int FileNum, bool Press, const char *KeyString )
{
	DARC_HEAD_VER5 Head ;
	DARC_DIRECTORY_VER5 Directory ;
	SIZESAVE SizeSave ;
	FILE *DestFp ;
	u8 *NameP, *FileP, *DirP ;
	int i ;
	u32 Type ;
	void *TempBuffer ;
	u8 Key[DXA_KEYSTR_LENGTH_VER5] ;

	// ̍쐬
	KeyCreate( KeyString, Key ) ;

	// t@Cǂݍ݂Ɏgpobt@̊m
	TempBuffer = malloc( DXA_BUFFERSIZE_VER5 ) ;
	
	// o̓t@CJ
	DestFp = fopen( OutputFileName, "wb" ) ;

	// A[JCũwb_o͂
	{
		Head.Head						= DXA_HEAD_VER5 ;
		Head.Version					= DXA_VER_VER5 ;
		Head.HeadSize					= 0xffffffff ;
		Head.DataStartAddress			= sizeof( DARC_HEAD_VER5 ) ;
		Head.FileNameTableStartAddress	= 0xffffffff ;
		Head.DirectoryTableStartAddress	= 0xffffffff ;
		Head.FileTableStartAddress		= 0xffffffff ;
		Head.CodePage					= GetACP() ;
		SetFileApisToANSI() ;

		KeyConvFileWrite( &Head, sizeof( DARC_HEAD_VER5 ), DestFp, Key, 0 ) ;
	}
	
	// eobt@mۂ
	if( ( NameP = ( u8 * )malloc( DXA_BUFFERSIZE_VER5 ) ) == NULL ) return -1 ;
	memset( NameP, 0, DXA_BUFFERSIZE_VER5 ) ;

	if( ( FileP = ( u8 * )malloc( DXA_BUFFERSIZE_VER5 ) ) == NULL ) return -1 ;
	memset( FileP, 0, DXA_BUFFERSIZE_VER5 ) ;

	if( ( DirP = ( u8 * )malloc( DXA_BUFFERSIZE_VER5 ) ) == NULL ) return -1 ;
	memset( DirP, 0, DXA_BUFFERSIZE_VER5 ) ;

	// TCYۑ\̂Ƀf[^Zbg
	SizeSave.DataSize		= 0 ;
	SizeSave.NameSize		= 0 ;
	SizeSave.DirectorySize	= 0 ;
	SizeSave.FileSize		= 0 ;
	
	// ŏ̃fBNg̃t@Co
	{
		DARC_FILEHEAD_VER5 File ;
		
		memset( &File, 0, sizeof( DARC_FILEHEAD_VER5 ) ) ;
		File.NameAddress	= SizeSave.NameSize ;
		File.Attributes		= FILE_ATTRIBUTE_DIRECTORY ;
		File.DataAddress	= SizeSave.DirectorySize ;
		File.DataSize		= 0 ;
		File.PressDataSize  = 0xffffffff ;

		// fBNg̏o
		SizeSave.NameSize += AddFileNameData( "", NameP + SizeSave.NameSize ) ;

		// t@C̏o
		memcpy( FileP + SizeSave.FileSize, &File, sizeof( DARC_FILEHEAD_VER5 ) ) ;
		SizeSave.FileSize += sizeof( DARC_FILEHEAD_VER5 ) ;
	}

	// ŏ̃fBNgo
	Directory.DirectoryAddress 			= 0 ;
	Directory.ParentDirectoryAddress 	= 0xffffffff ;
	Directory.FileHeadNum 				= FileNum ;
	Directory.FileHeadAddress 			= SizeSave.FileSize ;
	memcpy( DirP + SizeSave.DirectorySize, &Directory, sizeof( DARC_DIRECTORY_VER5 ) ) ;

	// TCYZ
	SizeSave.DirectorySize 	+= sizeof( DARC_DIRECTORY_VER5 ) ;
	SizeSave.FileSize 		+= sizeof( DARC_FILEHEAD_VER5 ) * FileNum ;

	// nꂽt@C̐JԂ
	for( i = 0 ; i < FileNum ; i ++ )
	{
		// w肳ꂽt@C邩ǂ
		Type = GetFileAttributes( FileOrDirectoryPath[i] ) ;
		if( ( signed int )Type == -1 ) continue ;

		// t@C̃^Cvɂď𕪊
		if( ( Type & FILE_ATTRIBUTE_DIRECTORY ) != 0 )
		{
			// fBNg̏ꍇ̓fBNg̃A[JCuɉ
			DirectoryEncode( FileOrDirectoryPath[i], NameP, DirP, FileP, &Directory, &SizeSave, i, DestFp, TempBuffer, Press, Key ) ;
		}
		else
		{
			WIN32_FIND_DATA FindData ;
			HANDLE FindHandle ;
			DARC_FILEHEAD_VER5 File ;
	
			// t@C̏𓾂
			FindHandle = FindFirstFile( FileOrDirectoryPath[i], &FindData ) ;
			if( FindHandle == INVALID_HANDLE_VALUE ) continue ;
			
			// t@Cwb_Zbg
			{
				File.NameAddress     = SizeSave.NameSize ;
				File.Time.Create     = ( ( ( LONGLONG )FindData.ftCreationTime.dwHighDateTime   ) << 32 ) + FindData.ftCreationTime.dwLowDateTime   ;
				File.Time.LastAccess = ( ( ( LONGLONG )FindData.ftLastAccessTime.dwHighDateTime ) << 32 ) + FindData.ftLastAccessTime.dwLowDateTime ;
				File.Time.LastWrite  = ( ( ( LONGLONG )FindData.ftLastWriteTime.dwHighDateTime  ) << 32 ) + FindData.ftLastWriteTime.dwLowDateTime  ;
				File.Attributes      = FindData.dwFileAttributes ;
				File.DataAddress     = SizeSave.DataSize ;
				File.DataSize        = FindData.nFileSizeLow ;
				File.PressDataSize	 = 0xffffffff ;
			}

			// t@Co
			SizeSave.NameSize += AddFileNameData( FindData.cFileName, NameP + SizeSave.NameSize ) ;

			// t@Cf[^o
			if( (u64)FindData.nFileSizeLow + ( (u64)FindData.nFileSizeHigh << 32 ) != 0 )
			{
				FILE *SrcP ;
				u32 FileSize, WriteSize, MoveSize ;

				// t@CJ
				SrcP = fopen( FileOrDirectoryPath[i], "rb" ) ;
				
				// TCY𓾂
				fseek( SrcP, 0, SEEK_END ) ;
				FileSize = ftell( SrcP ) ;
				fseek( SrcP, 0, SEEK_SET ) ;
				
				// t@CTCY 10MB ȉ̏ꍇŁAk̎w肪ꍇ͈k݂
				if( Press == true && (u64)FindData.nFileSizeLow + ( (u64)FindData.nFileSizeHigh << 32 ) < 10 * 1024 * 1024 )
				{
					void *SrcBuf, *DestBuf ;
					u32 DestSize, Len ;
					
					// ꕔ̃t@C`̏ꍇ͗\ߒe
					if( ( Len = strlen( FindData.cFileName ) ) > 4 )
					{
						char *sp ;
						
						sp = &FindData.cFileName[Len-3] ;
						if( StrICmp( sp, "wav" ) == 0 ||
							StrICmp( sp, "jpg" ) == 0 ||
							StrICmp( sp, "png" ) == 0 ||
							StrICmp( sp, "mpg" ) == 0 ||
							StrICmp( sp, "mp3" ) == 0 ||
							StrICmp( sp, "ogg" ) == 0 ||
							StrICmp( sp, "wmv" ) == 0 ||
							StrICmp( sp - 1, "jpeg" ) == 0 ) goto NOPRESS ;
					}
					
					// f[^ۂƓ郁̈̊m
					SrcBuf  = malloc( FileSize + FileSize * 2 + 64 ) ;
					DestBuf = (u8 *)SrcBuf + FileSize ;
					
					// t@CۂƓǂݍ
					fread( SrcBuf, FileSize, 1, SrcP ) ;
					
					// k
					DestSize = Encode( SrcBuf, FileSize, DestBuf ) ;
					
					// wǈkoȂꍇ͈kŃA[JCu
					if( (f64)DestSize / (f64)FileSize > 0.90 )
					{
						fseek( SrcP, 0L, SEEK_SET ) ;
						free( SrcBuf ) ;
						goto NOPRESS ;
					}
					
					// kf[^𔽓]ďo
					WriteSize = ( DestSize + 3 ) / 4 * 4 ;
					KeyConvFileWrite( DestBuf, WriteSize, DestFp, Key, File.DataSize ) ;
					
					// ̉
					free( SrcBuf ) ;
					
					// kf[^̃TCYۑ
					File.PressDataSize = DestSize ;
				}
				else
				{
NOPRESS:					
					// ]Jn
					WriteSize = 0 ;
					while( WriteSize < FileSize )
					{
						// ]TCY
						MoveSize = DXA_BUFFERSIZE_VER5 < FileSize - WriteSize ? DXA_BUFFERSIZE_VER5 : FileSize - WriteSize ;
						MoveSize = ( MoveSize + 3 ) / 4 * 4 ;	// TCY͂S̔{ɍ킹
						
						// t@C̔]ǂݍ
						KeyConvFileRead( TempBuffer, MoveSize, SrcP, Key, File.DataSize + WriteSize ) ;

						// o
						fwrite( TempBuffer, MoveSize, 1, DestFp ) ;
						
						// oTCỶZ
						WriteSize += MoveSize ;
					}
				}
				
				// ot@C
				fclose( SrcP ) ;
			
				// f[^TCỶZ
				SizeSave.DataSize += WriteSize ;
			}
			
			// t@Cwb_o
			memcpy( FileP + Directory.FileHeadAddress + sizeof( DARC_FILEHEAD_VER5 ) * i, &File, sizeof( DARC_FILEHEAD_VER5 ) ) ;

			// Find nh
			FindClose( FindHandle ) ;
		}
	}
	
	// obt@ɗߍ񂾊ewb_f[^o͂
	{
		// o͂鏇Ԃ t@Cl[e[uA DARC_FILEHEAD_VER5 e[uA DARC_DIRECTORY_VER5 e[u ̏
		KeyConvFileWrite( NameP, SizeSave.NameSize,      DestFp, Key, 0 ) ;
		KeyConvFileWrite( FileP, SizeSave.FileSize,      DestFp, Key, SizeSave.NameSize ) ;
		KeyConvFileWrite( DirP,  SizeSave.DirectorySize, DestFp, Key, SizeSave.NameSize + SizeSave.FileSize ) ;
	}
		
	// ĂуA[JCũwb_o͂
	{
		Head.Head                       = DXA_HEAD_VER5 ;
		Head.Version                    = DXA_VER_VER5 ;
		Head.HeadSize                   = SizeSave.NameSize + SizeSave.DirectorySize + SizeSave.FileSize  ;
		Head.DataStartAddress           = sizeof( DARC_HEAD_VER5 ) ;
		Head.FileNameTableStartAddress  = SizeSave.DataSize + Head.DataStartAddress ;
		Head.FileTableStartAddress      = SizeSave.NameSize ;
		Head.DirectoryTableStartAddress = Head.FileTableStartAddress + SizeSave.FileSize ;

		fseek( DestFp, 0, SEEK_SET ) ;
		KeyConvFileWrite( &Head, sizeof( DARC_HEAD_VER5 ), DestFp, Key, 0 ) ;
	}
	
	// ot@C
	fclose( DestFp ) ;
	
	// mۂobt@J
	free( NameP ) ;
	free( FileP ) ;
	free( DirP ) ;
	free( TempBuffer ) ;

	// I
	return 0 ;
}

// A[JCut@CWJ
int DXArchive_VER5::DecodeArchive( char *ArchiveName, char *OutputPath, const char *KeyString )
{
	u8 *HeadBuffer = NULL ;
	DARC_HEAD_VER5 Head ;
	u8 *FileP, *NameP, *DirP ;
	FILE *ArcP = NULL ;
	char OldDir[MAX_PATH] ;
	u8 Key[DXA_KEYSTR_LENGTH_VER5] ;

	// ̍쐬
	KeyCreate( KeyString, Key ) ;

	// A[JCut@CJ
	ArcP = fopen( ArchiveName, "rb" ) ;
	if( ArcP == NULL ) return -1 ;

	// o͐̃fBNgɃJgfBNgύX
	GetCurrentDirectory( MAX_PATH, OldDir ) ;
	SetCurrentDirectory( OutputPath ) ;

	// wb_͂
	{
		KeyConvFileRead( &Head, sizeof( DARC_HEAD_VER5 ), ArcP, Key, 0 ) ;

		// hč
		if( Head.Head != DXA_HEAD_VER5 )
		{
			// o[WQȑOׂ
			memset( Key, 0xffffffff, DXA_KEYSTR_LENGTH_VER5 ) ;

			fseek( ArcP, 0L, SEEK_SET ) ;
			KeyConvFileRead( &Head, sizeof( DARC_HEAD_VER5 ), ArcP, Key, 0 ) ;

			// o[WQȑOłȂꍇ̓G[
			if( Head.Head != DXA_HEAD_VER5 )
				goto ERR ;
		}
		
		// o[W
		if( Head.Version > DXA_VER_VER5 ) goto ERR ;
		
		// wb_̃TCỸmۂ
		HeadBuffer = ( u8 * )malloc( Head.HeadSize ) ;
		if( HeadBuffer == NULL ) goto ERR ;
		
		// wb_pbNɓǂݍ
		fseek( ArcP, Head.FileNameTableStartAddress, SEEK_SET ) ;
		if( Head.Version >= 0x0005 )
		{
			KeyConvFileRead( HeadBuffer, Head.HeadSize, ArcP, Key, 0 ) ;
		}
		else
		{
			KeyConvFileRead( HeadBuffer, Head.HeadSize, ArcP, Key ) ;
		}
		
		// eAhXZbg
		NameP = HeadBuffer ;
		FileP = NameP + Head.FileTableStartAddress ;
		DirP  = NameP + Head.DirectoryTableStartAddress ;
	}

	// A[JCu̓WJJn
	DirectoryDecode( NameP, DirP, FileP, &Head, ( DARC_DIRECTORY_VER5 * )DirP, ArcP, Key ) ;
	
	// t@C
	fclose( ArcP ) ;
	
	// wb_ǂݍł
	free( HeadBuffer ) ;

	// JgfBNgɖ߂
	SetCurrentDirectory( OldDir ) ;

	// I
	return 0 ;

ERR :
	if( HeadBuffer != NULL ) free( HeadBuffer ) ;
	if( ArcP != NULL ) fclose( ArcP ) ;

	// JgfBNgɖ߂
	SetCurrentDirectory( OldDir ) ;

	// I
	return -1 ;
}



// RXgN^
DXArchive_VER5::DXArchive_VER5( char *ArchivePath )
{
	this->fp = NULL ;
	this->HeadBuffer = NULL ;
	this->NameP = this->DirP = this->FileP = NULL ;
	this->CurrentDirectory = NULL ;
	this->CashBuffer = NULL ;

	if( ArchivePath != NULL )
	{
		this->OpenArchiveFile( ArchivePath ) ;
	}
}

// fXgN^
DXArchive_VER5::~DXArchive_VER5()
{
	if( this->fp != NULL ) this->CloseArchiveFile() ;

	if( this->fp != NULL ) fclose( this->fp ) ;
	if( this->HeadBuffer != NULL ) free( this->HeadBuffer ) ;
	if( this->CashBuffer != NULL ) free( this->CashBuffer ) ;

	this->fp = NULL ;
	this->HeadBuffer = NULL ;
	this->NameP = this->DirP = this->FileP = NULL ;
	this->CurrentDirectory = NULL ;
}

// w̃fBNgf[^̈Í( ۂƃɓǂݍ񂾏ꍇp )
int DXArchive_VER5::DirectoryKeyConv( DARC_DIRECTORY_VER5 *Dir )
{
	// C[Wł͂Ȃꍇ̓G[
	if( this->MemoryOpenFlag == false )
		return -1 ;

	// o[W 0x0005 Oł͉Ȃ
	if( this->Head.Version < 0x0005 )
		return 0 ;
	
	// ÍJn
	{
		u32 i, FileHeadSize ;
		DARC_FILEHEAD_VER5 *File ;

		// i[Ăt@C̐JԂ
		FileHeadSize = this->Head.Version >= 0x0002 ? sizeof( DARC_FILEHEAD_VER5 ) : sizeof( DARC_FILEHEAD_VER1 ) ;
		File = ( DARC_FILEHEAD_VER5 * )( this->FileP + Dir->FileHeadAddress ) ;
		for( i = 0 ; i < Dir->FileHeadNum ; i ++, File = (DARC_FILEHEAD_VER5 *)( (u8 *)File + FileHeadSize ) )
		{
			// fBNgǂŏ𕪊
			if( File->Attributes & FILE_ATTRIBUTE_DIRECTORY )
			{
				// fBNg̏ꍇ͍ċA
				DirectoryKeyConv( ( DARC_DIRECTORY_VER5 * )( this->DirP + File->DataAddress ) ) ;
			}
			else
			{
				u8 *DataP ;

				// t@C̏ꍇ͈Í
				
				// f[^ꍇ̂ݏ
				if( File->DataSize != 0 )
				{
					// f[^ʒuZbg
					DataP = ( u8 * )this->fp + this->Head.DataStartAddress + File->DataAddress ;

					// f[^kĂ邩ǂŏ𕪊
					if( this->Head.Version >= 0x0002 && File->PressDataSize != 0xffffffff )
					{
						// kĂꍇ
						KeyConv( DataP, File->PressDataSize, File->DataSize, this->Key ) ;
					}
					else
					{
						// kĂȂꍇ
						KeyConv( DataP, File->DataSize, File->DataSize, this->Key ) ;
					}
				}
			}
		}
	}

	// I
	return 0 ;
}

// ɂA[JCuC[WJ( 0:  -1:s )
int	DXArchive_VER5::OpenArchiveMem( void *ArchiveImage, int ArchiveSize, const char *KeyString )
{
	u8 *datp ;

	// ɂȂ炩̃A[JCuJĂꍇ̓G[
	if( this->fp != NULL ) return -1 ;

	// ̍쐬
	KeyCreate( KeyString, this->Key ) ;

	// ŏɃwb_̕𔽓]
	memcpy( &this->Head, ArchiveImage, sizeof( DARC_HEAD_VER5 ) ) ;
	KeyConv( &this->Head, sizeof( DARC_HEAD_VER5 ), 0, this->Key ) ;

	// hcႤꍇ̓o[WQȑOׂ
	if( Head.Head != DXA_HEAD_VER5 )
	{
		// o[WQȑOׂ
		memset( this->Key, 0xffffffff, DXA_KEYSTR_LENGTH_VER5 ) ;

		memcpy( &this->Head, ArchiveImage, sizeof( DARC_HEAD_VER5 ) ) ;
		KeyConv( &this->Head, sizeof( DARC_HEAD_VER5 ), 0, this->Key ) ;

		// o[WQȑOłȂꍇ̓G[
		if( Head.Head != DXA_HEAD_VER5 )
			return -1 ;
	}

	if( Head.Version < 0x0005 )
	{
		// ׂẴf[^𔽓]
		KeyConv( ArchiveImage, ArchiveSize, 0, this->Key ) ;
	}

	// |C^ۑ
	this->fp = (FILE *)ArchiveImage ;
	datp = (u8 *)ArchiveImage ;

	// wb_͂
	{
		if( Head.Version >= 0x0005 )
		{
			memcpy( &this->Head, datp, sizeof( DARC_HEAD_VER5 ) ) ;
			KeyConv( &this->Head, sizeof( DARC_HEAD_VER5 ), 0, this->Key ) ;
		}
		else
		{
			memcpy( &this->Head, datp, sizeof( DARC_HEAD_VER5 ) ) ;
		}

		datp += sizeof( DARC_HEAD_VER5 ) ;

		// hč
		if( this->Head.Head != DXA_HEAD_VER5 ) goto ERR ;
		
		// o[W
		if( this->Head.Version > DXA_VER_VER5 ) goto ERR ;

		// wb_pbÑAhXZbg
		this->HeadBuffer = (u8 *)this->fp + this->Head.FileNameTableStartAddress ;

		// eAhXZbg
		if( Head.Version >= 0x0005 )
		{
			KeyConv( this->HeadBuffer, this->Head.HeadSize, 0, this->Key ) ;
		}
		this->NameP = this->HeadBuffer ;
		this->FileP = this->NameP + this->Head.FileTableStartAddress ;
		this->DirP = this->NameP + this->Head.DirectoryTableStartAddress ;
	}

	// JgfBNg̃Zbg
	this->CurrentDirectory = ( DARC_DIRECTORY_VER5 * )this->DirP ;

	// C[WJĂtO𗧂Ă
	MemoryOpenFlag = true ;

	// SẴt@C̈Í
	if( this->Head.Version >= 0x0005 )
	{
		DirectoryKeyConv( ( DARC_DIRECTORY_VER5 * )this->DirP ) ;
	}

	// [U[̃C[WJtO𗧂Ă
	UserMemoryImageFlag = true ;

	// TCYۑĂ
	MemoryImageSize = ArchiveSize ;

	// I
	return 0 ;

ERR :
	if( Head.Version < 0x0005 )
	{
		// ]f[^ɖ߂
		KeyConv( ArchiveImage, ArchiveSize, 0, this->Key ) ;
	}

	// I
	return -1 ;
}

// A[JCut@CJŏɂׂăɓǂݍł珈( 0:  -1:s )
int DXArchive_VER5::OpenArchiveFileMem( const char *ArchivePath, const char *KeyString )
{
	FILE *fp ;
	u8 *datp ;
	void *ArchiveImage ;
	int ArchiveSize ;

	// ɂȂ炩̃A[JCuJĂꍇ̓G[
	if( this->fp != NULL ) return -1 ;

	// ̍쐬
	KeyCreate( KeyString, this->Key ) ;

	// ɓǂݍ
	{
		fp = fopen( ArchivePath, "rb" ) ;
		if( fp == NULL ) return -1 ;
		fseek( fp, 0L, SEEK_END ) ;
		ArchiveSize = ftell( fp ) ;
		fseek( fp, 0L, SEEK_SET ) ;
		ArchiveImage = malloc( ArchiveSize ) ;
		if( ArchiveImage == NULL )
		{
			fclose( fp ) ;
			return -1 ;
		}
		fread( ArchiveImage, ArchiveSize, 1, fp ) ;
		fclose( fp ) ;
	}

	// ŏɃwb_̕𔽓]
	memcpy( &this->Head, ArchiveImage, sizeof( DARC_HEAD_VER5 ) ) ;
	KeyConv( &this->Head, sizeof( DARC_HEAD_VER5 ), 0, this->Key ) ;

	// hcႤꍇ̓o[WQȑOׂ
	if( Head.Head != DXA_HEAD_VER5 )
	{
		// o[WQȑOׂ
		memset( this->Key, 0xffffffff, DXA_KEYSTR_LENGTH_VER5 ) ;

		memcpy( &this->Head, ArchiveImage, sizeof( DARC_HEAD_VER5 ) ) ;
		KeyConv( &this->Head, sizeof( DARC_HEAD_VER5 ), 0, this->Key ) ;

		// o[WQȑOłȂꍇ̓G[
		if( Head.Head != DXA_HEAD_VER5 )
			return -1 ;
	}

	// ׂẴf[^𔽓]
	if( Head.Version < 0x0005 )
	{
		KeyConv( ArchiveImage, ArchiveSize, 0, this->Key ) ;
	}

	// |C^ۑ
	this->fp = (FILE *)ArchiveImage ;
	datp = (u8 *)ArchiveImage ;

	// wb_͂
	{
		if( Head.Version >= 0x0005 )
		{
			memcpy( &this->Head, datp, sizeof( DARC_HEAD_VER5 ) ) ;
			KeyConv( &this->Head, sizeof( DARC_HEAD_VER5 ), 0, this->Key ) ;
		}
		else
		{
			memcpy( &this->Head, datp, sizeof( DARC_HEAD_VER5 ) ) ;
		}

		datp += sizeof( DARC_HEAD_VER5 ) ;
		
		// hč
		if( this->Head.Head != DXA_HEAD_VER5 ) goto ERR ;
		
		// o[W
		if( this->Head.Version > DXA_VER_VER5 ) goto ERR ;

		// wb_pbÑAhXZbg
		this->HeadBuffer = (u8 *)this->fp + this->Head.FileNameTableStartAddress ;

		// eAhXZbg
		if( Head.Version >= 0x0005 )
		{
			KeyConv( this->HeadBuffer, this->Head.HeadSize, 0, this->Key ) ;
		}
		this->NameP = this->HeadBuffer ;
		this->FileP = this->NameP + this->Head.FileTableStartAddress ;
		this->DirP = this->NameP + this->Head.DirectoryTableStartAddress ;
	}

	// JgfBNg̃Zbg
	this->CurrentDirectory = ( DARC_DIRECTORY_VER5 * )this->DirP ;

	// C[WJĂtO𗧂Ă
	MemoryOpenFlag = true ;

	// SẴt@C̈Í
	if( this->Head.Version >= 0x0005 )
	{
		DirectoryKeyConv( ( DARC_DIRECTORY_VER5 * )this->DirP ) ;
	}
	
	// [U[̃C[WJ킯ł͂Ȃ̂ŃtO|
	UserMemoryImageFlag = false ;

	// TCYۑĂ
	MemoryImageSize = ArchiveSize ;

	// I
	return 0 ;

ERR :
	if( Head.Version < 0x0005 )
	{
		// ]f[^ɖ߂
		KeyConv( ArchiveImage, ArchiveSize, 0, this->Key ) ;
	}
	
	// I
	return -1 ;
}

// A[JCut@CJ
int DXArchive_VER5::OpenArchiveFile( const char *ArchivePath, const char *KeyString )
{
	// ɂȂ炩̃A[JCuJĂꍇ̓G[
	if( this->fp != NULL ) return -1 ;

	// A[JCut@CJƎ݂
	this->fp = fopen( ArchivePath, "rb" ) ;
	if( this->fp == NULL ) return -1 ;

	// ̍쐬
	KeyCreate( KeyString, this->Key ) ;

	// wb_͂
	{
		KeyConvFileRead( &this->Head, sizeof( DARC_HEAD_VER5 ), this->fp, this->Key, 0 ) ;
		
		// hč
		if( this->Head.Head != DXA_HEAD_VER5 )
		{
			// o[WQȑOׂ
			memset( this->Key, 0xffffffff, DXA_KEYSTR_LENGTH_VER5 ) ;

			fseek( this->fp, 0L, SEEK_SET ) ;
			KeyConvFileRead( &Head, sizeof( DARC_HEAD_VER5 ), this->fp, this->Key, 0 ) ;

			// o[WQȑOłȂꍇ̓G[
			if( Head.Head != DXA_HEAD_VER5 )
				goto ERR ;
		}
		
		// o[W
		if( this->Head.Version > DXA_VER_VER5 ) goto ERR ;
		
		// wb_̃TCỸmۂ
		this->HeadBuffer = ( u8 * )malloc( this->Head.HeadSize ) ;
		if( this->HeadBuffer == NULL ) goto ERR ;
		
		// wb_pbNɓǂݍ
		fseek( this->fp, this->Head.FileNameTableStartAddress, SEEK_SET ) ;
		if( this->Head.Version >= 0x0005 )
		{
			KeyConvFileRead( this->HeadBuffer, this->Head.HeadSize, this->fp, this->Key, 0 ) ;
		}
		else
		{
			KeyConvFileRead( this->HeadBuffer, this->Head.HeadSize, this->fp, this->Key ) ;
		}
		
		// eAhXZbg
		this->NameP = this->HeadBuffer ;
		this->FileP = this->NameP + this->Head.FileTableStartAddress ;
		this->DirP = this->NameP + this->Head.DirectoryTableStartAddress ;
	}

	// JgfBNg̃Zbg
	this->CurrentDirectory = ( DARC_DIRECTORY_VER5 * )this->DirP ;

	// C[WJĂAtO|
	MemoryOpenFlag = false ;

	// I
	return 0 ;

ERR :
	if( this->fp != NULL ){ fclose( this->fp ) ; this->fp = NULL ; }
	if( this->HeadBuffer != NULL ){ free( this->HeadBuffer ) ; this->HeadBuffer = NULL ; }
	
	// I
	return -1 ;
}

// A[JCut@C
int DXArchive_VER5::CloseArchiveFile( void )
{
	// ɕĂ牽I
	if( this->fp == NULL ) return 0 ;

	// JĂ邩ǂŏ𕪊
	if( MemoryOpenFlag == true )
	{
		// A[JCuNXǂݍ񂾏ꍇƂłȂꍇŏ𕪊
		if( UserMemoryImageFlag == true )
		{
			// ]f[^ɖ߂
			if( this->Head.Version >= 0x0005 )
			{
				DirectoryKeyConv( ( DARC_DIRECTORY_VER5 * )this->DirP ) ;
				KeyConv( this->HeadBuffer, this->Head.HeadSize, 0, this->Key ) ;
			}
			else
			{
				KeyConv( this->fp, this->MemoryImageSize, 0, this->Key ) ;
			}
		}
		else
		{
			// mۂĂJ
			free( this->fp ) ;
		}
	}
	else
	{
		// A[JCut@C
		fclose( this->fp ) ;
		
		// wb_obt@
		free( this->HeadBuffer ) ;
	}

	// |C^
	this->fp = NULL ;
	this->HeadBuffer = NULL ;
	this->NameP = this->DirP = this->FileP = NULL ;
	this->CurrentDirectory = NULL ;

	// I
	return 0 ;
}

// A[JCũfBNgpXύX( 0:  -1:s )
int	DXArchive_VER5::ChangeCurrentDirectoryFast( SEARCHDATA *SearchData )
{
	DARC_FILEHEAD_VER5 *FileH ;
	int i, j, k, Num ;
	u8 *NameData, *PathData ;
	u16 PackNum, Parity ;

	PackNum  = SearchData->PackNum ;
	Parity   = SearchData->Parity ;
	PathData = SearchData->FileName ;

	// JgfBNg瓯̃fBNgT
	FileH = ( DARC_FILEHEAD_VER5 * )( this->FileP + this->CurrentDirectory->FileHeadAddress ) ;
	Num = (s32)this->CurrentDirectory->FileHeadNum ;
	for( i = 0 ; i < Num ; i ++, FileH ++ )
	{
		// fBNg`FbN
		if( ( FileH->Attributes & FILE_ATTRIBUTE_DIRECTORY ) == 0 ) continue ;

		// 񐔂ƃpeB`FbN
		NameData = this->NameP + FileH->NameAddress ;
		if( PackNum != ((u16 *)NameData)[0] || Parity != ((u16 *)NameData)[1] ) continue ;

		// `FbN
		NameData += 4 ;
		for( j = 0, k = 0 ; j < PackNum ; j ++, k += 4 )
			if( *((u32 *)&PathData[k]) != *((u32 *)&NameData[k]) ) break ;

		// KfBNg炱ŏI
		if( PackNum == j ) break ;
	}

	// G[
	if( i == Num ) return -1 ;

	// ݂JgfBNgύX
	this->CurrentDirectory = ( DARC_DIRECTORY_VER5 * )( this->DirP + FileH->DataAddress ) ;

	// I
	return 0 ;
}

// A[JCũfBNgpXύX( 0:  -1:s )
int DXArchive_VER5::ChangeCurrentDir( const char *DirPath )
{
	return ChangeCurrentDirectoryBase( DirPath, true ) ;
}

// A[JCũfBNgpXύX( 0:  -1:s )
int	DXArchive_VER5::ChangeCurrentDirectoryBase( const char *DirectoryPath, bool ErrorIsDirectoryReset, SEARCHDATA *LastSearchData )
{
	DARC_DIRECTORY_VER5 *OldDir ;
	SEARCHDATA SearchData ;

	// ɗ܂pX疳
	if( strcmp( DirectoryPath, "." ) == 0 ) return 0 ;

	// w\x̏ꍇ̓[gfBNgɖ߂
	if( strcmp( DirectoryPath, "\\" ) == 0 )
	{
		this->CurrentDirectory = ( DARC_DIRECTORY_VER5 * )this->DirP ;
		return 0 ;
	}

	// ɈpX珈𕪊
	if( strcmp( DirectoryPath, ".." ) == 0 )
	{
		// [gfBNgɋG[
		if( this->CurrentDirectory->ParentDirectoryAddress == 0xffffffff ) return -1 ;
		
		// efBNg炻Ɉڂ
		this->CurrentDirectory = ( DARC_DIRECTORY_VER5 * )( this->DirP + this->CurrentDirectory->ParentDirectoryAddress ) ;
		return 0 ;
	}

	// ȊȌꍇ͎w̖ÕfBNgT
	
	// ύXȑÕfBNgۑĂ
	OldDir = this->CurrentDirectory ;

	// pXɁw\x邩ǂŏ𕪊
	if( strchr( DirectoryPath, '\\' ) == NULL )
	{
		// t@Cp̌`ɕϊ
		ConvSearchData( &SearchData, DirectoryPath, NULL ) ;

		// fBNgύX
		if( ChangeCurrentDirectoryFast( &SearchData ) < 0 ) goto ERR ;

/*		// \ ꍇ́ÃfBNgT
		FileH = ( DARC_FILEHEAD_VER5 * )( this->FileP + this->CurrentDirectory->FileHeadAddress ) ;
		for( i = 0 ;
			 i < (s32)this->CurrentDirectory->FileHeadNum &&
			 StrICmp( ( char * )( this->NameP + FileH->NameAddress ), DirectoryPath ) != 0 ;
			 i ++, FileH ++ ){}
*/
	}
	else
	{
		// \ ꍇ͌qfBNgÂύXĂ䂭
	
		int Point, StrLength ;

		Point = 0 ;
		// [v
		for(;;)
		{
			// 擾
			ConvSearchData( &SearchData, &DirectoryPath[Point], &StrLength ) ;
			Point += StrLength ;
/*			StrPoint = 0 ;
			while( DirectoryPath[Point] != '\0' && DirectoryPath[Point] != '\\' )
			{
				if( CheckMultiByteChar( &DirectoryPath[Point] ) == TRUE )
				{
					*((u16 *)&String[StrPoint]) = *((u16 *)&DirectoryPath[Point]) ;
					StrPoint += 2 ;
					Point    += 2 ;
				}
				else
				{
					String[StrPoint] = DirectoryPath[Point] ;
					StrPoint ++ ;
					Point    ++ ;
				}
			}
			String[StrPoint] = '\0' ;
*/
			// [ \ ꍇ̓[gfBNgɗƂ
			if( StrLength == 0 && DirectoryPath[Point] == '\\' )
			{
				this->ChangeCurrentDirectoryBase( "\\", false ) ;
			}
			else
			{
				// ȊȌꍇ͕ʂɃfBNgύX
				if( this->ChangeCurrentDirectoryFast( &SearchData ) < 0 )
				{
					// G[NāAXɃG[NɌ̃fBNgɖ߂
					// tOĂꍇ͌̃fBNgɖ߂
					if( ErrorIsDirectoryReset == true ) this->CurrentDirectory = OldDir ;

					// G[I
					goto ERR ;
				}
			}

			// I[ŏIꍇ̓[v甲
			// ͂ \ Ȃꍇ[v甲
			if( DirectoryPath[Point] == '\0' ||
				( DirectoryPath[Point] == '\\' && DirectoryPath[Point+1] == '\0' ) ) break ;
			Point ++ ;
		}
	}

	if( LastSearchData != NULL )
	{
		memcpy( LastSearchData->FileName, SearchData.FileName, SearchData.PackNum * 4 ) ;
		LastSearchData->Parity  = SearchData.Parity ;
		LastSearchData->PackNum = SearchData.PackNum ;
	}

	// I
	return 0 ;

ERR:
	if( LastSearchData != NULL )
	{
		memcpy( LastSearchData->FileName, SearchData.FileName, SearchData.PackNum * 4 ) ;
		LastSearchData->Parity  = SearchData.Parity ;
		LastSearchData->PackNum = SearchData.PackNum ;
	}

	// G[I
	return -1 ;
}
		
// A[JCũJgfBNgpX擾
int DXArchive_VER5::GetCurrentDir( char *DirPathBuffer, int BufferLength )
{
	char DirPath[MAX_PATH] ;
	DARC_DIRECTORY_VER5 *Dir[200], *DirTempP ;
	int Depth, i ;

	// [gfBNgɒ܂Ō
	Depth = 0 ;
	DirTempP = this->CurrentDirectory ;
	while( DirTempP->DirectoryAddress != 0xffffffff && DirTempP->DirectoryAddress != 0 )
	{
		Dir[Depth] = DirTempP ;
		DirTempP = ( DARC_DIRECTORY_VER5 * )( this->DirP + DirTempP->ParentDirectoryAddress ) ;
		Depth ++ ;
	}
	
	// pXA
	DirPath[0] = '\0' ;
	for( i = Depth - 1 ; i >= 0 ; i -- )
	{
		strcat( DirPath, "\\" ) ;
		strcat( DirPath, ( char * )( this->NameP + ( ( DARC_FILEHEAD_VER5 * )( this->FileP + Dir[i]->DirectoryAddress ) )->NameAddress ) ) ;
	}

	// obt@̒OAȂƂ̓fBNg̒Ԃ
	if( BufferLength == 0 || BufferLength < (s32)strlen( DirPath ) )
	{
		return strlen( DirPath ) + 1 ;
	}
	else
	{
		// fBNgobt@ɓ]
		strcpy( DirPathBuffer, DirPath ) ;
	}

	// I
	return 0 ;
}



// A[JCut@C̎w̃t@Cɓǂݍ
int DXArchive_VER5::LoadFileToMem( const char *FilePath, void *Buffer, unsigned int BufferLength )
{
	DARC_FILEHEAD_VER5 *FileH ;

	// w̃t@C̏𓾂
	FileH = this->GetFileInfo( FilePath ) ;
	if( FileH == NULL ) return -1 ;

	// t@CTCYĂ邩ׂAĂȂAobt@A̓TCYOTCYԂ
	if( BufferLength < FileH->DataSize || BufferLength == 0 || Buffer == NULL )
	{
		return ( int )FileH->DataSize ;
	}

	// Ăꍇ̓obt@[ɓǂݍ

	// t@CkĂ邩ǂŏ𕪊
	if( this->Head.Version >= 0x0002 && FileH->PressDataSize != 0xffffffff )
	{
		// kĂꍇ

		// ɓǂݍł邩ǂŏ𕪊
		if( MemoryOpenFlag == true )
		{
			// ̈kf[^𓀂
			Decode( (u8 *)this->fp + this->Head.DataStartAddress + FileH->DataAddress, Buffer ) ;
		}
		else
		{
			void *temp ;

			// kf[^ɓǂݍł𓀂

			// kf[^܂郁̈̊m
			temp = malloc( FileH->PressDataSize ) ;

			// kf[^̓ǂݍ
			fseek( this->fp, this->Head.DataStartAddress + FileH->DataAddress, SEEK_SET ) ;
			if( this->Head.Version >= 0x0005 )
			{
				KeyConvFileRead( temp, FileH->PressDataSize, this->fp, this->Key, FileH->DataSize ) ;
			}
			else
			{
				KeyConvFileRead( temp, FileH->PressDataSize, this->fp, this->Key ) ;
			}
			
			// 
			Decode( temp, Buffer ) ;
			
			// ̉
			free( temp ) ;
		}
	}
	else
	{
		// kĂȂꍇ

		// ɓǂݍł邩ǂŏ𕪊
		if( MemoryOpenFlag == true )
		{
			// Rs[
			memcpy( Buffer, (u8 *)this->fp + this->Head.DataStartAddress + FileH->DataAddress, FileH->DataSize ) ;
		}
		else
		{
			// t@C|C^ړ
			fseek( this->fp, this->Head.DataStartAddress + FileH->DataAddress, SEEK_SET ) ;

			// ǂݍ
			if( this->Head.Version >= 0x0005 )
			{
				KeyConvFileRead( Buffer, FileH->DataSize, this->fp, this->Key, FileH->DataSize ) ;
			}
			else
			{
				KeyConvFileRead( Buffer, FileH->DataSize, this->fp, this->Key ) ;
			}
		}
	}
	
	// I
	return 0 ;
}

// A[JCut@C̎w̃t@CTCY擾
int DXArchive_VER5::GetFileSize( const char *FilePath )
{
	// t@CTCYԂ
	return this->LoadFileToMem( FilePath, NULL, 0 ) ;
}

// A[JCut@Cɓǂݍ񂾏ꍇ̃t@CC[Wi[Ă擪AhX擾( JĂꍇ̂ݗL )
void *DXArchive_VER5::GetFileImage( void )
{
	// C[WJĂȂG[
	if( MemoryOpenFlag == false ) return NULL ;

	// 擪AhXԂ
	return this->fp ;
}

// A[JCut@C̎w̃t@C̃t@C̈ʒuƃt@C̑傫𓾂( -1:G[ )
int DXArchive_VER5::GetFileInfo( const char *FilePath, int *PositionP, int *SizeP )
{
	DARC_FILEHEAD_VER5 *FileH ;

	// w̃t@C̏𓾂
	FileH = this->GetFileInfo( FilePath ) ;
	if( FileH == NULL ) return -1 ;

	// t@C̃f[^ʒuƃt@CTCYۑ
	if( PositionP != NULL ) *PositionP = this->Head.DataStartAddress + FileH->DataAddress ;
	if( SizeP     != NULL ) *SizeP     = FileH->DataSize ;

	// I
	return 0 ;
}

// A[JCut@C̎w̃t@CANX̃obt@ɓǂݍ
void *DXArchive_VER5::LoadFileToCash( const char *FilePath )
{
	int FileSize ;

	// t@CTCY擾
	FileSize = this->GetFileSize( FilePath ) ;

	// t@CG[
	if( FileSize < 0 ) return NULL ;

	// mۂĂLbVobt@̃TCY傫ꍇ̓obt@Ċmۂ
	if( FileSize > ( int )this->CashBufferSize )
	{
		// LbVobt@̃NA
		this->ClearCash() ;

		// LbVobt@̍Ċm
		this->CashBuffer = malloc( FileSize ) ;

		// mۂɎsꍇ NULL Ԃ
		if( this->CashBuffer == NULL ) return NULL ;

		// LbVobt@̃TCYۑ
		this->CashBufferSize = FileSize ;
	}

	// t@Cɓǂݍ
	this->LoadFileToMem( FilePath, this->CashBuffer, FileSize ) ;

	// LbVobt@̃AhXԂ
	return this->CashBuffer ;
}

// LbVobt@J
int DXArchive_VER5::ClearCash( void )
{
	// mۂĂ
	if( this->CashBuffer != NULL )
	{
		free( this->CashBuffer ) ;
		this->CashBuffer = NULL ;
		this->CashBufferSize = 0 ;
	}

	// I
	return 0 ;
}

	
// A[JCut@C̎w̃t@CJAt@CANZXpIuWFNg쐬
DXArchiveFile_VER5 *DXArchive_VER5::OpenFile( const char *FilePath )
{
	DARC_FILEHEAD_VER5 *FileH ;
	DXArchiveFile_VER5 *CDArc = NULL ;

	// JĂꍇ͖
	if( MemoryOpenFlag == true ) return NULL ;

	// w̃t@C̏𓾂
	FileH = this->GetFileInfo( FilePath ) ;
	if( FileH == NULL ) return NULL ;

	// V DXArchiveFile_VER5 NX쐬
	CDArc = new DXArchiveFile_VER5( FileH, this ) ;
	
	// DXArchiveFile_VER5 NX̃|C^Ԃ
	return CDArc ;
}













// RXgN^
DXArchiveFile_VER5::DXArchiveFile_VER5( DARC_FILEHEAD_VER5 *FileHead, DXArchive_VER5 *Archive )
{
	this->FileData  = FileHead ;
	this->Archive   = Archive ;
	this->EOFFlag   = FALSE ;
	this->FilePoint = 0 ;
	this->DataBuffer = NULL ;
	
	// t@CkĂꍇ͂œǂݍŉ𓀂Ă܂
	if( this->Archive->GetHeader()->Version >= 0x0002 && FileHead->PressDataSize != 0xffffffff )
	{
		void *temp ;

		// kf[^܂郁̈̊m
		temp = malloc( FileHead->PressDataSize ) ;

		// 𓀃f[^܂郁̈̊m
		this->DataBuffer = malloc( FileHead->DataSize ) ;

		// kf[^̓ǂݍ
		fseek( this->Archive->GetFilePointer(), this->Archive->GetHeader()->DataStartAddress + FileHead->DataAddress, SEEK_SET ) ;
		if( this->Archive->GetHeader()->Version >= 0x0005 )
		{
			DXArchive_VER5::KeyConvFileRead( temp, FileHead->PressDataSize, this->Archive->GetFilePointer(), this->Archive->GetKey(), FileHead->DataSize ) ;
		}
		else
		{
			DXArchive_VER5::KeyConvFileRead( temp, FileHead->PressDataSize, this->Archive->GetFilePointer(), this->Archive->GetKey() ) ;
		}
		
		// 
		DXArchive_VER5::Decode( temp, this->DataBuffer ) ;
		
		// ̉
		free( temp ) ;
	}
}

// fXgN^
DXArchiveFile_VER5::~DXArchiveFile_VER5()
{
	// ̉
	if( this->DataBuffer != NULL )
	{
		free( this->DataBuffer ) ;
		this->DataBuffer = NULL ;
	}
}

// t@C̓eǂݍ
int DXArchiveFile_VER5::Read( void *Buffer, int ReadLength )
{
	int ReadSize ;

	// EOF tOĂOԂ
	if( this->EOFFlag == TRUE ) return 0 ;
	
	// A[JCut@C|C^ƁAzt@C|C^vĂ邩ׂ
	// vĂȂA[JCut@C|C^ړ
	if( this->DataBuffer == NULL && ftell( this->Archive->GetFilePointer() ) != (s32)( this->FileData->DataAddress + this->Archive->GetHeader()->DataStartAddress + this->FilePoint ) )
	{
		fseek( this->Archive->GetFilePointer(), this->FileData->DataAddress + this->Archive->GetHeader()->DataStartAddress + this->FilePoint, SEEK_SET ) ;
	}
	
	// EOF o
	if( this->FileData->DataSize == this->FilePoint )
	{
		this->EOFFlag = TRUE ;
		return 0 ;
	}
	
	// f[^ǂݍޗʂݒ肷
	ReadSize = ReadLength < (s32)( this->FileData->DataSize - this->FilePoint ) ? ReadLength : this->FileData->DataSize - this->FilePoint ;
	
	// f[^ǂݍ
	if( this->DataBuffer == NULL )
	{
		if( this->Archive->GetHeader()->Version >= 0x0005 )
		{
			DXArchive_VER5::KeyConvFileRead( Buffer, ReadSize, this->Archive->GetFilePointer(), this->Archive->GetKey(), this->FileData->DataSize + this->FilePoint ) ;
		}
		else
		{
			DXArchive_VER5::KeyConvFileRead( Buffer, ReadSize, this->Archive->GetFilePointer(), this->Archive->GetKey() ) ;
		}
	}
	else
	{
		memcpy( Buffer, (u8 *)this->DataBuffer + this->FilePoint, ReadSize ) ;
	}
	
	// EOF tO|
	this->EOFFlag = FALSE ;

	// ǂݍ񂾕t@C|C^ړ
	this->FilePoint += ReadSize ;
	
	// ǂݍ񂾗eʂԂ
	return ReadSize ;
}
	
// t@C|C^ύX
int DXArchiveFile_VER5::Seek( int SeekPoint, int SeekMode )
{
	// V[N^Cvɂď𕪊
	switch( SeekMode )
	{
	case SEEK_SET : break ;		
	case SEEK_CUR : SeekPoint += this->FilePoint ; break ;
	case SEEK_END :	SeekPoint = this->FileData->DataSize + SeekPoint ; break ;
	}
	
	// ␳
	if( SeekPoint > (s32)this->FileData->DataSize ) SeekPoint = this->FileData->DataSize ;
	if( SeekPoint < 0 ) SeekPoint = 0 ;
	
	// Zbg
	this->FilePoint = SeekPoint ;
	
	// EOFtO|
	this->EOFFlag = FALSE ;
	
	// I
	return 0 ;
}

// ݂̃t@C|C^𓾂
int DXArchiveFile_VER5::Tell( void )
{
	return this->FilePoint ;
}

// t@C̏I[ɗĂ邩ÃtO𓾂
int DXArchiveFile_VER5::Eof( void )
{
	return this->EOFFlag ;
}

// t@C̃TCY擾
int DXArchiveFile_VER5::Size( void )
{
	return this->FileData->DataSize ;
}



