// -------------------------------------------------------------------------------
// 
// 		cwCuA[JCo
// 
//	Creator			: Rc I
//	Creation Date	: 2003/09/11
//	Version			: 1.08
//
// -------------------------------------------------------------------------------

// dCN[hh~p`
#ifndef DX_ARCHIVE_H
#define DX_ARCHIVE_H

// include --------------------------------------
#include <stdio.h>

// define ---------------------------------------

// f[^^`
#ifndef u64
#define u64		unsigned __int64
#endif

#ifndef u32
#define u32		unsigned int
#endif

#ifndef u16
#define u16		unsigned short
#endif

#ifndef u8
#define u8		unsigned char
#endif

#ifndef s64
#define s64		signed __int64
#endif

#ifndef s32
#define s32		signed int
#endif

#ifndef s16
#define s16		signed short
#endif

#ifndef s8
#define s8		signed char
#endif

#ifndef f64
#define f64		double
#endif

#ifndef TRUE
#define TRUE	(1)
#endif

#ifndef FALSE
#define FALSE	(0)
#endif

#ifndef NULL
#define NULL	(0)
#endif

#define DXA_HEAD						*((u16 *)"DX")	// wb_
#define DXA_VER							(0x0008)		// o[W
#define DXA_VER_MIN						(0x0008)		// ΉĂŒo[W
#define DXA_BUFFERSIZE					(0x1000000)		// A[JCu쐬Ɏgpobt@̃TCY
#define DXA_KEY_BYTES					(7)				// ̃oCg
#define DXA_KEY_STRING_LENGTH			(63)			// p̒
#define DXA_KEY_STRING_MAXLENGTH		(2048)			// pobt@̃TCY

// tO
#define DXA_FLAG_NO_KEY					(0x00000001)	// 
#define DXA_FLAG_NO_HEAD_PRESS			(0x00000002)	// wb_̈k

/*
	o[WƂ̈Ⴂ

	0x0002 DARC_FILEHEAD  PressDataSize ǉ
	0x0004 DARC_HEAD  CharCodeFormat ǉ
	0x0005 ÍꕔύX
	0x0006 64bit
	0x0007 ÍύX( pX[hw肵ꍇ̉Ǔx )
	0x0008 Í̒56bitɕύX
*/

/*
	f[^}bv
		
	DARC_HEAD
	t@Cf[^
	t@Ce[u
	DARC_FILEHEAD e[u
	DARC_DIRECTORY e[u
*/

/*
	t@C̃f[^`
	2byte:̒(oCgTCYS)
	2byte:̃peBf[^(SĂ̒̕l𑫂)
	p͑啶ɕϊꂽt@C̃f[^(S̔{̃TCY)
	p啶ɕϊĂȂt@C̃f[^
*/

// struct ---------------------------------------

#pragma pack(push)
#pragma pack(1)

// A[JCuf[^̍ŏ̃wb_
typedef struct tagDARC_HEAD
{
	u16 Head ;								// wb_
	u16 Version ;							// o[W
	u32 HeadSize ;							// wb_ DARC_HEAD 𔲂STCY
	u64 DataStartAddress ;					// ŏ̃t@C̃f[^i[Ăf[^AhX(t@C̐擪AhXAhXOƂ)
	u64 FileNameTableStartAddress ;			// t@Ce[u̐擪AhX(t@C̐擪AhXAhXOƂ)
	u64 FileTableStartAddress ;				// t@Ce[u̐擪AhX(oϐ FileNameTableStartAddress ̃AhXOƂ)
	u64 DirectoryTableStartAddress ;		// fBNge[u̐擪AhX(oϐ FileNameTableStartAddress ̃AhXOƂ)
											// AhXOzuĂ DARC_DIRECTORY \̂[gfBNg
	u32 CharCodeFormat ;					// t@CɎgpĂR[hy[Wԍ
	u32 Flags ;								// tO( DXA_FLAG_NO_KEY  )
	u8  HuffmanEncodeKB ;					// t@C̑Õnt}kTCY( PʁFLoCg 0xff ̏ꍇׂ͂Ĉk )
	u8  Reserve[ 15 ] ;						// \̈
} DARC_HEAD ;

// t@C̎ԏ
typedef struct tagDARC_FILETIME
{
	u64 Create ;			// 쐬
	u64 LastAccess ;		// ŏIANZX
	u64 LastWrite ;			// ŏIXV
} DARC_FILETIME ;

// t@Ci[
typedef struct tagDARC_FILEHEAD
{
	u64 NameAddress ;			// t@Ci[ĂAhX( ARCHIVE_HEAD\ ̃oϐ FileNameTableStartAddress ̃AhXAhXOƂ) 

	u64 Attributes ;			// t@C
	DARC_FILETIME Time ;		// ԏ
	u64 DataAddress ;			// t@Ci[ĂAhX
								//			t@C̏ꍇFDARC_HEAD\ ̃oϐ DataStartAddress AhXAhXOƂ
								//			fBNg̏ꍇFDARC_HEAD\ ̃oϐ DirectoryTableStartAddress ̂AhXAhXOƂ
	u64 DataSize ;				// t@C̃f[^TCY
	u64 PressDataSize ;			// k̃f[^̃TCY( 0xffffffffffffffff:kĂȂ ) ( Ver0x0002 Œǉꂽ )
	u64 HuffPressDataSize ;		// nt}k̃f[^̃TCY( 0xffffffffffffffff:kĂȂ ) ( Ver0x0008 Œǉꂽ )
} DARC_FILEHEAD ;

// fBNgi[
typedef struct tagDARC_DIRECTORY
{
	u64 DirectoryAddress ;			//  DARC_FILEHEAD i[ĂAhX( DARC_HEAD \ ̃oϐ FileTableStartAddress AhXAhXOƂ)
	u64 ParentDirectoryAddress ;	// efBNg DARC_DIRECTORY i[ĂAhX( DARC_HEAD\ ̃oϐ DirectoryTableStartAddress AhXAhXOƂ)
	u64 FileHeadNum ;				// fBNg̃t@C̐
	u64 FileHeadAddress ;			// fBNg̃t@C̃wb_񂪊i[ĂAhX( DARC_HEAD\ ̃oϐ FileTableStartAddress AhXAhXOƂ) 
} DARC_DIRECTORY ;

#pragma pack(pop)

// GR[his󋵕ۑp
typedef struct tagDARC_ENCODEINFO
{
	int TotalFileNum ;				// t@C
	int CompFileNum ;				// t@C̐
	unsigned int PrevDispTime ;		// O󋵏o͂
	char ProcessFileName[ 2048 ] ;	// ݏĂt@C̖O
	bool OutputStatus ;				// 󋵏o͂sǂ
} DARC_ENCODEINFO ;

// class ----------------------------------------

// A[JCuNX
class DXArchive
{
public :
	// t̔r
	enum DATE_RESULT
	{
		DATE_RESULT_LEFTNEW = 0,		// V
		DATE_RESULT_RIGHTNEW,			// V
		DATE_RESULT_DRAW,				// t͓
	} ;

	DXArchive( char *ArchivePath = NULL ) ;
	~DXArchive() ;

	static int			EncodeArchive( char *OutputFileName, char **FileOrDirectoryPath, int FileNum, bool Press = false, bool AlwaysHuffman = false, u8 HuffmanEncodeKB = 0, const char *KeyString_ = NULL, bool NoKey = false, bool OutputStatus = true, bool MaxPress = false ) ;	// A[JCut@C쐬
	static int			EncodeArchiveOneDirectory( char *OutputFileName, char *FolderPath, bool Press = false, bool AlwaysHuffman = false, u8 HuffmanEncodeKB = 0, const char *KeyString_ = NULL, bool NoKey = false, bool OutputStatus = true, bool MaxPress = false ) ;		// A[JCut@C쐬(fBNg)
	static int			DecodeArchive( char *ArchiveName, char *OutputPath, const char *KeyString_ = NULL ) ;								// A[JCut@CWJ

	int					OpenArchiveFile( const char *ArchivePath, const char *KeyString_ = NULL ) ;				// A[JCut@CJ( 0:  -1:s )
	int					OpenArchiveFileMem( const char *ArchivePath, const char *KeyString_ = NULL ) ;			// A[JCut@CJŏɂׂăɓǂݍł珈( 0:  -1:s )
	int					OpenArchiveMem( void *ArchiveImage, s64 ArchiveSize, const char *KeyString_ = NULL ) ;	// ɂA[JCut@CC[WJ( 0:  -1:s )
	int					CloseArchiveFile( void ) ;																// A[JCut@C

	s64					LoadFileToMem( const char *FilePath, void *Buffer, u64 BufferLength ) ;		// A[JCut@C̎w̃t@Cɓǂݍ( -1:G[ 0ȏ:t@CTCY )
	s64					GetFileSize( const char *FilePath ) ;										// A[JCut@C̎w̃t@CTCY擾( -1:G[ )
	int					GetFileInfo( const char *FilePath, u64 *PositionP, u64 *SizeP ) ;			// A[JCut@C̎w̃t@C̃t@C̈ʒuƃt@C̑傫𓾂( -1:G[ )
	void				*GetFileImage( void ) ;														// A[JCut@Cɓǂݍ񂾏ꍇ̃t@CC[Wi[Ă擪AhX擾( JĂꍇ̂ݗLAkĂꍇ́AkꂽԂ̃f[^i[Ă̂Œ )
	class DXArchiveFile *OpenFile( const char *FilePath ) ;											// A[JCut@C̎w̃t@CJAt@CANZXpIuWFNg쐬( t@CJĂꍇ̂ݗL )

	void *				LoadFileToCache( const char *FilePath ) ;									// A[JCut@C̎w̃t@CANX̃LbVobt@ɓǂݍ
	int					ClearCache( void ) ;															// LbVobt@J

	int					ChangeCurrentDir( const char *DirPath ) ;									// A[JCũfBNgpXύX( 0:  -1:s )
	int					GetCurrentDir( char *DirPathBuffer, int BufferLength ) ;					// A[JCũJgfBNgpX擾



	// ȉ͊ƓŎgp
	static void fwrite64( void *Data, s64 Size, FILE *fp ) ;													// WXg[Ƀf[^( 64bit )
	static void fread64( void *Buffer, s64 Size, FILE *fp ) ;													// WXg[f[^ǂݍ( 64bit )
	static void NotConv( void *Data , s64 Size ) ;																// f[^𔽓]֐
	static void NotConvFileWrite( void *Data, s64 Size, FILE *fp ) ;											// f[^𔽓]ăt@Cɏo֐
	static void NotConvFileRead( void *Data, s64 Size, FILE *fp ) ;												// f[^𔽓]ăt@Cǂݍފ֐
	static size_t CreateKeyFileString( int CharCodeFormat, const char *KeyString, size_t KeyStringBytes, DARC_DIRECTORY *Directory, DARC_FILEHEAD *FileHead, u8 *FileTable, u8 *DirectoryTable, u8 *NameTable, u8 *FileString ) ;	// JgfBNgɂw̃t@Čp̕쐬A߂l͕̒( PʁFByte )( FileString  DXA_KEY_STRING_MAXLENGTH ̒Kv )
	static void KeyCreate( const char *Source, size_t SourceBytes, u8 *Key ) ;									// 쐬
	static void KeyConv( void *Data, s64 Size, s64 Position, unsigned char *Key ) ;								// gp Xor Z( Key ͕K DXA_KEY_BYTES ̒Ȃ΂ȂȂ )
	static void KeyConvFileWrite( void *Data, s64 Size, FILE *fp, unsigned char *Key, s64 Position = -1 ) ;		// f[^gp Xor Zt@Cɏo֐( Key ͕K DXA_KEY_BYTES ̒Ȃ΂ȂȂ )
	static void KeyConvFileRead( void *Data, s64 Size, FILE *fp, unsigned char *Key, s64 Position = -1 ) ;		// t@Cǂݍ񂾃f[^gp Xor Z֐( Key ͕K DXA_KEY_BYTES ̒Ȃ΂ȂȂ )
	static DATE_RESULT DateCmp( DARC_FILETIME *date1, DARC_FILETIME *date2 ) ;									// ǂ炪Vr
	static int Encode( void *Src, u32 SrcSize, void *Dest, bool OutStatus = true, bool MaxPress = false ) ;		// f[^k( ߂l:k̃f[^TCY )
	static int Decode( void *Src, void *Dest ) ;																// f[^𓀂( ߂l:𓀌̃f[^TCY )
	static u32 HashCRC32( const void *SrcData, size_t SrcDataSize ) ;											// oCif[^ CRC32 ̃nbVlvZ

	DARC_DIRECTORY *GetCurrentDirectoryInfo( void ) ;															// A[JCũJgfBNg̏擾
	DARC_FILEHEAD *GetFileInfo( const char *FilePath, DARC_DIRECTORY **DirectoryP = NULL ) ;					// t@C̏𓾂
	inline DARC_HEAD *GetHeader( void ){ return &Head ; }
	inline u8 *GetKey( void ){ return Key ; }
	inline bool GetNoKey( void ){ return NoKey ; }
	inline char *GetKeyString( void ){ return KeyString ; }
	inline size_t GetKeyStringBytes( void ){ return KeyStringBytes ; }
	inline FILE *GetFilePointer( void ){ return fp ; }
	inline u8 *GetNameP( void ){ return NameP ; }
	inline u8 *GetFileHeadTable( void ){ return FileP ; }
	inline u8 *GetDirectoryTable( void ){ return DirP ; }
	inline u8 *GetNameTable( void ){ return NameP ; }

protected :
	FILE *fp ;							// A[JCut@C̃|C^	
	u8 *HeadBuffer ;					// wb_[obt@[
	u8 *FileP, *DirP, *NameP ;			// ee[u(t@Cwb_e[uAfBNge[uAOe[u)ւ̃|C^
	DARC_DIRECTORY *CurrentDirectory ;	// JgfBNgf[^ւ̃|C^

	void *CacheBuffer ;					// ǂݍ񂾃t@Cf[^ꎞIɕۑĂobt@
	u64 CacheBufferSize ;				// LbVobt@ɊmۂĂ郁e
	bool MemoryOpenFlag ;				// ̃t@CJĂ邩AtO
	bool UserMemoryImageFlag ;			// [U[WJC[WgpĂ邩AtO
	s64 MemoryImageSize ;				// ̃t@CJĂꍇ̃C[W̃TCY
	bool NoKey ;						// sȂǂ
	u8 Key[ DXA_KEY_BYTES ] ;			// 
	char KeyString[ DXA_KEY_STRING_LENGTH + 1 ] ;	// 
	size_t KeyStringBytes ;				// ̃oCg

	DARC_HEAD Head ;					// A[JCũwb_

	// TCYۑp\
	typedef struct tagSIZESAVE
	{
		u64 DataSize ;			// f[^̑
		u64 NameSize ;			// t@Cf[^̑
		u64 DirectorySize ;		// fBNgf[^̑
		u64 FileSize ;			// t@CvpeBf[^̑
	} SIZESAVE ;

	// t@Cpf[^\
	typedef struct tagSEARCHDATA
	{
		u8 FileName[1024] ;
		u16 Parity ;
		u16 PackNum ;
	} SEARCHDATA ;

	static int DirectoryEncode( int CharCodeFormat, char *DirectoryName, u8 *NameP, u8 *DirP, u8 *FileP, DARC_DIRECTORY *ParentDir, SIZESAVE *Size, int DataNumber, FILE *DestFp, void *TempBuffer, bool Press, bool MaxPress, bool AlwaysHuffman, u8 HuffmanEncodeKB, const char *KeyString, size_t KeyStringBytes, bool NoKey, char *KeyStringBuffer, DARC_ENCODEINFO *EncodeInfo ) ;	// w̃fBNgɂt@CA[JCuf[^ɓfo
	static int DirectoryDecode( u8 *NameP, u8 *DirP, u8 *FileP, DARC_HEAD *Head, DARC_DIRECTORY *Dir, FILE *ArcP, unsigned char *Key, const char *KeyString, size_t KeyStringBytes, bool NoKey, char *KeyStringBuffer ) ;											// w̃fBNgf[^ɂt@CWJ
	static int StrICmp( const char *Str1, const char *Str2 ) ;							// rΏƂ̕񒆂̑啶ƂĈr( 0:  1:Ⴄ )
	static int ConvSearchData( SEARCHDATA *Dest, const char *Src, int *Length ) ;		// p̃f[^ɕϊ( k \ I )
	static int AddFileNameData( int CharCodeFormat, const char *FileName, u8 *FileNameTable ) ;				// t@Cf[^ǉ( ߂l͎gpf[^oCg )
	static const char *GetOriginalFileName( u8 *FileNameTable ) ;						// t@Cf[^猳̃t@C̕擾
	static int GetDirectoryFilePath( const char *DirectoryPath, char *FilePathBuffer = NULL ) ;	// fBNg̃t@C̃pX擾( FilePathBuffer ͈t@Cɕt256oCg̗eʂKv )
	static void EncodeStatusErase( void ) ;														// GR[h̐is󋵂\
	static void EncodeStatusOutput( DARC_ENCODEINFO *EncodeInfo, bool Always = false ) ;		// GR[h̐is󋵂\
	static void AnalyseHuffmanEncode( u64 DataSize, u8 HuffmanEncodeKB, u64 *HeadDataSize, u64 *FootDataSize ) ;	// nt}kÕTCY擾
	int	ChangeCurrentDirectoryFast( SEARCHDATA *SearchData ) ;							// A[JCũfBNgpXύX( 0:  -1:s )
	int	ChangeCurrentDirectoryBase( const char *DirectoryPath, bool ErrorIsDirectoryReset, SEARCHDATA *LastSearchData = NULL ) ;		// A[JCũfBNgpXύX( 0:  -1:s )
	int DirectoryKeyConv( DARC_DIRECTORY *Dir, char *KeyStringBuffer ) ;										// w̃fBNgf[^̈Í( ۂƃɓǂݍ񂾏ꍇp )

	// QoCgׂ( TRUE:QoCg FALSE:PoCg )
	inline static int CheckMultiByteChar( const char *Buf )
	{
		return  ( (unsigned char)*Buf >= 0x81 && (unsigned char)*Buf <= 0x9F ) || ( (unsigned char)*Buf >= 0xE0 && (unsigned char)*Buf <= 0xFC ) ;
	}

	// t@CꏏɂȂĂƕĂpXt@CpXƃfBNgpX𕪊
	// tpXłKv͖
	static int GetFilePathAndDirPath( char *Src, char *FilePath, char *DirPath ) ;
} ;


// A[JCuꂽt@C̃ANZXp̃NX
class DXArchiveFile
{
protected :
	DARC_FILEHEAD *FileData ;		// t@Cf[^ւ̃|C^
	DXArchive *Archive ;			// A[JCuNXւ̃|C^
	void *DataBuffer ;				// Ƀf[^WJۂ̃obt@̃|C^

	u8 Key[ DXA_KEY_BYTES ] ;		// 

	int EOFFlag ;					// EOFtO
	u64 FilePoint ;					// t@C|C^

public :
	DXArchiveFile( DARC_FILEHEAD *FileHead, DARC_DIRECTORY *Directory, DXArchive *Archive ) ;
	~DXArchiveFile() ;

	s64 Read( void *Buffer, s64 ReadLength ) ;					// t@C̓eǂݍ
	s64 Seek( s64 SeekPoint, s64 SeekMode ) ;					// t@C|C^ύX
	s64 Tell( void ) ;											// ݂̃t@C|C^𓾂
	s64 Eof( void ) ;											// t@C̏I[ɗĂ邩ÃtO𓾂
	s64 Size( void ) ;											// t@C̃TCY擾

	inline DARC_FILEHEAD *GetFileData( void ){ return FileData ; }
} ;

#endif

