// -------------------------------------------------------------------------------
// 
// 		cwCuA[JCo
// 
//	Creator			: Rc I
//	Creation Date	: 2003/09/11
//	Version			: 1.02
// 
// -------------------------------------------------------------------------------

#define INLINE_ASM

// include ----------------------------
#include "DXArchive.h"
#include "CharCode.h"
#include "Huffman.h"
#include "FileLib.h"
#include <stdio.h>
#include <windows.h>
#include <string.h>

// define -----------------------------

#define MIN_COMPRESS		(4)						// ŒሳkoCg
#define MAX_SEARCHLISTNUM	(64)					// ővTׂ̃XgHő吔
#define MAX_SUBLISTNUM		(65536)					// kԒZk̂߂̃TuXg̍ő吔
#define MAX_COPYSIZE 		(0x1fff + MIN_COMPRESS)	// QƃAhXRs[o؂őTCY( kR[h\łRs[TCY̍ől + ŒሳkoCg )
#define MAX_ADDRESSLISTNUM	(1024 * 1024 * 1)		// XCh̍őTCY
#define MAX_POSITION		(1 << 24)				// QƉ\ȍő告΃AhX( 16MB )

// struct -----------------------------

// kԒZkpXg
typedef struct LZ_LIST
{
	LZ_LIST *next, *prev ;
	u32 address ;
} LZ_LIST ;

// data -------------------------------

// ftHg
static char DefaultKeyString[ 9 ] = { 0x44, 0x58, 0x42, 0x44, 0x58, 0x41, 0x52, 0x43, 0x00 }; // "DXLIBARC"

// O̒
int LogStringLength = 0 ;

// class code -------------------------

// t@CꏏɂȂĂƕĂpXt@CpXƃfBNgpX𕪊
// tpXłKv͖
int DXArchive::GetFilePathAndDirPath( char *Src, char *FilePath, char *DirPath )
{
	int i, Last ;
	
	// t@C𔲂o
	i = 0 ;
	Last = -1 ;
	while( Src[i] != '\0' )
	{
		if( CheckMultiByteChar( &Src[i] ) == FALSE )
		{
			if( Src[i] == '\\' || Src[i] == '/' || Src[i] == '\0' || Src[i] == ':' ) Last = i ;
			i ++ ;
		}
		else
		{
			i += 2 ;
		}
	}
	if( FilePath != NULL )
	{
		if( Last != -1 ) strcpy( FilePath, &Src[Last+1] ) ;
		else strcpy( FilePath, Src ) ;
	}
	
	// fBNgpX𔲂o
	if( DirPath != NULL )
	{
		if( Last != -1 )
		{
			strncpy( DirPath, Src, Last ) ;
			DirPath[Last] = '\0' ;
		}
		else
		{
			DirPath[0] = '\0' ;
		}
	}
	
	// I
	return 0 ;
}

// t@C̏𓾂
DARC_FILEHEAD *DXArchive::GetFileInfo( const char *FilePath, DARC_DIRECTORY **DirectoryP )
{
	DARC_DIRECTORY *OldDir ;
	DARC_FILEHEAD *FileH ;
	u8 *NameData ;
	int i, j, k, Num, FileHeadSize ;
	SEARCHDATA SearchData ;

	// ̃fBNgۑĂ
	OldDir = this->CurrentDirectory ;

	// t@CpX \ ܂܂ĂꍇAfBNgύXs
	if( strchr( FilePath, '\\' ) != NULL )
	{
		// JgfBNgړĨt@CfBNgɕύX
		if( this->ChangeCurrentDirectoryBase( FilePath, false, &SearchData ) >= 0 )
		{
			// G[NȂꍇ̓t@CfBNgƂɂȂ̂ŃG[
			goto ERR ;
		}
	}
	else
	{
		// t@Cpf[^ɕϊ
		ConvSearchData( &SearchData, FilePath, NULL ) ;
	}

	// ̃t@CT
	FileHeadSize = sizeof( DARC_FILEHEAD ) ;
	FileH = ( DARC_FILEHEAD * )( this->FileP + this->CurrentDirectory->FileHeadAddress ) ;
	Num = ( int )this->CurrentDirectory->FileHeadNum ;
	for( i = 0 ; i < Num ; i ++, FileH = (DARC_FILEHEAD *)( (u8 *)FileH + FileHeadSize ) )
	{
		// fBNg`FbN
		if( ( FileH->Attributes & FILE_ATTRIBUTE_DIRECTORY ) != 0 ) continue ;

		// 񐔂ƃpeB`FbN
		NameData = this->NameP + FileH->NameAddress ;
		if( SearchData.PackNum != ((u16 *)NameData)[0] || SearchData.Parity != ((u16 *)NameData)[1] ) continue ;

		// `FbN
		NameData += 4 ;
		for( j = 0, k = 0 ; j < SearchData.PackNum ; j ++, k += 4 )
			if( *((u32 *)&SearchData.FileName[k]) != *((u32 *)&NameData[k]) ) break ;

		// Kt@C炱ŏI
		if( SearchData.PackNum == j ) break ;
	}

	// G[
	if( i == Num ) goto ERR ;

	// fBNg̃AhXۑw肪ꍇ͕ۑ
	if( DirectoryP != NULL )
	{
		*DirectoryP = this->CurrentDirectory ;
	}
	
	// fBNgɖ߂
	this->CurrentDirectory = OldDir ;
	
	// ړĨt@C̃AhXԂ
	return FileH ;
	
ERR :
	// fBNgɖ߂
	this->CurrentDirectory = OldDir ;
	
	// G[I
	return NULL ;
}

// A[JCũJgfBNg̏擾
DARC_DIRECTORY *DXArchive::GetCurrentDirectoryInfo( void )
{
	return CurrentDirectory ;
}

// ǂ炪Vr
DXArchive::DATE_RESULT DXArchive::DateCmp( DARC_FILETIME *date1, DARC_FILETIME *date2 )
{
	if( date1->LastWrite == date2->LastWrite ) return DATE_RESULT_DRAW ;
	else if( date1->LastWrite > date2->LastWrite ) return DATE_RESULT_LEFTNEW ;
	else return DATE_RESULT_RIGHTNEW ;
}

// rΏƂ̕񒆂̑啶ƂĈr( 0:  1:Ⴄ )
int DXArchive::StrICmp( const char *Str1, const char *Str2 )
{
	int c1, c2 ;
	
	while( *Str1 != '\0' && *Str2 != '\0' )
	{
		if( CheckMultiByteChar( Str1 ) == FALSE )
		{
			c1 = ( *Str1 >= 'A' && *Str1 <= 'Z' ) ? *Str1 - 'A' + 'a' : *Str1 ;
			c2 = ( *Str2 >= 'A' && *Str2 <= 'Z' ) ? *Str2 - 'A' + 'a' : *Str2 ;
			if( c1 != c2 ) return 1 ;
			Str1 ++ ;
			Str2 ++ ;
		}
		else
		{
			if( *( (unsigned short *)Str1 ) != *( (unsigned short *)Str2 ) ) return 1 ;
			Str1 += 2 ;
			Str2 += 2 ;
		}
	}
	if( *Str1 != '\0' || *Str2 != '\0' ) return 1 ;

	// ܂ŗď߂ē
	return 0 ;
}

// 񒆂̉p̏啶ɕϊ
int DXArchive::ConvSearchData( SEARCHDATA *SearchData, const char *Src, int *Length )
{
	int i, StringLength ;
	u16 ParityData ;

	ParityData = 0 ;
	for( i = 0 ; Src[i] != '\0' && Src[i] != '\\' ; )
	{
		if( CheckMultiByteChar( &Src[i] ) == TRUE )
		{
			// QoCg̏ꍇ͂̂܂܃Rs[
			*((u16 *)&SearchData->FileName[i]) = *((u16 *)&Src[i]) ;
			ParityData += (u8)Src[i] + (u8)Src[i+1] ;
			i += 2 ;
		}
		else
		{
			// ̏ꍇ͑啶ɕϊ
			if( Src[i] >= 'a' && Src[i] <= 'z' )	SearchData->FileName[i] = (u8)Src[i] - 'a' + 'A' ;
			else									SearchData->FileName[i] = Src[i] ;
			ParityData += (u8)SearchData->FileName[i] ;
			i ++ ;
		}
	}

	// ̒ۑ
	if( Length != NULL ) *Length = i ;

	// S̔{̈ʒu܂łO
	StringLength = ( ( i + 1 ) + 3 ) / 4 * 4 ;
	memset( &SearchData->FileName[i], 0, StringLength - i ) ;

	// peBf[^̕ۑ
	SearchData->Parity = ParityData ;

	// pbNf[^̕ۑ
	SearchData->PackNum = StringLength / 4 ;

	// I
	return 0 ;
}

// t@Cf[^ǉ( ߂l͎gpf[^oCg )
int DXArchive::AddFileNameData( int CharCodeFormat, const char *FileName, u8 *FileNameTable )
{
	int PackNum, Length, i, j ;
	u32 Parity ;

	// TCYZbg
	Length = ( int )CL_strlen( CharCodeFormat, FileName ) * GetCharCodeFormatUnitSize( CharCodeFormat ) ;

	// ꕶꍇ̏
	if( Length == 0 )
	{
		// pbNƃpeB̂ݕۑ
		*((u32 *)&FileNameTable[0]) = 0 ;

		// gpTCYԂ
		return 4 ;
	}
	Length ++ ;

	PackNum = ( Length + 3 ) / 4 ;

	// pbNۑ
	*((u16 *)&FileNameTable[0]) = PackNum ;

	// obt@̏
	memset( &FileNameTable[4], 0, PackNum * 4 * 2 ) ;

	// Rs[
	CL_strcpy( CharCodeFormat, (char *)&FileNameTable[4 + PackNum * 4], FileName ) ;

	// p̏Sđ啶ɕϊt@Cۑ
	Parity = 0 ;
	for( i = 0 ; FileName[i] != '\0' ; )
	{
		int Bytes = GetCharBytes( &FileName[i], CharCodeFormat ) ;

		// 1oCgǂŏ𕪊
		if( Bytes == 1 )
		{
			// PoCg
			if( FileName[i] >= 'a' && FileName[i] <= 'z' )
			{
				// ̏ꍇ͑啶ɕϊ
				FileNameTable[4 + i] = (u8)FileName[i] - 'a' + 'A' ;
			}
			else
			{
				// ł͂Ȃꍇ͕ʂɃRs[
				FileNameTable[4 + i] = (u8)FileName[i] ;
			}
			Parity += FileNameTable[4 + i] ;
			i ++ ;
		}
		else
		{
			// }`oCg
			for( j = 0 ; j < Bytes ; j ++ )
			{
				FileNameTable[4 + i + j] = (u8)FileName[i + j] ;
				Parity += (u8)FileName[i + j] ;
			}
			i += Bytes ;
		}
	}

	// peBۑ
	*((u16 *)&FileNameTable[2]) = (u16)Parity ;

	// gpTCYԂ
	return PackNum * 4 * 2 + 4 ;
}

// t@Cf[^猳̃t@C̕擾
const char *DXArchive::GetOriginalFileName( u8 *FileNameTable )
{
	return (char *)FileNameTable + *((u16 *)&FileNameTable[0]) * 4 + 4 ;
}

// WXg[Ƀf[^( 64bit )
void DXArchive::fwrite64( void *Data, s64 Size, FILE *fp )
{
	int WriteSize ;
	s64 TotalWriteSize ;

	TotalWriteSize = 0 ;
	while( TotalWriteSize < Size )
	{
		if( Size > 0x7fffffff )
		{
			WriteSize = 0x7fffffff ;
		}
		else
		{
			WriteSize = ( int )Size ;
		}

		fwrite( ( u8 * )Data + TotalWriteSize, 1, WriteSize, fp ) ;

		TotalWriteSize += WriteSize ;
	}
}

// WXg[f[^ǂݍ( 64bit )
void DXArchive::fread64( void *Buffer, s64 Size, FILE *fp )
{
	int ReadSize ;
	s64 TotalReadSize ;

	TotalReadSize = 0 ;
	while( TotalReadSize < Size )
	{
		if( Size > 0x7fffffff )
		{
			ReadSize = 0x7fffffff ;
		}
		else
		{
			ReadSize = ( int )Size ;
		}

		fread( ( u8 * )Buffer + TotalReadSize, 1, ReadSize, fp ) ;

		TotalReadSize += ReadSize ;
	}
}

// f[^𔽓]֐
void DXArchive::NotConv( void *Data , s64 Size )
{
	s64 DwordNumQ ;
	s64 ByteNum ;
	u32 *dd ;

	dd = ( u32 * )Data ;

	DwordNumQ = Size / 4 ;
	ByteNum = Size - DwordNumQ * 4 ;

	if( DwordNumQ != 0 )
	{
		if( DwordNumQ < 0x100000000 )
		{
			u32 DwordNum ;

			DwordNum = ( u32 )DwordNumQ ;
			do
			{
				*dd++ = ~*dd ;
			}while( --DwordNum ) ;
		}
		else
		{
			do
			{
				*dd++ = ~*dd ;
			}while( --DwordNumQ ) ;
		}
	}
	if( ByteNum != 0 )
	{
		do
		{
			*((BYTE *)dd) = ~*((u8 *)dd) ;
			dd = (u32 *)(((u8 *)dd) + 1) ;
		}while( --ByteNum ) ;
	}
}


// f[^𔽓]ăt@Cɏo֐
void DXArchive::NotConvFileWrite( void *Data, s64 Size, FILE *fp )
{
	// f[^𔽓]
	NotConv( Data, Size ) ;

	// o
	fwrite64( Data, Size, fp ) ;

	// Ăє]
	NotConv( Data, Size ) ;
}

// f[^𔽓]ăt@Cǂݍފ֐
void DXArchive::NotConvFileRead( void *Data, s64 Size, FILE *fp )
{
	// ǂݍ
	fread64( Data, Size, fp ) ;

	// f[^𔽓]
	NotConv( Data, Size ) ;
}

// JgfBNgɂw̃t@Čp̕쐬A߂l͕̒( PʁFByte )( FileString  DXA_KEY_STRING_MAXLENGTH ̒Kv )
size_t DXArchive::CreateKeyFileString( int CharCodeFormat, const char *KeyString, size_t KeyStringBytes, DARC_DIRECTORY *Directory, DARC_FILEHEAD *FileHead, u8 *FileTable, u8 *DirectoryTable, u8 *NameTable, u8 *FileString )
{
	size_t StartAddr ;

	// ŏɃpX[h̕Zbg
	if( KeyString != NULL && KeyStringBytes != 0 )
	{
		memcpy( FileString, KeyString, KeyStringBytes ) ;
		FileString[ KeyStringBytes ] = '\0' ;
		StartAddr = KeyStringBytes ;
	}
	else
	{
		FileString[ 0 ] = '\0' ;
		StartAddr = 0 ;
	}
	memset( &FileString[ DXA_KEY_STRING_MAXLENGTH - 8 ], 0, 8 ) ;

	// Ƀt@C̕Zbg
	CL_strcat_s( CharCodeFormat, ( char * )&FileString[ StartAddr ], ( DXA_KEY_STRING_MAXLENGTH - 8 ) - StartAddr, ( char * )( NameTable + FileHead->NameAddress + 4 ) ) ;

	// ̌ɃfBNg̕Zbg
	if( Directory->ParentDirectoryAddress != 0xffffffffffffffff )
	{
		do
		{
			CL_strcat_s( CharCodeFormat, ( char * )&FileString[ StartAddr ], ( DXA_KEY_STRING_MAXLENGTH - 8 ) - StartAddr, ( char * )( NameTable + ( ( DARC_FILEHEAD * )( FileTable + Directory->DirectoryAddress ) )->NameAddress + 4 ) ) ;
			Directory = ( DARC_DIRECTORY * )( DirectoryTable + Directory->ParentDirectoryAddress ) ;
		}while( Directory->ParentDirectoryAddress != 0xffffffffffffffff ) ;
	}

	return StartAddr + CL_strlen( CharCodeFormat, ( char * )&FileString[ StartAddr ] ) * GetCharCodeFormatUnitSize( CharCodeFormat ) ;
}

// 쐬
void DXArchive::KeyCreate( const char *Source, size_t SourceBytes, u8 *Key )
{
	char SourceTempBuffer[ 1024 ] ;
	char WorkBuffer[ 1024 ] ;
	char *UseWorkBuffer ;
	u32 i, j ;
	u32 CRC32_0 ;
	u32 CRC32_1 ;

	if( SourceBytes == 0 )
	{
		SourceBytes = CL_strlen( CHARCODEFORMAT_ASCII, Source ) ;
	}

	if( SourceBytes < 4 )
	{
		CL_strcpy( CHARCODEFORMAT_ASCII, SourceTempBuffer, Source ) ;
		CL_strcpy( CHARCODEFORMAT_ASCII, &SourceTempBuffer[ SourceBytes ], DefaultKeyString ) ;
		Source = SourceTempBuffer ;
		SourceBytes = CL_strlen( CHARCODEFORMAT_ASCII, Source ) ;
	}

	if( SourceBytes > sizeof( WorkBuffer ) )
	{
		UseWorkBuffer = ( char * )malloc( SourceBytes ) ;
	}
	else
	{
		UseWorkBuffer = WorkBuffer ;
	}

	j = 0 ;
	for( i = 0 ; i < SourceBytes ; i += 2, j++ )
	{
		UseWorkBuffer[ j ] = Source[ i ] ;
	}
	CRC32_0 = HashCRC32( UseWorkBuffer, j ) ;

	j = 0 ;
	for( i = 1 ; i < SourceBytes ; i += 2, j++ )
	{
		UseWorkBuffer[ j ] = Source[ i ] ;
	}
	CRC32_1 = HashCRC32( UseWorkBuffer, j ) ;

	Key[ 0 ] = ( u8 )( CRC32_0 >>  0 ) ;
	Key[ 1 ] = ( u8 )( CRC32_0 >>  8 ) ;
	Key[ 2 ] = ( u8 )( CRC32_0 >> 16 ) ;
	Key[ 3 ] = ( u8 )( CRC32_0 >> 24 ) ;
	Key[ 4 ] = ( u8 )( CRC32_1 >>  0 ) ;
	Key[ 5 ] = ( u8 )( CRC32_1 >>  8 ) ;
	Key[ 6 ] = ( u8 )( CRC32_1 >> 16 ) ;

	if( SourceBytes > sizeof( WorkBuffer ) )
	{
		free( UseWorkBuffer ) ;
	}
}

// gp Xor Z( Key ͕K DXA_KEY_BYTES ̒Ȃ΂ȂȂ )
void DXArchive::KeyConv( void *Data, s64 Size, s64 Position, unsigned char *Key )
{
	if( Key == NULL )
	{
		return ;
	}

	Position %= DXA_KEY_BYTES ;

	if( Size < 0x100000000 )
	{
		u32 i, j ;

		j = ( u32 )Position ;
		for( i = 0 ; i < Size ; i ++ )
		{
			((u8 *)Data)[i] ^= Key[j] ;

			j ++ ;
			if( j == DXA_KEY_BYTES ) j = 0 ;
		}
	}
	else
	{
		s64 i, j ;

		j = Position ;
		for( i = 0 ; i < Size ; i ++ )
		{
			((u8 *)Data)[i] ^= Key[j] ;

			j ++ ;
			if( j == DXA_KEY_BYTES ) j = 0 ;
		}
	}
}

// f[^gp Xor Zt@Cɏo֐( Key ͕K DXA_KEY_BYTES ̒Ȃ΂ȂȂ )
void DXArchive::KeyConvFileWrite( void *Data, s64 Size, FILE *fp, unsigned char *Key, s64 Position )
{
	s64 pos = 0 ;

	if( Key != NULL )
	{
		// t@C̈ʒu擾Ă
		pos = Position == -1 ? _ftelli64( fp ) : Position ;

		// f[^g Xor Z
		KeyConv( Data, Size, pos, Key ) ;
	}

	// o
	fwrite64( Data, Size, fp ) ;

	if( Key != NULL )
	{
		// Ă Xor Z
		KeyConv( Data, Size, pos, Key ) ;
	}
}

// t@Cǂݍ񂾃f[^gp Xor Z֐( Key ͕K DXA_KEY_BYTES ̒Ȃ΂ȂȂ )
void DXArchive::KeyConvFileRead( void *Data, s64 Size, FILE *fp, unsigned char *Key, s64 Position )
{
	s64 pos = 0 ;

	if( Key != NULL )
	{
		// t@C̈ʒu擾Ă
		pos = Position == -1 ? _ftelli64( fp ) : Position ;
	}

	// ǂݍ
	fread64( Data, Size, fp ) ;

	if( Key != NULL )
	{
		// f[^g Xor Z
		KeyConv( Data, Size, pos, Key ) ;
	}
}

// w̃fBNgɂt@CA[JCuf[^ɓfo
int DXArchive::DirectoryEncode( int CharCodeFormat, char *DirectoryName, u8 *NameP, u8 *DirP, u8 *FileP, DARC_DIRECTORY *ParentDir, SIZESAVE *Size, int DataNumber, FILE *DestFp, void *TempBuffer, bool Press, bool MaxPress, bool AlwaysHuffman, u8 HuffmanEncodeKB, const char *KeyString, size_t KeyStringBytes, bool NoKey, char *KeyStringBuffer, DARC_ENCODEINFO *EncodeInfo )
{
	char DirPath[MAX_PATH] ;
	WIN32_FIND_DATAA FindData ;
	HANDLE FindHandle ;
	DARC_DIRECTORY Dir ;
	DARC_DIRECTORY *DirectoryP ;
	DARC_FILEHEAD File ;
	u8 lKey[DXA_KEY_BYTES] ;
	size_t KeyStringBufferBytes ;

	// fBNg̏𓾂
	FindHandle = FindFirstFileA( DirectoryName, &FindData ) ;
	if( FindHandle == INVALID_HANDLE_VALUE ) return 0 ;
	
	// fBNgi[t@Cwb_Zbg
	{
		File.NameAddress       = Size->NameSize ;
		File.Time.Create       = ( ( ( LONGLONG )FindData.ftCreationTime.dwHighDateTime ) << 32 ) + FindData.ftCreationTime.dwLowDateTime ;
		File.Time.LastAccess   = ( ( ( LONGLONG )FindData.ftLastAccessTime.dwHighDateTime ) << 32 ) + FindData.ftLastAccessTime.dwLowDateTime ;
		File.Time.LastWrite    = ( ( ( LONGLONG )FindData.ftLastWriteTime.dwHighDateTime ) << 32 ) + FindData.ftLastWriteTime.dwLowDateTime ;
		File.Attributes        = FindData.dwFileAttributes ;
		File.DataAddress       = Size->DirectorySize ;
		File.DataSize          = 0 ;
		File.PressDataSize	   = 0xffffffffffffffff ;
		File.HuffPressDataSize = 0xffffffffffffffff ;
	}

	// fBNgo
	Size->NameSize += AddFileNameData( CharCodeFormat, FindData.cFileName, NameP + Size->NameSize ) ;

	// fBNg񂪓t@Cwb_o
	memcpy( FileP + ParentDir->FileHeadAddress + DataNumber * sizeof( DARC_FILEHEAD ),
			&File, sizeof( DARC_FILEHEAD ) ) ;

	// Find nh
	FindClose( FindHandle ) ;

	// w̃fBNgɃJgfBNgڂ
	GetCurrentDirectoryA( MAX_PATH, DirPath ) ;
	SetCurrentDirectoryA( DirectoryName ) ;

	// fBNg̃Zbg
	{
		Dir.DirectoryAddress = ParentDir->FileHeadAddress + DataNumber * sizeof( DARC_FILEHEAD ) ;
		Dir.FileHeadAddress  = Size->FileSize ;

		// efBNg̏ʒuZbg
		if( ParentDir->DirectoryAddress != 0xffffffffffffffff && ParentDir->DirectoryAddress != 0 )
		{
			Dir.ParentDirectoryAddress = ((DARC_FILEHEAD *)( FileP + ParentDir->DirectoryAddress ))->DataAddress ;
		}
		else
		{
			Dir.ParentDirectoryAddress = 0 ;
		}

		// fBNg̃t@C̐擾
		Dir.FileHeadNum = GetDirectoryFilePath( "", NULL ) ;
	}

	// fBNg̏o͂
	memcpy( DirP + Size->DirectorySize, &Dir, sizeof( DARC_DIRECTORY ) ) ;	
	DirectoryP = ( DARC_DIRECTORY * )( DirP + Size->DirectorySize ) ;

	// AhX𐄈ڂ
	Size->DirectorySize += sizeof( DARC_DIRECTORY ) ;
	Size->FileSize      += sizeof( DARC_FILEHEAD ) * Dir.FileHeadNum ;
	
	// t@Cꍇ͂ŏI
	if( Dir.FileHeadNum == 0 )
	{
		// Ƃ̃fBNgJgfBNgɃZbg
		SetCurrentDirectoryA( DirPath ) ;
		return 0 ;
	}

	// t@Co͂
	{
		int i ;
		
		i = 0 ;
		
		// 񋓊Jn
		FindHandle = FindFirstFileA( "*", &FindData ) ;
		do
		{
			// ̃fBNgɖ߂肷邽߂̃pX͖
			if( strcmp( FindData.cFileName, "." ) == 0 || strcmp( FindData.cFileName, ".." ) == 0 ) continue ;

			// t@Cł͂ȂAfBNgꍇ͍ċA
			if( FindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY )
			{
				// fBNgꍇ̏
				if( DirectoryEncode( CharCodeFormat, FindData.cFileName, NameP, DirP, FileP, &Dir, Size, i, DestFp, TempBuffer, Press, MaxPress, AlwaysHuffman, HuffmanEncodeKB, KeyString, KeyStringBytes, NoKey, KeyStringBuffer, EncodeInfo ) < 0 ) return -1 ;
			}
			else
			{
				// t@Cꍇ̏

				// t@C̃f[^Zbg
				File.NameAddress       = Size->NameSize ;
				File.Time.Create       = ( ( ( LONGLONG )FindData.ftCreationTime.dwHighDateTime   ) << 32 ) + FindData.ftCreationTime.dwLowDateTime   ;
				File.Time.LastAccess   = ( ( ( LONGLONG )FindData.ftLastAccessTime.dwHighDateTime ) << 32 ) + FindData.ftLastAccessTime.dwLowDateTime ;
				File.Time.LastWrite    = ( ( ( LONGLONG )FindData.ftLastWriteTime.dwHighDateTime  ) << 32 ) + FindData.ftLastWriteTime.dwLowDateTime  ;
				File.Attributes        = FindData.dwFileAttributes ;
				File.DataAddress       = Size->DataSize ;
				File.DataSize          = ( ( ( LONGLONG )FindData.nFileSizeHigh ) << 32 ) + FindData.nFileSizeLow ;
				File.PressDataSize     = 0xffffffffffffffff ;
				File.HuffPressDataSize = 0xffffffffffffffff ;

				// is󋵏o
				if( EncodeInfo->OutputStatus )
				{
					// t@CZbg
					strcpy( EncodeInfo->ProcessFileName, FindData.cFileName ) ;

					// t@C𑝂₷
					EncodeInfo->CompFileNum ++ ;

					// \
					EncodeStatusOutput( EncodeInfo ) ;
				}

				// t@Co
				Size->NameSize += AddFileNameData( CharCodeFormat, FindData.cFileName, NameP + Size->NameSize ) ;

				// t@Cʂ̌쐬
				if( NoKey == false )
				{
					KeyStringBufferBytes = CreateKeyFileString( CharCodeFormat, KeyString, KeyStringBytes, DirectoryP, &File, FileP, DirP, NameP, ( BYTE * )KeyStringBuffer ) ;
					KeyCreate( KeyStringBuffer, KeyStringBufferBytes, lKey ) ;
				}
				
				// t@Cf[^o
				if( File.DataSize != 0 )
				{
					FILE *SrcP ;
					u64 FileSize, WriteSize, MoveSize ;
					bool Huffman = false ;
					bool AlwaysPress = false ;

					// t@CJ
					SrcP = fopen( FindData.cFileName, "rb" ) ;
					
					// TCY𓾂
					_fseeki64( SrcP, 0, SEEK_END ) ;
					FileSize = _ftelli64( SrcP ) ;
					_fseeki64( SrcP, 0, SEEK_SET ) ;

					// k̑ΏۂƂȂt@CtH[}bgׂ
					{
						u32 Len ;
						Len = ( u32 )strlen( FindData.cFileName ) ;
						if( Len > 4 )
						{
							char *sp ;
						
							sp = &FindData.cFileName[Len-3] ;
							if( StrICmp( sp, "wav" ) == 0 ||
								StrICmp( sp, "jpg" ) == 0 ||
								StrICmp( sp, "png" ) == 0 ||
								StrICmp( sp, "mpg" ) == 0 ||
								StrICmp( sp, "mp3" ) == 0 ||
								StrICmp( sp, "mp4" ) == 0 ||
								StrICmp( sp, "m4a" ) == 0 ||
								StrICmp( sp, "ogg" ) == 0 ||
								StrICmp( sp, "ogv" ) == 0 ||
								StrICmp( sp, "ops" ) == 0 ||
								StrICmp( sp, "wmv" ) == 0 ||
								StrICmp( sp, "tif" ) == 0 ||
								StrICmp( sp, "tga" ) == 0 ||
								StrICmp( sp, "bmp" ) == 0 ||
								StrICmp( sp - 1, "jpeg" ) == 0 )
							{
								Huffman = true ;
							}

							// wav  bmp ̏ꍇ͕Kk
							if( StrICmp( sp, "wav" ) == 0 ||
								StrICmp( sp, "tga" ) == 0 ||
								StrICmp( sp, "bmp" ) == 0 )
							{
								AlwaysPress = true ;
							}
						}
					}

					// AlwaysHuffman  true ̏ꍇ͕Knt}k
					if( AlwaysHuffman )
					{
						Huffman = true ;
					}

					// nt}kTCY 0 ̏ꍇ̓nt}ksȂ
					if( HuffmanEncodeKB == 0 )
					{
						Huffman = false ;
					}
					
					// k̎w肪ꍇŁA
					// Kkt@CtH[}bgAt@CTCY 10MB ȉ̏ꍇ͈k݂
					if( Press == true && ( AlwaysPress || File.DataSize < 10 * 1024 * 1024 ) )
					{
						void *SrcBuf, *DestBuf ;
						u32 DestSize, Len ;
						
						// ꕔ̃t@C`̏ꍇ͗\ߒe
						if( AlwaysPress == false && ( Len = ( int )strlen( FindData.cFileName ) ) > 4 )
						{
							char *sp ;
							
							sp = &FindData.cFileName[Len-3] ;
							if( StrICmp( sp, "wav" ) == 0 ||
								StrICmp( sp, "jpg" ) == 0 ||
								StrICmp( sp, "png" ) == 0 ||
								StrICmp( sp, "mpg" ) == 0 ||
								StrICmp( sp, "mp3" ) == 0 ||
								StrICmp( sp, "mp4" ) == 0 ||
								StrICmp( sp, "ogg" ) == 0 ||
								StrICmp( sp, "ogv" ) == 0 ||
								StrICmp( sp, "ops" ) == 0 ||
								StrICmp( sp, "wmv" ) == 0 ||
								StrICmp( sp - 1, "jpeg" ) == 0 ) goto NOPRESS ;
						}
						
						// f[^ۂƓ郁̈̊m
						SrcBuf  = malloc( ( size_t )( FileSize + FileSize * 2 + 64 ) ) ;
						DestBuf = (u8 *)SrcBuf + FileSize ;
						
						// t@CۂƓǂݍ
						fread64( SrcBuf, FileSize, SrcP ) ;
						
						// kꍇ͋Iɐis󋵏o͂XV
						if( EncodeInfo->OutputStatus )
						{
							EncodeStatusOutput( EncodeInfo, true ) ;
						}

						// k
						DestSize = Encode( SrcBuf, ( u32 )FileSize, DestBuf, EncodeInfo->OutputStatus, MaxPress ) ;
						
						// wǈkoȂꍇ͈kŃA[JCu
						if( AlwaysPress == false && ( (f64)DestSize / (f64)FileSize > 0.90 ) )
						{
							_fseeki64( SrcP, 0L, SEEK_SET ) ;
							free( SrcBuf ) ;
							goto NOPRESS ;
						}

						// kf[^̃TCYۑ
						File.PressDataSize = DestSize ;
						
						// nt}ksǂŏ𕪊
						if( Huffman )
						{
							u8 *HuffData ;

							// nt}kTCYɂď𕪊
							if( HuffmanEncodeKB == 0xff || DestSize <= ( u64 )( HuffmanEncodeKB * 1024 * 2 ) )
							{
								// nt}kp̃̈m
								HuffData = ( u8 * )calloc( 1, DestSize * 2 + 256 * 2 + 32 ) ;

								// t@CŜnt}k
								File.HuffPressDataSize = Huffman_Encode( DestBuf, DestSize, HuffData ) ;

								// kf[^ɌKpďo
								WriteSize = ( File.HuffPressDataSize + 3 ) / 4 * 4 ;	// TCY͂S̔{ɍ킹
								KeyConvFileWrite( HuffData, WriteSize, DestFp, NoKey ? NULL : lKey, File.DataSize ) ;
							}
							else
							{
								// nt}kp̃̈m
								HuffData = ( u8 * )calloc( 1, HuffmanEncodeKB * 1024 * 2 * 4 + 256 * 2 + 32 ) ;

								// t@C̑Ont}k
								memcpy( HuffData,                                  DestBuf,                                     HuffmanEncodeKB * 1024 ) ;
								memcpy( HuffData + HuffmanEncodeKB * 1024, ( u8 * )DestBuf + DestSize - HuffmanEncodeKB * 1024, HuffmanEncodeKB * 1024 ) ;
								File.HuffPressDataSize = Huffman_Encode( HuffData, HuffmanEncodeKB * 1024 * 2, HuffData + HuffmanEncodeKB * 1024 * 2 ) ;

								// nt}ko
								KeyConvFileWrite( HuffData + HuffmanEncodeKB * 1024 * 2, File.HuffPressDataSize, DestFp, NoKey ? NULL : lKey, File.DataSize ) ;

								// nt}kĂȂӏo
								WriteSize = File.HuffPressDataSize + DestSize - HuffmanEncodeKB * 1024 * 2 ;
								WriteSize = ( WriteSize + 3 ) / 4 * 4 ;	// TCY͂S̔{ɍ킹
								KeyConvFileWrite( ( u8 * )DestBuf + HuffmanEncodeKB * 1024, WriteSize - File.HuffPressDataSize, DestFp, NoKey ? NULL : lKey, File.DataSize + File.HuffPressDataSize ) ;
							}

							// ̉
							free( HuffData ) ;
						}
						else
						{
							// kf[^𔽓]ďo
							WriteSize = ( DestSize + 3 ) / 4 * 4 ;
							KeyConvFileWrite( DestBuf, WriteSize, DestFp, NoKey ? NULL : lKey, File.DataSize ) ;
						}
						
						// ̉
						free( SrcBuf ) ;
					}
					else
					{
NOPRESS:					
						// nt}ksǂŏ𕪊
						if( Press && Huffman )
						{
							u8 *SrcBuf, *HuffData ;

							// f[^ۂƓ郁̈̊m
							SrcBuf = ( u8 * )calloc( 1, ( size_t )( FileSize + 32 ) ) ;

							// t@CۂƓǂݍ
							fread64( SrcBuf, FileSize, SrcP ) ;
						
							// nt}kTCYɂď𕪊
							if( HuffmanEncodeKB == 0xff || FileSize <= HuffmanEncodeKB * 1024 * 2 )
							{
								// nt}kp̃̈m
								HuffData = ( u8 * )calloc( 1, ( size_t )( FileSize * 2 + 256 * 2 + 32 ) ) ;

								// t@CŜnt}k
								File.HuffPressDataSize = Huffman_Encode( SrcBuf, FileSize, HuffData ) ;

								// kf[^ɌKpďo
								WriteSize = ( File.HuffPressDataSize + 3 ) / 4 * 4 ;	// TCY͂S̔{ɍ킹
								KeyConvFileWrite( HuffData, WriteSize, DestFp, NoKey ? NULL : lKey, File.DataSize ) ;
							}
							else
							{
								// nt}kp̃̈m
								HuffData = ( u8 * )calloc( 1, HuffmanEncodeKB * 1024 * 2 * 4 + 256 * 2 + 32 ) ;

								// t@C̑Ont}k
								memcpy( HuffData,                          SrcBuf,                                     HuffmanEncodeKB * 1024 ) ;
								memcpy( HuffData + HuffmanEncodeKB * 1024, SrcBuf + FileSize - HuffmanEncodeKB * 1024, HuffmanEncodeKB * 1024 ) ;
								File.HuffPressDataSize = Huffman_Encode( HuffData, HuffmanEncodeKB * 1024 * 2, HuffData + HuffmanEncodeKB * 1024 * 2 ) ;

								// nt}ko
								KeyConvFileWrite( HuffData + HuffmanEncodeKB * 1024 * 2, File.HuffPressDataSize, DestFp, NoKey ? NULL : lKey, File.DataSize ) ;
								
								// nt}kĂȂӏo
								WriteSize = File.HuffPressDataSize + FileSize - HuffmanEncodeKB * 1024 * 2 ;
								WriteSize = ( WriteSize + 3 ) / 4 * 4 ;	// TCY͂S̔{ɍ킹
								KeyConvFileWrite( SrcBuf + HuffmanEncodeKB * 1024, WriteSize - File.HuffPressDataSize, DestFp, NoKey ? NULL : lKey, File.DataSize + File.HuffPressDataSize ) ;
							}

							// ̉
							free( SrcBuf ) ;
							free( HuffData ) ;
						}
						else
						{
							// ]Jn
							WriteSize = 0 ;
							while( WriteSize < FileSize )
							{
								// ]TCY
								MoveSize = DXA_BUFFERSIZE < FileSize - WriteSize ? DXA_BUFFERSIZE : FileSize - WriteSize ;
								MoveSize = ( MoveSize + 3 ) / 4 * 4 ;	// TCY͂S̔{ɍ킹
							
								// t@ČKpǂݍ
								memset( TempBuffer, 0, ( size_t )MoveSize ) ;
								KeyConvFileRead( TempBuffer, MoveSize, SrcP, NoKey ? NULL : lKey, File.DataSize + WriteSize ) ;

								// o
								fwrite64( TempBuffer, MoveSize, DestFp ) ;
							
								// oTCỶZ
								WriteSize += MoveSize ;
							}
						}
					}
					
					// ot@C
					fclose( SrcP ) ;
				
					// f[^TCỶZ
					Size->DataSize += WriteSize ;
				}
				
				// t@Cwb_o
				memcpy( FileP + Dir.FileHeadAddress + sizeof( DARC_FILEHEAD ) * i, &File, sizeof( DARC_FILEHEAD ) ) ;
			}
			
			i ++ ;
		}
		while( FindNextFileA( FindHandle, &FindData ) != 0 ) ;
		
		// Find nh
		FindClose( FindHandle ) ;
	}
						
	// Ƃ̃fBNgJgfBNgɃZbg
	SetCurrentDirectoryA( DirPath ) ;

	// I
	return 0 ;
}

// w̃fBNgf[^ɂt@CWJ
int DXArchive::DirectoryDecode( u8 *NameP, u8 *DirP, u8 *FileP, DARC_HEAD *Head, DARC_DIRECTORY *Dir, FILE *ArcP, unsigned char *Key, const char *KeyString, size_t KeyStringBytes, bool NoKey, char *KeyStringBuffer )
{
	char DirPath[MAX_PATH] ;
	
	// ݂̃JgfBNgۑ
	GetCurrentDirectoryA( MAX_PATH, DirPath ) ;

	// fBNg񂪂ꍇ́A܂WJp̃fBNg쐬
	if( Dir->DirectoryAddress != 0xffffffffffffffff && Dir->ParentDirectoryAddress != 0xffffffffffffffff )
	{
		DARC_FILEHEAD *DirFile ;
		
		// DARC_FILEHEAD ̃AhX擾
		DirFile = ( DARC_FILEHEAD * )( FileP + Dir->DirectoryAddress ) ;
		
		// fBNg̍쐬
		CreateDirectoryA( GetOriginalFileName( NameP + DirFile->NameAddress ), NULL ) ;
		
		// ̃fBNgɃJgfBNgڂ
		SetCurrentDirectoryA( GetOriginalFileName( NameP + DirFile->NameAddress ) ) ;
	}

	// WJJn
	{
		u32 i, FileHeadSize ;
		DARC_FILEHEAD *File ;
		size_t KeyStringBufferBytes ;
		unsigned char lKey[ DXA_KEY_BYTES ] ;

		// i[Ăt@C̐JԂ
		FileHeadSize = sizeof( DARC_FILEHEAD ) ;
		File = ( DARC_FILEHEAD * )( FileP + Dir->FileHeadAddress ) ;
		for( i = 0 ; i < Dir->FileHeadNum ; i ++, File = (DARC_FILEHEAD *)( (u8 *)File + FileHeadSize ) )
		{
			// fBNgǂŏ𕪊
			if( File->Attributes & FILE_ATTRIBUTE_DIRECTORY )
			{
				// fBNg̏ꍇ͍ċA
				DirectoryDecode( NameP, DirP, FileP, Head, ( DARC_DIRECTORY * )( DirP + File->DataAddress ), ArcP, Key, KeyString, KeyStringBytes, NoKey, KeyStringBuffer ) ;
			}
			else
			{
				FILE *DestP ;
				void *Buffer ;
			
				// t@C̏ꍇ͓WJ
				
				// obt@mۂ
				Buffer = malloc( DXA_BUFFERSIZE ) ;
				if( Buffer == NULL ) return -1 ;

				// t@CJ
				DestP = fopen( GetOriginalFileName( NameP + File->NameAddress ), "wb" ) ;

				// t@Cʂ̌쐬
				if( NoKey == false )
				{
					KeyStringBufferBytes = CreateKeyFileString( ( int )Head->CharCodeFormat, KeyString, KeyStringBytes, Dir, File, FileP, DirP, NameP, ( BYTE * )KeyStringBuffer ) ;
					KeyCreate( KeyStringBuffer, KeyStringBufferBytes, lKey ) ;
				}

				// f[^ꍇ̂ݓ]
				if( File->DataSize != 0 )
				{
					void *temp ;

					// ʒuZbg
					if( _ftelli64( ArcP ) != ( s32 )( Head->DataStartAddress + File->DataAddress ) )
						_fseeki64( ArcP, Head->DataStartAddress + File->DataAddress, SEEK_SET ) ;
						
					// f[^kĂ邩ǂŏ𕪊
					if( File->PressDataSize != 0xffffffffffffffff )
					{
						// kĂꍇ

						// nt}kĂ邩ǂŏ𕪊
						if( File->HuffPressDataSize != 0xffffffffffffffff )
						{
							// kf[^܂郁̈̊m
							temp = malloc( ( size_t )( File->PressDataSize + File->HuffPressDataSize + File->DataSize ) ) ;

							// kf[^̓ǂݍ
							KeyConvFileRead( temp, File->HuffPressDataSize, ArcP, NoKey ? NULL : lKey, File->DataSize ) ;

							// nt}k
							Huffman_Decode( temp, (u8 *)temp + File->HuffPressDataSize ) ;

							// t@C̑Ont}kĂꍇ͏𕪊
							if( Head->HuffmanEncodeKB != 0xff && File->PressDataSize > Head->HuffmanEncodeKB * 1024 * 2 )
							{
								// 𓀂f[^̓A딼ړ
								memmove( 
									( u8 * )temp + File->HuffPressDataSize + File->PressDataSize - Head->HuffmanEncodeKB * 1024,
									( u8 * )temp + File->HuffPressDataSize + Head->HuffmanEncodeKB * 1024,
									Head->HuffmanEncodeKB * 1024 ) ;

								// cLZkf[^ǂݍ
								KeyConvFileRead(
									( u8 * )temp + File->HuffPressDataSize + Head->HuffmanEncodeKB * 1024,
									File->PressDataSize - Head->HuffmanEncodeKB * 1024 * 2,
									ArcP, NoKey ? NULL : lKey, File->DataSize + File->HuffPressDataSize ) ;
							}
						
							// 
							Decode( (u8 *)temp + File->HuffPressDataSize, (u8 *)temp + File->HuffPressDataSize + File->PressDataSize ) ;
						
							// o
							fwrite64( (u8 *)temp + File->HuffPressDataSize + File->PressDataSize, File->DataSize, DestP ) ;
						
							// ̉
							free( temp ) ;
						}
						else
						{
							// kf[^܂郁̈̊m
							temp = malloc( ( size_t )( File->PressDataSize + File->DataSize ) ) ;

							// kf[^̓ǂݍ
							KeyConvFileRead( temp, File->PressDataSize, ArcP, NoKey ? NULL : lKey, File->DataSize ) ;
						
							// 
							Decode( temp, (u8 *)temp + File->PressDataSize ) ;
						
							// o
							fwrite64( (u8 *)temp + File->PressDataSize, File->DataSize, DestP ) ;
						
							// ̉
							free( temp ) ;
						}
					}
					else
					{
						// kĂȂꍇ
					
						// nt}k͂Ă邩ǂŏ𕪊
						if( File->HuffPressDataSize != 0xffffffffffffffff )
						{
							// kf[^܂郁̈̊m
							temp = malloc( ( size_t )( File->HuffPressDataSize + File->DataSize ) ) ;

							// kf[^̓ǂݍ
							KeyConvFileRead( temp, File->HuffPressDataSize, ArcP, NoKey ? NULL : lKey, File->DataSize ) ;

							// nt}k
							Huffman_Decode( temp, (u8 *)temp + File->HuffPressDataSize ) ;

							// t@C̑Ô݃nt}kĂꍇ͏𕪊
							if( Head->HuffmanEncodeKB != 0xff && File->DataSize > Head->HuffmanEncodeKB * 1024 * 2 )
							{
								// 𓀂f[^̓A딼ړ
								memmove( 
									( u8 * )temp + File->HuffPressDataSize + File->DataSize - Head->HuffmanEncodeKB * 1024,
									( u8 * )temp + File->HuffPressDataSize + Head->HuffmanEncodeKB * 1024,
									Head->HuffmanEncodeKB * 1024 ) ;

								// c̃f[^ǂݍ
								KeyConvFileRead(
									( u8 * )temp + File->HuffPressDataSize + Head->HuffmanEncodeKB * 1024,
									File->DataSize - Head->HuffmanEncodeKB * 1024 * 2,
									ArcP, NoKey ? NULL : lKey, File->DataSize + File->HuffPressDataSize ) ;
							}
						
							// o
							fwrite64( (u8 *)temp + File->HuffPressDataSize, File->DataSize, DestP ) ;
						
							// ̉
							free( temp ) ;
						}
						else
						{
							u64 MoveSize, WriteSize ;
							
							// ]Jn
							WriteSize = 0 ;
							while( WriteSize < File->DataSize )
							{
								MoveSize = File->DataSize - WriteSize > DXA_BUFFERSIZE ? DXA_BUFFERSIZE : File->DataSize - WriteSize ;

								// t@C̔]ǂݍ
								KeyConvFileRead( Buffer, MoveSize, ArcP, NoKey ? NULL : lKey, File->DataSize + WriteSize ) ;

								// o
								fwrite64( Buffer, MoveSize, DestP ) ;
								
								WriteSize += MoveSize ;
							}
						}
					}
				}
				
				// t@C
				fclose( DestP ) ;

				// obt@J
				free( Buffer ) ;

				// t@C̃^CX^vݒ肷
				{
					HANDLE HFile ;
					FILETIME CreateTime, LastAccessTime, LastWriteTime ;

					HFile = CreateFileA( GetOriginalFileName( NameP + File->NameAddress ),
										GENERIC_WRITE, 0, NULL,
										OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL ) ;
					if( HFile == INVALID_HANDLE_VALUE )
					{
						HFile = HFile ;
					}

					CreateTime.dwHighDateTime     = ( u32 )( File->Time.Create     >> 32        ) ;
					CreateTime.dwLowDateTime      = ( u32 )( File->Time.Create     & 0xffffffffffffffff ) ;
					LastAccessTime.dwHighDateTime = ( u32 )( File->Time.LastAccess >> 32        ) ;
					LastAccessTime.dwLowDateTime  = ( u32 )( File->Time.LastAccess & 0xffffffffffffffff ) ;
					LastWriteTime.dwHighDateTime  = ( u32 )( File->Time.LastWrite  >> 32        ) ;
					LastWriteTime.dwLowDateTime   = ( u32 )( File->Time.LastWrite  & 0xffffffffffffffff ) ;
					SetFileTime( HFile, &CreateTime, &LastAccessTime, &LastWriteTime ) ;
					CloseHandle( HFile ) ;
				}

				// t@Ct
				SetFileAttributesA( GetOriginalFileName( NameP + File->NameAddress ), ( u32 )File->Attributes ) ;
			}
		}
	}
	
	// JgfBNgɖ߂
	SetCurrentDirectoryA( DirPath ) ;

	// I
	return 0 ;
}

// fBNg̃t@CpX擾
int DXArchive::GetDirectoryFilePath( const char *DirectoryPath, char *FileNameBuffer )
{
	WIN32_FIND_DATAA FindData ;
	HANDLE FindHandle ;
	int FileNum ;
	char DirPath[256], String[256] ;

	// fBNgǂ`FbN
	if( DirectoryPath[0] != '\0' )
	{
		FindHandle = FindFirstFileA( DirectoryPath, &FindData ) ;
		if( FindHandle == INVALID_HANDLE_VALUE || ( FindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY ) == 0 ) return -1 ;
		FindClose( FindHandle ) ;
	}

	// w̃tH_̃t@C̖O擾
	FileNum = 0 ;
	if( DirectoryPath[0] != '\0' )
	{
		strcpy( DirPath, DirectoryPath ) ;
		if( DirPath[ strlen( DirPath ) - 1 ] != '\\' ) strcat( DirPath, "\\" ) ;
		strcpy( String, DirPath ) ;
		strcat( String, "*" ) ;
	}
	else
	{
		strcpy( DirPath, "" ) ;
		strcpy( String, "*" ) ;
	}
	FindHandle = FindFirstFileA( String, &FindData ) ;
	if( FindHandle != INVALID_HANDLE_VALUE )
	{
		do
		{
			// ̃fBNgɖ߂肷邽߂̃pX͖
			if( strcmp( FindData.cFileName, "." ) == 0 || strcmp( FindData.cFileName, ".." ) == 0 ) continue ;

			// t@CpXۑ
			if( FileNameBuffer != NULL )
			{
				strcpy( FileNameBuffer, DirPath ) ;
				strcat( FileNameBuffer, FindData.cFileName ) ;
				FileNameBuffer += 256 ;
			}

			// t@C̐𑝂₷
			FileNum ++ ;
		}
		while( FindNextFileA( FindHandle, &FindData ) != 0 ) ;
		FindClose( FindHandle ) ;
	}

	// Ԃ
	return FileNum ;
}

// GR[h̐is󋵂\
void DXArchive::EncodeStatusErase( void )
{
	static char StringBuffer[ 8192 ] ;

	if( LogStringLength > 0 )
	{
		int i ;
		int p = 0 ;
		for( i = 0 ; i < LogStringLength ; i ++ )
		{
			StringBuffer[ p ] = '\b' ;
			p ++ ;
		}
		for( i = 0 ; i < LogStringLength ; i ++ )
		{
			StringBuffer[ p ] = ' ' ;
			p ++ ;
		}
		for( i = 0 ; i < LogStringLength ; i ++ )
		{
			StringBuffer[ p ] = '\b' ;
			p ++ ;
		}
		StringBuffer[ p ] = '\0' ;
		printf( StringBuffer ) ;
	}
}

// GR[h̐is󋵂\
void DXArchive::EncodeStatusOutput( DARC_ENCODEINFO *EncodeInfo, bool Always )
{
	static char StringBuffer[ 8192 ] ;
	static char FileNameBuffer[ 2048 ] ;
	int FileNameLength ;
	unsigned int NowTime = GetTickCount() ;

	// O񂩂16msȏ㎞Ԃo߂Ă\
	if( Always == false && NowTime - EncodeInfo->PrevDispTime < 16 )
	{
		return ;
	}

	// O̕\e
	EncodeStatusErase() ;

	EncodeInfo->PrevDispTime = NowTime ;
	strcpy( FileNameBuffer, EncodeInfo->ProcessFileName ) ;
	FileNameLength = strlen( EncodeInfo->ProcessFileName ) ;
	if( FileNameLength > 50 )
	{
		strncpy( FileNameBuffer, EncodeInfo->ProcessFileName, 50 ) ;
		strcpy( &FileNameBuffer[ 50 ], "..." ) ;
	}
	sprintf( StringBuffer, " [%d/%d] %d%%%%  %s", EncodeInfo->CompFileNum, EncodeInfo->TotalFileNum, EncodeInfo->CompFileNum * 100 / EncodeInfo->TotalFileNum, FileNameBuffer ) ;
	LogStringLength = strlen( StringBuffer ) ;
	printf( StringBuffer ) ;
}

// nt}kÕTCY擾
void DXArchive::AnalyseHuffmanEncode( u64 DataSize, u8 HuffmanEncodeKB, u64 *HeadDataSize, u64 *FootDataSize )
{
	if( HuffmanEncodeKB == 0xff || DataSize < HuffmanEncodeKB * 1024 * 2 )
	{
		*HeadDataSize = DataSize ;
		*FootDataSize = 0 ;
	}
	else
	{
		*HeadDataSize = HuffmanEncodeKB * 1024 ;
		*FootDataSize = HuffmanEncodeKB * 1024 ;
	}
}

// GR[h( ߂l:k̃TCY  -1 ̓G[  Dest  NULL 邱Ƃ\ )
int DXArchive::Encode( void *Src, u32 SrcSize, void *Dest, bool OutStatus, bool MaxPress )
{
	s32 dstsize ;
	s32    bonus,    conbo,    conbosize,    address,    addresssize ;
	s32 maxbonus, maxconbo, maxconbosize, maxaddress, maxaddresssize ;
	u8 keycode, *srcp, *destp, *dp, *sp, *sp2, *sp1 ;
	u32 srcaddress, nextprintaddress, code ;
	s32 j ;
	u32 i, m ;
	u32 maxlistnum, maxlistnummask, listaddp ;
	u32 sublistnum, sublistmaxnum ;
	LZ_LIST *listbuf, *listtemp, *list, *newlist ;
	u8 *listfirsttable, *usesublistflagtable, *sublistbuf ;
	u32 searchlistnum ;

	// őv{߂̃XgHő吔̃Zbg
	searchlistnum = MaxPress ? 0xffffffff : MAX_SEARCHLISTNUM ;

	// TuXg̃TCY߂
	{
			 if( SrcSize < 100 * 1024 )			sublistmaxnum = 1 ;
		else if( SrcSize < 3 * 1024 * 1024 )	sublistmaxnum = MAX_SUBLISTNUM / 3 ;
		else									sublistmaxnum = MAX_SUBLISTNUM ;
	}

	// Xg̃TCY߂
	{
		maxlistnum = MAX_ADDRESSLISTNUM ;
		if( maxlistnum > SrcSize )
		{
			while( ( maxlistnum >> 1 ) > 0x100 && ( maxlistnum >> 1 ) > SrcSize )
				maxlistnum >>= 1 ;
		}
		maxlistnummask = maxlistnum - 1 ;
	}

	// ̊m
	usesublistflagtable   = (u8 *)malloc(
		sizeof( void * )  * 65536 +					// CXg̐擪IuWFNgp̈
		sizeof( LZ_LIST ) * maxlistnum +			// CXgp̈
		sizeof( u8 )      * 65536 +					// TuXggpĂ邩tOp̈
		sizeof( void * )  * 256 * sublistmaxnum ) ;	// TuXgp̈
		
	// AhX̃Zbg
	listfirsttable =     usesublistflagtable + sizeof(     u8 ) * 65536 ;
	sublistbuf     =          listfirsttable + sizeof( void * ) * 65536 ;
	listbuf        = (LZ_LIST *)( sublistbuf + sizeof( void * ) * 256 * sublistmaxnum ) ;
	
	// 
	memset( usesublistflagtable, 0, sizeof(     u8 ) * 65536               ) ;
	memset(          sublistbuf, 0, sizeof( void * ) * 256 * sublistmaxnum ) ;
	memset(      listfirsttable, 0, sizeof( void * ) * 65536               ) ;
	list = listbuf ;
	for( i = maxlistnum / 8 ; i ; i --, list += 8 )
	{
		list[0].address =
		list[1].address =
		list[2].address =
		list[3].address =
		list[4].address =
		list[5].address =
		list[6].address =
		list[7].address = 0xffffffff ;
	}

	srcp  = (u8 *)Src ;
	destp = (u8 *)Dest ;

	// kf[^̒ňԏopxႢoCgR[h
	{
		u32 qnum, table[256], mincode ;

		for( i = 0 ; i < 256 ; i ++ )
			table[i] = 0 ;
		
		sp   = srcp ;
		qnum = SrcSize / 8 ;
		i    = qnum * 8 ;
		for( ; qnum ; qnum --, sp += 8 )
		{
			table[sp[0]] ++ ;
			table[sp[1]] ++ ;
			table[sp[2]] ++ ;
			table[sp[3]] ++ ;
			table[sp[4]] ++ ;
			table[sp[5]] ++ ;
			table[sp[6]] ++ ;
			table[sp[7]] ++ ;
		}
		for( ; i < SrcSize ; i ++, sp ++ )
			table[*sp] ++ ;
			
		keycode = 0 ;
		mincode = table[0] ;
		for( i = 1 ; i < 256 ; i ++ )
		{
			if( mincode < table[i] ) continue ;
			mincode = table[i] ;
			keycode = (u8)i ;
		}
	}

	// k̃TCYZbg
	((u32 *)destp)[0] = SrcSize ;

	// L[R[hZbg
	destp[8] = keycode ;

	// k
	dp               = destp + 9 ;
	sp               = srcp ;
	srcaddress       = 0 ;
	dstsize          = 0 ;
	listaddp         = 0 ;
	sublistnum       = 0 ;
	nextprintaddress = 1024 * 100 ;
	if( OutStatus )
	{
		printf( " k     " ) ;
		LogStringLength += 10 ;
	}
	while( srcaddress < SrcSize )
	{
		// cTCYŒሳkTCYȉ̏ꍇ͈kȂ
		if( srcaddress + MIN_COMPRESS >= SrcSize ) goto NOENCODE ;

		// Xg擾
		code = *((u16 *)sp) ;
		list = (LZ_LIST *)( listfirsttable + code * sizeof( void * ) ) ;
		if( usesublistflagtable[code] == 1 )
		{
			list = (LZ_LIST *)( (void **)list->next + sp[2] ) ;
		}
		else
		{
			if( sublistnum < sublistmaxnum )
			{
				list->next = (LZ_LIST *)( sublistbuf + sizeof( void * ) * 256 * sublistnum ) ;
				list       = (LZ_LIST *)( (void **)list->next + sp[2] ) ;
			
				usesublistflagtable[code] = 1 ;
				sublistnum ++ ;
			}
		}

		// Ԉv̒R[hT
		maxconbo   = -1 ;
		maxaddress = -1 ;
		maxbonus   = -1 ;
		for( m = 0, listtemp = list->next ; m < searchlistnum && listtemp != NULL ; listtemp = listtemp->next, m ++ )
		{
			address = srcaddress - listtemp->address ;
			if( address >= MAX_POSITION )
			{
				if( listtemp->prev ) listtemp->prev->next = listtemp->next ;
				if( listtemp->next ) listtemp->next->prev = listtemp->prev ;
				listtemp->address = 0xffffffff ;
				continue ;
			}
			
			sp2 = &sp[-address] ;
			sp1 = sp ;
			if( srcaddress + MAX_COPYSIZE < SrcSize )
			{
				conbo = MAX_COPYSIZE / 4 ;
				while( conbo && *((u32 *)sp2) == *((u32 *)sp1) )
				{
					sp2 += 4 ;
					sp1 += 4 ;
					conbo -- ;
				}
				conbo = MAX_COPYSIZE - ( MAX_COPYSIZE / 4 - conbo ) * 4 ;

				while( conbo && *sp2 == *sp1 )
				{
					sp2 ++ ;
					sp1 ++ ;
					conbo -- ;
				}
				conbo = MAX_COPYSIZE - conbo ;
			}
			else
			{
				for( conbo = 0 ;
						conbo < MAX_COPYSIZE &&
						conbo + srcaddress < SrcSize &&
						sp[conbo - address] == sp[conbo] ;
							conbo ++ ){}
			}

			if( conbo >= 4 )
			{
				conbosize   = ( conbo - MIN_COMPRESS ) < 0x20 ? 0 : 1 ;
				addresssize = address < 0x100 ? 0 : ( address < 0x10000 ? 1 : 2 ) ;
				bonus       = conbo - ( 3 + conbosize + addresssize ) ;

				if( bonus > maxbonus )
				{
					maxconbo       = conbo ;
					maxaddress     = address ;
					maxaddresssize = addresssize ;
					maxconbosize   = conbosize ;
					maxbonus       = bonus ;
				}
			}
		}

		// Xgɓo^
		newlist = &listbuf[listaddp] ;
		if( newlist->address != 0xffffffff )
		{
			if( newlist->prev ) newlist->prev->next = newlist->next ;
			if( newlist->next ) newlist->next->prev = newlist->prev ;
			newlist->address = 0xffffffff ;
		}
		newlist->address = srcaddress ;
		newlist->prev    = list ;
		newlist->next    = list->next ;
		if( list->next != NULL ) list->next->prev = newlist ;
		list->next       = newlist ;
		listaddp         = ( listaddp + 1 ) & maxlistnummask ;

		// vR[hȂ񈳏kR[hƂďo
		if( maxconbo == -1 )
		{
NOENCODE:
			// L[R[hꍇ͂QAŏo͂
			if( *sp == keycode )
			{
				if( destp != NULL )
				{
					dp[0]  =
					dp[1]  = keycode ;
					dp += 2 ;
				}
				dstsize += 2 ;
			}
			else
			{
				if( destp != NULL )
				{
					*dp = *sp ;
					dp ++ ;
				}
				dstsize ++ ;
			}
			sp ++ ;
			srcaddress ++ ;
		}
		else
		{
			// ꍇ͌ʒuƒo͂
			
			// L[R[hƌʒuƒo
			if( destp != NULL )
			{
				// L[R[h̏o
				*dp++ = keycode ;

				// o͂A͍Œ MIN_COMPRESS 邱ƂOȂ̂ - MIN_COMPRESS ̂o͂
				maxconbo -= MIN_COMPRESS ;

				// AO`SrbgƘAA΃AhX̃rbgo
				*dp = (u8)( ( ( maxconbo & 0x1f ) << 3 ) | ( maxconbosize << 2 ) | maxaddresssize ) ;

				// L[R[h̘A̓L[R[hƒl̓񈳏kR[h
				// f邽߁AL[R[h̒lȏ̏ꍇ͒l{P
				if( *dp >= keycode ) dp[0] += 1 ;
				dp ++ ;

				// AT`PQrbgo
				if( maxconbosize == 1 )
					*dp++ = (u8)( ( maxconbo >> 5 ) & 0xff ) ;

				// maxconbo ͂܂g - MIN_COMPRESS ߂
				maxconbo += MIN_COMPRESS ;

				// o͂鑊΃AhX͂O( ݂̃AhX|P )}̂ŁA|P̂o͂
				maxaddress -- ;

				// ΃AhXo
				*dp++ = (u8)( maxaddress ) ;
				if( maxaddresssize > 0 )
				{
					*dp++ = (u8)( maxaddress >> 8 ) ;
					if( maxaddresssize == 2 )
						*dp++ = (u8)( maxaddress >> 16 ) ;
				}
			}
			
			// o̓TCYZ
			dstsize += 3 + maxaddresssize + maxconbosize ;
			
			// Xgɏǉ
			if( srcaddress + maxconbo < SrcSize )
			{
				sp2 = &sp[1] ;
				for( j = 1 ; j < maxconbo && (u64)&sp2[2] - (u64)srcp < SrcSize ; j ++, sp2 ++ )
				{
					code = *((u16 *)sp2) ;
					list = (LZ_LIST *)( listfirsttable + code * sizeof( void * ) ) ;
					if( usesublistflagtable[code] == 1 )
					{
						list = (LZ_LIST *)( (void **)list->next + sp2[2] ) ;
					}
					else
					{
						if( sublistnum < sublistmaxnum )
						{
							list->next = (LZ_LIST *)( sublistbuf + sizeof( void * ) * 256 * sublistnum ) ;
							list       = (LZ_LIST *)( (void **)list->next + sp2[2] ) ;
						
							usesublistflagtable[code] = 1 ;
							sublistnum ++ ;
						}
					}

					newlist = &listbuf[listaddp] ;
					if( newlist->address != 0xffffffff )
					{
						if( newlist->prev ) newlist->prev->next = newlist->next ;
						if( newlist->next ) newlist->next->prev = newlist->prev ;
						newlist->address = 0xffffffff ;
					}
					newlist->address = srcaddress + j ;
					newlist->prev = list ;
					newlist->next = list->next ;
					if( list->next != NULL ) list->next->prev = newlist ;
					list->next = newlist ;
					listaddp = ( listaddp + 1 ) & maxlistnummask ;
				}
			}
			
			sp         += maxconbo ;
			srcaddress += maxconbo ;
		}

		// k̕\
		if( nextprintaddress < srcaddress )
		{
			nextprintaddress = srcaddress + 100 * 1024 ;
			if( OutStatus ) printf( "\b\b\b\b%3d%%", (s32)( (f32)srcaddress * 100 / SrcSize ) ) ;
		}
	}

	if( OutStatus )
	{
		printf( "\b\b\b\b100%%" ) ;
	}

	// k̃f[^TCYۑ
	*((u32 *)&destp[4]) = dstsize + 9 ;

	// mۂ̉
	free( usesublistflagtable ) ;

	// f[^̃TCYԂ
	return dstsize + 9 ;
}

// fR[h( ߂l:𓀌̃TCY  -1 ̓G[  Dest  NULL 邱Ƃ\ )
int DXArchive::Decode( void *Src, void *Dest )
{
	u32 srcsize, destsize, code, indexsize, keycode, conbo, index ;
	u8 *srcp, *destp, *dp, *sp ;

	destp = (u8 *)Dest ;
	srcp  = (u8 *)Src ;
	
	// 𓀌̃f[^TCY𓾂
	destsize = *((u32 *)&srcp[0]) ;

	// kf[^̃TCY𓾂
	srcsize = *((u32 *)&srcp[4]) - 9 ;

	// L[R[h
	keycode = srcp[8] ;
	
	// o͐悪Ȃꍇ̓TCYԂ
	if( Dest == NULL )
		return destsize ;
	
	// WJJn
	sp  = srcp + 9 ;
	dp  = destp ;
	while( srcsize )
	{
		// L[R[hŏ𕪊
		if( sp[0] != keycode )
		{
			// 񈳏kR[h̏ꍇ͂̂܂܏o
			*dp = *sp ;
			dp      ++ ;
			sp      ++ ;
			srcsize -- ;
			continue ;
		}
	
		// L[R[hAĂꍇ̓L[R[ĥo
		if( sp[1] == keycode )
		{
			*dp = (u8)keycode ;
			dp      ++ ;
			sp      += 2 ;
			srcsize -= 2 ;
			
			continue ;
		}

		// oCg𓾂
		code = sp[1] ;

		// L[R[h傫Ȓlꍇ̓L[R[h
		// Ƃ̃obeBOh~ׂ̈Ɂ{PĂ̂Ł|P
		if( code > keycode ) code -- ;

		sp      += 2 ;
		srcsize -= 2 ;

		// A擾
		conbo = code >> 3 ;
		if( code & ( 0x1 << 2 ) )
		{
			conbo |= *sp << 5 ;
			sp      ++ ;
			srcsize -- ;
		}
		conbo += MIN_COMPRESS ;	// ۑɌZŏkoCg𑫂

		// QƑ΃AhX擾
		indexsize = code & 0x3 ;
		switch( indexsize )
		{
		case 0 :
			index = *sp ;
			sp      ++ ;
			srcsize -- ;
			break ;
			
		case 1 :
			index = *((u16 *)sp) ;
			sp      += 2 ;
			srcsize -= 2 ;
			break ;
			
		case 2 :
			index = *((u16 *)sp) | ( sp[2] << 16 ) ;
			sp      += 3 ;
			srcsize -= 3 ;
			break ;
		}
		index ++ ;		// ۑɁ|PĂ̂Ł{P

		// WJ
		if( index < conbo )
		{
			u32 num ;

			num  = index ;
			while( conbo > num )
			{
				memcpy( dp, dp - num, num ) ;
				dp    += num ;
				conbo -= num ;
				num   += num ;
			}
			if( conbo != 0 )
			{
				memcpy( dp, dp - num, conbo ) ;
				dp += conbo ;
			}
		}
		else
		{
			memcpy( dp, dp - index, conbo ) ;
			dp += conbo ;
		}
	}

	// 𓀌̃TCYԂ
	return (int)destsize ;
}

// oCif[^ CRC32 ̃nbVlvZ
u32 DXArchive::HashCRC32( const void *SrcData, size_t SrcDataSize )
{
	static DWORD CRC32Table[ 256 ] ;
	static int CRC32TableInit = 0 ;
	DWORD CRC = 0xffffffff ;
	BYTE *SrcByte = ( BYTE * )SrcData ;
	DWORD i ;

	// e[uĂȂ珉
	if( CRC32TableInit == 0 )
	{
		DWORD Magic = 0xedb88320 ;	// 0x4c11db7 rbgxŏԂtɂ̂ 0xedb88320
		DWORD j ;

		for( i = 0; i < 256; i++ )
		{
			DWORD Data = i ;
			for( j = 0; j < 8; j++ )
			{
				int b = ( Data & 1 ) ;
				Data >>= 1 ;
				if( b != 0 )
				{
					Data ^= Magic ;
				}
			}
			CRC32Table[ i ] = Data ;
		}

		// e[utO𗧂Ă
		CRC32TableInit = 1 ;
	}

	for( i = 0 ; i < SrcDataSize ; i ++ )
	{
		CRC = CRC32Table[ ( BYTE )( CRC ^ SrcByte[ i ] ) ] ^ ( CRC >> 8 ) ;
	}

	return CRC ^ 0xffffffff ;
}


// A[JCut@C쐬(fBNg)
int DXArchive::EncodeArchiveOneDirectory( char *OutputFileName, char *DirectoryPath, bool Press, bool AlwaysHuffman, u8 HuffmanEncodeKB, const char *KeyString_, bool NoKey, bool OutputStatus, bool MaxPress )
{
	int i, FileNum, Result ;
	char **FilePathList, *NameBuffer ;

	// t@C̐擾
	FileNum = GetDirectoryFilePath( DirectoryPath, NULL ) ;
	if( FileNum < 0 ) return -1 ;

	// t@C̐̕t@Cƃt@C|C^̊i[p̃mۂ
	NameBuffer = (char *)malloc( FileNum * ( 256 + sizeof( char * ) ) ) ;

	// t@C̃pX擾
	GetDirectoryFilePath( DirectoryPath, NameBuffer ) ;

	// t@CpX̃Xg쐬
	FilePathList = (char **)( NameBuffer + FileNum * 256 ) ;
	for( i = 0 ; i < FileNum ; i ++ )
		FilePathList[i] = NameBuffer + i * 256 ;
	
	// GR[h
	Result = EncodeArchive( OutputFileName, FilePathList, FileNum, Press, AlwaysHuffman, HuffmanEncodeKB, KeyString_, NoKey, OutputStatus, MaxPress ) ;

	// mۂ̉
	free( NameBuffer ) ;

	// ʂԂ
	return Result ;
}

// A[JCut@C쐬
int DXArchive::EncodeArchive( char *OutputFileName, char **FileOrDirectoryPath, int FileNum, bool Press, bool AlwaysHuffman, u8 HuffmanEncodeKB, const char *KeyString_, bool NoKey, bool OutputStatus, bool MaxPress )
{
	DARC_HEAD Head ;
	DARC_DIRECTORY Directory, *DirectoryP ;
	u64 HeaderHuffDataSize ;
	SIZESAVE SizeSave ;
	FILE *DestFp ;
	u8 *NameP, *FileP, *DirP ;
	int i ;
	u32 Type ;
	void *TempBuffer ;
	u8 Key[ DXA_KEY_BYTES ] ;
	char KeyString[ DXA_KEY_STRING_LENGTH + 1 ] ;
	size_t KeyStringBytes ;
	char KeyStringBuffer[ DXA_KEY_STRING_MAXLENGTH ] ;
	DARC_ENCODEINFO EncodeInfo ;

	// 󋵏o͂sꍇ̓t@C̑𐔂
	EncodeInfo.CompFileNum = 0 ;
	EncodeInfo.TotalFileNum = 0 ;
	EncodeInfo.OutputStatus = OutputStatus ;
	if( EncodeInfo.OutputStatus )
	{
		for( i = 0 ; i < FileNum ; i++ )
		{
			// w肳ꂽt@C邩ǂ
			Type = GetFileAttributesA( FileOrDirectoryPath[i] ) ;
			if( ( signed int )Type == -1 ) continue ;

			// t@C̃^Cvɂď𕪊
			if( ( Type & FILE_ATTRIBUTE_DIRECTORY ) != 0 )
			{
				FILE_INFOLIST FileList ;

				// tH_ȉ̃t@C擾
				CreateFileList( FileOrDirectoryPath[i], &FileList, TRUE, TRUE, NULL, NULL, NULL ) ;

				// tH_ȉ̃t@CZ
				EncodeInfo.TotalFileNum += FileList.Num ;

				// t@CXǧn
				ReleaseFileList( &FileList ) ;
			}
			else
			{
				// t@Cꍇ̓t@C̐𑝂₷
				EncodeInfo.TotalFileNum ++ ;
			}
		}
	}

	// ̕ۑƌ̍쐬
	if( NoKey == false )
	{
		// w肪ꍇ̓ftHǧgp
		if( KeyString_ == NULL )
		{
			KeyString_ = DefaultKeyString ;
		}

		KeyStringBytes = CL_strlen( CHARCODEFORMAT_ASCII, KeyString_ ) ;
		if( KeyStringBytes > DXA_KEY_STRING_LENGTH )
		{
			KeyStringBytes = DXA_KEY_STRING_LENGTH ;
		}
		memcpy( KeyString, KeyString_, KeyStringBytes ) ;
		KeyString[ KeyStringBytes ] = '\0' ;

		// ̍쐬
		KeyCreate( KeyString, KeyStringBytes, Key ) ;
	}

	// t@Cǂݍ݂Ɏgpobt@̊m
	TempBuffer = malloc( DXA_BUFFERSIZE ) ;

	// o̓t@CJ
	DestFp = fopen( OutputFileName, "wb" ) ;

	// A[JCũwb_o͂
	{
		memset( &Head, 0, sizeof( Head ) ) ;
		Head.Head						= DXA_HEAD ;
		Head.Version					= DXA_VER ;
		Head.HeadSize					= 0xffffffff ;
		Head.DataStartAddress			= sizeof( DARC_HEAD ) ;
		Head.FileNameTableStartAddress	= 0xffffffffffffffff ;
		Head.DirectoryTableStartAddress	= 0xffffffffffffffff ;
		Head.FileTableStartAddress		= 0xffffffffffffffff ;
		Head.CharCodeFormat				= GetACP() ;
		Head.Flags						= 0 ;
		Head.HuffmanEncodeKB			= HuffmanEncodeKB ;
		if( NoKey )						Head.Flags |= DXA_FLAG_NO_KEY ;
		if( Press == false )			Head.Flags |= DXA_FLAG_NO_HEAD_PRESS ;
		SetFileApisToANSI() ;

		KeyConvFileWrite( &Head, sizeof( DARC_HEAD ), DestFp, NoKey ? NULL : Key, 0 ) ;
	}
	
	// eobt@mۂ
	NameP = ( u8 * )malloc( DXA_BUFFERSIZE ) ;
	if( NameP == NULL ) return -1 ;
	memset( NameP, 0, DXA_BUFFERSIZE ) ;

	FileP = ( u8 * )malloc( DXA_BUFFERSIZE ) ;
	if( FileP == NULL ) return -1 ;
	memset( FileP, 0, DXA_BUFFERSIZE ) ;

	DirP = ( u8 * )malloc( DXA_BUFFERSIZE ) ;
	if( DirP == NULL ) return -1 ;
	memset( DirP, 0, DXA_BUFFERSIZE ) ;

	// TCYۑ\̂Ƀf[^Zbg
	SizeSave.DataSize		= 0 ;
	SizeSave.NameSize		= 0 ;
	SizeSave.DirectorySize	= 0 ;
	SizeSave.FileSize		= 0 ;
	
	// ŏ̃fBNg̃t@Co
	{
		DARC_FILEHEAD File ;
		
		memset( &File, 0, sizeof( DARC_FILEHEAD ) ) ;
		File.NameAddress	= SizeSave.NameSize ;
		File.Attributes		= FILE_ATTRIBUTE_DIRECTORY ;
		File.DataAddress	= SizeSave.DirectorySize ;
		File.DataSize		= 0 ;
		File.PressDataSize  = 0xffffffffffffffff ;

		// fBNg̏o
		SizeSave.NameSize += AddFileNameData( ( int )Head.CharCodeFormat, "", NameP + SizeSave.NameSize ) ;

		// t@C̏o
		memcpy( FileP + SizeSave.FileSize, &File, sizeof( DARC_FILEHEAD ) ) ;
		SizeSave.FileSize += sizeof( DARC_FILEHEAD ) ;
	}

	// ŏ̃fBNgo
	Directory.DirectoryAddress 			= 0 ;
	Directory.ParentDirectoryAddress 	= 0xffffffffffffffff ;
	Directory.FileHeadNum 				= FileNum ;
	Directory.FileHeadAddress 			= SizeSave.FileSize ;
	memcpy( DirP + SizeSave.DirectorySize, &Directory, sizeof( DARC_DIRECTORY ) ) ;
	DirectoryP = ( DARC_DIRECTORY * )( DirP + SizeSave.DirectorySize ) ;

	// TCYZ
	SizeSave.DirectorySize 	+= sizeof( DARC_DIRECTORY ) ;
	SizeSave.FileSize 		+= sizeof( DARC_FILEHEAD ) * FileNum ;

	// nꂽt@C̐JԂ
	for( i = 0 ; i < FileNum ; i ++ )
	{
		// w肳ꂽt@C邩ǂ
		Type = GetFileAttributesA( FileOrDirectoryPath[i] ) ;
		if( ( signed int )Type == -1 ) continue ;

		// t@C̃^Cvɂď𕪊
		if( ( Type & FILE_ATTRIBUTE_DIRECTORY ) != 0 )
		{
			// fBNg̏ꍇ̓fBNg̃A[JCuɉ
			DirectoryEncode( ( int )Head.CharCodeFormat, FileOrDirectoryPath[i], NameP, DirP, FileP, &Directory, &SizeSave, i, DestFp, TempBuffer, Press, MaxPress, AlwaysHuffman, HuffmanEncodeKB, KeyString, KeyStringBytes, NoKey, KeyStringBuffer, &EncodeInfo ) ;
		}
		else
		{
			WIN32_FIND_DATAA FindData ;
			HANDLE FindHandle ;
			DARC_FILEHEAD File ;
			u8 lKey[DXA_KEY_BYTES] ;
			size_t KeyStringBufferBytes ;
	
			// t@C̏𓾂
			FindHandle = FindFirstFileA( FileOrDirectoryPath[i], &FindData ) ;
			if( FindHandle == INVALID_HANDLE_VALUE ) continue ;

			// is󋵏o
			if( EncodeInfo.OutputStatus )
			{
				// t@CZbg
				strcpy( EncodeInfo.ProcessFileName, FindData.cFileName ) ;

				// t@C𑝂₷
				EncodeInfo.CompFileNum ++ ;

				// \
				EncodeStatusOutput( &EncodeInfo ) ;
			}

			// t@Cwb_Zbg
			{
				File.NameAddress       = SizeSave.NameSize ;
				File.Time.Create       = ( ( ( LONGLONG )FindData.ftCreationTime.dwHighDateTime   ) << 32 ) + FindData.ftCreationTime.dwLowDateTime   ;
				File.Time.LastAccess   = ( ( ( LONGLONG )FindData.ftLastAccessTime.dwHighDateTime ) << 32 ) + FindData.ftLastAccessTime.dwLowDateTime ;
				File.Time.LastWrite    = ( ( ( LONGLONG )FindData.ftLastWriteTime.dwHighDateTime  ) << 32 ) + FindData.ftLastWriteTime.dwLowDateTime  ;
				File.Attributes        = FindData.dwFileAttributes ;
				File.DataAddress       = SizeSave.DataSize ;
				File.DataSize          = ( ( ( LONGLONG )FindData.nFileSizeHigh ) << 32 ) + FindData.nFileSizeLow ;
				File.PressDataSize	   = 0xffffffffffffffff ;
				File.HuffPressDataSize = 0xffffffffffffffff ;
			}

			// t@Co
			SizeSave.NameSize += AddFileNameData( ( int )Head.CharCodeFormat, FindData.cFileName, NameP + SizeSave.NameSize ) ;

			// t@Cʂ̌쐬
			if( NoKey == false )
			{
				KeyStringBufferBytes = CreateKeyFileString( ( int )Head.CharCodeFormat, KeyString, KeyStringBytes, DirectoryP, &File, FileP, DirP, NameP, ( BYTE * )KeyStringBuffer ) ;
				KeyCreate( KeyStringBuffer, KeyStringBufferBytes, lKey  ) ;
			}

			// t@Cf[^o
			if( File.DataSize != 0 )
			{
				FILE *SrcP ;
				u64 FileSize, WriteSize, MoveSize ;
				bool Huffman = false ;
				bool AlwaysPress = false ;

				// t@CJ
				SrcP = fopen( FileOrDirectoryPath[i], "rb" ) ;
				
				// TCY𓾂
				_fseeki64( SrcP, 0, SEEK_END ) ;
				FileSize = _ftelli64( SrcP ) ;
				_fseeki64( SrcP, 0, SEEK_SET ) ;

				// k̑ΏۂƂȂt@CtH[}bgׂ
				{
					u32 Len ;
					Len = ( u32 )strlen( FindData.cFileName ) ;
					if( Len > 4 )
					{
						char *sp ;
						
						sp = &FindData.cFileName[Len-3] ;
						if( StrICmp( sp, "wav" ) == 0 ||
							StrICmp( sp, "jpg" ) == 0 ||
							StrICmp( sp, "png" ) == 0 ||
							StrICmp( sp, "mpg" ) == 0 ||
							StrICmp( sp, "mp3" ) == 0 ||
							StrICmp( sp, "mp4" ) == 0 ||
							StrICmp( sp, "m4a" ) == 0 ||
							StrICmp( sp, "ogg" ) == 0 ||
							StrICmp( sp, "ogv" ) == 0 ||
							StrICmp( sp, "ops" ) == 0 ||
							StrICmp( sp, "wmv" ) == 0 ||
							StrICmp( sp, "tif" ) == 0 ||
							StrICmp( sp, "tga" ) == 0 ||
							StrICmp( sp, "bmp" ) == 0 ||
							StrICmp( sp - 1, "jpeg" ) == 0 )
						{
							Huffman = true ;
						}

						// wav  bmp ̏ꍇ͕Kk
						if( StrICmp( sp, "wav" ) == 0 ||
							StrICmp( sp, "tga" ) == 0 ||
							StrICmp( sp, "bmp" ) == 0 )
						{
							AlwaysPress = true ;
						}
					}
				}

				// AlwaysHuffman  true ̏ꍇ͕Knt}k
				if( AlwaysHuffman )
				{
					Huffman = true ;
				}

				// nt}kTCY 0 ̏ꍇ̓nt}ksȂ
				if( HuffmanEncodeKB == 0 )
				{
					Huffman = false ;
				}

				// k̎w肪ꍇŁA
				// Kkt@CtH[}bgAt@CTCY 10MB ȉ̏ꍇ͈k݂
				if( Press == true && ( AlwaysPress || File.DataSize < 10 * 1024 * 1024 ) )
				{
					void *SrcBuf, *DestBuf ;
					u32 DestSize, Len ;
					
					// ꕔ̃t@C`̏ꍇ͗\ߒe
					if( AlwaysPress == false && ( Len = ( int )strlen( FindData.cFileName ) ) > 4 )
					{
						char *sp ;
						
						sp = &FindData.cFileName[Len-3] ;
						if( StrICmp( sp, "wav" ) == 0 ||
							StrICmp( sp, "jpg" ) == 0 ||
							StrICmp( sp, "png" ) == 0 ||
							StrICmp( sp, "mpg" ) == 0 ||
							StrICmp( sp, "mp3" ) == 0 ||
							StrICmp( sp, "mp4" ) == 0 ||
							StrICmp( sp, "ogg" ) == 0 ||
							StrICmp( sp, "ogv" ) == 0 ||
							StrICmp( sp, "ops" ) == 0 ||
							StrICmp( sp, "wmv" ) == 0 ||
							StrICmp( sp - 1, "jpeg" ) == 0 ) goto NOPRESS ;
					}

					// f[^ۂƓ郁̈̊m
					SrcBuf  = calloc( 1, ( size_t )( FileSize + FileSize * 2 + 64 ) ) ;
					DestBuf = (u8 *)SrcBuf + FileSize ;
					
					// t@CۂƓǂݍ
					fread64( SrcBuf, FileSize, SrcP ) ;

					// kꍇ͋Iɐis󋵏o͂XV
					if( EncodeInfo.OutputStatus )
					{
						EncodeStatusOutput( &EncodeInfo, true ) ;
					}
					
					// k
					DestSize = Encode( SrcBuf, ( u32 )FileSize, DestBuf, EncodeInfo.OutputStatus, MaxPress ) ;
					
					// wǈkoȂꍇ͈kŃA[JCu
					if( AlwaysPress == false && ( (f64)DestSize / (f64)FileSize > 0.90 ) )
					{
						_fseeki64( SrcP, 0L, SEEK_SET ) ;
						free( SrcBuf ) ;
						goto NOPRESS ;
					}

					// kf[^̃TCYۑ
					File.PressDataSize = DestSize ;

					// nt}ksǂŏ𕪊
					if( Huffman )
					{
						u8 *HuffData ;

						// nt}kTCYɂď𕪊
						if( HuffmanEncodeKB == 0xff || DestSize <= ( u64 )( HuffmanEncodeKB * 1024 * 2 ) )
						{
							// nt}kp̃̈m
							HuffData = ( u8 * )calloc( 1, DestSize * 2 + 256 * 2 + 32 ) ;

							// t@CŜnt}k
							File.HuffPressDataSize = Huffman_Encode( DestBuf, DestSize, HuffData ) ;

							// kf[^ɌKpďo
							WriteSize = ( File.HuffPressDataSize + 3 ) / 4 * 4 ;	// TCY͂S̔{ɍ킹
							KeyConvFileWrite( HuffData, WriteSize, DestFp, NoKey ? NULL : lKey, File.DataSize ) ;
						}
						else
						{
							// nt}kp̃̈m
							HuffData = ( u8 * )calloc( 1, HuffmanEncodeKB * 1024 * 2 * 4 + 256 * 2 + 32 ) ;

							// t@C̑Ont}k
							memcpy( HuffData,                                  DestBuf,                                     HuffmanEncodeKB * 1024 ) ;
							memcpy( HuffData + HuffmanEncodeKB * 1024, ( u8 * )DestBuf + DestSize - HuffmanEncodeKB * 1024, HuffmanEncodeKB * 1024 ) ;
							File.HuffPressDataSize = Huffman_Encode( HuffData, HuffmanEncodeKB * 1024 * 2, HuffData + HuffmanEncodeKB * 1024 * 2 ) ;

							// nt}ko
							KeyConvFileWrite( HuffData + HuffmanEncodeKB * 1024 * 2, File.HuffPressDataSize, DestFp, NoKey ? NULL : lKey, File.DataSize ) ;

							// nt}kĂȂӏo
							WriteSize = File.HuffPressDataSize + DestSize - HuffmanEncodeKB * 1024 * 2 ;
							WriteSize = ( WriteSize + 3 ) / 4 * 4 ;	// TCY͂S̔{ɍ킹
							KeyConvFileWrite( ( u8 * )DestBuf + HuffmanEncodeKB * 1024, WriteSize - File.HuffPressDataSize, DestFp, NoKey ? NULL : lKey, File.DataSize + File.HuffPressDataSize ) ;
						}

						// ̉
						free( HuffData ) ;
					}
					else
					{
						// kf[^𔽓]ďo
						WriteSize = ( DestSize + 3 ) / 4 * 4 ;	// TCY͂S̔{ɍ킹
						KeyConvFileWrite( DestBuf, WriteSize, DestFp, NoKey ? NULL : lKey, File.DataSize ) ;
					}

					// ̉
					free( SrcBuf ) ;
				}
				else
				{
NOPRESS:
					// nt}ksǂŏ𕪊
					if( Press && Huffman )
					{
						u8 *SrcBuf, *HuffData ;

						// f[^ۂƓ郁̈̊m
						SrcBuf = ( u8 * )calloc( 1, ( size_t )( FileSize + 32 ) ) ;

						// t@CۂƓǂݍ
						fread64( SrcBuf, FileSize, SrcP ) ;
						
						// nt}kTCYɂď𕪊
						if( HuffmanEncodeKB == 0xff || FileSize <= HuffmanEncodeKB * 1024 * 2 )
						{
							// nt}kp̃̈m
							HuffData = ( u8 * )calloc( 1, ( size_t )( FileSize * 2 + 256 * 2 + 32 ) ) ;

							// t@CŜnt}k
							File.HuffPressDataSize = Huffman_Encode( SrcBuf, FileSize, HuffData ) ;

							// kf[^ɌKpďo
							WriteSize = ( File.HuffPressDataSize + 3 ) / 4 * 4 ;	// TCY͂S̔{ɍ킹
							KeyConvFileWrite( HuffData, WriteSize, DestFp, NoKey ? NULL : lKey, File.DataSize ) ;
						}
						else
						{
							// nt}kp̃̈m
							HuffData = ( u8 * )calloc( 1, HuffmanEncodeKB * 1024 * 2 * 4 + 256 * 2 + 32 ) ;

							// t@C̑Ont}k
							memcpy( HuffData,                          SrcBuf,                                     HuffmanEncodeKB * 1024 ) ;
							memcpy( HuffData + HuffmanEncodeKB * 1024, SrcBuf + FileSize - HuffmanEncodeKB * 1024, HuffmanEncodeKB * 1024 ) ;
							File.HuffPressDataSize = Huffman_Encode( HuffData, HuffmanEncodeKB * 1024 * 2, HuffData + HuffmanEncodeKB * 1024 * 2 ) ;

							// nt}ko
							KeyConvFileWrite( HuffData + HuffmanEncodeKB * 1024 * 2, File.HuffPressDataSize, DestFp, NoKey ? NULL : lKey, File.DataSize ) ;

							// nt}kĂȂӏo
							WriteSize = File.HuffPressDataSize + FileSize - HuffmanEncodeKB * 1024 * 2 ;
							WriteSize = ( WriteSize + 3 ) / 4 * 4 ;	// TCY͂S̔{ɍ킹
							KeyConvFileWrite( SrcBuf + HuffmanEncodeKB * 1024, WriteSize - File.HuffPressDataSize, DestFp, NoKey ? NULL : lKey, File.DataSize + File.HuffPressDataSize ) ;
						}

						// ̉
						free( SrcBuf ) ;
						free( HuffData ) ;
					}
					else
					{
						// ]Jn
						WriteSize = 0 ;
						while( WriteSize < FileSize )
						{
							// ]TCY
							MoveSize = DXA_BUFFERSIZE < FileSize - WriteSize ? DXA_BUFFERSIZE : FileSize - WriteSize ;
							MoveSize = ( MoveSize + 3 ) / 4 * 4 ;	// TCY͂S̔{ɍ킹
						
							// t@ČKpǂݍ
							memset( TempBuffer, 0, ( size_t )MoveSize ) ;
							KeyConvFileRead( TempBuffer, MoveSize, SrcP, NoKey ? NULL : lKey, File.DataSize + WriteSize ) ;

							// o
							fwrite64( TempBuffer, MoveSize, DestFp ) ;
						
							// oTCỶZ
							WriteSize += MoveSize ;
						}
					}
				}
				
				// ot@C
				fclose( SrcP ) ;
			
				// f[^TCỶZ
				SizeSave.DataSize += WriteSize ;
			}
			
			// t@Cwb_o
			memcpy( FileP + Directory.FileHeadAddress + sizeof( DARC_FILEHEAD ) * i, &File, sizeof( DARC_FILEHEAD ) ) ;

			// Find nh
			FindClose( FindHandle ) ;
		}
	}
	
	// obt@ɗߍ񂾊ewb_f[^o͂
	{
		u8 *PressSource ;
		u64 TotalSize = SizeSave.NameSize + SizeSave.FileSize + SizeSave.DirectorySize ;

		// S̃f[^Z߂
		PressSource = ( u8 * )malloc( ( size_t )TotalSize ) ;
		if( PressSource == NULL ) return -1 ;
		memcpy( PressSource,                                         NameP, ( size_t )SizeSave.NameSize ) ;
		memcpy( PressSource + SizeSave.NameSize,                     FileP, ( size_t )SizeSave.FileSize ) ;
		memcpy( PressSource + SizeSave.NameSize + SizeSave.FileSize, DirP,  ( size_t )SizeSave.DirectorySize ) ;

		// k邩ǂŏ𕪊
		if( Press )
		{
			u8 *PressData ;
			int LZDataSize ;

			// kꍇ

			// kf[^i[郁̈̊m
			PressData = ( u8 * )malloc( ( size_t )( TotalSize * 4 + 256 * 2 + 32 * 2 ) ) ;
			if( PressData == NULL ) return -1 ;

			// LZk
			LZDataSize = Encode( PressSource, ( u32 )TotalSize, PressData, false ) ;

			// nt}k
			HeaderHuffDataSize = Huffman_Encode( PressData, ( u64 )LZDataSize, PressData + TotalSize * 2 + 32 ) ;

			// Z߂̂ɌKpďo
			KeyConvFileWrite( PressData + TotalSize * 2 + 32, HeaderHuffDataSize, DestFp, NoKey ? NULL : Key, 0 ) ;

			// ̉
			free( PressData ) ;
		}
		else
		{
			// Z߂̂ɌKpďo
			KeyConvFileWrite( PressSource, TotalSize, DestFp, NoKey ? NULL : Key, 0 ) ;
		}

		// ̉
		free( PressSource ) ;
	}
		
	// ĂуA[JCũwb_o͂
	{
		Head.Head                       = DXA_HEAD ;
		Head.Version                    = DXA_VER ;
		Head.HeadSize                   = ( u32 )( SizeSave.NameSize + SizeSave.FileSize + SizeSave.DirectorySize ) ;
		Head.DataStartAddress           = sizeof( DARC_HEAD ) ;
		Head.FileNameTableStartAddress  = SizeSave.DataSize + Head.DataStartAddress ;
		Head.FileTableStartAddress      = SizeSave.NameSize ;
		Head.DirectoryTableStartAddress = Head.FileTableStartAddress + SizeSave.FileSize ;

		_fseeki64( DestFp, 0, SEEK_SET ) ;
		fwrite64( &Head, sizeof( DARC_HEAD ), DestFp ) ;
	}
	
	// ot@C
	fclose( DestFp ) ;
	
	// mۂobt@J
	free( NameP ) ;
	free( FileP ) ;
	free( DirP ) ;
	free( TempBuffer ) ;

	// k󋵕\NA
	EncodeStatusErase() ;

	// I
	return 0 ;
}

// A[JCut@CWJ
int DXArchive::DecodeArchive( char *ArchiveName, char *OutputPath, const char *KeyString_ )
{
	u8 *HeadBuffer = NULL ;
	DARC_HEAD Head ;
	u8 *FileP, *NameP, *DirP ;
	FILE *ArcP = NULL ;
	char OldDir[MAX_PATH] ;
	u8 Key[DXA_KEY_BYTES] ;
	char KeyString[ DXA_KEY_STRING_LENGTH + 1 ] ;
	size_t KeyStringBytes ;
	char KeyStringBuffer[ DXA_KEY_STRING_MAXLENGTH ] ;
	bool NoKey ;

	// ̕ۑƌ̍쐬
	{
		// w肪ꍇ̓ftHǧgp
		if( KeyString_ == NULL )
		{
			KeyString_ = DefaultKeyString ;
		}

		KeyStringBytes = CL_strlen( CHARCODEFORMAT_ASCII, KeyString_ ) ;
		if( KeyStringBytes > DXA_KEY_STRING_LENGTH )
		{
			KeyStringBytes = DXA_KEY_STRING_LENGTH ;
		}
		memcpy( KeyString, KeyString_, KeyStringBytes ) ;
		KeyString[ KeyStringBytes ] = '\0' ;

		// ̍쐬
		KeyCreate( KeyString, KeyStringBytes, Key ) ;
	}

	// A[JCut@CJ
	ArcP = fopen( ArchiveName, "rb" ) ;
	if( ArcP == NULL ) return -1 ;

	// o͐̃fBNgɃJgfBNgύX
	GetCurrentDirectoryA( MAX_PATH, OldDir ) ;
	SetCurrentDirectoryA( OutputPath ) ;

	// wb_͂
	{
		s64 FileSize ;

		// wb_̓ǂݍ
		fread64( &Head, sizeof( DARC_HEAD ), ArcP ) ;
		
		// hč
		if( Head.Head != DXA_HEAD )
		{
			goto ERR ;
		}
		
		// o[W
		if( Head.Version > DXA_VER || Head.Version < DXA_VER_MIN ) goto ERR ;

		// sĂȂ擾
		NoKey = ( Head.Flags & DXA_FLAG_NO_KEY ) != 0 ;
		
		// wb_̃TCỸmۂ
		HeadBuffer = ( u8 * )malloc( ( size_t )Head.HeadSize ) ;
		if( HeadBuffer == NULL ) goto ERR ;

		// wb_kĂꍇ͉𓀂
		if( ( Head.Flags & DXA_FLAG_NO_HEAD_PRESS ) != 0 )
		{
			// kĂȂꍇ͕ʂɓǂݍ
			_fseeki64( ArcP, Head.FileNameTableStartAddress, SEEK_SET ) ;
			KeyConvFileRead( HeadBuffer, Head.HeadSize, ArcP, NoKey ? NULL : Key, 0 ) ;
		}
		else
		{
			void *HuffHeadBuffer ;
			u64 HuffHeadSize ;
			void *LzHeadBuffer ;
			u64 LzHeadSize ;

			// nt}kꂽwb_̃TCY擾
			_fseeki64( ArcP, 0, SEEK_END ) ;
			FileSize = _ftelli64( ArcP ) ;
			_fseeki64( ArcP, Head.FileNameTableStartAddress, SEEK_SET ) ;
			HuffHeadSize = ( u32 )( FileSize - _ftelli64( ArcP ) ) ;

			// nt}kꂽwb_ǂݍރmۂ
			HuffHeadBuffer = malloc( ( size_t )HuffHeadSize ) ;
			if( HuffHeadBuffer == NULL ) goto ERR ;

			// nt}kꂽwb_Rs[ƈÍ
			KeyConvFileRead( HuffHeadBuffer, HuffHeadSize, ArcP, NoKey ? NULL : Key, 0 ) ;

			// nt}kꂽwb_̉𓀌̗eʂ擾
			LzHeadSize = Huffman_Decode( HuffHeadBuffer, NULL ) ;

			// nt}kꂽwb_̉𓀌̃f[^i[郁p̊m
			LzHeadBuffer = malloc( ( size_t )LzHeadSize ) ;
			if( LzHeadBuffer == NULL )
			{
				free( HuffHeadBuffer ) ;
				goto ERR ;
			}

			// nt}kꂽwb_𓀂
			Huffman_Decode( HuffHeadBuffer, LzHeadBuffer ) ;

			// LZkꂽwb_𓀂
			Decode( LzHeadBuffer, HeadBuffer ) ;

			// ̉
			free( HuffHeadBuffer ) ;
			free( LzHeadBuffer ) ;
		}

		// eAhXZbg
		NameP = HeadBuffer ;
		FileP = NameP + Head.FileTableStartAddress ;
		DirP  = NameP + Head.DirectoryTableStartAddress ;
	}

	// A[JCu̓WJJn
	DirectoryDecode( NameP, DirP, FileP, &Head, ( DARC_DIRECTORY * )DirP, ArcP, Key, KeyString, KeyStringBytes, NoKey, KeyStringBuffer ) ;
	
	// t@C
	fclose( ArcP ) ;
	
	// wb_ǂݍł
	free( HeadBuffer ) ;

	// JgfBNgɖ߂
	SetCurrentDirectoryA( OldDir ) ;

	// I
	return 0 ;

ERR :
	if( HeadBuffer != NULL ) free( HeadBuffer ) ;
	if( ArcP != NULL ) fclose( ArcP ) ;

	// JgfBNgɖ߂
	SetCurrentDirectoryA( OldDir ) ;

	// I
	return -1 ;
}



// RXgN^
DXArchive::DXArchive( char *ArchivePath )
{
	this->fp = NULL ;
	this->HeadBuffer = NULL ;
	this->NameP = this->DirP = this->FileP = NULL ;
	this->CurrentDirectory = NULL ;
	this->CacheBuffer = NULL ;

	if( ArchivePath != NULL )
	{
		this->OpenArchiveFile( ArchivePath ) ;
	}
}

// fXgN^
DXArchive::~DXArchive()
{
	if( this->fp != NULL ) this->CloseArchiveFile() ;

	if( this->fp != NULL ) fclose( this->fp ) ;
	if( this->HeadBuffer != NULL ) free( this->HeadBuffer ) ;
	if( this->CacheBuffer != NULL ) free( this->CacheBuffer ) ;

	this->fp = NULL ;
	this->HeadBuffer = NULL ;
	this->NameP = this->DirP = this->FileP = NULL ;
	this->CurrentDirectory = NULL ;
}

// w̃fBNgf[^̈Í( ۂƃɓǂݍ񂾏ꍇp )
int DXArchive::DirectoryKeyConv( DARC_DIRECTORY *Dir, char *KeyStringBuffer )
{
	// C[Wł͂Ȃꍇ̓G[
	if( this->MemoryOpenFlag == false )
		return -1 ;

	// gȂꍇ͉ɏI
	if( this->NoKey )
		return -1 ;
	
	// ÍJn
	{
		u32 i, FileHeadSize ;
		DARC_FILEHEAD *File ;
		unsigned char lKey[ DXA_KEY_BYTES ] ;
		size_t KeyStringBufferBytes ;

		// i[Ăt@C̐JԂ
		FileHeadSize = sizeof( DARC_FILEHEAD ) ;
		File = ( DARC_FILEHEAD * )( this->FileP + Dir->FileHeadAddress ) ;
		for( i = 0 ; i < Dir->FileHeadNum ; i ++, File = (DARC_FILEHEAD *)( (u8 *)File + FileHeadSize ) )
		{
			// fBNgǂŏ𕪊
			if( File->Attributes & FILE_ATTRIBUTE_DIRECTORY )
			{
				// fBNg̏ꍇ͍ċA
				DirectoryKeyConv( ( DARC_DIRECTORY * )( this->DirP + File->DataAddress ), KeyStringBuffer ) ;
			}
			else
			{
				u8 *DataP ;

				// t@C̏ꍇ͈Í
				
				// f[^ꍇ̂ݏ
				if( File->DataSize != 0 )
				{
					// f[^ʒuZbg
					DataP = ( u8 * )this->fp + this->Head.DataStartAddress + File->DataAddress ;

					// t@Cʂ̌쐬
					if( NoKey == false )
					{
						KeyStringBufferBytes = CreateKeyFileString( ( int )this->Head.CharCodeFormat, this->KeyString, this->KeyStringBytes, Dir, File, this->FileP, this->DirP, this->NameP, ( BYTE * )KeyStringBuffer ) ;
						KeyCreate( KeyStringBuffer, KeyStringBufferBytes, lKey ) ;
					}

					// nt}kĂ邩ǂŏ𕪊
					if( File->HuffPressDataSize != 0xffffffffffffffff )
					{
						// nt}kĂꍇ
						KeyConv( DataP, File->HuffPressDataSize, File->DataSize, lKey ) ;
					}
					else
					// f[^kĂ邩ǂŏ𕪊
					if( File->PressDataSize != 0xffffffffffffffff )
					{
						// kĂꍇ
						KeyConv( DataP, File->PressDataSize, File->DataSize, lKey ) ;
					}
					else
					{
						// kĂȂꍇ
						KeyConv( DataP, File->DataSize, File->DataSize, lKey ) ;
					}
				}
			}
		}
	}

	// I
	return 0 ;
}

// A[JCut@CJ
int DXArchive::OpenArchiveFile( const char *ArchivePath, const char *KeyString_ )
{
	// ɂȂ炩̃A[JCuJĂꍇ̓G[
	if( this->fp != NULL ) return -1 ;

	// A[JCut@CJƎ݂
	this->fp = fopen( ArchivePath, "rb" ) ;
	if( this->fp == NULL ) return -1 ;

	// ̕ۑƌ̍쐬
	{
		// w肪ꍇ̓ftHǧgp
		if( KeyString_ == NULL )
		{
			KeyString_ = DefaultKeyString ;
		}

		KeyStringBytes = CL_strlen( CHARCODEFORMAT_ASCII, KeyString_ ) ;
		if( KeyStringBytes > DXA_KEY_STRING_LENGTH )
		{
			KeyStringBytes = DXA_KEY_STRING_LENGTH ;
		}
		memcpy( KeyString, KeyString_, KeyStringBytes ) ;
		KeyString[ KeyStringBytes ] = '\0' ;

		// ̍쐬
		KeyCreate( KeyString, KeyStringBytes, Key ) ;
	}

	// wb_͂
	{
		// wb_̓ǂݍ
		fread64( &this->Head, sizeof( DARC_HEAD ), this->fp ) ;
		
		// hč
		if( this->Head.Head != DXA_HEAD )
		{
			goto ERR ;
		}
		
		// o[W
		if( this->Head.Version > DXA_VER || this->Head.Version < DXA_VER_MIN ) goto ERR ;

		// sĂȂ擾
		this->NoKey = ( Head.Flags & DXA_FLAG_NO_KEY ) != 0 ;
		
		// wb_̃TCỸmۂ
		this->HeadBuffer = ( u8 * )malloc( ( size_t )this->Head.HeadSize ) ;
		if( this->HeadBuffer == NULL ) goto ERR ;

		// wb_kĂꍇ͉𓀂
		if( ( Head.Flags & DXA_FLAG_NO_HEAD_PRESS ) != 0 )
		{
			// kĂȂꍇ͕ʂɓǂݍ
			_fseeki64( this->fp, this->Head.FileNameTableStartAddress, SEEK_SET ) ;
			KeyConvFileRead( HeadBuffer, this->Head.HeadSize, this->fp, this->NoKey ? NULL : this->Key, 0 ) ;
		}
		else
		{
			void *HuffHeadBuffer ;
			u64 HuffHeadSize ;
			void *LzHeadBuffer ;
			u64 LzHeadSize ;
			s64 FileSize ;

			// kꂽwb_̗eʂ擾
			_fseeki64( this->fp, 0, SEEK_END ) ;
			FileSize = _ftelli64( this->fp ) ;
			_fseeki64( this->fp, this->Head.FileNameTableStartAddress, SEEK_SET ) ;
			HuffHeadSize = ( u32 )( FileSize - _ftelli64( this->fp ) ) ;

			// nt}kꂽwb_ǂݍރmۂ
			HuffHeadBuffer = malloc( ( size_t )HuffHeadSize ) ;
			if( HuffHeadBuffer == NULL ) goto ERR ;

			// nt}kꂽwb_ɓǂݍ
			KeyConvFileRead( HuffHeadBuffer, HuffHeadSize, this->fp, NoKey ? NULL : Key, 0 ) ;

			// nt}kꂽwb_̉𓀌̗eʂ擾
			LzHeadSize = Huffman_Decode( HuffHeadBuffer, NULL ) ;

			// nt}kꂽwb_̉𓀌̃f[^i[郁p̊m
			LzHeadBuffer = malloc( ( size_t )LzHeadSize ) ;
			if( LzHeadBuffer == NULL )
			{
				free( HuffHeadBuffer ) ;
				goto ERR ;
			}

			// nt}kꂽwb_𓀂
			Huffman_Decode( HuffHeadBuffer, LzHeadBuffer ) ;

			// LZkꂽwb_𓀂
			Decode( LzHeadBuffer, this->HeadBuffer ) ;

			// ̉
			free( HuffHeadBuffer ) ;
			free( LzHeadBuffer ) ;
		}

		// eAhXZbg
		this->NameP = this->HeadBuffer ;
		this->FileP = this->NameP + this->Head.FileTableStartAddress ;
		this->DirP = this->NameP + this->Head.DirectoryTableStartAddress ;
	}

	// JgfBNg̃Zbg
	this->CurrentDirectory = ( DARC_DIRECTORY * )this->DirP ;

	// C[WJĂAtO|
	MemoryOpenFlag = false ;

	// I
	return 0 ;

ERR :
	if( this->fp != NULL ){ fclose( this->fp ) ; this->fp = NULL ; }
	if( this->HeadBuffer != NULL ){ free( this->HeadBuffer ) ; this->HeadBuffer = NULL ; }
	
	// I
	return -1 ;
}

// A[JCut@CJŏɂׂăɓǂݍł珈( 0:  -1:s )
int DXArchive::OpenArchiveFileMem( const char *ArchivePath, const char *KeyString_ )
{
	FILE *fp ;
	u8 *datp ;
	void *ArchiveImage ;
	s64 ArchiveSize ;
	void *HuffHeadBuffer = NULL ;

	// ɂȂ炩̃A[JCuJĂꍇ̓G[
	if( this->fp != NULL ) return -1 ;

	// ̕ۑƌ̍쐬
	{
		// w肪ꍇ̓ftHǧgp
		if( KeyString_ == NULL )
		{
			KeyString_ = DefaultKeyString ;
		}

		KeyStringBytes = CL_strlen( CHARCODEFORMAT_ASCII, KeyString_ ) ;
		if( KeyStringBytes > DXA_KEY_STRING_LENGTH )
		{
			KeyStringBytes = DXA_KEY_STRING_LENGTH ;
		}
		memcpy( KeyString, KeyString_, KeyStringBytes ) ;
		KeyString[ KeyStringBytes ] = '\0' ;

		// ̍쐬
		KeyCreate( KeyString, KeyStringBytes, Key ) ;
	}

	// ɓǂݍ
	{
		fp = fopen( ArchivePath, "rb" ) ;
		if( fp == NULL ) return -1 ;
		_fseeki64( fp, 0L, SEEK_END ) ;
		ArchiveSize = _ftelli64( fp ) ;
		_fseeki64( fp, 0L, SEEK_SET ) ;
		ArchiveImage = malloc( ( size_t )ArchiveSize ) ;
		if( ArchiveImage == NULL )
		{
			fclose( fp ) ;
			return -1 ;
		}
		fread64( ArchiveImage, ArchiveSize, fp ) ;
		fclose( fp ) ;
	}

	// wb_̕Rs[
	memcpy( &this->Head, ArchiveImage, sizeof( DARC_HEAD ) ) ;

	// hcႤꍇ̓G[
	if( Head.Head != DXA_HEAD )
	{
		return -1 ;
	}

	// |C^ۑ
	this->fp = (FILE *)ArchiveImage ;
	datp = (u8 *)ArchiveImage ;

	// wb_͂
	{
		datp += sizeof( DARC_HEAD ) ;
		
		// o[W
		if( this->Head.Version > DXA_VER || this->Head.Version < DXA_VER_MIN ) goto ERR ;

		// sĂȂ擾
		this->NoKey = ( Head.Flags & DXA_FLAG_NO_KEY ) != 0 ;

		// wb_̃TCỸmۂ
		this->HeadBuffer = ( u8 * )malloc( ( size_t )this->Head.HeadSize ) ;
		if( this->HeadBuffer == NULL ) goto ERR ;

		// wb_kĂꍇ͉𓀂
		if( ( Head.Flags & DXA_FLAG_NO_HEAD_PRESS ) != 0 )
		{
			// kĂȂꍇ͕ʂɓǂݍ
			memcpy( HeadBuffer, ( u8 * )this->fp + this->Head.FileNameTableStartAddress, this->Head.HeadSize ) ;
			if( this->NoKey == false ) KeyConv( HeadBuffer, this->Head.HeadSize, 0, this->Key ) ;
		}
		else
		{
			void *HuffHeadBuffer ;
			u64 HuffHeadSize ;
			void *LzHeadBuffer ;
			u64 LzHeadSize ;

			// nt}kꂽwb_̗eʂ擾
			HuffHeadSize = ( u32 )( ( u64 )ArchiveSize - this->Head.FileNameTableStartAddress ) ;

			// nt}kꂽwb_ǂݍރmۂ
			HuffHeadBuffer = malloc( ( size_t )HuffHeadSize ) ;
			if( HuffHeadBuffer == NULL ) goto ERR ;

			// kꂽwb_Rs[ƈÍ
			memcpy( HuffHeadBuffer, ( u8 * )this->fp + this->Head.FileNameTableStartAddress, ( size_t )HuffHeadSize ) ;
			if( this->NoKey == false ) KeyConv( HuffHeadBuffer, HuffHeadSize, 0, this->Key ) ;

			// nt}kꂽwb_̉𓀌̗eʂ擾
			LzHeadSize = Huffman_Decode( HuffHeadBuffer, NULL ) ;

			// nt}kꂽwb_̉𓀌̃f[^i[郁p̊m
			LzHeadBuffer = malloc( ( size_t )LzHeadSize ) ;
			if( LzHeadBuffer == NULL )
			{
				free( HuffHeadBuffer ) ;
				goto ERR ;
			}

			// nt}kꂽwb_𓀂
			Huffman_Decode( HuffHeadBuffer, LzHeadBuffer ) ;

			// LZkꂽwb_𓀂
			Decode( LzHeadBuffer, this->HeadBuffer ) ;

			// ̉
			free( HuffHeadBuffer ) ;
			free( LzHeadBuffer ) ;
		}

		// eAhXZbg
		this->NameP = this->HeadBuffer ;
		this->FileP = this->NameP + this->Head.FileTableStartAddress ;
		this->DirP = this->NameP + this->Head.DirectoryTableStartAddress ;
	}

	// JgfBNg̃Zbg
	this->CurrentDirectory = ( DARC_DIRECTORY * )this->DirP ;

	// C[WJĂtO𗧂Ă
	MemoryOpenFlag = true ;

	// SẴt@C̈Í
	if( this->NoKey == false )
	{
		char KeyStringBuffer[ DXA_KEY_STRING_MAXLENGTH ] ;
		DirectoryKeyConv( ( DARC_DIRECTORY * )this->DirP, KeyStringBuffer ) ;
	}
	
	// [U[̃C[WJ킯ł͂Ȃ̂ŃtO|
	UserMemoryImageFlag = false ;

	// TCYۑĂ
	MemoryImageSize = ArchiveSize ;

	// I
	return 0 ;

ERR :
	
	// I
	return -1 ;
}

// ɂA[JCuC[WJ( 0:  -1:s )
int	DXArchive::OpenArchiveMem( void *ArchiveImage, s64 ArchiveSize, const char *KeyString_ )
{
	u8 *datp ;

	// ɂȂ炩̃A[JCuJĂꍇ̓G[
	if( this->fp != NULL ) return -1 ;

	// ̕ۑƌ̍쐬
	{
		// w肪ꍇ̓ftHǧgp
		if( KeyString_ == NULL )
		{
			KeyString_ = DefaultKeyString ;
		}

		KeyStringBytes = CL_strlen( CHARCODEFORMAT_ASCII, KeyString_ ) ;
		if( KeyStringBytes > DXA_KEY_STRING_LENGTH )
		{
			KeyStringBytes = DXA_KEY_STRING_LENGTH ;
		}
		memcpy( KeyString, KeyString_, KeyStringBytes ) ;
		KeyString[ KeyStringBytes ] = '\0' ;

		// ̍쐬
		KeyCreate( KeyString, KeyStringBytes, Key ) ;
	}

	// wb_̕Rs[
	memcpy( &this->Head, ArchiveImage, sizeof( DARC_HEAD ) ) ;

	// hcႤꍇ̓G[
	if( Head.Head != DXA_HEAD )
	{
		goto ERR ;
	}

	// |C^ۑ
	this->fp = (FILE *)ArchiveImage ;
	datp = (u8 *)ArchiveImage ;

	// wb_͂
	{
		datp += sizeof( DARC_HEAD ) ;

		// o[W
		if( this->Head.Version > DXA_VER || this->Head.Version < DXA_VER_MIN ) goto ERR ;

		// sĂȂ擾
		this->NoKey = ( Head.Flags & DXA_FLAG_NO_KEY ) != 0 ;

		// wb_̃TCỸmۂ
		this->HeadBuffer = ( u8 * )malloc( ( size_t )this->Head.HeadSize ) ;
		if( this->HeadBuffer == NULL ) goto ERR ;

		// wb_kĂꍇ͉𓀂
		if( ( Head.Flags & DXA_FLAG_NO_HEAD_PRESS ) != 0 )
		{
			// kĂȂꍇ͕ʂɓǂݍ
			memcpy( HeadBuffer, ( u8 * )this->fp + this->Head.FileNameTableStartAddress, this->Head.HeadSize ) ;
			if( this->NoKey == false ) KeyConv( HeadBuffer, this->Head.HeadSize, 0, this->Key ) ;
		}
		else
		{
			void *HuffHeadBuffer ;
			u64 HuffHeadSize ;
			void *LzHeadBuffer ;
			u64 LzHeadSize ;

			// nt}kꂽwb_̗eʂ擾
			HuffHeadSize = ( u32 )( ( u64 )ArchiveSize - this->Head.FileNameTableStartAddress ) ;

			// nt}kꂽwb_ǂݍރmۂ
			HuffHeadBuffer = malloc( ( size_t )HuffHeadSize ) ;
			if( HuffHeadBuffer == NULL ) goto ERR ;

			// nt}kꂽwb_Rs[ƈÍ
			memcpy( HuffHeadBuffer, ( u8 * )this->fp + this->Head.FileNameTableStartAddress, ( size_t )HuffHeadSize ) ;
			if( this->NoKey == false ) KeyConv( HuffHeadBuffer, HuffHeadSize, 0, this->Key ) ;

			// nt}kꂽwb_̉𓀌̗eʂ擾
			LzHeadSize = Huffman_Decode( HuffHeadBuffer, NULL ) ;

			// nt}kꂽwb_̉𓀌̃f[^i[郁p̊m
			LzHeadBuffer = malloc( ( size_t )LzHeadSize ) ;
			if( LzHeadBuffer == NULL )
			{
				free( HuffHeadBuffer ) ;
				goto ERR ;
			}

			// nt}kꂽwb_𓀂
			Huffman_Decode( HuffHeadBuffer, LzHeadBuffer ) ;

			// LZkꂽwb_𓀂
			Decode( LzHeadBuffer, this->HeadBuffer ) ;

			// ̉
			free( HuffHeadBuffer ) ;
			free( LzHeadBuffer ) ;
		}

		// eAhXZbg
		this->NameP = this->HeadBuffer ;
		this->FileP = this->NameP + this->Head.FileTableStartAddress ;
		this->DirP = this->NameP + this->Head.DirectoryTableStartAddress ;
	}

	// JgfBNg̃Zbg
	this->CurrentDirectory = ( DARC_DIRECTORY * )this->DirP ;

	// C[WJĂtO𗧂Ă
	MemoryOpenFlag = true ;

	// SẴt@C̈Í
	if( this->NoKey == false )
	{
		char KeyStringBuffer[ DXA_KEY_STRING_MAXLENGTH ] ;
		DirectoryKeyConv( ( DARC_DIRECTORY * )this->DirP, KeyStringBuffer ) ;
	}

	// [U[̃C[WJtO𗧂Ă
	UserMemoryImageFlag = true ;

	// TCYۑĂ
	MemoryImageSize = ArchiveSize ;

	// I
	return 0 ;

ERR :
	// I
	return -1 ;
}

// A[JCut@C
int DXArchive::CloseArchiveFile( void )
{
	// ɕĂ牽I
	if( this->fp == NULL ) return 0 ;

	// JĂ邩ǂŏ𕪊
	if( MemoryOpenFlag == true )
	{
		// A[JCuNXǂݍ񂾏ꍇƂłȂꍇŏ𕪊
		if( UserMemoryImageFlag == true )
		{
			// ]f[^ɖ߂
			if( this->NoKey == false )
			{
				char KeyStringBuffer[ DXA_KEY_STRING_MAXLENGTH ] ;
				DirectoryKeyConv( ( DARC_DIRECTORY * )this->DirP, KeyStringBuffer ) ;
				KeyConv( this->HeadBuffer, this->Head.HeadSize, 0, this->Key ) ;
			}
		}
		else
		{
			// mۂĂJ
			free( this->fp ) ;
		}
	}
	else
	{
		// A[JCut@C
		fclose( this->fp ) ;
	}

	// wb_obt@
	free( this->HeadBuffer ) ;

	// |C^
	this->fp = NULL ;
	this->HeadBuffer = NULL ;
	this->NameP = this->DirP = this->FileP = NULL ;
	this->CurrentDirectory = NULL ;

	// I
	return 0 ;
}

// A[JCũfBNgpXύX( 0:  -1:s )
int	DXArchive::ChangeCurrentDirectoryFast( SEARCHDATA *SearchData )
{
	DARC_FILEHEAD *FileH ;
	int i, j, k, Num ;
	u8 *NameData, *PathData ;
	u16 PackNum, Parity ;

	PackNum  = SearchData->PackNum ;
	Parity   = SearchData->Parity ;
	PathData = SearchData->FileName ;

	// JgfBNg瓯̃fBNgT
	FileH = ( DARC_FILEHEAD * )( this->FileP + this->CurrentDirectory->FileHeadAddress ) ;
	Num = (s32)this->CurrentDirectory->FileHeadNum ;
	for( i = 0 ; i < Num ; i ++, FileH ++ )
	{
		// fBNg`FbN
		if( ( FileH->Attributes & FILE_ATTRIBUTE_DIRECTORY ) == 0 ) continue ;

		// 񐔂ƃpeB`FbN
		NameData = this->NameP + FileH->NameAddress ;
		if( PackNum != ((u16 *)NameData)[0] || Parity != ((u16 *)NameData)[1] ) continue ;

		// `FbN
		NameData += 4 ;
		for( j = 0, k = 0 ; j < PackNum ; j ++, k += 4 )
			if( *((u32 *)&PathData[k]) != *((u32 *)&NameData[k]) ) break ;

		// KfBNg炱ŏI
		if( PackNum == j ) break ;
	}

	// G[
	if( i == Num ) return -1 ;

	// ݂JgfBNgύX
	this->CurrentDirectory = ( DARC_DIRECTORY * )( this->DirP + FileH->DataAddress ) ;

	// I
	return 0 ;
}

// A[JCũfBNgpXύX( 0:  -1:s )
int DXArchive::ChangeCurrentDir( const char *DirPath )
{
	return ChangeCurrentDirectoryBase( DirPath, true ) ;
}

// A[JCũfBNgpXύX( 0:  -1:s )
int	DXArchive::ChangeCurrentDirectoryBase( const char *DirectoryPath, bool ErrorIsDirectoryReset, SEARCHDATA *LastSearchData )
{
	DARC_DIRECTORY *OldDir ;
	SEARCHDATA SearchData ;

	// ɗ܂pX疳
	if( strcmp( DirectoryPath, "." ) == 0 ) return 0 ;

	// w\x̏ꍇ̓[gfBNgɖ߂
	if( strcmp( DirectoryPath, "\\" ) == 0 )
	{
		this->CurrentDirectory = ( DARC_DIRECTORY * )this->DirP ;
		return 0 ;
	}

	// ɈpX珈𕪊
	if( strcmp( DirectoryPath, ".." ) == 0 )
	{
		// [gfBNgɋG[
		if( this->CurrentDirectory->ParentDirectoryAddress == 0xffffffffffffffff ) return -1 ;
		
		// efBNg炻Ɉڂ
		this->CurrentDirectory = ( DARC_DIRECTORY * )( this->DirP + this->CurrentDirectory->ParentDirectoryAddress ) ;
		return 0 ;
	}

	// ȊȌꍇ͎w̖ÕfBNgT
	
	// ύXȑÕfBNgۑĂ
	OldDir = this->CurrentDirectory ;

	// pXɁw\x邩ǂŏ𕪊
	if( strchr( DirectoryPath, '\\' ) == NULL )
	{
		// t@Cp̌`ɕϊ
		ConvSearchData( &SearchData, DirectoryPath, NULL ) ;

		// fBNgύX
		if( ChangeCurrentDirectoryFast( &SearchData ) < 0 ) goto ERR ;

/*		// \ ꍇ́ÃfBNgT
		FileH = ( DARC_FILEHEAD * )( this->FileP + this->CurrentDirectory->FileHeadAddress ) ;
		for( i = 0 ;
			 i < (s32)this->CurrentDirectory->FileHeadNum &&
			 StrICmp( ( char * )( this->NameP + FileH->NameAddress ), DirectoryPath ) != 0 ;
			 i ++, FileH ++ ){}
*/
	}
	else
	{
		// \ ꍇ͌qfBNgÂύXĂ䂭
	
		int Point, StrLength ;

		Point = 0 ;
		// [v
		for(;;)
		{
			// 擾
			ConvSearchData( &SearchData, &DirectoryPath[Point], &StrLength ) ;
			Point += StrLength ;
/*			StrPoint = 0 ;
			while( DirectoryPath[Point] != '\0' && DirectoryPath[Point] != '\\' )
			{
				if( CheckMultiByteChar( &DirectoryPath[Point] ) == TRUE )
				{
					*((u16 *)&String[StrPoint]) = *((u16 *)&DirectoryPath[Point]) ;
					StrPoint += 2 ;
					Point    += 2 ;
				}
				else
				{
					String[StrPoint] = DirectoryPath[Point] ;
					StrPoint ++ ;
					Point    ++ ;
				}
			}
			String[StrPoint] = '\0' ;
*/
			// [ \ ꍇ̓[gfBNgɗƂ
			if( StrLength == 0 && DirectoryPath[Point] == '\\' )
			{
				this->ChangeCurrentDirectoryBase( "\\", false ) ;
			}
			else
			{
				// ȊȌꍇ͕ʂɃfBNgύX
				if( this->ChangeCurrentDirectoryFast( &SearchData ) < 0 )
				{
					// G[NāAXɃG[NɌ̃fBNgɖ߂
					// tOĂꍇ͌̃fBNgɖ߂
					if( ErrorIsDirectoryReset == true ) this->CurrentDirectory = OldDir ;

					// G[I
					goto ERR ;
				}
			}

			// I[ŏIꍇ̓[v甲
			// ͂ \ Ȃꍇ[v甲
			if( DirectoryPath[Point] == '\0' ||
				( DirectoryPath[Point] == '\\' && DirectoryPath[Point+1] == '\0' ) ) break ;
			Point ++ ;
		}
	}

	if( LastSearchData != NULL )
	{
		memcpy( LastSearchData->FileName, SearchData.FileName, SearchData.PackNum * 4 ) ;
		LastSearchData->Parity  = SearchData.Parity ;
		LastSearchData->PackNum = SearchData.PackNum ;
	}

	// I
	return 0 ;

ERR:
	if( LastSearchData != NULL )
	{
		memcpy( LastSearchData->FileName, SearchData.FileName, SearchData.PackNum * 4 ) ;
		LastSearchData->Parity  = SearchData.Parity ;
		LastSearchData->PackNum = SearchData.PackNum ;
	}

	// G[I
	return -1 ;
}
		
// A[JCũJgfBNgpX擾
int DXArchive::GetCurrentDir( char *DirPathBuffer, int BufferLength )
{
	char DirPath[MAX_PATH] ;
	DARC_DIRECTORY *Dir[200], *DirTempP ;
	int Depth, i ;

	// [gfBNgɒ܂Ō
	Depth = 0 ;
	DirTempP = this->CurrentDirectory ;
	while( DirTempP->DirectoryAddress != 0xffffffffffffffff && DirTempP->DirectoryAddress != 0 )
	{
		Dir[Depth] = DirTempP ;
		DirTempP = ( DARC_DIRECTORY * )( this->DirP + DirTempP->ParentDirectoryAddress ) ;
		Depth ++ ;
	}
	
	// pXA
	DirPath[0] = '\0' ;
	for( i = Depth - 1 ; i >= 0 ; i -- )
	{
		strcat( DirPath, "\\" ) ;
		strcat( DirPath, ( char * )( this->NameP + ( ( DARC_FILEHEAD * )( this->FileP + Dir[i]->DirectoryAddress ) )->NameAddress ) ) ;
	}

	// obt@̒OAȂƂ̓fBNg̒Ԃ
	if( BufferLength == 0 || BufferLength < (s32)strlen( DirPath ) )
	{
		return ( int )( strlen( DirPath ) + 1 ) ;
	}
	else
	{
		// fBNgobt@ɓ]
		strcpy( DirPathBuffer, DirPath ) ;
	}

	// I
	return 0 ;
}



// A[JCut@C̎w̃t@Cɓǂݍ
s64 DXArchive::LoadFileToMem( const char *FilePath, void *Buffer, u64 BufferLength )
{
	DARC_FILEHEAD *FileH ;
	char KeyStringBuffer[ DXA_KEY_STRING_MAXLENGTH ] ;
	size_t KeyStringBufferBytes ;
	unsigned char lKey[ DXA_KEY_BYTES ] ;
	DARC_DIRECTORY *Directory ;
	void *HuffDataBuffer = NULL ;

	// w̃t@C̏𓾂
	FileH = this->GetFileInfo( FilePath, &Directory ) ;
	if( FileH == NULL ) return -1 ;

	// t@CTCYĂ邩ׂAĂȂAobt@A̓TCYOTCYԂ
	if( BufferLength < FileH->DataSize || BufferLength == 0 || Buffer == NULL )
	{
		return ( s64 )FileH->DataSize ;
	}

	// Ăꍇ̓obt@[ɓǂݍ

	// t@CkĂ邩ǂŏ𕪊
	if( FileH->PressDataSize != 0xffffffffffffffff )
	{
		// kĂꍇ

		// nt}kĂ邩ǂŏ𕪊
		if( FileH->HuffPressDataSize != 0xffffffffffffffff )
		{
			// ɓǂݍł邩ǂŏ𕪊
			if( MemoryOpenFlag == true )
			{
				// nt}k𓀂f[^i[郁̈̊m
				HuffDataBuffer = malloc( ( size_t )FileH->PressDataSize ) ;
				if( HuffDataBuffer == NULL ) return -1 ;

				// nt}kf[^
				Huffman_Decode( (u8 *)this->fp + this->Head.DataStartAddress + FileH->DataAddress, HuffDataBuffer ) ;

				// ̈kf[^𓀂
				Decode( HuffDataBuffer, Buffer ) ;

				// 
				free( HuffDataBuffer ) ;
			}
			else
			{
				void *temp ;

				// kf[^ɓǂݍł𓀂

				// kf[^܂郁̈̊m
				temp = malloc( ( size_t )( FileH->PressDataSize + FileH->HuffPressDataSize ) ) ;

				// kf[^̓ǂݍ
				_fseeki64( this->fp, this->Head.DataStartAddress + FileH->DataAddress, SEEK_SET ) ;

				// t@Cʂ̌쐬
				if( this->NoKey == false )
				{
					KeyStringBufferBytes = CreateKeyFileString( ( int )this->Head.CharCodeFormat, this->KeyString, this->KeyStringBytes, Directory, FileH, this->FileP, this->DirP, this->NameP, ( BYTE * )KeyStringBuffer ) ;
					KeyCreate( KeyStringBuffer, KeyStringBufferBytes, lKey ) ;
				}

				// Íǂݍ
				KeyConvFileRead( temp, FileH->HuffPressDataSize, this->fp, this->NoKey ? NULL : lKey, FileH->DataSize ) ;

				// nt}kf[^
				Huffman_Decode( temp, ( u8 * )temp + FileH->HuffPressDataSize ) ;
			
				// 
				Decode( ( u8 * )temp + FileH->HuffPressDataSize, Buffer ) ;
			
				// ̉
				free( temp ) ;
			}
		}
		else
		{
			// ɓǂݍł邩ǂŏ𕪊
			if( MemoryOpenFlag == true )
			{
				// ̈kf[^𓀂
				Decode( (u8 *)this->fp + this->Head.DataStartAddress + FileH->DataAddress, Buffer ) ;
			}
			else
			{
				void *temp ;

				// kf[^ɓǂݍł𓀂

				// kf[^܂郁̈̊m
				temp = malloc( ( size_t )FileH->PressDataSize ) ;

				// kf[^̓ǂݍ
				_fseeki64( this->fp, this->Head.DataStartAddress + FileH->DataAddress, SEEK_SET ) ;

				// t@Cʂ̌쐬
				if( this->NoKey == false )
				{
					KeyStringBufferBytes = CreateKeyFileString( ( int )this->Head.CharCodeFormat, this->KeyString, this->KeyStringBytes, Directory, FileH, this->FileP, this->DirP, this->NameP, ( BYTE * )KeyStringBuffer ) ;
					KeyCreate( KeyStringBuffer, KeyStringBufferBytes, lKey ) ;
				}

				KeyConvFileRead( temp, FileH->PressDataSize, this->fp, this->NoKey ? NULL : lKey, FileH->DataSize ) ;
			
				// 
				Decode( temp, Buffer ) ;
			
				// ̉
				free( temp ) ;
			}
		}
	}
	else
	{
		// kĂȂꍇ

		// nt}kĂ邩ǂŏ𕪊
		if( FileH->HuffPressDataSize != 0xffffffffffffffff )
		{
			// ɓǂݍł邩ǂŏ𕪊
			if( MemoryOpenFlag == true )
			{
				// nt}k𓀂f[^i[郁̈̊m
				HuffDataBuffer = malloc( ( size_t )FileH->PressDataSize ) ;
				if( HuffDataBuffer == NULL ) return -1 ;

				// nt}kf[^
				Huffman_Decode( (u8 *)this->fp + this->Head.DataStartAddress + FileH->DataAddress, HuffDataBuffer ) ;

				// Rs[
				memcpy( Buffer, HuffDataBuffer, ( size_t )FileH->DataSize ) ;

				// 
				free( HuffDataBuffer ) ;
			}
			else
			{
				void *temp ;

				// kf[^ɓǂݍł𓀂

				// nt}kf[^܂郁̈̊m
				temp = malloc( ( size_t )FileH->HuffPressDataSize ) ;

				// kf[^̓ǂݍ
				_fseeki64( this->fp, this->Head.DataStartAddress + FileH->DataAddress, SEEK_SET ) ;

				// t@Cʂ̌쐬
				if( this->NoKey == false )
				{
					KeyStringBufferBytes = CreateKeyFileString( ( int )this->Head.CharCodeFormat, this->KeyString, this->KeyStringBytes, Directory, FileH, this->FileP, this->DirP, this->NameP, ( BYTE * )KeyStringBuffer ) ;
					KeyCreate( KeyStringBuffer, KeyStringBufferBytes, lKey ) ;
				}

				// Íǂݍ
				KeyConvFileRead( temp, FileH->HuffPressDataSize, this->fp, this->NoKey ? NULL : lKey, FileH->DataSize ) ;

				// nt}kf[^
				Huffman_Decode( temp, Buffer ) ;
			
				// ̉
				free( temp ) ;
			}
		}
		else
		{
			// ɓǂݍł邩ǂŏ𕪊
			if( MemoryOpenFlag == true )
			{
				// Rs[
				memcpy( Buffer, (u8 *)this->fp + this->Head.DataStartAddress + FileH->DataAddress, ( size_t )FileH->DataSize ) ;
			}
			else
			{
				// t@C|C^ړ
				_fseeki64( this->fp, this->Head.DataStartAddress + FileH->DataAddress, SEEK_SET ) ;

				// ǂݍ

				// t@Cʂ̌쐬
				if( this->NoKey == false )
				{
					KeyStringBufferBytes = CreateKeyFileString( ( int )this->Head.CharCodeFormat, this->KeyString, this->KeyStringBytes, Directory, FileH, this->FileP, this->DirP, this->NameP, ( BYTE * )KeyStringBuffer ) ;
					KeyCreate( KeyStringBuffer, KeyStringBufferBytes, lKey ) ;
				}

				KeyConvFileRead( Buffer, FileH->DataSize, this->fp, this->NoKey ? NULL : lKey, FileH->DataSize ) ;
			}
		}
	}
	
	// I
	return 0 ;
}

// A[JCut@C̎w̃t@CTCY擾
s64 DXArchive::GetFileSize( const char *FilePath )
{
	// t@CTCYԂ
	return this->LoadFileToMem( FilePath, NULL, 0 ) ;
}

// A[JCut@Cɓǂݍ񂾏ꍇ̃t@CC[Wi[Ă擪AhX擾( JĂꍇ̂ݗL )
void *DXArchive::GetFileImage( void )
{
	// C[WJĂȂG[
	if( MemoryOpenFlag == false ) return NULL ;

	// 擪AhXԂ
	return this->fp ;
}

// A[JCut@C̎w̃t@C̃t@C̈ʒuƃt@C̑傫𓾂( -1:G[ )
int DXArchive::GetFileInfo( const char *FilePath, u64 *PositionP, u64 *SizeP )
{
	DARC_FILEHEAD *FileH ;

	// w̃t@C̏𓾂
	FileH = this->GetFileInfo( FilePath ) ;
	if( FileH == NULL ) return -1 ;

	// t@C̃f[^ʒuƃt@CTCYۑ
	if( PositionP != NULL ) *PositionP = this->Head.DataStartAddress + FileH->DataAddress ;
	if( SizeP     != NULL ) *SizeP     = FileH->DataSize ;

	// I
	return 0 ;
}

// A[JCut@C̎w̃t@CANX̃obt@ɓǂݍ
void *DXArchive::LoadFileToCache( const char *FilePath )
{
	s64 FileSize ;

	// t@CTCY擾
	FileSize = this->GetFileSize( FilePath ) ;

	// t@CG[
	if( FileSize < 0 ) return NULL ;

	// mۂĂLbVobt@̃TCY傫ꍇ̓obt@Ċmۂ
	if( FileSize > ( s64 )this->CacheBufferSize )
	{
		// LbVobt@̃NA
		this->ClearCache() ;

		// LbVobt@̍Ċm
		this->CacheBuffer = malloc( ( size_t )FileSize ) ;

		// mۂɎsꍇ NULL Ԃ
		if( this->CacheBuffer == NULL ) return NULL ;

		// LbVobt@̃TCYۑ
		this->CacheBufferSize = FileSize ;
	}

	// t@Cɓǂݍ
	this->LoadFileToMem( FilePath, this->CacheBuffer, FileSize ) ;

	// LbVobt@̃AhXԂ
	return this->CacheBuffer ;
}

// LbVobt@J
int DXArchive::ClearCache( void )
{
	// mۂĂ
	if( this->CacheBuffer != NULL )
	{
		free( this->CacheBuffer ) ;
		this->CacheBuffer = NULL ;
		this->CacheBufferSize = 0 ;
	}

	// I
	return 0 ;
}

	
// A[JCut@C̎w̃t@CJAt@CANZXpIuWFNg쐬
DXArchiveFile *DXArchive::OpenFile( const char *FilePath )
{
	DARC_FILEHEAD *FileH ;
	DARC_DIRECTORY *Directory ;
	DXArchiveFile *CDArc = NULL ;

	// JĂꍇ͖
	if( MemoryOpenFlag == true ) return NULL ;

	// w̃t@C̏𓾂
	FileH = this->GetFileInfo( FilePath, &Directory ) ;
	if( FileH == NULL ) return NULL ;

	// V DXArchiveFile NX쐬
	CDArc = new DXArchiveFile( FileH, Directory, this ) ;
	
	// DXArchiveFile NX̃|C^Ԃ
	return CDArc ;
}













// RXgN^
DXArchiveFile::DXArchiveFile( DARC_FILEHEAD *FileHead, DARC_DIRECTORY *Directory, DXArchive *Archive )
{
	void *temp ;

	this->FileData  = FileHead ;
	this->Archive   = Archive ;
	this->EOFFlag   = FALSE ;
	this->FilePoint = 0 ;
	this->DataBuffer = NULL ;

	// 쐬
	if( this->Archive->GetNoKey() == false )
	{
		char KeyStringBuffer[ DXA_KEY_STRING_MAXLENGTH ] ;
		size_t KeyStringBufferBytes ;

		KeyStringBufferBytes = DXArchive::CreateKeyFileString(
			( int )this->Archive->GetHeader()->CharCodeFormat,
			this->Archive->GetKeyString(),
			this->Archive->GetKeyStringBytes(),
			Directory,
			FileHead,
			this->Archive->GetFileHeadTable(),
			this->Archive->GetDirectoryTable(),
			this->Archive->GetNameTable(),
			( BYTE * )KeyStringBuffer
		) ;
		DXArchive::KeyCreate( KeyStringBuffer, KeyStringBufferBytes, Key ) ;
	}

	// t@CkĂꍇ͉𓀃f[^܂郁̈̊m
	if( FileHead->PressDataSize     != 0xffffffffffffffff ||
		FileHead->HuffPressDataSize != 0xffffffffffffffff )
	{
		// 𓀃f[^܂郁̈̊m
		this->DataBuffer = malloc( ( size_t )FileHead->DataSize ) ;
	}
	
	// t@CkĂꍇ͂œǂݍŉ𓀂Ă܂
	if( FileHead->PressDataSize != 0xffffffffffffffff )
	{
		// nt}kĂ邩ǂŏ𕪊
		if( FileHead->HuffPressDataSize != 0xffffffffffffffff )
		{
			// kf[^܂郁̈̊m
			temp = malloc( ( size_t )( FileHead->PressDataSize + FileHead->HuffPressDataSize ) ) ;

			// kf[^̓ǂݍ
			_fseeki64( this->Archive->GetFilePointer(), this->Archive->GetHeader()->DataStartAddress + FileHead->DataAddress, SEEK_SET ) ;

			// ǂݍ
			DXArchive::KeyConvFileRead( temp, FileHead->HuffPressDataSize, this->Archive->GetFilePointer(), this->Archive->GetNoKey() ? NULL : Key, FileHead->DataSize ) ;

			// nt}kf[^
			Huffman_Decode( temp, ( u8 * )temp + FileHead->HuffPressDataSize ) ;
		
			// 
			DXArchive::Decode( ( u8 * )temp + FileHead->HuffPressDataSize, this->DataBuffer ) ;

			// ̉
			free( temp ) ;
		}
		else
		{
			// kf[^܂郁̈̊m
			temp = malloc( ( size_t )FileHead->PressDataSize ) ;

			// kf[^̓ǂݍ
			_fseeki64( this->Archive->GetFilePointer(), this->Archive->GetHeader()->DataStartAddress + FileHead->DataAddress, SEEK_SET ) ;
			DXArchive::KeyConvFileRead( temp, FileHead->PressDataSize, this->Archive->GetFilePointer(), this->Archive->GetNoKey() ? NULL : Key, FileHead->DataSize ) ;
		
			// 
			DXArchive::Decode( temp, this->DataBuffer ) ;

			// ̉
			free( temp ) ;
		}
	}
	else
	// nt}kĂ邩ǂŏ𕪊
	if( FileHead->HuffPressDataSize != 0xffffffffffffffff )
	{
		// kf[^܂郁̈̊m
		temp = malloc( ( size_t )FileHead->HuffPressDataSize ) ;

		// kf[^̓ǂݍ
		_fseeki64( this->Archive->GetFilePointer(), this->Archive->GetHeader()->DataStartAddress + FileHead->DataAddress, SEEK_SET ) ;

		// Íǂݍ
		DXArchive::KeyConvFileRead( temp, FileHead->HuffPressDataSize, this->Archive->GetFilePointer(), this->Archive->GetNoKey() ? NULL : Key, FileHead->DataSize ) ;

		// nt}kf[^
		Huffman_Decode( temp, this->DataBuffer ) ;

		// ̉
		free( temp ) ;
	}
}

// fXgN^
DXArchiveFile::~DXArchiveFile()
{
	// ̉
	if( this->DataBuffer != NULL )
	{
		free( this->DataBuffer ) ;
		this->DataBuffer = NULL ;
	}
}

// t@C̓eǂݍ
s64 DXArchiveFile::Read( void *Buffer, s64 ReadLength )
{
	s64 ReadSize ;

	// EOF tOĂOԂ
	if( this->EOFFlag == TRUE ) return 0 ;
	
	// A[JCut@C|C^ƁAzt@C|C^vĂ邩ׂ
	// vĂȂA[JCut@C|C^ړ
	if( this->DataBuffer == NULL && _ftelli64( this->Archive->GetFilePointer() ) != (s32)( this->FileData->DataAddress + this->Archive->GetHeader()->DataStartAddress + this->FilePoint ) )
	{
		_fseeki64( this->Archive->GetFilePointer(), this->FileData->DataAddress + this->Archive->GetHeader()->DataStartAddress + this->FilePoint, SEEK_SET ) ;
	}
	
	// EOF o
	if( this->FileData->DataSize == this->FilePoint )
	{
		this->EOFFlag = TRUE ;
		return 0 ;
	}
	
	// f[^ǂݍޗʂݒ肷
	ReadSize = ReadLength < (s64)( this->FileData->DataSize - this->FilePoint ) ? ReadLength : this->FileData->DataSize - this->FilePoint ;
	
	// f[^ǂݍ
	if( this->DataBuffer == NULL )
	{
		DXArchive::KeyConvFileRead( Buffer, ReadSize, this->Archive->GetFilePointer(), this->Archive->GetNoKey() ? NULL : Key, this->FileData->DataSize + this->FilePoint ) ;
	}
	else
	{
		memcpy( Buffer, (u8 *)this->DataBuffer + this->FilePoint, ( size_t )ReadSize ) ;
	}
	
	// EOF tO|
	this->EOFFlag = FALSE ;

	// ǂݍ񂾕t@C|C^ړ
	this->FilePoint += ReadSize ;
	
	// ǂݍ񂾗eʂԂ
	return ReadSize ;
}
	
// t@C|C^ύX
s64 DXArchiveFile::Seek( s64 SeekPoint, s64 SeekMode )
{
	// V[N^Cvɂď𕪊
	switch( SeekMode )
	{
	case SEEK_SET : break ;		
	case SEEK_CUR : SeekPoint += this->FilePoint ; break ;
	case SEEK_END :	SeekPoint = this->FileData->DataSize + SeekPoint ; break ;
	}
	
	// ␳
	if( SeekPoint > (s64)this->FileData->DataSize ) SeekPoint = this->FileData->DataSize ;
	if( SeekPoint < 0 ) SeekPoint = 0 ;
	
	// Zbg
	this->FilePoint = SeekPoint ;
	
	// EOFtO|
	this->EOFFlag = FALSE ;
	
	// I
	return 0 ;
}

// ݂̃t@C|C^𓾂
s64 DXArchiveFile::Tell( void )
{
	return this->FilePoint ;
}

// t@C̏I[ɗĂ邩ÃtO𓾂
s64 DXArchiveFile::Eof( void )
{
	return this->EOFFlag ;
}

// t@C̃TCY擾
s64 DXArchiveFile::Size( void )
{
	return this->FileData->DataSize ;
}



