#ifndef CREATEFONTDATA_H
#define CREATEFONTDATA_H

#include <windows.h>

/* o[W

0      o[W
1      J[jOǉ

*/

/* f[^}bv

FONTDATAFILEHEADER

kĊi[
	FONTDATAFILEPRESSHEADER
	FONTDATAFILECHARADATA ~ ̐
	FONTDATAFILEKERNINGPAIRDATA ~ J[jOyA̐	

tHgC[Wf[^

*/

// o[W
#define DX_FONTDATAFILE_VERSION						(1)

// Zbg
#define DX_CHARSET_DEFAULT							(0)					// ftHgZbg
#define DX_CHARSET_SHFTJIS							(1)					// {ꕶZbg
#define DX_CHARSET_HANGEUL							(2)					// ؍ꕶZbg
#define DX_CHARSET_BIG5								(3)					// ɑ̕Zbg
#define DX_CHARSET_GB2312							(4)					// ȑ̕Zbg
#define DX_CHARSET_WINDOWS_1252						(5)					// (e̕R[h)
#define DX_CHARSET_ISO_IEC_8859_15					(6)					// (e̕R[h)
#define DX_CHARSET_UTF8								(7)					// UTF8

// tHǧC[W̃f[^^Cv
#define DX_FONT_SRCIMAGETYPE_1BIT					(0)					// 1sNZ1rbg
#define DX_FONT_SRCIMAGETYPE_1BIT_SCALE4			(1)					// 1sNZ1rbgA摜𑜓x4{
#define DX_FONT_SRCIMAGETYPE_1BIT_SCALE8			(2)					// 1sNZ1rbgA摜𑜓x8{
#define DX_FONT_SRCIMAGETYPE_1BIT_SCALE16			(3)					// 1sNZ1rbgA摜𑜓x16{
#define DX_FONT_SRCIMAGETYPE_4BIT_MAX15				(4)					// 1sNZ4rbgAl͈̔͂0`15
#define DX_FONT_SRCIMAGETYPE_8BIT_ON_OFF			(5)					// 1sNZ8rbgAl͈̔͂00ȊO
#define DX_FONT_SRCIMAGETYPE_8BIT_MAX16				(6)					// 1sNZ8rbgAl͈̔͂0`16
#define DX_FONT_SRCIMAGETYPE_8BIT_MAX64				(7)					// 1sNZ8rbgAl͈̔͂0`64
#define DX_FONT_SRCIMAGETYPE_8BIT_MAX255			(8)					// 1sNZ8rbgAl͈̔͂0`255

// tHg摜̊Krbg
#define DX_FONTIMAGE_BIT_1							(0)
#define DX_FONTIMAGE_BIT_4							(1)
#define DX_FONTIMAGE_BIT_8							(2)

#define DEFAULT_FONT_SIZE							(16)				// tHg̃ftHg̃TCY
#define DEFAULT_FONT_THICKNESS						(6)					// tHg̃ftHg̑

// tHg񋓎pf[^\
struct ENUMFONTDATA
{
	wchar_t *				FontBuffer ;
	int						FontNum ;
	int						BufferNum ;
	const wchar_t *			EnumFontName ;
} ;

// tHg̊{
struct FONTBASEINFO
{
	WORD					FontThickness ;						// tHg̑
	WORD					FontSize ;							// `悷tHg̃TCY
	WORD					FontHeight ;						// `悷tHg̍őc
	WORD					FontAddHeight ;						// TCŸׂɑ
	BYTE					Italic ;							// C^bNtHgǂ(TRUE:C^bN FALSE:C^bN)
	BYTE					Padding ;
	WORD					MaxWidth ;							// tHg̍ő啝
	WORD					CharSet ;							// LN^Zbg
	WORD					CharCodeFormat ;					// R[hy[W
	WORD					Ascent ;							// ̃x[XCԏ܂ł̍
	WORD					Padding2 ;
	DWORD					KerningPairNum ;					// J[jOyA̐
	DWORD					Padding3[ 10 ] ;
} ;

// tHgt@C̃wb_̈k镔
struct FONTDATAFILEPRESSHEADER
{
	WORD					FontName[ 128 ] ;	// tHg̖O( UTF-16LE )
	FONTBASEINFO			BaseInfo ;			// {
	BYTE					ImageBitDepth ;		// 摜̃rbg[x( DX_FONTIMAGE_BIT_1  )
	BYTE					Padding[ 3 ] ;
	DWORD					Padding2[ 16 ] ;
} ;

// tHgt@C̃wb_
struct FONTDATAFILEHEADER
{
	BYTE					Magic[ 4 ] ;		// FNTF
	WORD					Version ;			// o[W
	WORD					Padding ;
	DWORD					ImageAddress ;		// 摜f[^ۑĂ擪AhX
	DWORD					MaxImageBytes ;		// 摜f[^̍őTCY
	DWORD					CharaNum ;			// ̐
	DWORD					CharaExNum ;		// ̓AR[h 0x10000 ȏ̐̕
	FONTDATAFILEPRESSHEADER	Press ;				// wb_t@C̈kΏۂ̕
} ;

// J[jOyA
struct FONTDATAFILEKERNINGPAIRDATA
{
	DWORD					First ;				// yÂP
	DWORD					Second ;			// yÂQ
	int						KernAmount ;		// 炷hbg
	DWORD					Padding ;
} ;

// t@Cۑp̃tHgP̏
struct FONTDATAFILECHARADATA
{
	DWORD					CodeUnicode ;		// Unicode ̕R[h
	BYTE					Press ;				// kĂ邩ǂ( 1:kĂ  0:kĂȂ )
	BYTE					Padding ;
	short					DrawX ;				// 摜`悷ׂwW
	short					DrawY ;				// 摜`悷ׂxW
	short					AddX ;				// ̕`悷ׂ΂wW
	WORD					SizeX ;				// ̂wTCY
	WORD					SizeY ;				// ̂xTCY
	DWORD					ImageAddress ;		// 摜f[^ۑĂAhX( FONTDATAFILEHEADER.ImageAddress ̎AhX 0 Ƃ )
	DWORD					ImagePitch ;		// 摜f[^̂PC̃oCg
	DWORD					Padding2[ 2 ] ;
} ;

// tHgLbV̊Ǘf[^
struct FONTMANAGE
{
	wchar_t					FontName[ 128 ] ;					// tHg
	FONTBASEINFO			BaseInfo ;							// {
	int						ImageBitDepth ;						// tHg摜̃rbg[x( DX_FONTIMAGE_BIT_1 Ȃ )

	int						UseTextOut ;						// TextOut gp^CṽtHgǂ( TRUE:TextOutgp  FALSE:GetGlyphOutline gp )
	HFONT					FontObj ;							// tHg̃IuWFNgf[^
	HBITMAP					CacheBitmap ;						// eLXgLbVprbg}bv
	unsigned char			*CacheBitmapMem ;					// eLXgLbVprbg}bṽ
	int						CacheBitmapMemPitch ;				// eLXgLbVprbg}bṽsb`

	FONTDATAFILECHARADATA	CharaData ;							// P̃f[^

	FONTDATAFILEKERNINGPAIRDATA * KerningPairData ;				// J[jOyA

	void *					GetGlyphOutlineBuffer ;				// GetGlyphOutline ̃f[^擾pɎgpobt@
	DWORD					GetGlyphOutlineBufferSize ;			// GetGlyphOutline ̃f[^擾pɎgpobt@̃TCY

	unsigned char			*CacheMem ;							// eLXgLbV
	int						CachePitch ;						// eLXgLbṼsb`	
	int						CacheDataBitNum ;					// eLXgLbV̂PsNZ̃rbg
} ;

// Windowsp tHgVXep\
struct FONTSYSTEM_WIN
{
	HDC						Devicecontext ;						// FontCacheCharAddToHandle ̏ŎgpfoCXReLXg
	HFONT					OldFont ;							// FontCacheCharAddToHandle ̏ŎgptHg
	HBITMAP					OldBitmap ;							// FontCacheCharAddToHandle ̏Ŏgprbg}bv
	TEXTMETRIC				TextMetric ;						// FontCacheCharAddToHandle ̏ŎgptHg̏
} ;

// tHgVXep\
struct FONTSYSTEM
{
	BYTE					BitCountTable[ 256 ] ;				// rbgJEge[u
} ;

// tHg̏
extern int InitializeFont( void ) ;

// tHgf[^̍쐬
extern FONTMANAGE *CreateFontManageData(
	const wchar_t *	FontName,
	int				Size,
	int				ImageBitDepth /* DX_FONTIMAGE_BIT_1 */ , 
	int				Thick,
	int				Italic = FALSE ,
	int				CharSet = -1,
	int				CharCodeFormat = -1
) ;

// tHgf[^̌n
extern int DeleteFontManageData( FONTMANAGE *ManageData ) ;

// LbV̕ύX
extern int FontCacheCharChange( FONTMANAGE *ManageData, const wchar_t *CharCode ) ;

// tHgf[^t@C̍쐬
extern int CreateFontDataFile(
	const wchar_t *	SaveFilePath,
	const wchar_t *	FontName,
	int				Size,
	int				ImageBitDepth /* DX_FONTIMAGE_BIT_1 */ , 
	int				Thick,
	int				Italic = FALSE ,
	int				CharSet = -1,
	int				CharCodeFormat = -1,
	const wchar_t *	SaveCharaList = NULL
) ;

#endif // CREATEFONTDATA_H

